/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.emc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.emc.service.EmcService;
import com.digiwin.athena.semc.proxy.emc.service.model.OmEventResp;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EmcServiceImpl
implements EmcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmcServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    private static final String EMC_OM_TEMPLATE = "/api/emc/v2/notices/settings/entrance";
    private static final String EMC_WECOM_CONFIG = "/api/emc/v1/appconfig/outsource/current";
    public static final String EMC_MESSAGE_WECHAT = "/api/emc/v1/message/sendWechat";

    public List<OmEventResp> queryOmTemplateList(String channelFlag, String nameConditon) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("source", "Athena");
        requestMap.put("type", channelFlag.equals(Constants.MessageChannelEnum.WECOM.getFlag()) ? "weCom" : channelFlag);
        requestMap.put("noticeContent", nameConditon);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getEmcUrl()).append(EMC_OM_TEMPLATE);
        try {
            log.info("query om template list. param:{}", (Object)JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                JSONArray data = ((JSONObject)respEntity.getBody()).getJSONArray("data");
                return JSONArray.parseArray((String)data.toJSONString(), OmEventResp.class);
            }
            log.info("query om template list return empty, userToken:{}, request:{}, url:{}, code:{}, response:{}", new Object[]{userToken, requestMap, url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            return Lists.newArrayList();
        }
        catch (Exception ex) {
            log.error("query om template list error, userToken:{}, request:{}, url:{}, errorMessage:{}", new Object[]{userToken, requestMap, url, ex.getMessage()});
            throw BusinessException.create((String)ex.getMessage());
        }
    }

    public JSONObject queryWeComConfig(String userToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        String url = this.envProperties.getEmcUrl() + EMC_WECOM_CONFIG;
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                JSONArray data = ((JSONObject)respEntity.getBody()).getJSONArray("data");
                JSONObject jsonObject = data.getJSONObject(0);
                return jsonObject;
            }
            log.info("query wecom config return empty. url:{}, request:{}, response:{}", new Object[]{url, requestEntity, JSONObject.toJSONString((Object)respEntity.getBody())});
            return null;
        }
        catch (Exception ex) {
            log.error("query wecom config occur error. url:{}, request:{}, errorMessage:{}", new Object[]{url, requestEntity, ex.getMessage(), ex});
            return null;
        }
    }

    public void sendWeChat(List<String> userIdList, String msg, String userToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        headers.add("digi-middleware-auth-user", userToken);
        JSONObject reqObject = new JSONObject();
        reqObject.put("msgType", (Object)"text");
        reqObject.put("content", (Object)msg);
        reqObject.put("userIds", userIdList);
        HttpEntity httpEntity = new HttpEntity((Object)reqObject, (MultiValueMap)headers);
        String url = this.envProperties.getEmcUrl() + EMC_MESSAGE_WECHAT;
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("invoke emc | send WeChat success. url:{}, request:{}, response\uff1a{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), JsonUtils.objectToString((Object)respEntity.getBody())});
        }
        catch (Exception ex) {
            log.error("invoke emc | send WeChat error. url:{}, request:{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), ex});
        }
    }
}

