/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.eoc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.eoc.service.model.UserDeptDTO;
import com.digiwin.athena.semc.proxy.eoc.service.model.UserDeptInfoDTO;
import com.digiwin.athena.semc.proxy.eoc.service.model.UserInfoDetailDTO;
import com.digiwin.athena.semc.util.FormatUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class EocServiceImpl
implements EocService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EocServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    private static final String EOC_EMP_DEPTS = "/api/eoc/v2/emp/depts";
    private static final String EOC_EMP_JOB = "/api/eoc/v2/emp/id";
    private static final String EOC_EMP_INFO = "/api/eoc/v2/emp/info";
    private static final String QUERY_DEPT_USER_INFO_EOC = "/api/eoc/v2/dept/emp/list/emp/simple?deptSids={}&bindUser=true";
    private static final String CURRENT_TENANT_DEPTS = "/api/eoc/v2/dept/list?pageNum=1&pageSize=99999";

    public List<UserDeptInfoDTO> queryUserDeptList(String empId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("empId", empId);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getEocDomain()).append(EOC_EMP_DEPTS);
        try {
            log.info("query user dept list param:" + JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                JSONArray data = ((JSONObject)respEntity.getBody()).getJSONArray("data");
                return JSONArray.parseArray((String)data.toJSONString(), UserDeptInfoDTO.class);
            }
            log.info("query user dept list return empty, userToken:{}, request:{}, url:{}, code:{}, response:{}", new Object[]{userToken, requestMap, url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            return Lists.newArrayList();
        }
        catch (Exception ex) {
            log.error("query user dept list error, userToken:{}, request:{}, url:{}, errorMessage:{}", new Object[]{userToken, requestMap, url, ex.getMessage()});
            throw BusinessException.create((String)ex.getMessage());
        }
    }

    public String getEmpJobNum() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        String userId = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("userId", userId);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getEocDomain()).append(EOC_EMP_JOB);
        try {
            log.info("query user getEmpJobNum  param:" + JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                String data = ((JSONObject)respEntity.getBody()).getString("data");
                return data;
            }
            log.info("query user getEmpJobNum return empty, userToken:{}, request:{}, url:{}, code:{}, response:{}", new Object[]{userToken, requestMap, url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            return "";
        }
        catch (Exception ex) {
            log.error("query user getEmpJobNum error, userToken:{}, request:{}, url:{}, errorMessage:{}", new Object[]{userToken, requestMap, url, ex.getMessage()});
            return "";
        }
    }

    public UserInfoDetailDTO queryUserInfoDetail(String userId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("userId", userId);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getEocDomain()).append(EOC_EMP_INFO);
        try {
            log.info("query user info detail param:" + JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                JSONObject jsonObject = ((JSONObject)respEntity.getBody()).getJSONObject("data");
                return (UserInfoDetailDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject), UserInfoDetailDTO.class);
            }
            log.info("query user info detail return empty. url:{}, request:{}, response:{}", new Object[]{url, requestEntity, JSONObject.toJSONString((Object)respEntity)});
            return null;
        }
        catch (Exception ex) {
            log.warn("query user info detail errorMessage:{}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    public List<Long> queryUserDeptSidList(String userId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("userId", userId);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getEocDomain()).append(EOC_EMP_INFO);
        try {
            log.info("query user info detail param:" + JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                JSONObject jsonObject = ((JSONObject)respEntity.getBody()).getJSONObject("data");
                ArrayList deptSidList = Lists.newArrayList();
                if (MapUtils.isEmpty((Map)jsonObject)) {
                    return deptSidList;
                }
                JSONArray depts = jsonObject.getJSONArray("depts");
                if (CollectionUtils.isEmpty((Collection)depts)) {
                    return deptSidList;
                }
                for (int i = 0; i < depts.size(); ++i) {
                    deptSidList.add(depts.getJSONObject(i).getLong("sid"));
                }
                return deptSidList;
            }
            log.info("query user info detail return empty. url:{}, request:{}, response:{}", new Object[]{url, requestEntity, JSONObject.toJSONString((Object)respEntity)});
            return Lists.newArrayList();
        }
        catch (Exception ex) {
            log.warn("query user info detail errorMessage:{}", (Object)ex.getMessage(), (Object)ex);
            return Lists.newArrayList();
        }
    }

    public List<UserDeptInfoDTO> queryUserByDeptSidList(List<Long> deptSidList) {
        ResponseEntity respEntity;
        if (CollectionUtils.isEmpty(deptSidList)) {
            return Lists.newArrayList();
        }
        String deptSidStr = deptSidList.stream().map(Objects::toString).collect(Collectors.joining(",", "", ""));
        String url = this.envProperties.getEocDomain() + FormatUtil.format((String)QUERY_DEPT_USER_INFO_EOC, (Object[])new Object[]{deptSidStr});
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class, new Object[0]);
        }
        catch (Exception ex) {
            log.error("query user by dept sid list error, url:{}, request:{}, errorMsg:{}", new Object[]{url, httpEntity, ex.getMessage(), ex});
            return Lists.newArrayList();
        }
        if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
            JSONArray data = ((JSONObject)respEntity.getBody()).getJSONArray("data");
            return JSONObject.parseArray((String)data.toJSONString(), UserDeptInfoDTO.class);
        }
        log.warn("query user by role dept list return empty, url:{}, request:{}, statusCode:{}, response:{}", new Object[]{url, httpEntity, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
        return Lists.newArrayList();
    }

    public List<UserDeptDTO> queryTenantDeptList() {
        ResponseEntity respEntity;
        String url = this.envProperties.getEocDomain() + CURRENT_TENANT_DEPTS;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class, new Object[0]);
        }
        catch (Exception ex) {
            log.error("query tenant dept list error, url:{}, request:{}, errorMsg:{}", new Object[]{url, httpEntity, ex.getMessage(), ex});
            return Lists.newArrayList();
        }
        if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
            JSONObject jsonObject = ((JSONObject)respEntity.getBody()).getJSONObject("data");
            if (!ObjectUtils.isEmpty((Object)jsonObject)) {
                return JSONObject.parseArray((String)jsonObject.getJSONArray("list").toJSONString(), UserDeptDTO.class);
            }
        } else {
            log.warn("query tenant dept list return empty, url:{}, request:{}, statusCode:{}, response:{}", new Object[]{url, httpEntity, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
        }
        return Lists.newArrayList();
    }
}

