/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.es.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.semc.dto.homepage.AdvertisementDTO;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.es.service.EsService;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EsServiceImpl
implements EsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EsServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    private static final String ES_QUERY_ADS_PATH = "/announcementservice/api/ads/escloud?serviceRegion=%s&adLaunchArea=%s&accessToken=%s";
    private static final String ES_READ_ADS_PATH = "/announcementservice/api/ads/read?accessToken=";

    public List<AdvertisementDTO> queryAdList(String serviceRegion, String adLaunchArea, String esAccessToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String invokePath = String.format(ES_QUERY_ADS_PATH, serviceRegion, adLaunchArea, esAccessToken);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getEsUri()).append(invokePath);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                JSONArray array = ((JSONObject)respEntity.getBody()).getJSONArray("ads");
                return JSONArray.parseArray((String)array.toJSONString(), AdvertisementDTO.class);
            }
            log.info("query advertisement list from es return empty, url:{}, status:{}, response:{}", new Object[]{url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            return Lists.newArrayList();
        }
        catch (Exception ex) {
            log.error("query ad list from es error, url:{}, errorMessage:{}", (Object)url, (Object)ex.getMessage());
            throw BusinessException.create((String)ex.getMessage());
        }
    }

    public boolean readServiceCloud(Long adId, String customerServiceCode, String esUserId, String esAccessToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("Adid", adId);
        requestMap.put("CustomerServiceCode", customerServiceCode);
        requestMap.put("UserId", esUserId);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getEsUri()).append(ES_READ_ADS_PATH).append(esAccessToken);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                return ((JSONObject)respEntity.getBody()).getBoolean("data");
            }
            log.info("query advertisement list from es return empty, url:{}, status:{}, response:{}", new Object[]{url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            return false;
        }
        catch (Exception ex) {
            log.error("query ad list from es error, url:{}, errorMessage:{}", (Object)url, (Object)ex.getMessage());
            throw BusinessException.create((String)ex.getMessage());
        }
    }
}

