/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.esp.service.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.ServiceException;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.util.DataTypeAdapter;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ESPServiceImpl
implements ESPService {
    private static final String BODY_STD_DATA = "std_data";
    private static final String EXECUTION_FAIL = "exception.execution.api.fail";
    private static Logger logger = LoggerFactory.getLogger(ESPServiceImpl.class);
    @Resource
    private MessageUtils messageUtils;

    public Map<String, Object> queryByEsp(String eaiSysName, String eaiSysUid, String serviceName, Map<String, String> extHeader, Map<String, Object> parameter, String queryCondition, PageInfo pageInfo) {
        Map headers = this.createHeader(extHeader);
        HashMap bodyMap = new HashMap();
        HashMap<String, Map<String, Object>> stdData = new HashMap<String, Map<String, Object>>();
        if (parameter == null) {
            parameter = new HashMap<String, Object>();
        }
        if (pageInfo != null) {
            if (pageInfo.getPageSize() != null) {
                parameter.put("use_has_next", true);
                parameter.put("page_size", pageInfo.getPageSize());
            }
            if (pageInfo.getPageNo() != null) {
                parameter.put("page_no", pageInfo.getPageNo());
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)queryCondition)) {
            parameter.put("query_condition", queryCondition);
        }
        stdData.put("parameter", parameter);
        bodyMap.put(BODY_STD_DATA, stdData);
        RequestModel requestModel = this.createRequestModel(eaiSysName, eaiSysUid, serviceName, headers, JsonUtil.toString(bodyMap));
        return this.invokeEsp(requestModel, true);
    }

    private Map<String, String> createHeader(Map<String, String> extHeader) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(extHeader)) {
            headers.putAll(extHeader);
        }
        return headers;
    }

    private RequestModel createRequestModel(String eaiSysName, String eaiSysUid, String serviceName, Map<String, String> headers, String body) {
        RequestModel requestModel = new RequestModel();
        requestModel.setHostProd("Athena");
        requestModel.setHostVer("1.0.0");
        requestModel.setHostAcct("athena");
        requestModel.setHostId("SEMC");
        requestModel.setLanguage(LocaleContextHolder.getLocale().toString());
        requestModel.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        requestModel.setServiceProd(eaiSysName);
        requestModel.setServiceName(serviceName);
        requestModel.setServiceProdUid(eaiSysUid);
        requestModel.setBodyJsonString(body);
        requestModel.setHeaderMap(headers);
        return requestModel;
    }

    private Map<String, Object> invokeEsp(RequestModel requestModel, boolean sync) {
        ResponseModel responseModel;
        String serviceId = requestModel.getServiceProd().concat(".").concat(requestModel.getServiceName());
        try {
            logger.info("Call ESP param:{}", (Object)new Gson().toJson((Object)requestModel));
            responseModel = sync ? Invoker.invokeRestSync((RequestModel)requestModel) : Invoker.invokeRestFasync((RequestModel)requestModel);
            logger.info("Call ESP result:{}", (Object)new Gson().toJson((Object)responseModel));
        }
        catch (Exception e) {
            logger.error("Call ESP Error", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage(EXECUTION_FAIL), LocalDateTime.now(), serviceId, e.getMessage());
            throw new ServiceException(Integer.valueOf(500), error);
        }
        Map resultMap = this.throwEspError(serviceId, responseModel);
        Map stdDataMap = resultMap.getOrDefault(BODY_STD_DATA, null);
        if (stdDataMap != null) {
            return stdDataMap.getOrDefault("parameter", null);
        }
        return Maps.newHashMap();
    }

    private Map<String, Object> throwEspError(String serviceId, ResponseModel responseModel) {
        if (Objects.isNull(responseModel) || Objects.isNull(responseModel.getEspCode())) {
            String error = String.format(this.messageUtils.getMessage("exception.execution.api.fail6"), serviceId);
            throw BizException.getDefaultBizException((Integer)599, (String)error);
        }
        if (!responseModel.getEspCode().startsWith("0")) {
            String error = String.format(this.messageUtils.getMessage(EXECUTION_FAIL), LocalDateTime.now(), serviceId, responseModel.getEspMessage());
            throw BizException.getDefaultBizException((Integer)599, (String)error);
        }
        if (!StringUtils.hasText((String)responseModel.getBodyJsonString())) {
            String error = String.format(this.messageUtils.getMessage("exception.execution.api.fail2"), serviceId);
            throw BizException.getDefaultBizException((Integer)599, (String)error);
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(new /* Unavailable Anonymous Inner Class!! */.getType(), (Object)new DataTypeAdapter()).create();
        Map espResponse = (Map)gson.fromJson(responseModel.getBodyJsonString(), new /* Unavailable Anonymous Inner Class!! */.getType());
        if (espResponse.containsKey("error")) {
            String error = String.format(this.messageUtils.getMessage(EXECUTION_FAIL), LocalDateTime.now(), serviceId, espResponse.get("error"));
            throw BizException.getDefaultBizException((Integer)599, (String)error);
        }
        Map stdDataMap = espResponse.getOrDefault(BODY_STD_DATA, null);
        if (stdDataMap == null) {
            String error = String.format(this.messageUtils.getMessage("exception.execution.api.fail3"), serviceId, responseModel.getBodyJsonString());
            throw BizException.getDefaultBizException((Integer)599, (String)error);
        }
        Map execution = stdDataMap.getOrDefault("execution", null);
        if (execution == null) {
            String error = String.format(this.messageUtils.getMessage("exception.execution.api.fail4"), serviceId, responseModel.getBodyJsonString());
            throw BizException.getDefaultBizException((Integer)599, (String)error);
        }
        if (!"000".equals(responseModel.getSrvCode())) {
            String description = execution.getOrDefault("description", "");
            String code = execution.getOrDefault("code", "");
            throw BizException.getDefaultBizException((Integer)Integer.parseInt(code), (String)description);
        }
        return espResponse;
    }
}

