/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.fineReport.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.fineReport.model.resp.FineReportTreeVO;
import com.digiwin.athena.semc.proxy.fineReport.model.resp.FineReportUserVO;
import com.digiwin.athena.semc.proxy.fineReport.service.FineReportProxyService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class FineReportProxyServiceImpl
implements FineReportProxyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FineReportProxyServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    private static final String QUERY_FINE_REPORT_ENTRY_TREE = "/webroot/decision/sp/client/api/v3/entry/tree?device=";
    private static final String ADD_FINE_REPORT_USER = "/webroot/decision/sp/client/api/v3/user";
    private static final Map<String, String> FINE_REPORT_ERROR_CODE_MAP = ImmutableMap.of((Object)"21300015", (Object)"\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef");

    public List<FineReportTreeVO> queryFineReportEntryTree(String clientId, String secret, String deviceType) {
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        header.add("clientId", clientId);
        header.add("secret", secret);
        HttpEntity requestMap = new HttpEntity(null, (MultiValueMap)header);
        StringBuilder url = new StringBuilder(this.envProperties.getFineReportUrl()).append(QUERY_FINE_REPORT_ENTRY_TREE).append(deviceType);
        try {
            ResponseEntity response = this.restTemplate.exchange(url.toString(), HttpMethod.GET, requestMap, JSONObject.class, new Object[0]);
            if (200 == response.getStatusCodeValue() && response.getBody() != null) {
                JSONArray data = ((JSONObject)response.getBody()).getJSONArray("data");
                return JSONArray.parseArray((String)data.toJSONString(), FineReportTreeVO.class);
            }
            log.info("query fineReport entry tree return empty, url:{}, request:{}, response:{}", new Object[]{url, requestMap, JSONObject.toJSONString((Object)response)});
            return Lists.newArrayList();
        }
        catch (Exception ex) {
            log.error("query fineReport entry tree occur error, url:{}, request:{}, errorMsg:{}", new Object[]{url, requestMap, ex.getMessage(), ex});
            return Lists.newArrayList();
        }
    }

    public void addFineReportUser(String clientId, String secret, FineReportUserVO fineReportUserVO) {
        JSONObject result = this.operateFineReportUser(clientId, secret, ADD_FINE_REPORT_USER, Collections.singletonList(fineReportUserVO), HttpMethod.POST);
        this.checkFineReportUserResponse(result);
    }

    public void updateFineReportUser(String clientId, String secret, FineReportUserVO fineReportUserVO) {
        JSONObject result = this.operateFineReportUser(clientId, secret, ADD_FINE_REPORT_USER, Collections.singletonList(fineReportUserVO), HttpMethod.PUT);
        this.checkFineReportUserResponse(result);
    }

    private void checkFineReportUserResponse(JSONObject response) {
        JSONObject parseResult;
        Object data = JSONPath.eval((Object)response, (String)"$.data[0]");
        if (data != null && !(parseResult = JSON.parseObject((String)JSON.toJSONString((Object)data))).getBooleanValue("status")) {
            String errorCode = parseResult.getString("errorCode");
            String errorMessage = (String)FINE_REPORT_ERROR_CODE_MAP.get(errorCode);
            throw new RuntimeException("\u8c03\u7528\u5e06\u8f6f\u670d\u52a1\u5f02\u5e38\uff1a" + (errorMessage != null ? errorMessage : parseResult.getString("errorMsg")));
        }
    }

    public void deleteFineReportUser(String clientId, String secret, String frUserId) {
        JSONObject result = this.operateFineReportUser(clientId, secret, "/webroot/decision/sp/client/api/v3/user?user=[\"" + frUserId + "\"]", null, HttpMethod.DELETE);
        if (result != null && result.getInteger("status") != 200) {
            throw new RuntimeException("\u8c03\u7528\u5e06\u8f6f\u670d\u52a1\u5f02\u5e38\uff1a" + result.getString("errorMsg"));
        }
    }

    public List<FineReportUserVO> queryFineReportUser(String clientId, String secret, String frUserId) {
        JSONObject data;
        JSONObject response = this.operateFineReportUser(clientId, secret, "/webroot/decision/sp/client/api/v3/user?page=1&count=9999&username=" + frUserId, null, HttpMethod.GET);
        if (response != null && response.get((Object)"data") != null && (data = response.getJSONObject("data")).get((Object)"items") != null) {
            return JSON.parseArray((String)data.getJSONArray("items").toJSONString(), FineReportUserVO.class);
        }
        return Collections.emptyList();
    }

    private JSONObject operateFineReportUser(String clientId, String secret, String url, Object data, HttpMethod method) {
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        header.add("clientId", clientId);
        header.add("secret", secret);
        HttpEntity requestMap = new HttpEntity(data, (MultiValueMap)header);
        ResponseEntity response = this.restTemplate.exchange(this.envProperties.getFineReportUrl() + url, method, requestMap, JSONObject.class, new Object[0]);
        log.info("save fineReport user, url:{}, request:{}, response:{}", new Object[]{this.envProperties.getFineReportUrl() + url, JSONObject.toJSONString((Object)data), JSONObject.toJSONString((Object)response)});
        if (200 != response.getStatusCodeValue()) {
            throw new RuntimeException("\u8c03\u7528\u5e06\u8f6f\u670d\u52a1\u5f02\u5e38");
        }
        return (JSONObject)response.getBody();
    }
}

