/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.gmc.service.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.semc.dto.homepage.UpgradeInfoDTO;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.gmc.service.IGmcService;
import com.digiwin.athena.semc.util.DateUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class GmcServiceImpl
implements IGmcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GmcServiceImpl.class);
    private static final int PAGE_SIZE = 999;
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private EnvProperties envProperties;

    public List<UpgradeInfoDTO> getDeploy(boolean elaborate, String sid) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("platform", "Athena");
        String currentDate = DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss");
        param.put("startTime", DateUtils.addDate((String)currentDate, (String)"yyyy-MM-dd HH:mm:ss", (int)-1, (String)"year"));
        param.put("endTime", currentDate);
        param.put("pageSize", 999);
        param.put("sid", sid);
        param.put("elaborate", elaborate);
        HttpEntity requestEntity = new HttpEntity(param, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getGmcUri()).append("/api/gmc/v2/release/query");
        try {
            log.info("GmcServiceImpl getDeploy URL:{}, param:{}", (Object)url, (Object)JsonUtils.objectToString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            log.info("GmcServiceImpl getDeploy result:{}", (Object)JsonUtils.objectToString((Object)respEntity));
            if (200 == respEntity.getStatusCodeValue() && Objects.nonNull(respEntity.getBody())) {
                return JsonUtils.jsonToListObject((String)String.valueOf(((JSONObject)respEntity.getBody()).get("data")), UpgradeInfoDTO.class);
            }
            log.error("\u62c9\u53d6\u7248\u66f4\u4fe1\u606f\u5931\u8d25, \u8bf7\u6c42\u4f53\uff1a{}, url:{}, \u54cd\u5e94\u5185\u5bb9\uff1a{}", new Object[]{JsonUtils.objectToString((Object)requestEntity), url, JsonUtils.objectToString((Object)respEntity.getBody())});
            return null;
        }
        catch (Exception ex) {
            log.error("\u62c9\u53d6\u7248\u66f4\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u4f53\uff1a{}, url\uff1a{}", new Object[]{JsonUtils.objectToString((Object)requestEntity), url, ex});
            return null;
        }
    }
}

