/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.iam.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.exception.OperateException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.erpsso.AuthorizeDTO;
import com.digiwin.athena.semc.dto.erpsso.RegisterDTO;
import com.digiwin.athena.semc.entity.applink.TenantAppDTO;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.eoc.service.model.EocResultDTO;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.AccountDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.AppTenantDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.AppUserDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.BossIamTenantAuthDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.BossIamTenantDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.OrgAspectDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.OrgRoleUserDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.RoleDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.TenantSimpleDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.UserInfoDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.UserLangMetadataDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.UserOrgInfoDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.UserRoleDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.req.UserAllPermissionReqDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.resp.AppTenantRespVO;
import com.digiwin.athena.semc.proxy.iam.service.model.resp.TenantUserBaseRespVO;
import com.digiwin.athena.semc.proxy.iam.service.model.resp.TenantUserRespVO;
import com.digiwin.athena.semc.proxy.iam.service.model.resp.UserAllPermissionBaseRespVO;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.common.PermissionUserFunctionalDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationModulesSimpleDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationSimpleDTO;
import com.digiwin.athena.semc.vo.portal.AppExistVO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class IamServiceImpl
implements IamService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamServiceImpl.class);
    private static final String APPLICATION_REGISTER_V2 = "/api/iam/v2/oauth2/app/register";
    private static final String APPLICATION_QUERY_INFO_V2 = "/api/iam/v2/oauth2/app";
    private static final String TOKEN_ANALYZE_URL = "/api/iam/v2/identity/token/analyze";
    private static final String TENANT_APPLICATION_LIST_URL = "/api/iam/v2/tenant/application/list";
    private static final String MAPPING_QUERY_EMP_ID = "/api/iam/v2/mapping/query";
    private static final String USER_PERMISSION_V2 = "/api/iam/v2/permission/user";
    private static final String DEV_APP_LIST_V2 = "/api/iam/v2/dev/app";
    private static final String USER_APPLICATION = "/api/iam/v2/user/application";
    private static final String USER_FUNCTIONAL = "/api/iam/v2/permission/user/functional";
    private static final String COMPANY_FACORY = "/api/iam/v2/org/cascade";
    private static final String USER_LOGIN_INFO = "/api/iam/v2/user/current?withEmp=true";
    private static final String IAM_AUTHORIZE_V2 = "/api/iam/v2/oauth2/authorize";
    private static final String SAML_CALLBACK_URL_EXIT = "/api/iam/v2/saml/sys/exist";
    private static final String SAML_CALLBACK_URL_ADD = "/api/iam/v2/saml/sys/add";
    private static final String AUTHCODE_SAML_TOKEN = "/api/iam/v2/identity/token/saml/access";
    public static final String USERMETADATA_USER_GET = "/api/iam/v2/usermetadata/user/get";
    private static final String CAS_CALLBACK_URL_ADD = "/api/iam/v2/sys/sso/url/cfg/add";
    public static final String USER = "/api/iam/v2/user/full";
    public static final String QUERY_TENANT_BASIC_PATH = "/api/iam/v2/tenant/basic/by/apps";
    public static final String QUERY_TENANT_ROLE_LIST = "/api/iam/v2/role/simple";
    public static final String USER_EMAIL_TENANTS_AUTH = "/api/iam/v2/user/email/tenants/auth";
    public static final String TENANT_CURRENT_SIMPLE = "/api/iam/v2/tenant/current/simple";
    public static final String ORG_ASPECT = "/api/iam/v2/org/aspect";
    public static final String INTEGRATION_TOKEN = "/api/iam/v2/identity/login/internal";
    public static final String QUERY_USER_BY_VERIFY_USER_ID = "/api/iam/v2/mapping/query/appuser";
    public static final String QUERY_All_VERIFY_MAPPING_USER = "/api/iam/v2/mapping/query/app";
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private MessageUtils messageUtils;

    public Long registerApp(RegisterDTO registerDTO) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("name", registerDTO.getName());
        requestMap.put("description", registerDTO.getDescription());
        requestMap.put("callbackUrl", StringUtils.isBlank((CharSequence)registerDTO.getCallbackUrl()) ? String.format("http://www.%s.com", registerDTO.getName()) : registerDTO.getCallbackUrl());
        requestMap.put("logoImage", "");
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(APPLICATION_REGISTER_V2);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                return ((JSONObject)respEntity.getBody()).getLong("data");
            }
            log.error("\u4eceIAM\u6ce8\u518c\u5e94\u7528\u5931\u8d25, \u7528\u6237token:{}, appToken:{}, request:{}, url:{}, statusCode:{}, response\uff1a{}", new Object[]{userToken, this.envProperties.getAppToken(), requestMap, url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            throw new Exception(((JSONObject)Optional.ofNullable(respEntity.getBody()).orElse(new JSONObject())).getString("errorMessage"));
        }
        catch (Exception ex) {
            log.error("\u4eceIAM\u6ce8\u518c\u5e94\u7528\u53d1\u751f\u5f02\u5e38, \u7528\u6237token:{}, appToken:{}, request:{}, url:{}, errorMsg:{}", new Object[]{userToken, this.envProperties.getAppToken(), requestMap, url, ex.getMessage()});
            throw ex;
        }
    }

    public Long updateAppInfoForIAM(RegisterDTO registerDTO) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("name", registerDTO.getName());
        requestMap.put("description", registerDTO.getDescription());
        requestMap.put("callbackUrl", StringUtils.isBlank((CharSequence)registerDTO.getCallbackUrl()) ? String.format("http://www.%s.com", registerDTO.getName()) : registerDTO.getCallbackUrl());
        requestMap.put("logoImage", "");
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(APPLICATION_QUERY_INFO_V2).append("/").append(registerDTO.getSid());
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                return ((JSONObject)respEntity.getBody()).getLong("data");
            }
            log.error("\u8c03\u7528IAM\u66f4\u65b0\u5e94\u7528\u5931\u8d25, \u7528\u6237token:{}, appToken:{}, request:{}, url:{}, statusCode\uff1a{}, response:{}", new Object[]{userToken, this.envProperties.getAppToken(), requestMap, url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            throw new Exception(((JSONObject)Optional.ofNullable(respEntity.getBody()).orElse(new JSONObject())).getString("errorMessage"));
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528IAM\u66f4\u65b0\u5e94\u7528\u5f02\u5e38, \u7528\u6237token:{}, appToken:{}, request:{}, url:{}, errorMsg:{}", new Object[]{userToken, this.envProperties.getAppToken(), requestMap, url, ex.getMessage()});
            throw ex;
        }
    }

    public RegisterDTO queryAppInfo(Long appSid, String appToken) throws Exception {
        if (appSid == null) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(APPLICATION_QUERY_INFO_V2).append("/").append(appSid);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                JSONObject jsonObject = ((JSONObject)respEntity.getBody()).getJSONObject("data");
                return (RegisterDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject), RegisterDTO.class);
            }
            log.error("\u4eceIAM\u67e5\u8be2\u5e94\u7528\u4fe1\u606f\u5931\u8d25, appSid\uff1a{}, token:{}, appToken:{}, url\uff1a{}, statusCode:{}, response\uff1a{}", new Object[]{appSid, userToken, this.envProperties.getAppToken(), url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            throw new Exception(((JSONObject)Optional.ofNullable(respEntity.getBody()).orElse(new JSONObject())).getString("errorMessage"));
        }
        catch (Exception ex) {
            log.error("\u4eceIAM\u67e5\u8be2\u5e94\u7528\u4fe1\u606f\u53d1\u751f\u5f02\u5e38, appSid:{}, token: {}, appToken:{}, statusCode\uff1a{}, errorMsg:{}", new Object[]{appSid, userToken, this.envProperties.getAppToken(), url, ex.getMessage()});
            throw ex;
        }
    }

    public boolean checkUserToken(String userToken, String appToken) {
        boolean isUserTokenValid = false;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", appToken);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(TOKEN_ANALYZE_URL);
        try {
            log.info("Call IAM checks user token url:{}, param:{}", (Object)url, (Object)JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            log.info("Call IAM checks user token result:{}", (Object)JSONObject.toJSONString((Object)respEntity));
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                JSONObject jsonObject = (JSONObject)respEntity.getBody();
                isUserTokenValid = Objects.nonNull(jsonObject.get((Object)"id"));
            }
        }
        catch (Exception ex) {
            log.error("Call IAM checks user token error", (Throwable)ex);
            isUserTokenValid = false;
        }
        return isUserTokenValid;
    }

    public List<TenantAppDTO> queryTenantApps() {
        ArrayList<TenantAppDTO> appDTOList = new ArrayList<TenantAppDTO>();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        this.setAcceptLanguage(headers);
        HashMap<String, Boolean> requestMap = new HashMap<String, Boolean>();
        requestMap.put("showEntry", true);
        org.springframework.http.HttpEntity reqEntity = new org.springframework.http.HttpEntity(requestMap, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + TENANT_APPLICATION_LIST_URL;
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (200 == respEntity.getStatusCodeValue()) {
                return (List)respEntity.getBody();
            }
            log.error("\u83b7\u53d6\u79df\u6237\u4e0b\u7684\u5e94\u7528\u6e05\u5355\u5931\u8d25\uff0c\u7528\u6237token: {}, \u72b6\u6001\u7801\uff1a{}\uff0c\u54cd\u5e94\u5185\u5bb9\uff1a{}", new Object[]{AppAuthContextHolder.getContext().getAuthoredUser().getToken(), respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            return appDTOList;
        }
        catch (Exception ex) {
            log.error("\u83b7\u53d6\u79df\u6237\u4e0b\u7684\u5e94\u7528\u6e05\u5355\u5931\u8d25\uff0c\u7528\u6237token: {}, \u9519\u8bef\u5185\u5bb9\uff1a{}", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getToken(), (Object)ex.getMessage());
            return appDTOList;
        }
    }

    private void setAcceptLanguage(HttpHeaders headers) {
        String locale = LocaleContextHolder.getLocale().toString();
        if (StringUtils.isEmpty((CharSequence)locale)) {
            return;
        }
        locale = locale.replaceAll("_", "-");
        headers.add("Accept-Language", locale);
    }

    public String queryMappingEmpId(String appId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("tenantSid", 0);
        requestMap.put("userSid", 0);
        requestMap.put("identityId", appId);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(MAPPING_QUERY_EMP_ID);
        try {
            log.info("param:" + JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && CollectionUtils.isNotEmpty((Collection)((Collection)respEntity.getBody()))) {
                return ((JSONObject)((List)respEntity.getBody()).get(0)).getString("verifyUserId");
            }
            log.info("query mappingEmpId return empty, token:{}, request:{}, url:{}, statusCode:{}, response:{}", new Object[]{userToken, requestMap, url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            return null;
        }
        catch (Exception ex) {
            log.error("query mappingEmpId occur error, token:{}, request:{}, url:{}, errorMsg:{}", new Object[]{userToken, requestMap, url, ex.getMessage()});
            return null;
        }
    }

    public JSONArray queryUserPermissionV2(AuthoredUser authoredUser) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", authoredUser.getToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("userId", authoredUser.getUserId());
        requestMap.put("sysId", this.envProperties.getSemcAppId());
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(requestMap, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + USER_PERMISSION_V2;
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                return ((JSONObject)respEntity.getBody()).getJSONArray("data");
            }
            log.info("query user permission return empty, token:{}, url:{}, request:{}, statusCode:{}, response:{}", new Object[]{authoredUser.getToken(), url, requestMap, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            return null;
        }
        catch (Exception ex) {
            log.error("query user permission occur error, token:{}, url:{}, request\uff1a{}, errorMsg\uff1a{}", new Object[]{authoredUser.getToken(), url, requestMap, ex.getMessage()});
            throw BusinessException.create((String)ex.getMessage());
        }
    }

    public UserOrgInfoDTO qryUserOrgInfo(String userId, String token) {
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/org";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        httpHeaders.add("digi-middleware-auth-user-data", token);
        HashMap<String, String> reqBody = new HashMap<String, String>();
        reqBody.put("id", userId);
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(reqBody, (MultiValueMap)new HttpHeaders());
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, UserOrgInfoDTO.class, new Object[0]);
        if (200 == responseEntity.getStatusCodeValue()) {
            return (UserOrgInfoDTO)responseEntity.getBody();
        }
        throw new OperateException("Call iam get user organization info failed, status code: " + responseEntity.getStatusCodeValue() + ", response: " + responseEntity.getBody());
    }

    public List<Long> qryUserOrgSidList(String userId, String token) {
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/org";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        httpHeaders.add("digi-middleware-auth-user-data", token);
        HashMap<String, String> reqBody = new HashMap<String, String>();
        reqBody.put("id", userId);
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(reqBody, (MultiValueMap)new HttpHeaders());
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
        if (200 == responseEntity.getStatusCodeValue()) {
            ArrayList userOrgSidList = Lists.newArrayList();
            JSONObject body = (JSONObject)responseEntity.getBody();
            if (MapUtils.isEmpty((Map)body)) {
                return userOrgSidList;
            }
            JSONArray userInOrgs = body.getJSONArray("userInOrgs");
            if (CollectionUtils.isEmpty((Collection)userInOrgs)) {
                return userOrgSidList;
            }
            for (int i = 0; i < userInOrgs.size(); ++i) {
                userOrgSidList.add(userInOrgs.getJSONObject(i).getLong("orgSid"));
            }
            return userOrgSidList;
        }
        log.warn("Call iam get user organization info failed\uff1a{},{}", (Object)responseEntity.getStatusCodeValue(), (Object)((JSONObject)responseEntity.getBody()).toString());
        return Lists.newArrayList();
    }

    public List<RoleDTO> queryUserRoles(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", userId);
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/role";
        ResponseEntity roleResponseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserRoleDTO.class, new Object[0]);
        if (roleResponseEntity.getBody() == null) {
            return new ArrayList<RoleDTO>();
        }
        return ((UserRoleDTO)roleResponseEntity.getBody()).getRoles();
    }

    public List<Long> queryUserRolesSidList(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", userId);
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/role";
        ResponseEntity roleResponseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, JSONObject.class, new Object[0]);
        JSONObject body = (JSONObject)roleResponseEntity.getBody();
        ArrayList roleSidList = Lists.newArrayList();
        if (MapUtils.isEmpty((Map)body)) {
            return roleSidList;
        }
        JSONArray roles = ((JSONObject)roleResponseEntity.getBody()).getJSONArray("roles");
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return roleSidList;
        }
        for (int i = 0; i < roles.size(); ++i) {
            roleSidList.add(roles.getJSONObject(i).getLong("sid"));
        }
        return roleSidList;
    }

    public List<RoleDTO> queryAllUserList() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HashMap param = new HashMap();
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/simple";
        log.info("start query all user, url:{}, request:{}", (Object)url, (Object)httpEntity);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return (List)respEntity.getBody();
    }

    public List<RoleDTO> queryEnabledUserList() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/tenant/user/list?pageNum=1&pageSize=99999";
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                JSONArray data = ((JSONObject)respEntity.getBody()).getJSONArray("list");
                return JSONObject.parseArray((String)data.toJSONString(), RoleDTO.class);
            }
            log.info("query enabled user list return empty. url:{}, request:{}, response:{}", new Object[]{url, httpEntity, respEntity});
            return Lists.newArrayList();
        }
        catch (Exception ex) {
            log.error("query enabled user list occur error. url:{}, request:{}, errorMsg:{}", new Object[]{url, httpEntity, ex});
            return Lists.newArrayList();
        }
    }

    public List<OrgRoleUserDTO> queryUserByOrgSidList(List<Long> orgSidList) {
        ResponseEntity respEntity;
        if (CollectionUtils.isEmpty(orgSidList)) {
            return Lists.newArrayList();
        }
        String url = this.envProperties.getIamUri() + "/api/iam/v2/org/userinorg/list/simple";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("orgSids", orgSidList);
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(param, (MultiValueMap)headers);
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
        }
        catch (Exception ex) {
            log.error("query user by org sid list error, url:{}, token:{}, request:{}, errorMsg:{}", new Object[]{url, userToken, httpEntity, ex});
            throw BusinessException.create((String)ex.getMessage());
        }
        if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
            JSONArray data = ((JSONObject)respEntity.getBody()).getJSONArray("data");
            return JSONObject.parseArray((String)data.toJSONString(), OrgRoleUserDTO.class);
        }
        log.warn("query user by org sid list return empty, url:{}, token:{}, request:{}, statusCode:{}, response:{}", new Object[]{url, userToken, httpEntity, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
        return Lists.newArrayList();
    }

    public List<OrgRoleUserDTO> queryUserByAllOrgSidList(List<Long> orgSidList) {
        List list = ListUtil.split(orgSidList, (int)100);
        ArrayList resultList = Lists.newArrayList();
        for (List tempList : list) {
            resultList.addAll(this.queryUserByOrgSidList(tempList));
        }
        return resultList;
    }

    public List<OrgRoleUserDTO> queryUserByRoleSidList(List<Long> roleSidList) {
        ResponseEntity respEntity;
        if (CollectionUtils.isEmpty(roleSidList)) {
            return Lists.newArrayList();
        }
        String url = this.envProperties.getIamUri() + "/api/iam/v2/association/userinrole/list/simple";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("roleSids", roleSidList);
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(param, (MultiValueMap)headers);
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
        }
        catch (Exception ex) {
            log.error("query user by role sid list error, url:{}, token:{}, request:{}, errorMsg:{}", new Object[]{url, userToken, httpEntity, ex});
            throw BusinessException.create((String)ex.getMessage());
        }
        if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
            JSONArray data = ((JSONObject)respEntity.getBody()).getJSONArray("data");
            return JSONObject.parseArray((String)data.toJSONString(), OrgRoleUserDTO.class);
        }
        log.warn("query user by role sid list return empty, url:{}, token:{}, request:{}, statusCode:{}, response:{}", new Object[]{url, userToken, httpEntity, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
        return Lists.newArrayList();
    }

    public List<OrgRoleUserDTO> queryUserByAllRoleSidList(List<Long> roleSidList) {
        List list = ListUtil.split(roleSidList, (int)100);
        ArrayList resultList = Lists.newArrayList();
        for (List tempList : list) {
            resultList.addAll(this.queryUserByRoleSidList(tempList));
        }
        return resultList;
    }

    public List<AppExistVO.AppDTO> queryAppListExistAppToken() throws Exception {
        block8: {
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                URIBuilder builder = new URIBuilder("https://iam.digiwincloud.com.cn/api/iam/v2/dev/app");
                builder.addParameter("params", "{\"nonDev\":\"true\"}");
                HttpGet get = new HttpGet(builder.build());
                get.setHeader("digi-middleware-auth-app", this.envProperties.getAppToken());
                String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
                get.setHeader("digi-middleware-auth-user", this.getFormalZoneUserToken());
                log.info("srart query appList exist appToken, url:{}, headers:{}", (Object)builder, (Object)get);
                CloseableHttpResponse execute = httpClient.execute((HttpUriRequest)get);
                log.info("srart query appList resp:{}", (Object)JSONObject.toJSONString((Object)execute.getEntity()));
                if (200 == execute.getStatusLine().getStatusCode()) {
                    Gson gson = new Gson();
                    HttpEntity entity = execute.getEntity();
                    String content = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                    AppExistVO appExistDeveloperVO = (AppExistVO)gson.fromJson(content, AppExistVO.class);
                    if (!ObjectUtils.isEmpty((Object)appExistDeveloperVO)) {
                        List list = appExistDeveloperVO.getData();
                        return list;
                    }
                    break block8;
                }
                log.error("query appList exist appToken fail, url:{}, headers:{}, status:{}", new Object[]{builder, get, execute.getStatusLine().getStatusCode()});
                throw BusinessException.create((String)"query appList exist appToken fail");
            }
        }
        return null;
    }

    private String getFormalZoneUserToken() {
        String userToken = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("tenantId", "semcIntegrated");
        bodyMap.put("userId", "integration");
        bodyMap.put("passwordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B");
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(bodyMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange("https://iam.digiwincloud.com.cn/api/iam/v2/identity/login/internal", HttpMethod.POST, httpEntity, Map.class, new Object[0]);
        if (null != responseEntity.getBody()) {
            userToken = (String)((Map)responseEntity.getBody()).get("token");
        }
        log.info("\u83b7\u53d6 userToken, userToken:{}", userToken);
        return userToken;
    }

    public String queryIntegrationUserToken(String tenantId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("tenantId", tenantId);
        bodyMap.put("userId", "integration");
        bodyMap.put("identityType", "internal");
        bodyMap.put("passwordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B");
        String url = this.envProperties.getIamUri() + INTEGRATION_TOKEN;
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(bodyMap, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, Map.class, new Object[0]);
            if (null != response.getBody()) {
                return (String)((Map)response.getBody()).get("token");
            }
            log.info("query integration user token return empty, url:{}, request:{}, response:{}", new Object[]{url, httpEntity, JSONObject.toJSONString((Object)response.getBody())});
            return null;
        }
        catch (Exception ex) {
            log.error("query integration user token error, url:{}, request:{}, errMsg:{}", new Object[]{url, httpEntity, ex.getMessage(), ex});
            return null;
        }
    }

    public Map<String, Object> queryAppTokenBySid(Long sid) {
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        String userToken = this.getFormalZoneUserToken();
        header.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        header.add("digi-middleware-auth-user", userToken);
        org.springframework.http.HttpEntity requestMap = new org.springframework.http.HttpEntity(null, (MultiValueMap)header);
        String url = "https://iam.digiwincloud.com.cn/api/iam/v2/dev/app/" + sid;
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestMap, Map.class, new Object[0]);
            if (200 == response.getStatusCodeValue() && response.getBody() != null) {
                Map map = (Map)((Map)response.getBody()).get("data");
                return map;
            }
            log.info("query appToken by sid return empty, url:{}, userToken:{}, appToken:{}, request:{}, statusCode:{}, response:{}", new Object[]{url, userToken, this.envProperties.getAppToken(), requestMap, response.getStatusCodeValue(), JSONObject.toJSONString((Object)response.getBody())});
            return null;
        }
        catch (Exception ex) {
            log.error("query appToken by sid occur error, url:{}, userToken:{}, appToken:{}, request:{}, errorMsg:{}", new Object[]{url, userToken, this.envProperties.getAppToken(), requestMap, ex.getMessage()});
            return null;
        }
    }

    public AuthorizeDTO queryAuthorizeInfo(String appId, String callbackUrl) throws Exception {
        if (appId == null || StringUtils.isBlank((CharSequence)callbackUrl)) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("appId", appId);
        requestMap.put("callbackUrl", callbackUrl);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(IAM_AUTHORIZE_V2);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                JSONObject jsonObject = ((JSONObject)respEntity.getBody()).getJSONObject("data");
                return (AuthorizeDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject), AuthorizeDTO.class);
            }
            log.error("\u4eceIAM\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5931\u8d25, appId\uff1a{}, token:{}, callbackUrl:{}, url\uff1a{}, statusCode:{}, response\uff1a{}", new Object[]{appId, userToken, callbackUrl, url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            return null;
        }
        catch (Exception ex) {
            log.error("\u4eceIAM\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u53d1\u751f\u5f02\u5e38, appId:{}, token: {}, callbackUrl:{}, url\uff1a{}, errorMsg:{}", new Object[]{appId, userToken, callbackUrl, url, ex.getMessage()});
            String error = String.format(this.messageUtils.getMessage("error.message.iam.authorize.exception"), LocalDateTime.now(), IAM_AUTHORIZE_V2);
            throw BusinessException.create((String)error);
        }
    }

    public List<UserApplicationDTO> queryUserApplication() {
        List<Object> userApplicationList = new ArrayList<UserApplicationDTO>();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(USER_APPLICATION);
        try {
            log.info("query user application param:{}", (Object)JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity, JSONArray.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                userApplicationList = JSONArray.parseArray((String)((JSONArray)respEntity.getBody()).toString(), UserApplicationDTO.class);
                return userApplicationList;
            }
        }
        catch (Exception ex) {
            log.error("query user application error. url:{}, request:{}, errorMsg:{}", new Object[]{url, JSONObject.toJSONString((Object)requestEntity), ex.getMessage()});
            return userApplicationList;
        }
        return userApplicationList;
    }

    public List<UserApplicationSimpleDTO> queryUserApplicationSimple(boolean filterAppExpired, boolean filterModuleExpired, boolean validPermission) {
        ArrayList<UserApplicationSimpleDTO> userApplicationList = new ArrayList<UserApplicationSimpleDTO>();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(USER_APPLICATION);
        try {
            log.info("query user application param:{}", (Object)JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity, JSONArray.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && CollectionUtils.isNotEmpty((Collection)((Collection)respEntity.getBody()))) {
                JSONArray body = (JSONArray)respEntity.getBody();
                for (int i = 0; i < body.size(); ++i) {
                    JSONObject appJSONObject = body.getJSONObject(i);
                    if (filterAppExpired && Boolean.TRUE.equals(appJSONObject.getBoolean("expired"))) continue;
                    UserApplicationSimpleDTO userApplicationSimpleDTO = new UserApplicationSimpleDTO();
                    userApplicationSimpleDTO.setId(appJSONObject.getString("id"));
                    if (!validPermission) {
                        userApplicationSimpleDTO.setName(appJSONObject.getString("name"));
                    }
                    JSONArray enabledModules = appJSONObject.getJSONArray("enabledModules");
                    ArrayList modulesSimpleDTOList = Lists.newArrayList();
                    if (CollectionUtils.isNotEmpty((Collection)enabledModules)) {
                        for (int j = 0; j < enabledModules.size(); ++j) {
                            JSONObject modulesJSONObject = enabledModules.getJSONObject(j);
                            if (filterModuleExpired && Boolean.TRUE.equals(modulesJSONObject.getBoolean("expired"))) continue;
                            UserApplicationModulesSimpleDTO userApplicationModulesSimpleDTO = new UserApplicationModulesSimpleDTO();
                            userApplicationModulesSimpleDTO.setId(modulesJSONObject.getString("id"));
                            if (!validPermission) {
                                userApplicationModulesSimpleDTO.setName(modulesJSONObject.getString("name"));
                            }
                            modulesSimpleDTOList.add(userApplicationModulesSimpleDTO);
                        }
                    }
                    userApplicationSimpleDTO.setEnabledModules((List)modulesSimpleDTOList);
                    userApplicationList.add(userApplicationSimpleDTO);
                }
            }
        }
        catch (Exception ex) {
            log.error("query user application error. url:{}, request:{}, errorMsg:{}", new Object[]{url, JSONObject.toJSONString((Object)requestEntity), ex.getMessage()});
            return userApplicationList;
        }
        return userApplicationList;
    }

    public List<PermissionUserFunctionalDTO> queryUserFunctional(String target, AuthoredUser authoredUser) {
        List<Object> functionalDTOList = new ArrayList<PermissionUserFunctionalDTO>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = authoredUser.getToken();
        String userId = authoredUser.getUserId();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("userId", userId);
        requestMap.put("target", target);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(USER_FUNCTIONAL);
        try {
            log.info("query user functional param:{}", (Object)JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && null != respEntity.getBody()) {
                JSONObject resultJson = ((JSONObject)respEntity.getBody()).getJSONObject("result");
                functionalDTOList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)resultJson.getJSONArray("permissions")), PermissionUserFunctionalDTO.class);
            }
        }
        catch (Exception ex) {
            log.error("query user functional error. url:{}, request:{}, errorMsg:{}", new Object[]{url, JSONObject.toJSONString((Object)requestEntity), ex.getMessage()});
            return functionalDTOList;
        }
        return functionalDTOList;
    }

    public JSONArray getCompanyFactory() {
        JSONArray resultArray = new JSONArray();
        String cascadeUrl = this.envProperties.getIamUri() + COMPANY_FACORY;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        headers.add("digi-middleware-auth-user", Utils.getUserToken());
        org.springframework.http.HttpEntity responseHttpEntity = new org.springframework.http.HttpEntity((MultiValueMap)headers);
        try {
            log.info("/api/iam/v2/org/cascade param{} ", (Object)JSONObject.toJSONString((Object)responseHttpEntity));
            ResponseEntity responseEntity = this.restTemplate.exchange(cascadeUrl, HttpMethod.GET, responseHttpEntity, JSONObject.class, new Object[0]);
            JSONObject body = (JSONObject)responseEntity.getBody();
            resultArray = body.getJSONArray("defaultOrgAspect");
        }
        catch (Exception e) {
            log.error("\u4eceiam\u83b7\u53d6\u516c\u53f8\u522b\u5382\u522b\uff0c error, token:{},request:{},errorMsg:{}", new Object[]{Utils.getUserToken(), JSONObject.toJSONString((Object)responseHttpEntity), e.getMessage()});
            return resultArray;
        }
        return resultArray;
    }

    public List<String> getIamEmail() {
        LinkedList<String> emailInfo = new LinkedList<String>();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(USER_LOGIN_INFO);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity, JSONObject.class, new Object[0]);
            JSONObject body = (JSONObject)responseEntity.getBody();
            if (body != null) {
                String emailPrefix = body.getString("email").substring(0, body.getString("email").indexOf("@"));
                String emailSuffix = body.getString("email").substring(body.getString("email").indexOf("@") + 1);
                emailInfo.add(emailPrefix);
                emailInfo.add(emailSuffix);
                return emailInfo;
            }
        }
        catch (Exception ex) {
            log.error("\u4eceIAM\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u90ae\u4ef6\u8be6\u7ec6\u4fe1\u606f,email:{}", emailInfo);
            return new LinkedList<String>();
        }
        return new LinkedList<String>();
    }

    public ResponseEntity<?> checkExitAndAddSAMLCallbackUrl(String successCallbackUrl, String failCallbackUrl) {
        ResponseEntity responseEntity;
        HashMap callbackExitMap = new HashMap();
        String url = this.envProperties.getIamUri() + SAML_CALLBACK_URL_EXIT;
        try {
            ResponseEntity respEntity = this.postIamRequest(url, new HashMap(0));
            int respCode = respEntity.getStatusCodeValue();
            JSONObject respBody = (JSONObject)respEntity.getBody();
            if (200 == respCode && respBody != null) {
                Integer code = respBody.getInteger("code");
                Boolean success = respBody.getBoolean("success");
                String message = respBody.getString("message");
                String data = respBody.getString("data");
                responseEntity = 200 == code && success.booleanValue() && "success".equals(message) && "true".equals(data) ? ResponseEntityWrapper.wrapperOk((Object)true) : this.addSAMLCallbackUrl(successCallbackUrl, failCallbackUrl);
            } else {
                log.warn("query saml callback url return empty, url:{}, request:{}, statusCode:{}, response:{}", new Object[]{url, callbackExitMap, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
                responseEntity = ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.invoke.iam.error"));
            }
        }
        catch (Exception ex) {
            log.error("query saml callback url occur error, url:{}, request\uff1a{}, errorMsg\uff1a{}", new Object[]{url, callbackExitMap, ex.getMessage()});
            responseEntity = ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.invoke.iam.error"));
        }
        return responseEntity;
    }

    public ResponseEntity<?> addSamlCallbackUrl(String successCallbackUrl, String failCallbackUrl) {
        return this.addSAMLCallbackUrl(successCallbackUrl, failCallbackUrl);
    }

    private ResponseEntity<?> addSAMLCallbackUrl(String successCallbackUrl, String failCallbackUrl) {
        ResponseEntity responseEntity;
        HashMap<String, String> callbackAddMap = new HashMap<String, String>();
        callbackAddMap.put("sysName", "Athena");
        callbackAddMap.put("successCallbackUrl", successCallbackUrl);
        callbackAddMap.put("failCallbackUrl", failCallbackUrl);
        String signArg = Utils.encodeSignArg(callbackAddMap);
        String url = this.envProperties.getIamUri() + SAML_CALLBACK_URL_ADD;
        try {
            ResponseEntity respEntity = this.postIamRequest(url, callbackAddMap, signArg);
            log.info("add saml callback url result, url:{}, request:{}, statusCode:{}, response:{}", new Object[]{url, callbackAddMap, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            int respCode = respEntity.getStatusCodeValue();
            JSONObject respBody = (JSONObject)respEntity.getBody();
            if (null == respBody) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.invoke.iam.error"));
            }
            if (200 == respCode && respBody != null) {
                Integer code = respBody.getInteger("code");
                Boolean success = respBody.getBoolean("success");
                String message = respBody.getString("message");
                responseEntity = 200 == code && success.booleanValue() && "success".equals(message) ? ResponseEntityWrapper.wrapperOk((Object)true) : ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.invoke.iam.error"));
            } else {
                log.warn("add saml callback url return result, url:{}, request:{}, statusCode:{}, response:{}", new Object[]{url, callbackAddMap, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
                responseEntity = ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)respBody.getString("errorMessage"));
            }
        }
        catch (Exception ex) {
            log.error("add saml callback url occur error, url:{}, request\uff1a{}, errorMsg\uff1a{}", new Object[]{url, callbackAddMap, ex.getMessage()});
            responseEntity = ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.invoke.iam.error"));
        }
        return responseEntity;
    }

    public ResponseEntity<?> queryUserTokenByAuthCode(String authCode, String ssoType) {
        ResponseEntity responseEntity;
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("code", authCode);
        if (!ObjectUtils.isEmpty((Object)ssoType)) {
            requestMap.put("ssoType", "cas");
        }
        String url = this.envProperties.getIamUri() + AUTHCODE_SAML_TOKEN;
        try {
            ResponseEntity respEntity = this.postIamRequest(url, requestMap);
            log.info("query user token return result, authCode:{}, url:{}, request:{}, statusCode:{}, response:{}", new Object[]{authCode, url, requestMap, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            int respCode = respEntity.getStatusCodeValue();
            JSONObject respBody = (JSONObject)respEntity.getBody();
            if (null == respBody) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.invoke.iam.error"));
            }
            if (200 == respCode && respBody != null) {
                Integer code = respBody.getInteger("code");
                Boolean success = respBody.getBoolean("success");
                String message = respBody.getString("message");
                JSONObject data = respBody.getJSONObject("data");
                responseEntity = 200 == code && success.booleanValue() && "success".equals(message) ? ResponseEntityWrapper.wrapperOk((Object)data) : ResponseEntityWrapper.wrapperOk((Object)false);
            } else {
                log.warn("query userToken from iam return result, url:{}, request:{}, statusCode:{}, response:{}", new Object[]{url, requestMap, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
                responseEntity = ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)respBody.getString("errorMessage"));
            }
        }
        catch (Exception ex) {
            log.error("query userToken from iam occur error, authCode:{}, url:{}, request\uff1a{}, errorMsg\uff1a{}", new Object[]{authCode, url, requestMap, ex.getMessage()});
            responseEntity = ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.invoke.iam.error"));
        }
        return responseEntity;
    }

    private ResponseEntity<JSONObject> postIamRequest(String url, Map<String, Object> requestParam) {
        HttpHeaders header = new HttpHeaders();
        header.add("Content-Type", "application/json");
        header.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(requestParam, (MultiValueMap)header);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
    }

    private ResponseEntity<JSONObject> postIamRequest(String url, Map<String, Object> requestParam, String encode) {
        HttpHeaders header = new HttpHeaders();
        header.add("Content-Type", "application/json");
        header.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        header.add("digi-middleware-sign-arg", encode);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(requestParam, (MultiValueMap)header);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
    }

    public String queryUserLangMetadata() {
        String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        String userId = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("catalogId", "basic");
        params.put("key", "dapAcceptLanguage");
        params.put("userId", userId);
        params.put("tenantSid", 0);
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(params, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + USERMETADATA_USER_GET;
        try {
            log.info("start query user lang metadata. url:{}, param:{}", (Object)url, (Object)JSONObject.toJSONString((Object)httpEntity));
            ResponseEntity respEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserLangMetadataDTO.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                UserLangMetadataDTO baseResult = (UserLangMetadataDTO)respEntity.getBody();
                Optional<Object> langOpt = Optional.ofNullable(baseResult.getData()).map(data -> data.get("value"));
                return langOpt.isPresent() ? String.valueOf(langOpt.get()) : "zh_CH";
            }
            log.error("query user lang metadata fail, url\uff1a{}, param:{}, response\uff1a{}", new Object[]{url, JSONObject.toJSONString((Object)httpEntity), JSONObject.toJSONString((Object)respEntity.getBody())});
            return "zh_CH";
        }
        catch (Exception ex) {
            log.error("query user lang metadata error, url\uff1a{}, param:{}, message\uff1a{}", new Object[]{url, JSONObject.toJSONString((Object)httpEntity), ex.getMessage()});
            return "zh_CH";
        }
    }

    public boolean batchUserAuthorizeApp(String appId, List<Long> userSidList, Integer type) {
        String url = this.envProperties.getIamUri() + "/api/iam/v2/tenant/batch/auth/user/update";
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        headers.add("digi-middleware-auth-user", userToken);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("appId", appId);
        param.put("action", type);
        param.put("userSids", userSidList);
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(param, (MultiValueMap)headers);
        try {
            log.info("IAMServiceImpl | invoke batch auth user interface, url\uff1a{}, param:{}", (Object)url, (Object)JSONObject.toJSONString((Object)httpEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                JSONObject jsonObject = (JSONObject)respEntity.getBody();
                return jsonObject.getBoolean("success");
            }
            log.error("IAMServiceImpl | batch user authorize app fail, url\uff1a{}, param:{}, response\uff1a{}", new Object[]{url, JSONObject.toJSONString((Object)httpEntity), JSONObject.toJSONString((Object)respEntity.getBody())});
            return false;
        }
        catch (Exception ex) {
            log.error("IAMServiceImpl | batch user authorize app error, url\uff1a{}, param:{}, errorMessage\uff1a{}", new Object[]{url, JSONObject.toJSONString((Object)httpEntity), ex});
            return false;
        }
    }

    public ResponseEntity<?> addCasCallbackUrl(String successCallbackUrl, String failCallbackUrl, String logoutCallbackUrl) {
        ResponseEntity responseEntity;
        HashMap<String, String> callbackAddMap = new HashMap<String, String>();
        callbackAddMap.put("sysName", "Athena");
        callbackAddMap.put("successCallbackUrl", successCallbackUrl);
        callbackAddMap.put("failCallbackUrl", failCallbackUrl);
        callbackAddMap.put("logoutCallbackUrl", logoutCallbackUrl);
        callbackAddMap.put("ssoType", "cas");
        String signArg = Utils.encodeSignArg(callbackAddMap);
        String url = this.envProperties.getIamUri() + CAS_CALLBACK_URL_ADD;
        try {
            ResponseEntity respEntity = this.postIamRequest(url, callbackAddMap, signArg);
            log.info("add cas callback url result, url:{}, request:{}, statusCode:{}, response:{}", new Object[]{url, callbackAddMap, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            int respCode = respEntity.getStatusCodeValue();
            JSONObject respBody = (JSONObject)respEntity.getBody();
            if (null == respBody) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.invoke.iam.error"));
            }
            if (200 == respCode && respBody != null) {
                Integer code = respBody.getInteger("code");
                Boolean success = respBody.getBoolean("success");
                String message = respBody.getString("message");
                responseEntity = 200 == code && success.booleanValue() && "success".equals(message) ? ResponseEntityWrapper.wrapperOk((Object)true) : ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.invoke.iam.error"));
            } else {
                log.warn("add cas callback url return result, url:{}, request:{}, statusCode:{}, response:{}", new Object[]{url, callbackAddMap, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
                responseEntity = ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)respBody.getString("errorMessage"));
            }
        }
        catch (Exception e) {
            log.error("add cas callback url occur error, url:{}, request\uff1a{}, errorMsg\uff1a{}", new Object[]{url, callbackAddMap, e.getMessage()});
            responseEntity = ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.invoke.iam.error"));
        }
        return responseEntity;
    }

    public UserInfoDTO queryUser(String userId, Long sid, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        HashMap<String, String> param = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            param.put("id", userId);
        }
        if (Objects.nonNull(sid)) {
            param.put("sid", String.valueOf(sid));
        }
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + USER;
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserInfoDTO.class, new Object[0]);
        return (UserInfoDTO)responseEntity.getBody();
    }

    public Map<String, Object> getTenantAuth(AuthoredUser authoredUser, String email, String telephone, String appId, Integer tenantType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)email) && StringUtils.isEmpty((CharSequence)telephone)) {
            return null;
        }
        appId = StringUtils.isNotEmpty((CharSequence)appId) ? appId : "Athena";
        tenantType = tenantType != null ? tenantType : 0;
        String url = this.envProperties.getIamUri() + USER_EMAIL_TENANTS_AUTH;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", authoredUser.getToken());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("email", email);
        param.put("telephone", telephone);
        param.put("appId", appId);
        param.put("tenantType", tenantType);
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(param, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, EocResultDTO.class, new HashMap());
            if (responseEntity == null || responseEntity.getStatusCode() != HttpStatus.OK) {
                resultMap.put("status", -1);
                log.error("\u83b7\u53d6\u7528\u6237\u5f52\u5c5e\u7684\u79df\u6237\u4ee5\u53ca\u6307\u5b9a\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25");
                return resultMap;
            }
            EocResultDTO eocResultDTO = (EocResultDTO)responseEntity.getBody();
            if (eocResultDTO == null) {
                resultMap.put("status", -1);
                log.error("\u83b7\u53d6\u7528\u6237\u5f52\u5c5e\u7684\u79df\u6237\u4ee5\u53ca\u6307\u5b9a\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25");
                return resultMap;
            }
            BossIamTenantAuthDTO bossIamTenantAuthDTO = (BossIamTenantAuthDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)eocResultDTO.getData()), BossIamTenantAuthDTO.class);
            List bossIamTenantDTOS = bossIamTenantAuthDTO.getTenants();
            if (CollectionUtils.isEmpty((Collection)bossIamTenantDTOS)) {
                resultMap.put("status", 0);
                log.error("\u83b7\u53d6\u7528\u6237\u5f52\u5c5e\u7684\u79df\u6237\u4ee5\u53ca\u6307\u5b9a\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff1a\u6ca1\u6709\u4e2a\u4eba\u79df\u6237");
                return resultMap;
            }
            BossIamTenantDTO bossIamTenantDTO = (BossIamTenantDTO)bossIamTenantDTOS.get(0);
            if (!bossIamTenantDTO.getIsTenantAuth().booleanValue() || !bossIamTenantDTO.getIsUserAuth().booleanValue()) {
                resultMap.put("status", 1);
                resultMap.put("userId", bossIamTenantAuthDTO.getUserId());
                resultMap.put("tenantId", bossIamTenantDTO.getId());
                resultMap.put("isTenantAuth", bossIamTenantDTO.getIsTenantAuth());
                resultMap.put("isUserAuth", bossIamTenantDTO.getIsUserAuth());
                log.error("\u83b7\u53d6\u7528\u6237\u5f52\u5c5e\u7684\u79df\u6237\u4ee5\u53ca\u6307\u5b9a\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff08\u6ca1\u6709\u6388\u6743\uff09\uff1a{}", (Object)bossIamTenantAuthDTO);
                return resultMap;
            }
            resultMap.put("status", 2);
            resultMap.put("userId", bossIamTenantAuthDTO.getUserId());
            resultMap.put("tenantId", bossIamTenantDTO.getId());
            resultMap.put("isTenantAuth", bossIamTenantDTO.getIsTenantAuth());
            resultMap.put("isUserAuth", bossIamTenantDTO.getIsUserAuth());
        }
        catch (Exception e) {
            resultMap.put("status", -1);
            log.error("\u83b7\u53d6\u7528\u6237\u5f52\u5c5e\u7684\u79df\u6237\u4ee5\u53ca\u6307\u5b9a\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        return resultMap;
    }

    public List<AppTenantDTO> queryTenantByApp(List<String> appIds) {
        List<Object> tenantInfoDTOList = new ArrayList<AppTenantDTO>();
        if (CollectionUtils.isEmpty(appIds)) {
            return tenantInfoDTOList;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, List<String>> requestMap = new HashMap<String, List<String>>();
        requestMap.put("appIds", appIds);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(QUERY_TENANT_BASIC_PATH);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 != respEntity.getStatusCodeValue() || respEntity.getBody() == null || null == ((JSONObject)respEntity.getBody()).get((Object)"data")) {
                return tenantInfoDTOList;
            }
            tenantInfoDTOList = (List)JsonUtils.jsonToObject((String)JSONObject.toJSONString((Object)((JSONObject)respEntity.getBody()).get((Object)"data")), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return tenantInfoDTOList;
        }
        catch (Exception ex) {
            log.error("\u6279\u91cf\u6839\u636e\u5e94\u7528id\u67e5\u8be2\u6388\u6743\u7684\u79df\u6237\u57fa\u672c\u4fe1\u606f error, request\uff1a{}, errorMsg\uff1a{}", (Object)JSONObject.toJSONString(requestMap), (Object)ex.getMessage());
            return tenantInfoDTOList;
        }
    }

    public List<AppTenantRespVO> queryBuyTenantListByAppId(String appId) {
        List appTenantRespVOList = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)appId)) {
            return appTenantRespVOList;
        }
        HttpHeaders headers = this.getCommonHeaders();
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(null, (MultiValueMap)headers);
        String urlName = "\u67e5\u8be2\u8d2d\u4e70\u4e86\u6307\u5b9a\u5e94\u7528\u7684\u79df\u6237";
        String url = this.envProperties.getIamUri() + "/api/iam/v2/tenant/apps/" + appId;
        log.info("{}\u8bf7\u6c42\uff1a{}\uff0c{}", new Object[]{urlName, url, JSON.toJSONString((Object)headers.toSingleValueMap())});
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, String.class, new Object[0]);
            if (HttpStatus.OK != response.getStatusCode() || StringUtils.isBlank((CharSequence)((CharSequence)response.getBody()))) {
                log.info("{}\u8bf7\u6c42\u5931\u8d25\uff1a{}\uff0c{}", new Object[]{urlName, response.getStatusCodeValue(), response.getBody()});
                return appTenantRespVOList;
            }
            String body = (String)response.getBody();
            log.info("{}\u8fd4\u56de\uff1a{}", (Object)urlName, (Object)StringUtils.substring((String)body, (int)0, (int)500));
            appTenantRespVOList = JSON.parseArray((String)body, AppTenantRespVO.class);
        }
        catch (Exception ex) {
            log.info("{}\u5f02\u5e38\uff1a{}", new Object[]{urlName, ex.getMessage(), ex});
        }
        return appTenantRespVOList;
    }

    public List<TenantUserRespVO> queryUserListByTenantId(String tenantId) {
        List tenantUserRespVOList = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            return tenantUserRespVOList;
        }
        HttpHeaders headers = this.getCommonHeaders();
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(null, (MultiValueMap)headers);
        String urlName = "\u83b7\u53d6\u79df\u6237\u4e0b\u7528\u6237\u5217\u8868";
        String url = this.envProperties.getBossIamUri() + "/api/boss/v1/users/simple/" + tenantId;
        log.info("{}\u8bf7\u6c42\uff1a{}\uff0c{}", new Object[]{urlName, url, JSON.toJSONString((Object)headers.toSingleValueMap())});
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, String.class, new Object[0]);
            if (HttpStatus.OK != response.getStatusCode() || StringUtils.isBlank((CharSequence)((CharSequence)response.getBody()))) {
                log.info("{}\u8bf7\u6c42\u5931\u8d25\uff1a{}\uff0c{}", new Object[]{urlName, response.getStatusCodeValue(), response.getBody()});
                return tenantUserRespVOList;
            }
            String body = (String)response.getBody();
            log.info("{}\u8fd4\u56de\uff1a{}", (Object)urlName, (Object)StringUtils.substring((String)body, (int)0, (int)500));
            TenantUserBaseRespVO tenantUserBaseRespVO = (TenantUserBaseRespVO)JSON.parseObject((String)body, TenantUserBaseRespVO.class);
            tenantUserRespVOList = tenantUserBaseRespVO.getData();
        }
        catch (Exception ex) {
            log.info("{}\u5f02\u5e38\uff1a{}", new Object[]{urlName, ex.getMessage(), ex});
        }
        return tenantUserRespVOList;
    }

    public UserAllPermissionBaseRespVO queryUserAllPermission(UserAllPermissionReqDTO reqDTO) {
        UserAllPermissionBaseRespVO userAllPermissionBaseRespVO = null;
        HttpHeaders headers = this.getCommonHeaders();
        Map requestMap = BeanUtil.beanToMap((Object)reqDTO, (boolean)false, (boolean)true);
        String urlName = "\u83b7\u53d6\u7528\u6237\u7684\u529f\u80fd\u6743\u9650";
        String url = this.envProperties.getIamUri() + "/api/iam/v2/permission/user/all";
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((Object)requestMap, (MultiValueMap)headers);
        log.info("{}\u8bf7\u6c42\uff1a{}\uff0c{}\uff0c{}", new Object[]{urlName, url, JSON.toJSONString((Object)requestMap), JSON.toJSONString((Object)headers.toSingleValueMap())});
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            if (HttpStatus.OK != response.getStatusCode() || StringUtils.isBlank((CharSequence)((CharSequence)response.getBody()))) {
                log.info("{}\u8bf7\u6c42\u5931\u8d25\uff1a{}\uff0c{}", new Object[]{urlName, response.getStatusCodeValue(), response.getBody()});
                return null;
            }
            String body = (String)response.getBody();
            log.info("{}\u8fd4\u56de\uff1a{}", (Object)urlName, (Object)StringUtils.substring((String)body, (int)0, (int)500));
            userAllPermissionBaseRespVO = (UserAllPermissionBaseRespVO)JSON.parseObject((String)body, UserAllPermissionBaseRespVO.class);
        }
        catch (Exception ex) {
            log.info("{}\u5f02\u5e38\uff1a{}", new Object[]{urlName, ex.getMessage(), ex});
        }
        return userAllPermissionBaseRespVO;
    }

    private HttpHeaders getCommonHeaders() {
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        header.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        header.add("digi-middleware-auth-user", userToken);
        return header;
    }

    public List<RoleDTO> queryAllRoleList() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(QUERY_TENANT_ROLE_LIST);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                return (List)respEntity.getBody();
            }
            log.error("query role list fail. url:{}, request:{}, response:{}", new Object[]{url, httpEntity, JSONObject.toJSONString((Object)respEntity.getBody())});
            return null;
        }
        catch (Exception ex) {
            log.error("query role list occur error. url:{}, request:{}, errorMsg:{}", new Object[]{url, httpEntity, ex.getMessage()});
            return null;
        }
    }

    public List<AccountDTO> queryTenantAccountMappingList(String appId, String companyId, String account) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        String urlPath = "/api/iam/v2/tenantmapping/list?appId=";
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            urlPath = urlPath + appId;
        } else if (StringUtils.isNotBlank((CharSequence)companyId)) {
            urlPath = urlPath + "&companyId=" + companyId;
        } else if (StringUtils.isNotBlank((CharSequence)account)) {
            urlPath = urlPath + "&account=" + account;
        }
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(urlPath);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                JSONArray data = ((JSONObject)respEntity.getBody()).getJSONArray("data");
                return JSONArray.parseArray((String)data.toJSONString(), AccountDTO.class);
            }
            log.error("query tenant account mapping list fail. url:{}, request:{}, response:{}", new Object[]{url, httpEntity, JSONObject.toJSONString((Object)respEntity.getBody())});
            return Lists.newArrayList();
        }
        catch (Exception ex) {
            log.error("query tenant account mapping error. url:{}, request:{}, errorMsg:{}", new Object[]{url, httpEntity, ex.getMessage()});
            return Lists.newArrayList();
        }
    }

    public TenantSimpleDTO queryTenantSimple() {
        TenantSimpleDTO simpleDTO = new TenantSimpleDTO();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(TENANT_CURRENT_SIMPLE);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                simpleDTO = (TenantSimpleDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((JSONObject)respEntity.getBody()).getJSONObject("data")), TenantSimpleDTO.class);
                return simpleDTO;
            }
            log.error("/api/iam/v2/tenant/current/simple fail. url:{}, request:{}, response:{}", new Object[]{url, httpEntity, JSONObject.toJSONString((Object)respEntity.getBody())});
            return simpleDTO;
        }
        catch (Exception ex) {
            log.error("/api/iam/v2/tenant/current/simple error. url:{}, request:{}, errorMsg:{}", new Object[]{url, httpEntity, ex.getMessage()});
            return simpleDTO;
        }
    }

    public List<OrgAspectDTO> getOrgAspect() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("id", "defaultOrgAspect");
        requestMap.put("catalogId", "defaultOrgCatalog");
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(ORG_ASPECT);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (200 == respEntity.getStatusCodeValue()) {
                return (List)respEntity.getBody();
            }
        }
        catch (Exception ex) {
            log.error("/api/iam/v2/org/aspect error. url:{}, request:{}, errorMsg:{}", new Object[]{url, requestEntity, ex.getMessage()});
            return null;
        }
        return null;
    }

    public String queryVerifyMappingUser(String userToken, String appCode, String verifyUserId) {
        if (StringUtils.isBlank((CharSequence)appCode) || StringUtils.isBlank((CharSequence)verifyUserId)) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("identityId", appCode);
        requestMap.put("verifyUserId", verifyUserId);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(QUERY_USER_BY_VERIFY_USER_ID);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                String userId = ((JSONObject)respEntity.getBody()).getString("verifyUserId");
                return userId;
            }
            log.info("query by verify userId return empty, url:{}, request:{}, response:{}", new Object[]{url, requestEntity, JSONObject.toJSONString((Object)respEntity.getBody())});
            return null;
        }
        catch (Exception ex) {
            log.error("query by verify userId error, url:{}, request:{}, errMsg:{}", new Object[]{url, requestEntity, ex.getMessage(), ex});
            return null;
        }
    }

    public List<AppUserDTO> queryAllVerifyMappingUser(String userToken, String appCode) {
        if (StringUtils.isBlank((CharSequence)appCode)) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("identityId", appCode);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(QUERY_All_VERIFY_MAPPING_USER);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONArray.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                return JSONArray.parseArray((String)((JSONArray)respEntity.getBody()).toString(), AppUserDTO.class);
            }
            log.info("query all verify mapping user return empty, url:{}, request:{}, response:{}", new Object[]{url, requestEntity, JSONObject.toJSONString((Object)respEntity.getBody())});
            return Lists.newArrayList();
        }
        catch (Exception ex) {
            log.error("query all verify mapping user error, url:{}, request:{}, errMsg:{}", new Object[]{url, requestEntity, ex.getMessage(), ex});
            return Lists.newArrayList();
        }
    }
}

