/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.kbs.service.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.kbs.service.KbsService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class KbsServiceImpl
implements KbsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KbsServiceImpl.class);
    private static final String fileQueryUrl = "/restful/standard/kbs/knowledge/permission/base/home/info/get";
    private static final String fileInfoUrl = "/restful/standard/kbs/knowledge/permission/file/detail/get";
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;

    public JSONArray selectKnowledgeInfo(String content) {
        JSONArray resp = new JSONArray();
        String kbsUri = this.envProperties.getKbsUri();
        StringBuilder kbsUriBuilder = new StringBuilder();
        kbsUriBuilder.append(kbsUri).append(fileQueryUrl);
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.set("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap map = Maps.newHashMap();
        map.put("search_content", content);
        map.put("search_range", "");
        map.put("knowledge_classification_info", Lists.newArrayList());
        map.put("tag_classification_info", Lists.newArrayList());
        map.put("start_time", "");
        map.put("end_time", "");
        HashMap mapPagination = Maps.newHashMap();
        mapPagination.put("page", 1);
        mapPagination.put("page_size", Constants.MAXPAGESIZE);
        map.put("pagination", mapPagination);
        map.put("tab_no", "all");
        com.alibaba.fastjson.JSONObject req = new com.alibaba.fastjson.JSONObject();
        req.put("knowledge_info", (Object)map);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(kbsUriBuilder.toString(), HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        log.info("Call KBS file query result:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)responseEntity));
        JSONObject jsonObjectResponse = (JSONObject)((JSONObject)responseEntity.getBody()).get("response");
        if (com.alibaba.fastjson.JSONObject.toJSONString((Object)jsonObjectResponse.get("data")).equals("null")) {
            return resp;
        }
        JSONObject objectData = (JSONObject)jsonObjectResponse.get("data");
        JSONArray jsonArrayKnowledgeInfo = (JSONArray)objectData.get("knowledge_info");
        return jsonArrayKnowledgeInfo;
    }

    public JSONObject getFileDetail(String fileId) {
        JSONObject responseData = new JSONObject();
        String kbsUri = this.envProperties.getKbsUri();
        StringBuilder kbsUriBuilder = new StringBuilder();
        kbsUriBuilder.append(kbsUri).append(fileInfoUrl);
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.set("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap map = Maps.newHashMap();
        map.put("file_id", fileId);
        com.alibaba.fastjson.JSONObject req = new com.alibaba.fastjson.JSONObject();
        req.put("file_info", (Object)map);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity fileDetail = this.restTemplate.exchange(kbsUriBuilder.toString(), HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        log.info("Call KBS file detail result:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)fileDetail));
        JSONObject jsonObjectBody = (JSONObject)fileDetail.getBody();
        JSONObject jsonObjectBodyResponse = (JSONObject)jsonObjectBody.get("response");
        if (!((Boolean)jsonObjectBodyResponse.get("success")).booleanValue()) {
            return responseData;
        }
        responseData = (JSONObject)jsonObjectBodyResponse.get("data");
        return responseData;
    }
}

