/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.km.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.semc.dto.BaseResultDTO;
import com.digiwin.athena.semc.dto.module.TenantModuleDto;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import com.digiwin.athena.semc.service.workbench.constant.EnvOperateEnum;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class KmServiceImpl
implements KmService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KmServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    private static final String QUERY_APP_JOB_PATH = "/restful/standard/datamap/record/activitiesInfoByPattern";
    private static final String QUERY_APP_JOB_TENANTID_PATH = "/restful/standard/datamap/record/activitiesInfoByTenantId";
    private static final String QUERY_TEMAMT_MODULE = "/restful/service/datamap/record/tenantModule";
    private static final String QUERY_TENANT_VERSION_PATH = "/restful/service/knowledgegraph/tenant/tenantVersion?tenantId={tenantId}";

    public List<AppJobDTO> queryAppJobList() {
        String url = this.envProperties.getAppmetadataUrl() + QUERY_APP_JOB_PATH;
        return this.getAppJobDTOS(url);
    }

    public List<AppJobDTO> queryAppJobListBy() {
        String url = this.envProperties.getAppmetadataUrl() + QUERY_APP_JOB_TENANTID_PATH;
        return this.getAppJobDTOS(url);
    }

    private List<AppJobDTO> getAppJobDTOS(String url) {
        ResponseEntity responseEntity;
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("query km application job list error, url:{}, request:{}", new Object[]{url, httpEntity, e});
            return Lists.newArrayList();
        }
        if (responseEntity.getStatusCodeValue() == HttpStatus.OK.value() && responseEntity.getBody() != null) {
            JSONArray data = ((JSONObject)responseEntity.getBody()).getJSONArray("response");
            if (CollectionUtils.isEmpty((Collection)data)) {
                log.error("query km application job list return empty, url:{}, request:{}, response:{}", new Object[]{url, httpEntity, responseEntity});
                return Lists.newArrayList();
            }
            log.info("query km application job list success, request:{}", (Object)httpEntity);
            return JSONArray.parseArray((String)data.toJSONString(), AppJobDTO.class);
        }
        log.error("query km application job list fail, url:{}, request:{}, response:{}", new Object[]{url, httpEntity, responseEntity});
        return Lists.newArrayList();
    }

    public String queryTenantVersion() {
        String url = this.envProperties.getKmDomain() + QUERY_TENANT_VERSION_PATH;
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, params);
        if (HttpStatus.OK.value() == respEntity.getStatusCodeValue() && null != respEntity.getBody() && ((BaseResultDTO)respEntity.getBody()).isOK()) {
            return (String)((BaseResultDTO)respEntity.getBody()).getResponse();
        }
        throw BusinessException.create((String)("\u8bf7\u6c42KM\u83b7\u53d6\u79df\u6237" + tenantId + "\u7248\u672c\u53d1\u751f\u9519\u8bef"));
    }

    public String queryTenantVersionWithDefault() {
        String tenantVersion = this.queryTenantVersion();
        return StringUtils.isNotBlank((CharSequence)tenantVersion) ? tenantVersion : EnvOperateEnum.SWITCH.getVersion();
    }

    public List<TenantModuleDto> queryTenantModuleList(String pattern) {
        ResponseEntity responseEntity;
        String url = this.envProperties.getKmDomain() + QUERY_TEMAMT_MODULE + "?pattern=" + pattern;
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("query km tenant module list error, url:{}, request:{}", new Object[]{url, httpEntity, e});
            return Lists.newArrayList();
        }
        if (responseEntity.getStatusCodeValue() == HttpStatus.OK.value() && responseEntity.getBody() != null) {
            JSONArray data = ((JSONObject)responseEntity.getBody()).getJSONArray("response");
            if (CollectionUtils.isEmpty((Collection)data)) {
                log.error("query km tenant module list return empty, url:{}, request:{}, response:{}", new Object[]{url, httpEntity, responseEntity});
                return Lists.newArrayList();
            }
            log.info("query km tenant module list success, request:{}", (Object)httpEntity);
            return JSONArray.parseArray((String)data.toJSONString(), TenantModuleDto.class);
        }
        log.error("query km tenant module list fail, url:{}, request:{}, response:{}", new Object[]{url, httpEntity, responseEntity});
        return Lists.newArrayList();
    }
}

