/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.maycur.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.maycur.MayCurService;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class MayCurServiceImpl
implements MayCurService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MayCurServiceImpl.class);
    @Resource
    RestTemplate restTemplate;
    @Resource
    EocService eocService;
    private static final String MAYCUR_SSO_URL = "/sso?entCode=%s&userId=%s&timestamp=%s&token=%s";

    public String getSsoToken(String userId, String secretKey, long timestamp) {
        String ssoToken = DigestUtils.sha256Hex((byte[])(secretKey + ":" + userId + ":" + timestamp).getBytes());
        return ssoToken;
    }

    public String getHomeSsoUrl(String callback, String entCode, String userId, String ssoToken, long timestamp) {
        callback = callback + MAYCUR_SSO_URL;
        String authUrl = String.format(callback, entCode, userId, timestamp, ssoToken);
        return authUrl;
    }

    public String getCloudSsoUrl(String callback, String entCode, String userId, String ssoToken, String formCategory, long timestamp) {
        String jobSsoUrl = String.format(callback + MAYCUR_SSO_URL, entCode, userId, timestamp, ssoToken);
        jobSsoUrl = jobSsoUrl + "&formCategory=" + formCategory;
        return jobSsoUrl;
    }

    public String getJobSsoUrl(String callback, String entCode, String userId, String ssoToken, String url, long timestamp) {
        String jobSsoUrl = String.format(callback + MAYCUR_SSO_URL + "&language=zh&url=%s", entCode, userId, timestamp, ssoToken, url);
        return jobSsoUrl;
    }

    public String getReplaceExistUrl(String url, String entCode, String userId, long timestamp, String ssoToken) {
        String finalPath = url.replace("/sso?entCode={entCode}&userId={userId}&timestamp={timestamp}&token={token}", MAYCUR_SSO_URL);
        String jobSsoUrl = String.format(finalPath, entCode, userId, timestamp, ssoToken);
        return jobSsoUrl;
    }

    public ResponseEntity<Map> getTokenId(LabelSystemDataDto labelSystemDataDto, String userId) {
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)new HttpHeaders());
        String authUrl = String.format(labelSystemDataDto.getCallBackUrl() + "/api/web/auth/sso?entCode=%s&userId=%s&timestamp=%s&token=%s", labelSystemDataDto.getAppId(), userId, System.currentTimeMillis(), this.getSsoToken(userId, labelSystemDataDto.getAppSecret(), System.currentTimeMillis()));
        ResponseEntity response = null;
        try {
            response = this.restTemplate.exchange(authUrl, HttpMethod.GET, httpEntity, Map.class, new Object[0]);
            log.info("getTokenId resp, request:{}, result:{}", (Object)authUrl, (Object)JSONObject.toJSONString((Object)response));
        }
        catch (RestClientException e) {
            log.error("getTokenId error, request:{}, request:{},errorMessage:{}", new Object[]{authUrl, JSONObject.toJSONString((Object)response), e.getMessage()});
            return null;
        }
        return response;
    }

    public List<Map<String, Object>> listMayCurData(String tokenId, int pageNum, LabelSystemDataDto labelSystemDataDto) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("entCode", labelSystemDataDto.getAppId());
        headers.set("tokenId", tokenId);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        List<Map<String, Object>> map = new LinkedList<Map<String, Object>>();
        try {
            responseEntity = this.restTemplate.exchange(labelSystemDataDto.getCallBackUrl() + "/api/web/report/approvals?limit=500" + "&offset=" + pageNum, HttpMethod.GET, httpEntity, Map.class, new Object[0]);
            if (null != responseEntity && null != responseEntity.getBody()) {
                map = (List)((Map)responseEntity.getBody()).get("data");
                return map;
            }
            log.info("listMayCurData resp, request:{}, result:{}", (Object)JSONObject.toJSONString((Object)httpEntity), (Object)JSONObject.toJSONString((Object)responseEntity));
        }
        catch (RestClientException e) {
            log.error("listMayCurData error, request:{}, request:{},errorMessage:{}", new Object[]{JSONObject.toJSONString((Object)httpEntity), JSONObject.toJSONString(responseEntity), e.getMessage()});
            return map;
        }
        return map;
    }
}

