/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.mdc.impl;

import com.alibaba.excel.event.SyncReadListener;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.mdc.MdcService;
import com.digiwin.athena.semc.proxy.mdc.model.TenantProductOperationDTO;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.DMCBuilder;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class MdcServiceImpl
implements MdcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MdcServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    private static final String TENANT_PRODUCT_OPERATION_LIST_GET = "/restful/standard/mdc/TenantProductOperationList/Get";

    public List<TenantProductOperationDTO> getTenantProductOperationList(String tenantId, String prodName) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("tenant_id", tenantId);
        requestMap.put("prod_name", prodName);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getMdcDomain()).append(TENANT_PRODUCT_OPERATION_LIST_GET);
        try {
            log.info("getTenantProductOperationList. param:{}", (Object)JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            log.info("getTenantProductOperationList response:{}", (Object)JSONObject.toJSONString((Object)respEntity.getBody()));
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null && ((JSONObject)respEntity.getBody()).containsKey((Object)"org_type_company")) {
                JSONArray data = ((JSONObject)respEntity.getBody()).getJSONArray("org_type_company");
                return JSONArray.parseArray((String)data.toJSONString(), TenantProductOperationDTO.class);
            }
            log.info("getTenantProductOperationList return empty, userToken:{}, request:{}, url:{}, code:{}, response:{}", new Object[]{userToken, requestMap, url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            return Lists.newArrayList();
        }
        catch (Exception ex) {
            log.error("getTenantProductOperationList error, userToken:{}, request:{}, url:{}, errorMessage:{}", new Object[]{userToken, requestMap, url, ex.getMessage()});
            throw BusinessException.create((String)ex.getMessage());
        }
    }

    public DMC buildDmc() {
        return DMCBuilder.create().build(this.envProperties.getDmcUri(), "entrance", "entrance123456", this.envProperties.getSemcAppId());
    }

    public <T> List<T> doReadSync(SyncReadListener listener) {
        return listener.getList();
    }
}

