/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.trans.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.semc.dto.common.TranslateReq;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.cache.ICacheService;
import java.time.Duration;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class TranslateServiceImpl
implements TranslateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TranslateServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private ICacheService cacheService;
    private static final String DAP_TRANSLATE_PATH = "/restful/service/translater/IDWTranslateService/translate";

    public String translateTextCache(String text, String businessFlag) {
        String locale = LocaleContextHolder.getLocale().toString();
        if (StringUtils.isBlank((CharSequence)text) || "en_US".equals(locale)) {
            return text;
        }
        String textKey = "zh_CN".equals(locale) ? "text-cn-cache:" + businessFlag + text : "text-tw-cache:" + businessFlag + text;
        String translateText = null;
        try {
            Object cache = this.cacheService.get(textKey);
            if (Objects.nonNull(cache)) {
                return String.valueOf(cache);
            }
            translateText = this.translateText(text);
            if (StringUtils.isNotBlank((CharSequence)translateText)) {
                this.cacheService.cache(textKey, translateText, Duration.ofHours(24L));
            }
        }
        catch (Exception e) {
            log.error("translateTextCache exception", (Throwable)e);
            return text;
        }
        return translateText;
    }

    public String translateText(String text) {
        return text;
    }

    public JSONObject translateTextPackage(TranslateReq translateReq) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("content", translateReq.getContent());
        requestMap.put("convertTypes", translateReq.getConvertTypes());
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getTransUri()).append(DAP_TRANSLATE_PATH);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                return ((JSONObject)respEntity.getBody()).getJSONObject("response");
            }
            log.error("translateTextPackage | translate text fail, url:{}, status:{}, response:{}", new Object[]{url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            return null;
        }
        catch (Exception ex) {
            log.error("translateTextPackage | translate text package error, url:{}, requestEntity:{}, errorMessage:{}", new Object[]{url, requestEntity, ex.getMessage()});
            throw BusinessException.create((String)ex.getMessage());
        }
    }
}

