/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.tripartite.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.util.DataTypeAdapter;
import com.digiwin.athena.semc.util.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class TripartiteServiceImpl
implements TripartiteService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TripartiteServiceImpl.class);
    @Resource
    private RestTemplate restTemplate;
    @Resource
    EnvProperties envProperties;
    private static final String BODY_STD_DATA = "std_data";
    private static final String THIRD_GROUP_BUSINESS_TODO_CONFIG_URL = "/third/business/todo/queryGroupList";
    private static final String THIRD_GROUP_BUSINESS_TODO_VALUE_URL = "/third/business/todo/queryGroupValueList";

    public Map<String, Object> selectDataPagePost(String url, LabelSystemPreReq bodyParam, String appToken) {
        Map<String, Object> result = new HashMap<String, Object>();
        String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-userToken", token);
        headers.add("digi-appToken", StringUtils.isBlank((CharSequence)appToken) ? this.envProperties.getAppToken() : appToken);
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        if (bodyParam.getPageSize() != null) {
            bodyMap.put("page_size", bodyParam.getPageSize());
        }
        if (bodyParam.getPageNum() != null) {
            bodyMap.put("page_no", bodyParam.getPageNum());
        }
        if (StringUtils.isNotEmpty((CharSequence)bodyParam.getQryCondition())) {
            bodyMap.put("query_condition", bodyParam.getQryCondition());
        }
        HttpEntity requestEntity = new HttpEntity(bodyMap, (MultiValueMap)headers);
        try {
            log.info("\u8bf7\u6c42\u4e09\u65b9\u7cfb\u7edfstart url:{},req:{}", (Object)url, bodyMap);
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            log.info("\u8bf7\u6c42\u4e09\u65b9\u7cfb\u7edf\u7ed3\u679c url:{},req:{},resp:{}", new Object[]{url, bodyMap, JSON.toJSONString((Object)respEntity.getBody())});
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                Gson gson = new GsonBuilder().registerTypeAdapter(new /* Unavailable Anonymous Inner Class!! */.getType(), (Object)new DataTypeAdapter()).create();
                result = (Map)gson.fromJson(JSON.toJSONString((Object)((JSONObject)respEntity.getBody()).getJSONObject("response")), new /* Unavailable Anonymous Inner Class!! */.getType());
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u4e09\u65b9\u7cfb\u7edf\u5f02\u5e38,,req:{},url:{},errorMsg:{}", new Object[]{bodyMap, url, e});
            return result;
        }
        return result;
    }

    public Map<String, Object> selectDataCountListPost(String countCode, List<String> contentCodeList, String url, String locale) {
        Map<String, Object> result = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)countCode) && CollectionUtils.isNotEmpty(contentCodeList)) {
            bodyMap.put("countType", countCode);
            bodyMap.put("countContent", contentCodeList);
        }
        bodyMap.put("locale", locale);
        HttpEntity requestEntity = new HttpEntity(bodyMap, (MultiValueMap)headers);
        try {
            log.info("start query third count data. url:{}, req:{}", (Object)url, bodyMap);
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            log.info("start query third count data end. url:{}, req:{}, resp:{}", new Object[]{url, bodyMap, JSON.toJSONString((Object)respEntity.getBody())});
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                Gson gson = new GsonBuilder().registerTypeAdapter(new /* Unavailable Anonymous Inner Class!! */.getType(), (Object)new DataTypeAdapter()).create();
                result = (Map)gson.fromJson(JSON.toJSONString((Object)((JSONObject)respEntity.getBody()).getJSONObject("response")), new /* Unavailable Anonymous Inner Class!! */.getType());
            }
        }
        catch (Exception e) {
            log.error("query third count data occur error. url:{}, req:{}", new Object[]{url, bodyMap, e});
            return result;
        }
        return result;
    }

    public Map<String, Object> queryThirdMessageDataPage(String url, Integer pageNo, Integer pageSize) {
        Map<String, Object> result = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        HashMap<String, Integer> bodyMap = new HashMap<String, Integer>();
        if (pageNo != null) {
            bodyMap.put("page_no", pageNo);
        }
        if (pageSize != null) {
            bodyMap.put("page_size", pageSize);
        }
        HttpEntity requestEntity = new HttpEntity(bodyMap, (MultiValueMap)headers);
        try {
            log.info("start query third message data page. url:{}, req:{}", (Object)url, bodyMap);
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            log.info("query third message data page over. url:{},req:{},resp:{}", new Object[]{url, bodyMap, JSON.toJSONString((Object)respEntity.getBody())});
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                Gson gson = new GsonBuilder().registerTypeAdapter(new /* Unavailable Anonymous Inner Class!! */.getType(), (Object)new DataTypeAdapter()).create();
                result = (Map)gson.fromJson(JSON.toJSONString((Object)((JSONObject)respEntity.getBody()).getJSONObject("response")), new /* Unavailable Anonymous Inner Class!! */.getType());
            } else {
                log.info("query third message data page fail. url:{}, param:{}, resp:{}", new Object[]{url, bodyMap, JSON.toJSONString((Object)respEntity.getBody())});
            }
        }
        catch (Exception e) {
            log.error("query third message data page error, url:{}, param:{}, errorMsg:{}", new Object[]{bodyMap, url, e});
            return result;
        }
        return result;
    }

    public JSONArray queryThirdData(String url, String appToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-appToken", StringUtils.isBlank((CharSequence)appToken) ? this.envProperties.getAppToken() : appToken);
        HashMap bodyMap = new HashMap();
        HttpEntity requestEntity = new HttpEntity(bodyMap, (MultiValueMap)headers);
        try {
            log.info("\u8bf7\u6c42\u4e09\u65b9\u7cfb\u7edf\u6570\u636e start url:{},req:{}", (Object)url, bodyMap);
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            log.info("\u8bf7\u6c42\u4e09\u65b9\u7cfb\u7edf\u6570\u636e \u7ed3\u679c url:{},req:{},resp:{}", new Object[]{url, bodyMap, JSON.toJSONString((Object)respEntity.getBody())});
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                JSONArray data = ((JSONObject)respEntity.getBody()).getJSONArray("response");
                return data;
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u4e09\u65b9\u7cfb\u7edf\u6570\u636e \u5f02\u5e38,,req:{},url:{},errorMsg:{}", new Object[]{bodyMap, url, e});
            return null;
        }
        return null;
    }

    public Map<String, Object> queryThirdData(String url, String appToken, Map<String, Object> bodyMap) {
        HashMap<String, Object> result = new HashMap();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-appToken", StringUtils.isBlank((CharSequence)appToken) ? this.envProperties.getAppToken() : appToken);
        HttpEntity requestEntity = new HttpEntity(bodyMap, (MultiValueMap)headers);
        try {
            log.info("\u8bf7\u6c42\u4e09\u65b9\u7cfb\u7edf\u6570\u636e start url:{},req:{}", (Object)url, bodyMap);
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            log.info("\u8bf7\u6c42\u4e09\u65b9\u7cfb\u7edf\u6570\u636e \u7ed3\u679c url:{},req:{},resp:{}", new Object[]{url, bodyMap, JSON.toJSONString((Object)respEntity.getBody())});
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                Gson gson = new GsonBuilder().registerTypeAdapter(new /* Unavailable Anonymous Inner Class!! */.getType(), (Object)new DataTypeAdapter()).create();
                result = (Map)gson.fromJson(JSON.toJSONString((Object)((JSONObject)respEntity.getBody()).getJSONObject("response")), new /* Unavailable Anonymous Inner Class!! */.getType());
                return result;
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u4e09\u65b9\u7cfb\u7edf\u6570\u636e \u5f02\u5e38,,req:{},url:{},errorMsg:{}", new Object[]{bodyMap, url, e});
            return null;
        }
        return null;
    }

    public Map<String, Object> queryThirdBusinessTodoGroupList(String restUrl) {
        Map<String, Object> result = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity requestEntity = new HttpEntity(bodyMap, (MultiValueMap)headers);
        String url = restUrl + THIRD_GROUP_BUSINESS_TODO_CONFIG_URL;
        try {
            log.info("start query third business todo group list. url:{}, param:{}", (Object)url, (Object)requestEntity);
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            log.info("query third business todo group list end. url:{}, param:{}, result:{}", new Object[]{restUrl, bodyMap, JSON.toJSONString((Object)respEntity.getBody())});
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                Gson gson = new GsonBuilder().registerTypeAdapter(new /* Unavailable Anonymous Inner Class!! */.getType(), (Object)new DataTypeAdapter()).create();
                result = (Map)gson.fromJson(JSON.toJSONString((Object)((JSONObject)respEntity.getBody()).getJSONObject("response")), new /* Unavailable Anonymous Inner Class!! */.getType());
            } else {
                log.info("query third business todo group list error fail. url:{}, param:{}, resp:{}", new Object[]{url, bodyMap, JSON.toJSONString((Object)respEntity.getBody())});
            }
        }
        catch (Exception e) {
            log.error("query third business todo group list error. url:{}, param:{}, errorMsg:{}", new Object[]{url, bodyMap, e});
            return result;
        }
        return result;
    }

    public Map<String, Object> queryThirdBusinessTodoValueList(LabelSystemData labelSystemData, String appToken) {
        Map<String, Object> result = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-userToken", Utils.getUserToken());
        headers.add("digi-appToken", appToken);
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("locale", LocaleContextHolder.getLocale().toString());
        if (StringUtils.isBlank((CharSequence)labelSystemData.getCountContentCode())) {
            bodyMap.put("groupConditionCode", labelSystemData.getCountCode());
        } else {
            bodyMap.put("groupCode", labelSystemData.getCountCode());
            bodyMap.put("groupConditionCode", labelSystemData.getCountContentCode());
        }
        HttpEntity requestEntity = new HttpEntity(bodyMap, (MultiValueMap)headers);
        String url = labelSystemData.getRestUrl() + THIRD_GROUP_BUSINESS_TODO_VALUE_URL;
        try {
            log.info("start query third business todo group value list. url:{}, param:{}", (Object)url, (Object)requestEntity);
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            log.info("query third business todo group value list end. url:{}, param:{}, result:{}", new Object[]{url, bodyMap, JSON.toJSONString((Object)respEntity.getBody())});
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                Gson gson = new GsonBuilder().registerTypeAdapter(new /* Unavailable Anonymous Inner Class!! */.getType(), (Object)new DataTypeAdapter()).create();
                result = (Map)gson.fromJson(JSON.toJSONString((Object)((JSONObject)respEntity.getBody()).getJSONObject("response")), new /* Unavailable Anonymous Inner Class!! */.getType());
            } else {
                log.info("query third business todo group value list error fail. url:{}, param:{}, resp:{}", new Object[]{url, bodyMap, JSON.toJSONString((Object)respEntity.getBody())});
            }
        }
        catch (Exception e) {
            log.error("query third business todo group value list error. url:{}, param:{}, errorMsg:{}", new Object[]{url, bodyMap, e});
            return result;
        }
        return result;
    }
}

