/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxywrapper.impl;

import com.alibaba.fastjson2.JSON;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxywrapper.IamUserService;
import com.digiwin.athena.semc.proxywrapper.dto.IamUserAuthInfo;
import com.digiwin.athena.semc.service.cache.CommonConfigService;
import com.digiwin.athena.semc.service.cache.ICacheService;
import com.digiwin.athena.semc.util.FormatUtil;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class IamUserServiceImpl
implements IamUserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamUserServiceImpl.class);
    @Qualifier(value="semcAsyncExecutor")
    private final Executor asyncTaskExecutor;
    private final IamService iamService;
    private final EocService eocService;
    private final ICacheService cacheService;
    private final CommonConfigService commonConfigService;

    public Tuple3<List<Long>, List<Long>, List<Long>> getUserAuthInfo(String userId, String userToken) {
        AtomicReference userOrgInfoDTO = new AtomicReference();
        AtomicReference roleDTOList = new AtomicReference();
        AtomicReference userInfoDetailDTO = new AtomicReference();
        CompletableFuture<List> completableFutureOrg = CompletableFuture.supplyAsync(() -> this.iamService.qryUserOrgSidList(userId, userToken), this.asyncTaskExecutor);
        CompletableFuture<List> completableFutureRole = CompletableFuture.supplyAsync(() -> this.iamService.queryUserRolesSidList(userId, userToken), this.asyncTaskExecutor);
        CompletableFuture<List> completableFutureDept = CompletableFuture.supplyAsync(() -> this.eocService.queryUserDeptSidList(userId), this.asyncTaskExecutor);
        CompletableFuture.allOf(completableFutureOrg, completableFutureRole, completableFutureDept).join();
        completableFutureOrg.handle((result, ex) -> {
            if (ex != null) {
                log.error("\u67e5\u8be2\u7528\u6237\u6240\u5728\u7ec4\u7ec7\u5f02\u5e38\uff1a", ex);
            } else {
                userOrgInfoDTO.set(result);
            }
            return result;
        });
        completableFutureRole.handle((result, ex) -> {
            if (ex != null) {
                log.error("\u67e5\u8be2\u7528\u6237\u6240\u5728\u89d2\u8272\u5f02\u5e38\uff1a", ex);
            } else {
                roleDTOList.set(result);
            }
            return result;
        });
        completableFutureDept.handle((result, ex) -> {
            if (ex != null) {
                log.error("\u67e5\u8be2\u7528\u6237\u6240\u5728\u90e8\u95e8\u5f02\u5e38\uff1a", ex);
            } else {
                userInfoDetailDTO.set(result);
            }
            return result;
        });
        return new Tuple3(userOrgInfoDTO.get(), roleDTOList.get(), userInfoDetailDTO.get());
    }

    private IamUserAuthInfo getNoCacheUserAuthSids(String userId, String userToken) {
        Tuple3 tuple3 = this.getUserAuthInfo(userId, userToken);
        List orgSidList = (List)tuple3._1;
        List roleSidList = (List)tuple3._2;
        List deptSidList = (List)tuple3._3;
        IamUserAuthInfo iamUserAuthInfo = new IamUserAuthInfo();
        boolean hasAuth = false;
        if (CollectionUtils.isNotEmpty((Collection)orgSidList)) {
            hasAuth = true;
            iamUserAuthInfo.setOrgSids(orgSidList);
        }
        if (CollectionUtils.isNotEmpty((Collection)roleSidList)) {
            hasAuth = true;
            iamUserAuthInfo.setRoleSids(roleSidList);
        }
        if (CollectionUtils.isNotEmpty((Collection)deptSidList)) {
            hasAuth = true;
            iamUserAuthInfo.setDeptSids(deptSidList);
        }
        if (hasAuth) {
            return iamUserAuthInfo;
        }
        return null;
    }

    public IamUserAuthInfo getUserAuthSids(String userId, String tenantId, String userToken) {
        Tuple2 tuple2 = this.commonConfigService.getIamUserAuthInfoConfig();
        if (Boolean.TRUE.equals(tuple2._1)) {
            String cacheKey = FormatUtil.format((String)"IamUserAuthInfo:{}:{}", (Object[])new Object[]{userId, tenantId});
            String cacheValue = this.cacheService.getValue(cacheKey);
            if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
                return (IamUserAuthInfo)JSON.parseObject((String)cacheValue, IamUserAuthInfo.class);
            }
            IamUserAuthInfo iamUserAuthInfo = this.getNoCacheUserAuthSids(userId, userToken);
            if (iamUserAuthInfo != null) {
                this.cacheService.cache(cacheKey, JSON.toJSONString((Object)iamUserAuthInfo), Duration.ofSeconds(((Integer)tuple2._2).intValue()));
            }
            return iamUserAuthInfo;
        }
        return this.getNoCacheUserAuthSids(userId, userToken);
    }

    public void removeUserAuthInfo(String userId, String tenantId) {
        String cacheKey = FormatUtil.format((String)"IamUserAuthInfo:{}:{}", (Object[])new Object[]{userId, tenantId});
        this.cacheService.delete(cacheKey);
    }

    public void removeSuperAdminFlagCache(String tenantId, String userId) {
        String cacheKey = FormatUtil.format((String)"SuperAdminFlag:{}:{}", (Object[])new Object[]{tenantId, userId});
        this.cacheService.delete(cacheKey);
    }

    @Generated
    public IamUserServiceImpl(@Qualifier(value="semcAsyncExecutor") Executor asyncTaskExecutor, IamService iamService, EocService eocService, ICacheService cacheService, CommonConfigService commonConfigService) {
        this.asyncTaskExecutor = asyncTaskExecutor;
        this.iamService = iamService;
        this.eocService = eocService;
        this.cacheService = cacheService;
        this.commonConfigService = commonConfigService;
    }
}

