/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.quartz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.dto.mq.MessageDO;
import com.digiwin.athena.semc.entity.message.ThirdMessageInfo;
import com.digiwin.athena.semc.event.ThirdMessageWecomEvent;
import com.digiwin.athena.semc.event.dto.ThirdMessageWecomEventDTO;
import com.digiwin.athena.semc.mapper.message.ThirdMessageInfoMapper;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.service.message.ThirdMessageInfoService;
import com.digiwin.athena.semc.service.mq.MessageSendService;
import com.digiwin.athena.semc.service.sso.IErpSsoInfoService;
import com.digiwin.athena.semc.util.DateUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class ThirdMessagePullTaskJob
extends QuartzJobBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdMessagePullTaskJob.class);
    @Resource
    private SchedulerFactoryBean schedulerFactoryBean;
    @Autowired
    private TripartiteService tripartiteService;
    @Autowired
    private ESPService espService;
    @Autowired
    private ThirdMessageInfoMapper thirdMessageInfoMapper;
    @Autowired
    private ThirdMessageInfoService thirdMessageInfoService;
    @Autowired
    private IErpSsoInfoService erpSsoInfoService;
    @Autowired
    private MessageSendService messageSendService;
    @Resource
    private IamService iamService;
    @Resource
    private ApplicationEventPublisher eventPublisher;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        try {
            String tenantId;
            List messageList = new ArrayList();
            Map params = (Map)context.getJobDetail().getJobDataMap().get((Object)"params");
            Integer appAccessModel = (Integer)params.get("appAccessModel");
            String id = ObjectUtils.isNotEmpty(params.get("id")) ? params.get("id").toString() : "";
            String string = tenantId = ObjectUtils.isNotEmpty(params.get("tenantsid")) ? params.get("tenantsid").toString() : "";
            if (appAccessModel == 0) {
                AuthoredUser athenaUser = new AuthoredUser();
                athenaUser.setTenantId(tenantId);
                AppAuthContextHolder.getContext().setAuthoredUser(athenaUser);
                LocaleContextHolder.setLocale((Locale)Locale.SIMPLIFIED_CHINESE);
                String middleSystemName = params.get("middleSystemName").toString();
                String middleSystemUid = params.get("middleSystemUid").toString();
                HashMap<String, String> extHeader = new HashMap<String, String>();
                extHeader.put("digi-userToken", "");
                extHeader.put("digi-appToken", "");
                int i = 1;
                while (true) {
                    HashMap<String, Object> parameter = new HashMap<String, Object>();
                    parameter.put("page_no", i);
                    parameter.put("page_size", 100);
                    parameter.put("tenant_id", tenantId);
                    Map result = this.espService.queryByEsp(middleSystemName, middleSystemUid, EAIServiceNameEnum.MESSAGE_PULL.getServiceName(), extHeader, parameter, null, null);
                    if (Objects.isNull(result.get("message_list"))) {
                        System.out.println("\u6df7\u5408\u4e91\u672a\u67e5\u8be2\u5230\u6d88\u606f\u6570\u636e");
                        break;
                    }
                    messageList = (List)result.get("message_list");
                    System.out.println("\u6df7\u5408\u4e91\u6d88\u606f\u6570\u636e" + messageList);
                    this.handleMessageData(params, messageList);
                    System.out.println("\u6df7\u5408\u4e91\u6d88\u606f\u4efb\u52a1:" + id + "\u6267\u884c\u6210\u529f\uff01");
                    if (!((Boolean)result.get("has_next")).booleanValue()) break;
                    ++i;
                }
            }
            if (appAccessModel == 1) {
                int i = 1;
                while (true) {
                    String domain = params.get("domain").toString();
                    HashMap<String, Object> bodyMap = new HashMap<String, Object>();
                    bodyMap.put("page_no", i);
                    bodyMap.put("page_size", 100);
                    bodyMap.put("tenant_id", tenantId);
                    Map jobData = this.tripartiteService.queryThirdData(domain + "/third/message/query", "", bodyMap);
                    if (null == jobData) {
                        System.out.println("\u975e\u6df7\u5408\u4e91\u672a\u67e5\u8be2\u5230\u6d88\u606f\u6570\u636e");
                    } else {
                        messageList = (List)jobData.get("message_list");
                        System.out.println("\u975e\u6df7\u5408\u4e91\u6d88\u606f\u6570\u636e" + messageList);
                        this.handleMessageData(params, messageList);
                        System.out.println("\u975e\u6df7\u5408\u4e91\u6d88\u606f\u4efb\u52a1:" + id + "\u6267\u884c\u6210\u529f\uff01");
                        if (((Boolean)jobData.get("has_next")).booleanValue()) {
                            ++i;
                            continue;
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println("\u6d88\u606f\u4efb\u52a1\u6267\u884c\u5931\u8d25");
        }
    }

    public void addJob(Map<String, Object> params) {
        try {
            String id = params.get("id").toString();
            Integer pullPeriod = (Integer)params.get("pullPeriod");
            Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
            JobDetail jobDetail = JobBuilder.newJob(ThirdMessagePullTaskJob.class).withIdentity("ThirdMessagePullTaskJob", "MessageJob_" + id).storeDurably(true).build();
            jobDetail.getJobDataMap().put("params", params);
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("ThirdMessagePullTaskJob", "MessageTrigger_" + id).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(pullPeriod.intValue()).repeatForever()).build();
            scheduler.scheduleJob(jobDetail, trigger);
            scheduler.start();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public void pauseJob(String name, String group) throws SchedulerException {
        JobKey jobKey;
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobDetail jobDetail = scheduler.getJobDetail(jobKey = new JobKey(name, group));
        if (jobDetail == null) {
            return;
        }
        scheduler.pauseJob(jobKey);
    }

    public void resumeJob(String name, String group) throws SchedulerException {
        JobKey jobKey;
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobDetail jobDetail = scheduler.getJobDetail(jobKey = new JobKey(name, group));
        if (jobDetail == null) {
            return;
        }
        scheduler.resumeJob(jobKey);
    }

    public void deleteJob(String name, String group) throws Exception {
        JobKey jobKey;
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobDetail jobDetail = scheduler.getJobDetail(jobKey = new JobKey(name, group));
        if (jobDetail == null) {
            return;
        }
        scheduler.deleteJob(jobKey);
    }

    public void handleMessageData(Map<String, Object> params, List<Map<String, Object>> messageList) {
        String userToken;
        String messageAppCode = ObjectUtils.isNotEmpty((Object)params.get("appCode")) ? params.get("appCode").toString() : "";
        String appId = ObjectUtils.isNotEmpty((Object)params.get("appId")) ? params.get("appId").toString() : "";
        String tenantId = ObjectUtils.isNotEmpty((Object)params.get("tenantsid")) ? params.get("tenantsid").toString() : "";
        String sendChannel = ObjectUtils.isNotEmpty((Object)params.get("sendChannel")) ? params.get("sendChannel").toString() : "";
        boolean allSeeFlag = Boolean.FALSE;
        ArrayList<Object> messageInfos = new ArrayList<Object>();
        ArrayList<Object> newMessageInfoList = new ArrayList<Object>();
        ArrayList<String> messageUserList = new ArrayList<String>();
        QueryWrapper condition = (QueryWrapper)new QueryWrapper().eq((Object)"message_app_id", (Object)appId);
        List thirdMessageInfoList = this.thirdMessageInfoService.list((Wrapper)condition);
        HashMap existMessageMap = CollectionUtils.isNotEmpty((Collection)thirdMessageInfoList) ? thirdMessageInfoList.stream().collect(Collectors.toMap(ThirdMessageInfo::getMessageId, a -> a, (k1, k2) -> k1)) : Maps.newHashMap();
        for (Map<String, Object> map : messageList) {
            ThirdMessageInfo messageInfo = new ThirdMessageInfo();
            messageInfo.setMessageAppCode(messageAppCode);
            messageInfo.setMessageAppId(appId);
            messageInfo.setMessageId(map.get("message_id").toString());
            messageInfo.setMessageTitle(map.get("message_title").toString());
            messageInfo.setMessageUrl(map.get("message_url").toString());
            messageInfo.setMessagePublishTime(map.get("message_publish_time").toString());
            messageInfo.setMessageContent(map.get("message_content").toString());
            messageInfo.setMessageOwner(map.get("message_owner").toString());
            String accountId = MapUtils.getString(map, (Object)"account_id");
            if (StringUtils.isNotBlank((CharSequence)accountId)) {
                messageInfo.setAccountId(accountId);
                messageInfo.setAccountName(MapUtils.getString(map, (Object)"account_name"));
            }
            messageInfo.setCreateTime(DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss"));
            messageInfo.setMessageAllStaffRead(Integer.valueOf(Integer.parseInt(map.get("message_all_staff_read").toString())));
            messageInfo.setTenantId(tenantId);
            messageInfo.setSideType(MapUtils.getInteger(map, (Object)"sideType", null));
            messageInfo.setMobileMessageUrl(MapUtils.getString(map, (Object)"mobileMessageUrl", null));
            if (existMessageMap.containsKey(messageInfo.getMessageId())) {
                ThirdMessageInfo existInfo = (ThirdMessageInfo)existMessageMap.get(messageInfo.getMessageId());
                messageInfo.setId(existInfo.getId());
                messageInfo.setModifyTime(DateUtils.getNowTime(null));
                if (Constants.MESSAGE_ALL_STAFF_FLAG.equals(messageInfo.getMessageAllStaffRead())) {
                    messageInfo.setMessageOwner("all");
                    allSeeFlag = Boolean.TRUE;
                } else {
                    messageInfo.setMessageOwner(existInfo.getMessageOwner().equals("all") ? messageInfo.getMessageOwner() : existInfo.getMessageOwner() + "," + messageInfo.getMessageOwner());
                    messageUserList.addAll(Arrays.asList(messageInfo.getMessageOwner().split(",")));
                }
            } else {
                messageInfo.setCreateTime(DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss"));
                if (Constants.MESSAGE_ALL_STAFF_FLAG.equals(messageInfo.getMessageAllStaffRead())) {
                    messageInfo.setMessageOwner("all");
                    allSeeFlag = Boolean.TRUE;
                } else {
                    messageUserList.addAll(Arrays.asList(messageInfo.getMessageOwner().split(",")));
                    newMessageInfoList.add(messageInfo);
                }
            }
            messageInfos.add(messageInfo);
        }
        if (CollectionUtils.isNotEmpty(messageInfos)) {
            this.thirdMessageInfoService.saveOrUpdateBatch(messageInfos);
        }
        List tenantIdList = this.erpSsoInfoService.queryTenantIdByAppId(appId);
        if (Boolean.TRUE.equals(allSeeFlag)) {
            MessageDO payload = new MessageDO();
            payload.setTenantId(CollectionUtils.isNotEmpty((Collection)tenantIdList) ? (String)tenantIdList.get(0) : "");
            payload.setAllStaffNoticeFlag(Boolean.TRUE);
            payload.setType(Integer.valueOf(2));
            payload.setAppId(appId);
            this.messageSendService.sendToClient(null, payload, "THIRD_MESSAGE_NOTICE");
            this.messageSendService.sendToClient(null, payload, "THIRD_MESSAGE_MOBILE_NOTICE");
        } else {
            List distinctList = messageUserList.stream().distinct().collect(Collectors.toList());
            for (String verifyUserId : distinctList) {
                MessageDO payload = new MessageDO();
                payload.setTenantId(CollectionUtils.isNotEmpty((Collection)tenantIdList) ? (String)tenantIdList.get(0) : "");
                payload.setUserId(verifyUserId);
                payload.setType(Integer.valueOf(2));
                payload.setAppId(appId);
                this.messageSendService.sendToClient(verifyUserId, payload, "THIRD_MESSAGE_NOTICE");
                this.messageSendService.sendToClient(verifyUserId, payload, "THIRD_MESSAGE_MOBILE_NOTICE");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sendChannel) && sendChannel.contains(Constants.MessageChannelEnum.WECOM.getFlag()) && CollectionUtils.isNotEmpty(newMessageInfoList) && StringUtils.isNotBlank((CharSequence)(userToken = this.iamService.queryIntegrationUserToken(tenantId)))) {
            ThirdMessageWecomEventDTO thirdMessageWecomEventDTO = new ThirdMessageWecomEventDTO();
            thirdMessageWecomEventDTO.setNewMessageInfoList(newMessageInfoList);
            thirdMessageWecomEventDTO.setTenantId(tenantId);
            thirdMessageWecomEventDTO.setUserToken(userToken);
            ThirdMessageWecomEvent thirdMessageWecomEvent = new ThirdMessageWecomEvent((Object)this, thirdMessageWecomEventDTO);
            this.eventPublisher.publishEvent((ApplicationEvent)thirdMessageWecomEvent);
        }
    }

    public QueryWrapper getMessageWrapepr(String appId, String Id2) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            queryWrapper.eq((Object)"message_app_id", (Object)appId);
        }
        if (StringUtils.isNotEmpty((CharSequence)Id2)) {
            queryWrapper.eq((Object)"message_id", (Object)Id2);
        }
        return queryWrapper;
    }
}

