/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.quartz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.dto.mq.MessageDO;
import com.digiwin.athena.semc.entity.portal.TodoField;
import com.digiwin.athena.semc.entity.portal.TodoList;
import com.digiwin.athena.semc.entity.portal.TodoRead;
import com.digiwin.athena.semc.mapper.portal.TodoFieldMapper;
import com.digiwin.athena.semc.mapper.portal.TodoListMapper;
import com.digiwin.athena.semc.mapper.portal.TodoReadMapper;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.service.mq.MessageSendService;
import com.digiwin.athena.semc.service.portal.TodoFieldService;
import com.digiwin.athena.semc.service.portal.TodoListService;
import com.digiwin.athena.semc.util.DateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class ThirdTodoPullTaskJob
extends QuartzJobBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdTodoPullTaskJob.class);
    @Resource
    private SchedulerFactoryBean schedulerFactoryBean;
    @Autowired
    private ESPService espService;
    @Autowired
    private TripartiteService tripartiteService;
    @Autowired
    private TodoListMapper todoListMapper;
    @Autowired
    private TodoListService todoListService;
    @Autowired
    private TodoFieldMapper todoFieldMapper;
    @Autowired
    private TodoFieldService todoFieldService;
    @Autowired
    private MessageSendService messageSendService;
    @Autowired
    private TodoReadMapper todoReadMapper;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        try {
            ArrayList todoLists = new ArrayList();
            List todoFieldList = new ArrayList();
            Map params = (Map)context.getJobDetail().getJobDataMap().get((Object)"params");
            Integer appAccessModel = (Integer)params.get("appAccessModel");
            String id = ObjectUtils.isNotEmpty(params.get("id")) ? params.get("id").toString() : "";
            String appId = ObjectUtils.isNotEmpty(params.get("appId")) ? params.get("appId").toString() : "";
            String appIdCode = ObjectUtils.isNotEmpty(params.get("appIdCode")) ? params.get("appIdCode").toString() : "";
            String tenantsid = ObjectUtils.isNotEmpty(params.get("tenantsid")) ? params.get("tenantsid").toString() : "";
            log.info("ThirdTodoPullTaskJob start. appIdCode:{}, appId:{}", (Object)appIdCode, (Object)appId);
            if (appAccessModel == 0) {
                AuthoredUser athenaUser = new AuthoredUser();
                athenaUser.setTenantId(tenantsid);
                AppAuthContextHolder.getContext().setAuthoredUser(athenaUser);
                LocaleContextHolder.setLocale((Locale)Locale.SIMPLIFIED_CHINESE);
                String middleSystemName = params.get("middleSystemName").toString();
                String middleSystemUid = params.get("middleSystemUid").toString();
                HashMap<String, String> extHeader = new HashMap<String, String>();
                extHeader.put("digi-userToken", "");
                extHeader.put("digi-appToken", "");
                int i = 1;
                while (true) {
                    HashMap<String, Object> parameter = new HashMap<String, Object>();
                    parameter.put("page_no", i);
                    parameter.put("page_size", Constants.TODO_MAX_SIZE);
                    parameter.put("tenant_id", tenantsid);
                    Map result = this.espService.queryByEsp(middleSystemName, middleSystemUid, EAIServiceNameEnum.TO_DO_LIST_QUERY.getServiceName(), extHeader, parameter, null, null);
                    if (Objects.isNull(result.get("to_do_list"))) {
                        log.info("ThirdTodoPullTaskJob \u6df7\u5408\u4e91\u672a\u67e5\u8be2\u5230\u5f85\u529e\u6570\u636e");
                        break;
                    }
                    List todoList = (List)result.get("to_do_list");
                    todoFieldList = (List)result.get("display_field_list");
                    log.info("ThirdTodoPullTaskJob  \u6df7\u5408\u4e91\u5f85\u529e\u6570\u636e:{}", (Object)todoList);
                    if (CollectionUtils.isNotEmpty((Collection)todoList) && CollectionUtils.isNotEmpty(todoFieldList)) {
                        todoLists.addAll(todoList);
                    }
                    log.info("ThirdTodoPullTaskJob \u6df7\u5408\u4e91\u5f85\u529e\u4efb\u52a1" + id + "\u6267\u884c\u6210\u529f\uff01");
                    if (!((Boolean)result.get("has_next")).booleanValue()) break;
                    ++i;
                }
            }
            if (appAccessModel == 1) {
                int i = 1;
                while (true) {
                    String domain = params.get("domain").toString();
                    HashMap<String, Object> bodyMap = new HashMap<String, Object>();
                    bodyMap.put("page_no", i);
                    bodyMap.put("page_size", Constants.TODO_MAX_SIZE);
                    bodyMap.put("tenant_id", tenantsid);
                    Map jobData = this.tripartiteService.queryThirdData(domain + "/tenant/semc/todo/queryAll", "", bodyMap);
                    if (null == jobData) {
                        log.info("ThirdTodoPullTaskJob \u975e\u6df7\u5408\u4e91\u672a\u67e5\u8be2\u5230\u5f85\u529e\u6570\u636e");
                        break;
                    }
                    List todoList = (List)jobData.get("to_do_list");
                    todoFieldList = (List)jobData.get("display_field_list");
                    log.info("ThirdTodoPullTaskJob \u975e\u6df7\u5408\u4e91\u5f85\u529e\u6570\u636e:{}", (Object)todoList);
                    if (CollectionUtils.isNotEmpty((Collection)todoList) && CollectionUtils.isNotEmpty(todoFieldList)) {
                        todoLists.addAll(todoList);
                    }
                    log.info("ThirdTodoPullTaskJob \u975e\u6df7\u5408\u4e91\u5f85\u529e\u4efb\u52a1" + id + "\u6267\u884c\u6210\u529f\uff01");
                    if (!((Boolean)jobData.get("has_next")).booleanValue()) break;
                    ++i;
                }
            }
            this.handleTodoData(todoLists, todoFieldList, appId, appIdCode);
            List todoReadList = this.todoReadMapper.selectList((Wrapper)this.getToDoReadWrapepr(appId));
            if (CollectionUtils.isNotEmpty((Collection)todoReadList) && CollectionUtils.isNotEmpty(todoLists)) {
                for (TodoRead todoRead : todoReadList) {
                    List result = todoLists.stream().filter(it -> it.get("to_do_id").toString().equals(todoRead.getToDoId()) && it.get("to_do_owner").toString().equals(todoRead.getToDoUser())).collect(Collectors.toList());
                    if (result.size() != 0) continue;
                    QueryWrapper deleteWrapper = new QueryWrapper();
                    deleteWrapper.eq((Object)"app_id", (Object)appId);
                    deleteWrapper.eq((Object)"to_do_id", (Object)todoRead.getToDoId());
                    deleteWrapper.eq((Object)"to_do_user", (Object)todoRead.getToDoUser());
                    this.todoReadMapper.delete((Wrapper)deleteWrapper);
                }
            }
        }
        catch (Exception e) {
            log.error("ThirdTodoPullTaskJob error  e:{}", (Throwable)e);
        }
    }

    public void addJob(Map<String, Object> params) {
        try {
            String id = params.get("id").toString();
            Integer pullPeriod = (Integer)params.get("pullPeriod");
            Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
            JobDetail jobDetail = JobBuilder.newJob(ThirdTodoPullTaskJob.class).withIdentity("ThirdTodoPullTaskJob", "TodoJob_" + id).storeDurably(true).build();
            jobDetail.getJobDataMap().put("params", params);
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("ThirdTodoPullTaskJob", "TodoTrigger_" + id).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(pullPeriod.intValue()).repeatForever()).build();
            scheduler.scheduleJob(jobDetail, trigger);
            scheduler.start();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public void pauseJob(String name, String group) throws SchedulerException {
        JobKey jobKey;
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobDetail jobDetail = scheduler.getJobDetail(jobKey = new JobKey(name, group));
        if (jobDetail == null) {
            return;
        }
        scheduler.pauseJob(jobKey);
    }

    public void resumeJob(String name, String group) throws SchedulerException {
        JobKey jobKey;
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobDetail jobDetail = scheduler.getJobDetail(jobKey = new JobKey(name, group));
        if (jobDetail == null) {
            return;
        }
        scheduler.resumeJob(jobKey);
    }

    public void deleteJob(String name, String group) throws Exception {
        JobKey jobKey;
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobDetail jobDetail = scheduler.getJobDetail(jobKey = new JobKey(name, group));
        if (jobDetail == null) {
            return;
        }
        scheduler.deleteJob(jobKey);
    }

    public QueryWrapper getToDoWrapepr(String appId, List<TodoList> todoListDtos) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            queryWrapper.eq((Object)"app_id", (Object)appId);
        }
        return queryWrapper;
    }

    public QueryWrapper getToDoReadWrapepr(String appId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            queryWrapper.eq((Object)"app_id", (Object)appId);
        }
        return queryWrapper;
    }

    public void handleTodoData(List<Map<String, Object>> todoList, List<Map<String, Object>> todoFieldList, String appId, String appIdCode) {
        ArrayList<TodoList> todoListDtos = new ArrayList<TodoList>();
        ArrayList<TodoField> todoFieldListDtos = new ArrayList<TodoField>();
        ArrayList<String> todoUserList = new ArrayList<String>();
        for (Map<String, Object> map : todoList) {
            TodoList todo = new TodoList();
            String todoId = map.get("to_do_id").toString();
            String todoUser = map.get("to_do_owner").toString();
            String accountId = MapUtils.getString(map, (Object)"account_id");
            if (StringUtils.isEmpty((CharSequence)todoId) || StringUtils.isEmpty((CharSequence)todoUser)) continue;
            todo.setToDoSource(Integer.valueOf(2));
            todo.setAppName("");
            todo.setAppId(appId);
            todo.setAppIdCode(appIdCode);
            if (StringUtils.isNotBlank((CharSequence)accountId)) {
                todo.setAccountId(accountId);
                todo.setAccountName(MapUtils.getString(map, (Object)"account_name"));
            }
            todo.setToDoId(todoId);
            String toDoUrl = map.get("to_do_url") == null ? "" : map.get("to_do_url").toString();
            todo.setToDoUrl(toDoUrl);
            String mobileUrl = map.get("to_do_mobile_url") == null ? "" : map.get("to_do_mobile_url").toString();
            todo.setMobileUrl(mobileUrl);
            todo.setToDoUser(todoUser);
            String toDoData = map.get("to_do_data") == null ? "" : map.get("to_do_data").toString();
            todo.setToDoData(toDoData);
            todo.setIsCompleted(Integer.valueOf(0));
            todo.setIsRead(Integer.valueOf(0));
            String mobileMainTitle = map.get("mobile_main_title") == null ? "" : map.get("mobile_main_title").toString();
            todo.setMobileMainTitle(mobileMainTitle);
            String mobileSubTitle = map.get("mobile_sub_title") == null ? "" : map.get("mobile_sub_title").toString();
            todo.setMobileSubTitle(mobileSubTitle);
            String mobileLabel = map.get("mobile_label") == null ? "" : map.get("mobile_label").toString();
            todo.setMobileLabel(mobileLabel);
            todo.setTenantId("");
            todo.setCreateTime(DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss"));
            todoListDtos.add(todo);
            if (todoUserList.contains(todoUser)) continue;
            todoUserList.add(todoUser);
        }
        for (Map<String, Object> fieldmap : todoFieldList) {
            TodoField field = new TodoField();
            field.setAppId(appId);
            String displayName = fieldmap.get("display_name") == null ? "" : fieldmap.get("display_name").toString();
            field.setDisplayName(displayName);
            Integer displayOrder = fieldmap.get("display_order") == null ? null : Integer.valueOf(Integer.parseInt(fieldmap.get("display_order").toString()));
            field.setDisplayOrder(displayOrder);
            String bindingDataKey = fieldmap.get("binding_data_key") == null ? "" : fieldmap.get("binding_data_key").toString();
            field.setBindingDataKey(bindingDataKey);
            field.setCreateTime(DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss"));
            todoFieldListDtos.add(field);
        }
        this.todoListMapper.delete((Wrapper)this.getToDoWrapepr(appId, todoListDtos));
        if (CollectionUtils.isNotEmpty(todoListDtos)) {
            if (todoListDtos.size() > 1000) {
                for (int i = 0; i < todoListDtos.size(); i += 1000) {
                    List batchEntities = todoListDtos.subList(i, Math.min(i + 1000, todoListDtos.size()));
                    this.todoListService.saveBatch(batchEntities);
                }
            } else {
                this.todoListService.saveBatch(todoListDtos);
            }
        }
        if (CollectionUtils.isNotEmpty(todoFieldListDtos)) {
            QueryWrapper delFieldWrapper = new QueryWrapper();
            delFieldWrapper.eq((Object)"app_id", (Object)appId);
            this.todoFieldMapper.delete((Wrapper)delFieldWrapper);
            this.todoFieldService.saveBatch(todoFieldListDtos);
        }
        this.pushToUser(appId, todoUserList);
    }

    public void pushToUser(String appCode, List<String> verifyUserldList) {
        for (String verifyUserld : verifyUserldList) {
            try {
                MessageDO payload = new MessageDO();
                payload.setAppId(appCode);
                payload.setUserId(verifyUserld);
                payload.setType(Constants.VALID_STATUS_UNUSABLE);
                this.messageSendService.sendToClient(verifyUserld, payload, "SEMC_TODO_USER");
            }
            catch (Exception e) {
                log.info("\u3010pushToUser-sendToClient\u53d1\u9001MQTT\u5f02\u5e38\u3011verifyUserld\uff1a{},error\uff1a{}", (Object)verifyUserld, (Object)e);
            }
        }
    }
}

