/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.applink.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.BizObjectTypeEnum;
import com.digiwin.athena.semc.common.enums.ErpAppNameEnum;
import com.digiwin.athena.semc.common.enums.MaycurCodeEnum;
import com.digiwin.athena.semc.common.enums.PreinstalledApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.ProtocolTypeEnum;
import com.digiwin.athena.semc.common.enums.SsoSourceTypeEnum;
import com.digiwin.athena.semc.dto.erpsso.AuthorizeDTO;
import com.digiwin.athena.semc.dto.erpsso.ErpSsoSpecialDTO;
import com.digiwin.athena.semc.dto.erpsso.GetSsoUrlReq;
import com.digiwin.athena.semc.dto.erpsso.GetSsoUrlResp;
import com.digiwin.athena.semc.dto.erpsso.PreErpSsoDTO;
import com.digiwin.athena.semc.dto.erpsso.QueryDisplayReq;
import com.digiwin.athena.semc.dto.erpsso.ThirdSsoInfoDto;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.applink.AppLinkGroupDTO;
import com.digiwin.athena.semc.entity.applink.AppLinkListDTO;
import com.digiwin.athena.semc.entity.applink.TenantAppDTO;
import com.digiwin.athena.semc.entity.common.BizObjAuthRel;
import com.digiwin.athena.semc.entity.common.BizObjCommonUse;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplicationInstance;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.MobileSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.mapper.mongo.AppLinkMongoMapper;
import com.digiwin.athena.semc.mapper.portal.PreinstalledApplicationInstanceMapper;
import com.digiwin.athena.semc.mapper.portal.PreinstalledApplicationMapper;
import com.digiwin.athena.semc.proxy.cac.service.CacService;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.maycur.MayCurService;
import com.digiwin.athena.semc.proxy.mdc.MdcService;
import com.digiwin.athena.semc.proxy.mdc.model.TenantProductOperationDTO;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.common.IBizObjAuthRelService;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.sso.IErpSsoInfoService;
import com.digiwin.athena.semc.service.sso.IMobileSsoInfoService;
import com.digiwin.athena.semc.service.sso.IThirdSsoInfoService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.vavr.Tuple2;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;

@Service
public class AppLinkServiceImpl
implements AppLinkService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppLinkServiceImpl.class);
    @Autowired
    private AppLinkMongoMapper appLinkMongoMapper;
    @Resource
    private PreinstalledApplicationInstanceMapper preinstalledApplicationInstanceMapper;
    @Resource
    private IamService iamService;
    @Resource
    private CacService cacService;
    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;
    @Autowired
    IErpSsoInfoService erpSsoInfoService;
    @Autowired
    IThirdSsoInfoService thirdSsoInfoService;
    @Autowired
    IMobileSsoInfoService mobileSsoInfoService;
    @Resource
    private IBizObjAuthRelService bizObjAuthRelService;
    @Resource
    private TranslateService translateService;
    @Resource
    private PreinstalledApplicationMapper preinstalledApplicationMapper;
    @Autowired
    MayCurService mayCurService;
    @Autowired
    EocService eocService;
    @Autowired
    MdcService mdcService;
    @Resource(name="semcAsyncExecutor")
    private Executor asyncTaskExecutor;
    private static final String PLATFORM_CODE_ATHENA_LCDP = "athena-lcdp";
    public static final int RESENT_COUNT = 9;
    private static final String SSO_LOGIN_URL = "%s/sso-login?userToken=%s&dwLang=%s";

    public void accessLink(String appId) {
        this.appLinkMongoMapper.access(appId);
    }

    public AppLinkListDTO queryLinkList(AuthoredUser user) {
        AppLinkListDTO result = new AppLinkListDTO();
        ArrayList appLinkList = Lists.newArrayList();
        AppLinkGroupDTO defaultGroup = new AppLinkGroupDTO();
        defaultGroup.setGroupId("default");
        defaultGroup.setGroupName("\u9f0e\u6377\u5e94\u7528");
        List iamAppLinkList = this.queryDefaultGroup(user);
        List filteredAppLinkList = this.filterBSAppList(user.getTenantId(), iamAppLinkList);
        List preAppLinkList = this.queryPerInstallAppGroup(user);
        filteredAppLinkList.addAll(preAppLinkList);
        defaultGroup.setLinks(filteredAppLinkList);
        appLinkList.add(defaultGroup);
        AppLinkGroupDTO ssoAppGroup = new AppLinkGroupDTO();
        ssoAppGroup.setGroupId("sso");
        ssoAppGroup.setGroupName("\u5176\u4ed6\u5e94\u7528");
        List ssoAppLinkList = this.queryStaticAppLinks();
        ssoAppGroup.setLinks(ssoAppLinkList);
        appLinkList.add(ssoAppGroup);
        result.setAll((List)appLinkList);
        ArrayList allAppLinkList = Lists.newArrayList();
        allAppLinkList.addAll(filteredAppLinkList);
        allAppLinkList.addAll(ssoAppLinkList);
        if (allAppLinkList.size() > 9) {
            Map dic = this.buildAppMap((List)allAppLinkList);
            List latestApps = this.appLinkMongoMapper.getLatestAccesses();
            ArrayList latest = Lists.newArrayList();
            for (Map app : latestApps) {
                if (!dic.containsKey(app.get("_id"))) continue;
                latest.add(dic.get(app.get("_id")));
            }
            result.setLatest((List)latest);
        }
        return result;
    }

    public List<AppLinkGroupDTO> getAppLinkList(AuthoredUser user) {
        ArrayList appLinkList = Lists.newArrayList();
        AppLinkGroupDTO defaultGroup = new AppLinkGroupDTO();
        defaultGroup.setGroupId("default");
        defaultGroup.setGroupName("\u9f0e\u6377\u5e94\u7528");
        List iamAppLinkList = this.queryDefaultGroup(user);
        List filteredAppLinkList = this.filterBSAppList(user.getTenantId(), iamAppLinkList);
        List preAppLinkList = this.queryPerInstallAppGroup(user);
        filteredAppLinkList.addAll(preAppLinkList);
        defaultGroup.setLinks(filteredAppLinkList);
        appLinkList.add(defaultGroup);
        AppLinkGroupDTO ssoAppGroup = new AppLinkGroupDTO();
        ssoAppGroup.setGroupId("sso");
        ssoAppGroup.setGroupName("\u5176\u4ed6\u5e94\u7528");
        List ssoAppLinkList = this.queryStaticAppLinks();
        ssoAppGroup.setLinks(ssoAppLinkList);
        appLinkList.add(ssoAppGroup);
        return appLinkList;
    }

    public List<AppLinkDTO> queryDisplayList(AuthoredUser user) {
        ArrayList appList = Lists.newArrayList();
        List bizObjAuthRelList = this.bizObjAuthRelService.qryBizObjAuthRel(BizObjectTypeEnum.APPlICATION_MANAGEMENT.getValue());
        if (CollectionUtils.isEmpty((Collection)bizObjAuthRelList)) {
            return appList;
        }
        List ssoAppList = this.queryStaticAppLinks();
        List preAppList = this.queryPerInstallAppGroup(user);
        List iamAppLinkList = this.queryDefaultGroup(user);
        List filteredAppLinkList = this.filterBSAppList(user.getTenantId(), iamAppLinkList);
        ssoAppList.addAll(preAppList);
        ssoAppList.addAll(filteredAppLinkList);
        Map typeAppMap = ssoAppList.stream().collect(Collectors.groupingBy(AppLinkDTO::getType, Collectors.toMap(AppLinkDTO::getPrimaryId, Function.identity())));
        bizObjAuthRelList = bizObjAuthRelList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BizObjAuthRel>(Comparator.comparing(BizObjAuthRel::getBizObjSubType).thenComparing(BizObjAuthRel::getBizObjId))), ArrayList::new));
        bizObjAuthRelList.forEach(x -> {
            Map idMap = (Map)typeAppMap.get(String.valueOf(x.getBizObjSubType()));
            if (MapUtils.isNotEmpty((Map)idMap) && idMap.get(x.getBizObjId()) != null) {
                AppLinkDTO appLinkDTO = (AppLinkDTO)idMap.get(x.getBizObjId());
                appList.add(appLinkDTO);
            }
        });
        for (AppLinkDTO appLinkDTO : appList) {
            appLinkDTO.setName(this.translateService.translateTextCache(appLinkDTO.getName(), ""));
        }
        appList.sort(Comparator.comparing(AppLinkDTO::getName));
        return appList;
    }

    public AppLinkDTO queryDisplay(AuthoredUser user, QueryDisplayReq req) throws Exception {
        return this.queryStaticAppLink(user, req);
    }

    public List<AppLinkDTO> queryCommonList(List<BizObjCommonUse> commonUseList, AuthoredUser user) {
        ArrayList appList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(commonUseList)) {
            return appList;
        }
        List ssoAppList = this.queryStaticAppLinks();
        List preAppList = this.queryPerInstallAppGroup(user);
        List iamAppLinkList = this.queryDefaultGroup(user);
        ssoAppList.addAll(preAppList);
        ssoAppList.addAll(iamAppLinkList);
        List bizObjAuthRelList = this.bizObjAuthRelService.qryBizObjAuthRel(BizObjectTypeEnum.APPlICATION_MANAGEMENT.getValue());
        List appIdList = bizObjAuthRelList.stream().map(BizObjAuthRel::getBizObjId).collect(Collectors.toList());
        commonUseList = commonUseList.stream().filter(x -> appIdList.contains(x.getBizObjId())).collect(Collectors.toList());
        Map typeAppMap = ssoAppList.stream().collect(Collectors.groupingBy(AppLinkDTO::getType, Collectors.toMap(AppLinkDTO::getPrimaryId, Function.identity())));
        commonUseList.forEach(x -> {
            Map idMap = (Map)typeAppMap.get(String.valueOf(x.getBizObjSubType()));
            if (MapUtils.isNotEmpty((Map)idMap) && idMap.get(String.valueOf(x.getBizObjId())) != null) {
                AppLinkDTO appLinkDTO = (AppLinkDTO)idMap.get(x.getBizObjId());
                appList.add(appLinkDTO);
            }
        });
        for (AppLinkDTO appLinkDTO : appList) {
            appLinkDTO.setName(this.translateService.translateTextCache(appLinkDTO.getName(), ""));
        }
        return appList;
    }

    public List<AppLinkDTO> queryManageList(AuthoredUser user) {
        List ssoAppList = this.queryStaticAppLinks();
        List preAppList = this.queryPerInstallAppGroup(user);
        List iamAppLinkList = this.queryDefaultGroup(user);
        List filteredAppLinkList = this.filterBSAppList(user.getTenantId(), iamAppLinkList);
        ssoAppList.addAll(preAppList);
        ssoAppList.addAll(filteredAppLinkList);
        ssoAppList.sort(Comparator.comparing(AppLinkDTO::getName));
        return ssoAppList;
    }

    public List<AppLinkDTO> queryAuthorizedList(String authId) {
        List<Object> authAppList = Lists.newArrayList();
        QueryWrapper condition = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_obj_type", (Object)BizObjectTypeEnum.APPlICATION_MANAGEMENT.getValue())).eq((Object)"auth_id", (Object)authId);
        List bizObjAuthRelList = this.bizObjAuthRelService.getBaseMapper().selectList((Wrapper)condition);
        if (CollectionUtils.isEmpty((Collection)bizObjAuthRelList)) {
            return authAppList;
        }
        authAppList = bizObjAuthRelList.stream().map(x -> {
            AppLinkDTO appLinkDTO = new AppLinkDTO();
            appLinkDTO.setPrimaryId(x.getBizObjId());
            appLinkDTO.setType(String.valueOf(x.getBizObjSubType()));
            return appLinkDTO;
        }).collect(Collectors.toList());
        return authAppList;
    }

    private List<AppLinkDTO> filterBSAppList(String tenantId, List<AppLinkDTO> iamAppLinkList) {
        if (StringUtils.isBlank((CharSequence)tenantId) || CollectionUtils.isEmpty(iamAppLinkList)) {
            return iamAppLinkList;
        }
        Map iamAppLinkMap = iamAppLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getId, Function.identity(), (a, b) -> a));
        CompletableFuture[] completableFutures = new CompletableFuture[iamAppLinkList.size()];
        ArrayList appLinkList = Lists.newArrayList();
        for (int i = 0; i < iamAppLinkList.size(); ++i) {
            AppLinkDTO x = iamAppLinkList.get(i);
            completableFutures[i] = CompletableFuture.supplyAsync(() -> this.cacService.verifyAppAuthorizedResult(tenantId, x.getId()), this.asyncTaskExecutor);
        }
        CompletableFuture.allOf(completableFutures).join();
        for (CompletableFuture completableFuture : completableFutures) {
            try {
                Tuple2 tuple2 = (Tuple2)completableFuture.get();
                if (!Boolean.TRUE.equals(tuple2._2)) continue;
                appLinkList.add(iamAppLinkMap.get(tuple2._1()));
            }
            catch (Exception e) {
                log.error("filterBSAppListEx\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
        }
        return appLinkList;
    }

    public List<AppLinkDTO> queryDefaultGroup(AuthoredUser user) {
        AppAuthContextHolder.getContext().setAuthoredUser(user);
        ArrayList iamAppLinkList = Lists.newArrayList();
        List allTenantApps = this.iamService.queryTenantApps();
        for (TenantAppDTO tenantApp : allTenantApps) {
            AppLinkDTO appLink = new AppLinkDTO();
            appLink.setPrimaryId(tenantApp.getId());
            appLink.setType(PreinstalledApplicationTypeEnum.IAM_APPLICATION.getType());
            appLink.setSystemType(ApplicationTypeEnum.BS_APPLICATION.getType());
            appLink.setDataSource(ApplicationTypeEnum.IAM_APPLICATION.getType());
            appLink.setId(tenantApp.getId());
            appLink.setCode(tenantApp.getId());
            appLink.setName(tenantApp.getName());
            appLink.setCloudwebsite(tenantApp.getCloudwebsite());
            appLink.setNeedAuthCodeFlag(Constants.NEED_AUTH_CODE_FLAG_NO);
            if (tenantApp.getPlatformCodes() != null && tenantApp.getPlatformCodes().contains(PLATFORM_CODE_ATHENA_LCDP)) {
                appLink.setAppToken(tenantApp.getAppToken());
            }
            appLink.setCloudwebsite(tenantApp.getCloudwebsite() + "/sso-login?userToken=" + AppAuthContextHolder.getContext().getAuthoredUser().getToken());
            iamAppLinkList.add(appLink);
        }
        return iamAppLinkList;
    }

    public AppLinkDTO getLinkSsoUrl(AppLinkDTO req) {
        AppLinkDTO appLinkDTO = new AppLinkDTO();
        PreinstalledApplication preinstalled = (PreinstalledApplication)this.preinstalledApplicationMapper.selectById((Serializable)((Object)req.getPrimaryId()));
        if (null == preinstalled) {
            return appLinkDTO;
        }
        if (MaycurCodeEnum.MAYCUR_CLOUD.getType().equals(preinstalled.getApplicationCode()) || MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(preinstalled.getApplicationCode())) {
            PreinstalledApplicationInstance preinstalledIns = this.preinstalledApplicationService.getPreINstance(Long.valueOf(Long.parseLong(req.getPrimaryId())), "", "");
            if (null == preinstalledIns || null == preinstalledIns.getApplicationExtConfig()) {
                return appLinkDTO;
            }
            String callBackUrl = preinstalledIns.getApplicationExtConfig().getString("callBackUrl");
            String appId = preinstalledIns.getApplicationExtConfig().getString("appId");
            String appSecret = preinstalledIns.getApplicationExtConfig().getString("appSecret");
            String userId = this.eocService.getEmpJobNum();
            if (StringUtils.isEmpty((CharSequence)userId)) {
                return appLinkDTO;
            }
            long timestamp = System.currentTimeMillis();
            String ssoToken = this.mayCurService.getSsoToken(userId, appSecret, timestamp);
            String ssoUrl = this.mayCurService.getHomeSsoUrl(callBackUrl, appId, userId, ssoToken, timestamp);
            appLinkDTO.setCloudwebsite(ssoUrl);
        }
        return appLinkDTO;
    }

    public List<AppLinkDTO> querySsoList(AuthoredUser user) {
        List ssoAppList = this.queryStaticAppLinks();
        List preAppList = this.queryPerInstallAppGroup(user);
        ssoAppList.addAll(preAppList);
        ssoAppList.sort(Comparator.comparing(AppLinkDTO::getName));
        return ssoAppList;
    }

    public List<AppLinkDTO> queryPerInstallAppGroup(AuthoredUser user) {
        AppAuthContextHolder.getContext().setAuthoredUser(user);
        ArrayList preInstallAppLinkList = Lists.newArrayList();
        List preInstalledAppList = this.preinstalledApplicationService.queryPreinstalledAppList(user);
        if (CollectionUtils.isEmpty((Collection)preInstalledAppList)) {
            return preInstallAppLinkList;
        }
        Map<String, List<PreinstalledApplication>> preinstalledApplicationMap = preInstalledAppList.stream().collect(Collectors.groupingBy(PreinstalledApplication::getApplicationType));
        List csSsoLinkList = this.buildCsAppLink(preinstalledApplicationMap);
        List bsSsoLinkList = this.buildBsAppLink(preinstalledApplicationMap);
        List t100LinkList = this.buildSpecialAppLink(user, preinstalledApplicationMap);
        preInstallAppLinkList.addAll(csSsoLinkList);
        preInstallAppLinkList.addAll(bsSsoLinkList);
        preInstallAppLinkList.addAll(t100LinkList);
        preInstallAppLinkList.sort(Comparator.comparing(AppLinkDTO::getName));
        return preInstallAppLinkList;
    }

    private List<AppLinkDTO> buildSpecialAppLink(AuthoredUser user, Map<String, List<PreinstalledApplication>> preinstalledApplicationMap) {
        List<PreinstalledApplication> specialPreAppList = preinstalledApplicationMap.get(PreinstalledApplicationTypeEnum.SPECIAL_APPLICATION.getValue());
        if (CollectionUtils.isEmpty(specialPreAppList)) {
            return Lists.newArrayList();
        }
        List idList = specialPreAppList.stream().map(PreinstalledApplication::getId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"preinstalled_application_id", idList);
        queryWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        List applicationInstanceList = this.preinstalledApplicationInstanceMapper.selectList((Wrapper)queryWrapper);
        applicationInstanceList = applicationInstanceList.stream().filter(x -> ObjectUtils.isNotEmpty((Object)x.getApplicationExtConfig())).collect(Collectors.toList());
        Map<Long, JSONObject> id2ConfigMap = applicationInstanceList.stream().collect(Collectors.toMap(PreinstalledApplicationInstance::getPreinstalledApplicationId, PreinstalledApplicationInstance::getApplicationExtConfig));
        ArrayList specialAppLinkList = Lists.newArrayList();
        List T100AppLinkList = this.parseT100AppLink(specialPreAppList, id2ConfigMap);
        specialAppLinkList.addAll(T100AppLinkList);
        List TTLinkAppList = this.parseTTAppLink(specialPreAppList, id2ConfigMap);
        specialAppLinkList.addAll(TTLinkAppList);
        return specialAppLinkList;
    }

    private List<AppLinkDTO> parseT100AppLink(List<PreinstalledApplication> specialPreAppList, Map<Long, JSONObject> id2ConfigMap) {
        List T100AppList = specialPreAppList.stream().filter(x -> "100".equals(x.getProductCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(T100AppList)) {
            return Lists.newArrayList();
        }
        return T100AppList.stream().map(x -> {
            AppLinkDTO appLinkDTO = new AppLinkDTO();
            appLinkDTO.setProductCode(x.getProductCode());
            appLinkDTO.setPrimaryId(String.valueOf(x.getId()));
            appLinkDTO.setId("WT-" + x.getApplicationName());
            appLinkDTO.setCode(x.getApplicationCode());
            appLinkDTO.setName(x.getApplicationName());
            appLinkDTO.setAppId(x.getAppId());
            appLinkDTO.setType(PreinstalledApplicationTypeEnum.SPECIAL_APPLICATION.getValue());
            appLinkDTO.setSystemType(x.getSystemType());
            appLinkDTO.setDataSource(ApplicationTypeEnum.PRESET_APPLICATION.getType());
            appLinkDTO.setUserBindFlag(x.getUserBindFlag());
            appLinkDTO.setApplicationAppId(x.getAppId());
            appLinkDTO.setProtocolType(x.getProtocolType());
            appLinkDTO.setNeedAuthCodeFlag(x.getNeedAuthCodeFlag());
            ErpSsoSpecialDTO erpSsoSpecialDTO = (ErpSsoSpecialDTO)Optional.ofNullable(com.alibaba.fastjson.JSONObject.parseObject((String)x.getApplicationConfig(), ErpSsoSpecialDTO.class)).orElse(new ErpSsoSpecialDTO());
            appLinkDTO.setAppToken(erpSsoSpecialDTO.getAppToken());
            JSONObject jsonObject = (JSONObject)id2ConfigMap.get(x.getId());
            String protocolHeader = Optional.ofNullable(jsonObject).filter(object -> object.containsKey((Object)"protocolHeader")).map(object -> object.getString("protocolHeader")).orElse("");
            String ip = Optional.ofNullable(jsonObject).filter(object -> object.containsKey((Object)"ip")).map(object -> object.getString("ip")).orElse("");
            String companyCode = Optional.ofNullable(jsonObject).filter(object -> object.containsKey((Object)"companyCode")).map(object -> object.getString("companyCode")).orElse("");
            String environment = Optional.ofNullable(jsonObject).filter(object -> object.containsKey((Object)"environment")).map(object -> object.getString("environment")).orElse(erpSsoSpecialDTO.getEnvironment());
            environment = StringUtils.isNotBlank((CharSequence)environment) ? "/w" + environment : "";
            String linkStr = protocolHeader + ip + environment + "/wa/r/app/gdc_azzi000?Arg=" + companyCode + "&Arg=" + erpSsoSpecialDTO.getArg() + "&Arg=QVRIRU5B&Arg=";
            String loginUserId = this.queryVerifyUserId(x.getApplicationCode());
            String hashKey = DateUtils.getNowTime((String)"yyyyMMddHHmmss") + "athenaAb1234PWd28682266T100frank" + loginUserId;
            String encoderHashKey = Base64.getEncoder().encodeToString(hashKey.getBytes(StandardCharsets.UTF_8));
            encoderHashKey = encoderHashKey.replaceAll("\\+", "_plus_");
            String fullLink = linkStr + encoderHashKey;
            appLinkDTO.setCloudwebsite(fullLink);
            appLinkDTO.setDesc(x.getApplicationDescription());
            return appLinkDTO;
        }).collect(Collectors.toList());
    }

    private String queryVerifyUserId(String appId) {
        String empId = this.iamService.queryMappingEmpId(appId);
        empId = StringUtils.isNotBlank((CharSequence)empId) ? empId : "";
        return empId;
    }

    private List<AppLinkDTO> parseTTAppLink(List<PreinstalledApplication> specialPreAppList, Map<Long, JSONObject> id2ConfigMap) {
        List TTAppList = specialPreAppList.stream().filter(x -> "06".equals(x.getProductCode())).collect(Collectors.toList());
        List<AppLinkDTO> TTLinkAppList = TTAppList.stream().map(x -> {
            AppLinkDTO appLinkDTO = new AppLinkDTO();
            appLinkDTO.setProductCode(x.getProductCode());
            appLinkDTO.setPrimaryId(String.valueOf(x.getId()));
            appLinkDTO.setId("WT-" + x.getApplicationName());
            appLinkDTO.setCode(x.getApplicationCode());
            appLinkDTO.setName(x.getApplicationName());
            appLinkDTO.setAppId(x.getAppId());
            appLinkDTO.setType(PreinstalledApplicationTypeEnum.SPECIAL_APPLICATION.getValue());
            appLinkDTO.setSystemType(x.getSystemType());
            appLinkDTO.setDataSource(ApplicationTypeEnum.PRESET_APPLICATION.getType());
            appLinkDTO.setUserBindFlag(x.getUserBindFlag());
            appLinkDTO.setApplicationAppId(x.getAppId());
            appLinkDTO.setProtocolType(x.getProtocolType());
            appLinkDTO.setNeedAuthCodeFlag(x.getNeedAuthCodeFlag());
            ErpSsoSpecialDTO erpSsoSpecialDTO = (ErpSsoSpecialDTO)Optional.ofNullable(com.alibaba.fastjson.JSONObject.parseObject((String)x.getApplicationConfig(), ErpSsoSpecialDTO.class)).orElse(new ErpSsoSpecialDTO());
            appLinkDTO.setAppToken(erpSsoSpecialDTO.getAppToken());
            JSONObject jsonObject = (JSONObject)id2ConfigMap.get(x.getId());
            String ip = Optional.ofNullable(jsonObject).map(object -> object.getString("ip")).orElse("");
            String loginUserId = this.queryVerifyUserId(x.getApplicationCode());
            String tokenKey = this.encryptionTokenKey(erpSsoSpecialDTO.getSystemCode(), loginUserId);
            String linkStr = erpSsoSpecialDTO.getProtocolHeader() + ip + "?Arg=" + erpSsoSpecialDTO.getArg() + "&Arg=" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + "&Arg=" + tokenKey + "&Arg=_blank_&Arg=" + erpSsoSpecialDTO.getJobCode() + "&Arg=" + LocaleContextHolder.getLocale();
            appLinkDTO.setCloudwebsite(linkStr);
            appLinkDTO.setDesc(x.getApplicationDescription());
            return appLinkDTO;
        }).collect(Collectors.toList());
        return TTLinkAppList;
    }

    public String encryptionTokenKey(String systemCode, String outerLoginUserId) {
        String encode;
        String base64String = "28682266";
        try {
            com.alibaba.fastjson.JSONObject info = new com.alibaba.fastjson.JSONObject();
            info.put("System", (Object)systemCode);
            info.put("Account", (Object)outerLoginUserId);
            info.put("Date", (Object)DateUtils.getNowTime(null));
            String token = info.toString();
            byte[] keyData = Base64Utils.encode((byte[])"28682266".getBytes());
            SecretKeySpec spec = new SecretKeySpec(keyData, "BlowFish");
            Cipher cipher = Cipher.getInstance("BlowFish");
            cipher.init(1, spec);
            byte[] hasil = cipher.doFinal(token.getBytes());
            encode = new String(Base64Utils.encode((byte[])hasil));
            encode = encode.replaceAll("\\+", "_plus_");
        }
        catch (Exception e) {
            log.error("encrypt token key occur error", (Throwable)e);
            return null;
        }
        return encode;
    }

    public String getPreInstanceCallback(Long applicationId) {
        PreinstalledApplicationInstance applicationInstance = this.preinstalledApplicationService.getPreINstance(applicationId, "", "");
        if (null == applicationInstance) {
            return "";
        }
        JSONObject jsonObject = applicationInstance.getApplicationExtConfig();
        String callBackUrl = jsonObject == null ? "" : jsonObject.getString("callBackUrl");
        return callBackUrl;
    }

    private List<AppLinkDTO> buildBsAppLink(Map<String, List<PreinstalledApplication>> preinstalledApplicationMap) {
        List<PreinstalledApplication> bsPreAppList = preinstalledApplicationMap.get(PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue());
        if (CollectionUtils.isEmpty(bsPreAppList)) {
            return Lists.newArrayList();
        }
        return bsPreAppList.stream().map(x -> {
            ThirdSsoInfoDto thirdSsoInfoDto;
            AppLinkDTO appLinkDTO = new AppLinkDTO();
            appLinkDTO.setCasServerUrl(x.getCasServerUrl());
            appLinkDTO.setProtocolType(x.getProtocolType());
            appLinkDTO.setAppSecret(x.getAppSecret());
            if (MaycurCodeEnum.MAYCUR_CLOUD.getType().equals(x.getApplicationCode()) || MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(x.getApplicationCode())) {
                appLinkDTO.setIsNeedSsoUrl(Integer.valueOf(1));
                String callBackUrl = this.getPreInstanceCallback(x.getId());
                appLinkDTO.setCallBackUrl(callBackUrl);
            }
            if (ProtocolTypeEnum.OAUTH.getType().equals(x.getProtocolType())) {
                String linkStr;
                appLinkDTO.setPrimaryId(String.valueOf(x.getId()));
                appLinkDTO.setId("MT-" + x.getApplicationName());
                appLinkDTO.setCode(x.getApplicationCode());
                appLinkDTO.setName(x.getApplicationName());
                appLinkDTO.setAppId(x.getAppId());
                appLinkDTO.setType(PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue());
                appLinkDTO.setSystemType(x.getSystemType());
                appLinkDTO.setDataSource(ApplicationTypeEnum.PRESET_APPLICATION.getType());
                appLinkDTO.setUserBindFlag(x.getUserBindFlag());
                appLinkDTO.setApplicationAppId(x.getAppId());
                thirdSsoInfoDto = (ThirdSsoInfoDto)Optional.ofNullable(JSON.toJavaObject((JSON)com.alibaba.fastjson.JSONObject.parseObject((String)x.getApplicationConfig()), ThirdSsoInfoDto.class)).orElse(new ThirdSsoInfoDto());
                appLinkDTO.setAppToken(thirdSsoInfoDto.getAppToken());
                appLinkDTO.setCallBackUrl(thirdSsoInfoDto.getCallBackUrl());
                if (Arrays.asList(Constants.BindFlagEnum.AUTO.getFlag(), Constants.BindFlagEnum.HAND.getFlag()).contains(x.getUserBindFlag())) {
                    appLinkDTO.setNeedAuthCodeFlag(x.getNeedAuthCodeFlag());
                }
                if (Constants.BindFlagEnum.NO.getFlag().equals(x.getUserBindFlag())) {
                    linkStr = StringUtils.stripToEmpty((String)thirdSsoInfoDto.getCallBackUrl()) + "?userToken=" + AppAuthContextHolder.getContext().getAuthoredUser().getToken();
                    if (x.getApplicationName().equals("\u5f00\u53d1\u5e73\u53f0")) {
                        linkStr = linkStr + "&routerLink=/home";
                    }
                } else {
                    linkStr = StringUtils.stripToEmpty((String)thirdSsoInfoDto.getCallBackUrl()) + (thirdSsoInfoDto.getCallBackUrl().contains("?") ? "&" : "?") + "appToken=" + thirdSsoInfoDto.getAppToken() + "&tenantId=" + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId() + "&appCode=" + x.getApplicationCode() + "&appId=" + thirdSsoInfoDto.getAppId() + "&bindMode=" + x.getUserBindFlag();
                }
                appLinkDTO.setCloudwebsite(linkStr);
            }
            if (ProtocolTypeEnum.CAS.getType().equals(x.getProtocolType())) {
                appLinkDTO.setPrimaryId(String.valueOf(x.getId()));
                appLinkDTO.setId("MT-" + x.getApplicationName());
                appLinkDTO.setCode(x.getApplicationCode());
                appLinkDTO.setName(x.getApplicationName());
                appLinkDTO.setType(PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue());
                appLinkDTO.setApplicationAppId(x.getAppId());
                thirdSsoInfoDto = (ThirdSsoInfoDto)Optional.ofNullable(JSON.toJavaObject((JSON)com.alibaba.fastjson.JSONObject.parseObject((String)x.getApplicationConfig()), ThirdSsoInfoDto.class)).orElse(new ThirdSsoInfoDto());
                appLinkDTO.setAppToken(thirdSsoInfoDto.getAppToken());
                appLinkDTO.setCallBackUrl(thirdSsoInfoDto.getCallBackUrl());
                appLinkDTO.setNeedAuthCodeFlag(x.getNeedAuthCodeFlag());
                appLinkDTO.setCloudwebsite(thirdSsoInfoDto.getCallBackUrl());
            }
            if (ProtocolTypeEnum.SAML.getType().equals(x.getProtocolType())) {
                appLinkDTO.setPrimaryId(String.valueOf(x.getId()));
                appLinkDTO.setId("MT-" + x.getApplicationName());
                appLinkDTO.setCode(x.getApplicationCode());
                appLinkDTO.setName(x.getApplicationName());
                appLinkDTO.setType(PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue());
                appLinkDTO.setSystemType(x.getSystemType());
                appLinkDTO.setDataSource(ApplicationTypeEnum.PRESET_APPLICATION.getType());
                thirdSsoInfoDto = (ThirdSsoInfoDto)Optional.ofNullable(JSON.toJavaObject((JSON)com.alibaba.fastjson.JSONObject.parseObject((String)x.getApplicationConfig()), ThirdSsoInfoDto.class)).orElse(new ThirdSsoInfoDto());
                appLinkDTO.setCallBackUrl(thirdSsoInfoDto.getCallBackUrl());
                appLinkDTO.setCloudwebsite(thirdSsoInfoDto.getCallBackUrl());
            }
            appLinkDTO.setDesc(x.getApplicationDescription());
            return appLinkDTO;
        }).collect(Collectors.toList());
    }

    private List<AppLinkDTO> buildCsAppLink(Map<String, List<PreinstalledApplication>> preinstalledApplicationMap) {
        List<PreinstalledApplication> csPreAppList = preinstalledApplicationMap.get(PreinstalledApplicationTypeEnum.CS_APPLICATION.getValue());
        if (CollectionUtils.isEmpty(csPreAppList)) {
            return Lists.newArrayList();
        }
        return csPreAppList.stream().map(x -> {
            PreErpSsoDTO preErpSsoDTO;
            AppLinkDTO appLinkDTO = new AppLinkDTO();
            if (x.getProtocolType().equals(1)) {
                appLinkDTO.setPrimaryId(String.valueOf(x.getId()));
                appLinkDTO.setId("WT-" + x.getApplicationName());
                appLinkDTO.setCode(x.getApplicationCode());
                appLinkDTO.setName(x.getApplicationName());
                appLinkDTO.setAppId(x.getAppId());
                appLinkDTO.setType(PreinstalledApplicationTypeEnum.CS_APPLICATION.getValue());
                appLinkDTO.setSystemType(x.getSystemType());
                appLinkDTO.setDataSource(ApplicationTypeEnum.PRESET_APPLICATION.getType());
                appLinkDTO.setUserBindFlag(x.getUserBindFlag());
                appLinkDTO.setNeedAuthCodeFlag(x.getNeedAuthCodeFlag());
                preErpSsoDTO = (PreErpSsoDTO)Optional.ofNullable(JSON.toJavaObject((JSON)com.alibaba.fastjson.JSONObject.parseObject((String)x.getApplicationConfig()), PreErpSsoDTO.class)).orElse(new PreErpSsoDTO());
                appLinkDTO.setAppToken(preErpSsoDTO.getAppToken());
                StringBuilder linkSb = new StringBuilder();
                linkSb.append(StringUtils.stripToEmpty((String)preErpSsoDTO.getProtocolHeader())).append(StringUtils.stripToEmpty((String)preErpSsoDTO.getClientConfiguration()));
                if (preErpSsoDTO.getGetClientMode() != null && Constants.PRESCRIBED_ROUTE.equals(preErpSsoDTO.getGetClientMode())) {
                    linkSb.append("?");
                }
                StringBuilder linkParamSb = new StringBuilder();
                linkParamSb.append("appToken").append("=").append(preErpSsoDTO.getAppToken()).append("&");
                linkParamSb.append("appCode").append("=").append(x.getApplicationCode()).append("&");
                if (Constants.BindFlagEnum.NO.getFlag().equals(x.getUserBindFlag()) || StringUtils.isBlank((CharSequence)preErpSsoDTO.getAppId())) {
                    linkParamSb.append("userToken").append("=").append(AppAuthContextHolder.getContext().getAuthoredUser().getToken());
                } else {
                    linkParamSb.append("tenantId").append("=").append(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId()).append("&");
                    linkParamSb.append("callBackUrl").append("=").append(String.format("http://www.%s.com", preErpSsoDTO.getApplicationCode())).append("&").append("appId").append("=").append(preErpSsoDTO.getAppId()).append("&").append("bindMode").append("=").append(x.getUserBindFlag());
                }
                com.alibaba.fastjson.JSONObject dynamicParameter = JSON.parseObject((String)preErpSsoDTO.getDynamicParameter());
                Optional.ofNullable(dynamicParameter).ifPresent(param -> param.forEach((k, v) -> {
                    if (k != null && v != null) {
                        linkParamSb.append("&").append((String)k).append("=").append(v);
                    }
                }));
                String linkParamStr = linkParamSb.toString();
                if (Constants.ERP_URL_NEEDBASE64.equals(preErpSsoDTO.getParamEncryptionMethod())) {
                    linkParamStr = Base64.getEncoder().encodeToString(linkParamStr.getBytes(StandardCharsets.UTF_8));
                }
                String fullLinkStr = linkSb + linkParamStr;
                appLinkDTO.setCloudwebsite(fullLinkStr);
                appLinkDTO.setProtocolType(x.getProtocolType());
                appLinkDTO.setCasServerUrl(x.getCasServerUrl());
                appLinkDTO.setCallBackUrl(String.format("http://www.%s.com", preErpSsoDTO.getApplicationCode()));
                appLinkDTO.setApplicationAppId(x.getAppId());
            }
            if (x.getProtocolType().equals(2)) {
                appLinkDTO.setPrimaryId(String.valueOf(x.getId()));
                appLinkDTO.setId("WT-" + x.getApplicationName());
                appLinkDTO.setCode(x.getApplicationCode());
                appLinkDTO.setName(x.getApplicationName());
                appLinkDTO.setAppId(x.getAppId());
                appLinkDTO.setType(PreinstalledApplicationTypeEnum.CS_APPLICATION.getValue());
                appLinkDTO.setSystemType(x.getSystemType());
                appLinkDTO.setDataSource(ApplicationTypeEnum.PRESET_APPLICATION.getType());
                preErpSsoDTO = (PreErpSsoDTO)Optional.ofNullable(JSON.toJavaObject((JSON)com.alibaba.fastjson.JSONObject.parseObject((String)x.getApplicationConfig()), PreErpSsoDTO.class)).orElse(new PreErpSsoDTO());
                appLinkDTO.setAppToken(preErpSsoDTO.getAppToken());
                appLinkDTO.setNeedAuthCodeFlag(x.getNeedAuthCodeFlag());
                appLinkDTO.setCloudwebsite(String.format("http://www.%s.com", preErpSsoDTO.getApplicationCode()));
                appLinkDTO.setProtocolType(x.getProtocolType());
                appLinkDTO.setCasServerUrl(x.getCasServerUrl());
                appLinkDTO.setApplicationAppId(x.getAppId());
                appLinkDTO.setCallBackUrl(String.format("http://www.%s.com", preErpSsoDTO.getApplicationCode()));
            }
            return appLinkDTO;
        }).collect(Collectors.toList());
    }

    private List<AppLinkDTO> queryStaticAppLinks() {
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        List erpSSOList = this.queryErpSsoInfoAppLinks(user);
        List thirdSSOList = this.queryThirdSsoInfoAppLinks(user);
        erpSSOList.addAll(thirdSSOList);
        return erpSSOList;
    }

    private AppLinkDTO queryStaticAppLink(AuthoredUser user, QueryDisplayReq req) throws Exception {
        AppLinkDTO appLink = null;
        this.convertCompanyId(user, req);
        if (ErpAppNameEnum.WFGP.getValue().equalsIgnoreCase(req.getErpAppName()) || ErpAppNameEnum.E10.getValue().equalsIgnoreCase(req.getErpAppName())) {
            ErpSsoInfo erpSsoInfo = this.erpSsoInfoService.erpSsoInfoWithParams(user, req);
            if (null == erpSsoInfo) {
                return null;
            }
            appLink = this.buildAppLinkDTO(erpSsoInfo.getCallBackUrl(), erpSsoInfo.getAppId(), erpSsoInfo.getAppToken(), erpSsoInfo.getId(), erpSsoInfo.getCode(), erpSsoInfo.getName(), null, erpSsoInfo.getExt(), ApplicationTypeEnum.CS_APPLICATION.getType(), erpSsoInfo.getProtocolType(), erpSsoInfo.getCasServerUrl(), erpSsoInfo.getUserBindFlag());
        } else if (ErpAppNameEnum.T100.getValue().equalsIgnoreCase(req.getErpAppName())) {
            appLink = this.dealT100(user, req);
        } else {
            log.warn("erpAppName not match,erpAppName:{}", (Object)req.getErpAppName());
        }
        this.addAuthorize(appLink);
        return appLink;
    }

    private AppLinkDTO dealT100(AuthoredUser user, QueryDisplayReq req) {
        Map.Entry companyIdEntry;
        List preAppList = this.queryPerInstallAppGroup(user);
        Optional<AppLinkDTO> appLinkOpt = preAppList.stream().filter(appLinkDTO -> "100".equals(appLinkDTO.getProductCode())).findFirst();
        if (!appLinkOpt.isPresent()) {
            return null;
        }
        AppLinkDTO appLink = appLinkOpt.get();
        Map.Entry pridEntry = this.getDynamicParamValue("PRID", req.getDynamicParams());
        if (null != pridEntry) {
            String prid = (String)pridEntry.getValue();
            appLink.setCloudwebsite(this.dynamicParamsReplace(appLink.getCloudwebsite(), prid, "gdc_", "?Arg="));
        }
        if (null != (companyIdEntry = this.getDynamicParamValue("CompanyId", req.getDynamicParams()))) {
            String companyId = (String)companyIdEntry.getValue();
            appLink.setCloudwebsite(this.dynamicParamsReplace(appLink.getCloudwebsite(), companyId, "?Arg=", "&Arg="));
        }
        return appLink;
    }

    private String dynamicParamsReplace(String originalStr, String replaceStr, String beginStr, String endStr) {
        log.info("dynamicParamsReplace originalStr:{}, replaceStr:{}", (Object)originalStr, (Object)replaceStr);
        int beginStrIndex = originalStr.indexOf(beginStr);
        if (beginStrIndex > 0) {
            String str1 = originalStr.substring(0, beginStrIndex + beginStr.length());
            String str2 = originalStr.substring(beginStrIndex + beginStr.length() + 1);
            int endStrIndex = str2.indexOf(endStr);
            String str3 = str2.substring(endStrIndex);
            String newStr = str1 + replaceStr + str3;
            log.info("dynamicParamsReplace newStr:{}", (Object)newStr);
            return newStr;
        }
        return originalStr;
    }

    private void convertCompanyId(AuthoredUser user, QueryDisplayReq req) {
        Map.Entry entry = this.getDynamicParamValue("companyId", req.getDynamicParams());
        if (null == entry) {
            return;
        }
        String companyId = (String)entry.getValue();
        List tenantProductOperationDTOList = this.mdcService.getTenantProductOperationList(user.getTenantId(), req.getErpAppName());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)tenantProductOperationDTOList)) {
            return;
        }
        Optional<TenantProductOperationDTO> tenantProductOpt = tenantProductOperationDTOList.stream().filter(item -> item.getEocCompanyId().equals(companyId)).findFirst();
        if (tenantProductOpt.isPresent()) {
            req.getDynamicParams().put(entry.getKey(), tenantProductOpt.get().getOmCompanyId());
        }
    }

    private Map.Entry<String, String> getDynamicParamValue(String key, Map<String, String> dynamicParams) {
        Optional<Map.Entry> keyOpt = dynamicParams.entrySet().stream().filter(param -> ((String)param.getKey()).equalsIgnoreCase(key)).findFirst();
        if (!keyOpt.isPresent()) {
            return null;
        }
        return keyOpt.get();
    }

    private void addAuthorize(AppLinkDTO appLink) throws Exception {
        if (appLink == null) {
            return;
        }
        AuthorizeDTO authorizeDTO = this.iamService.queryAuthorizeInfo(appLink.getApplicationAppId(), appLink.getCallBackUrl());
        if (null == authorizeDTO) {
            return;
        }
        appLink.setCloudwebsite(appLink.getCloudwebsite() + "&code=" + authorizeDTO.getCode());
    }

    public AppLinkDTO buildAppLinkDTO(String callBackUrl, String appId, String appToken, Long primaryId, String code, String name, String desc, Map<String, Object> ext, Integer type, Integer protocolType, String casServerUrl, Integer userBindFlag) {
        AppLinkDTO appLink = new AppLinkDTO();
        appLink.setPrimaryId(String.valueOf(primaryId));
        appLink.setId(code);
        appLink.setCode(code);
        appLink.setName(name);
        appLink.setDesc(desc);
        appLink.setAppToken(appToken);
        appLink.setType(type + "");
        appLink.setSystemType(type);
        appLink.setDataSource(type);
        appLink.setCloudwebsite(ObjectUtils.isNotEmpty(ext) && ObjectUtils.isNotEmpty((Object)ext.get("_fullpath")) ? ext.get("_fullpath").toString() : "");
        appLink.setProtocolType(protocolType);
        appLink.setCasServerUrl(casServerUrl);
        appLink.setApplicationAppId(appId);
        appLink.setCallBackUrl(callBackUrl);
        appLink.setUserBindFlag(userBindFlag);
        if (Arrays.asList(Constants.BindFlagEnum.AUTO.getFlag(), Constants.BindFlagEnum.HAND.getFlag()).contains(userBindFlag)) {
            appLink.setNeedAuthCodeFlag(Constants.NEED_AUTH_CODE_FLAG_YES);
        }
        return appLink;
    }

    private Map<String, AppLinkDTO> buildAppMap(List<AppLinkDTO> defaultAppLinkList) {
        HashMap result = Maps.newHashMap();
        for (AppLinkDTO link : defaultAppLinkList) {
            result.put(link.getId(), link);
        }
        return result;
    }

    private List<AppLinkDTO> queryErpSsoInfoAppLinks(AuthoredUser user) {
        AppAuthContextHolder.getContext().setAuthoredUser(user);
        ArrayList ssoLinkList = Lists.newArrayList();
        List erpSsoInfoList = this.erpSsoInfoService.erpSsoInfoWithParams();
        if (CollectionUtils.isNotEmpty((Collection)erpSsoInfoList)) {
            for (ErpSsoInfo erpSsoInfo : erpSsoInfoList) {
                AppLinkDTO appLink = this.buildAppLinkDTO(erpSsoInfo.getCallBackUrl(), erpSsoInfo.getAppId(), erpSsoInfo.getAppToken(), erpSsoInfo.getId(), erpSsoInfo.getCode(), erpSsoInfo.getName(), erpSsoInfo.getAppDesc(), erpSsoInfo.getExt(), ApplicationTypeEnum.CS_APPLICATION.getType(), erpSsoInfo.getProtocolType(), erpSsoInfo.getCasServerUrl(), erpSsoInfo.getUserBindFlag());
                ssoLinkList.add(appLink);
            }
        }
        return ssoLinkList;
    }

    private List<AppLinkDTO> queryThirdSsoInfoAppLinks(AuthoredUser user) {
        AppAuthContextHolder.getContext().setAuthoredUser(user);
        ArrayList ssoLinkList = Lists.newArrayList();
        List infosThirdPartWeb = this.thirdSsoInfoService.erpSsoInfoWithParams();
        if (CollectionUtils.isNotEmpty((Collection)infosThirdPartWeb)) {
            for (ThirdSsoInfoDto thirdSsoInfo : infosThirdPartWeb) {
                AppLinkDTO appLink = this.buildAppLinkDTO(thirdSsoInfo.getCallBackUrl(), thirdSsoInfo.getAppId(), thirdSsoInfo.getAppToken(), thirdSsoInfo.getId(), thirdSsoInfo.getCode(), thirdSsoInfo.getName(), thirdSsoInfo.getAppDesc(), thirdSsoInfo.getExt(), ApplicationTypeEnum.BS_APPLICATION.getType(), thirdSsoInfo.getProtocolType(), thirdSsoInfo.getCasServerUrl(), thirdSsoInfo.getUserBindFlag());
                ssoLinkList.add(appLink);
            }
        }
        return ssoLinkList;
    }

    private List<AppLinkDTO> queryMobileAppLink(AuthoredUser user) {
        AppAuthContextHolder.getContext().setAuthoredUser(user);
        ArrayList appLinkList = Lists.newArrayList();
        List mobileSsoInfoList = this.mobileSsoInfoService.queryMobileLinkSsoList(null);
        if (CollectionUtils.isEmpty((Collection)mobileSsoInfoList)) {
            return appLinkList;
        }
        for (MobileSsoInfo mobileSsoInfo : mobileSsoInfoList) {
            AppLinkDTO appLink = new AppLinkDTO();
            appLink.setPrimaryId(String.valueOf(mobileSsoInfo.getId()));
            appLink.setId(mobileSsoInfo.getAppCode());
            appLink.setCode(mobileSsoInfo.getAppCode());
            appLink.setName(mobileSsoInfo.getAppName());
            appLink.setDesc(mobileSsoInfo.getAppDesc());
            appLink.setAppToken(mobileSsoInfo.getAppToken());
            appLink.setCloudwebsite(mobileSsoInfo.getMobileLinkUrl());
            appLink.setAppId(mobileSsoInfo.getAppId());
            appLink.setApplicationAppId(mobileSsoInfo.getAppId());
            appLink.setCallBackUrl(mobileSsoInfo.getCallBackUrl());
            appLink.setUserBindFlag(mobileSsoInfo.getUserBindFlag());
            appLink.setSystemType(ApplicationTypeEnum.BS_APPLICATION.getType());
            if (Arrays.asList(Constants.BindFlagEnum.AUTO.getFlag(), Constants.BindFlagEnum.HAND.getFlag()).contains(mobileSsoInfo.getUserBindFlag())) {
                appLink.setNeedAuthCodeFlag(Constants.NEED_AUTH_CODE_FLAG_YES);
            }
            appLinkList.add(appLink);
        }
        return appLinkList;
    }

    public List<AppLinkDTO> queryManageListSync(AuthoredUser user) {
        try {
            CompletableFuture<List> erpSsoInfo = CompletableFuture.supplyAsync(() -> this.queryErpSsoInfoAppLinks(user), this.asyncTaskExecutor);
            CompletableFuture<List> queryThirdSsoInfo = CompletableFuture.supplyAsync(() -> this.queryThirdSsoInfoAppLinks(user), this.asyncTaskExecutor);
            CompletableFuture<List> queryPerInstallApp = CompletableFuture.supplyAsync(() -> this.queryPerInstallAppGroup(user), this.asyncTaskExecutor);
            CompletableFuture<List> queryDefaultGroup = CompletableFuture.supplyAsync(() -> this.queryDefaultGroup(user), this.asyncTaskExecutor);
            CompletableFuture.allOf(erpSsoInfo, queryThirdSsoInfo, queryPerInstallApp, queryDefaultGroup);
            List erpSsoInfoAppList = erpSsoInfo.get();
            List thirdSsoInfoAppList = queryThirdSsoInfo.get();
            List preAppList = queryPerInstallApp.get();
            List iamAppLinkList = queryDefaultGroup.get();
            ArrayList<AppLinkDTO> result = new ArrayList<AppLinkDTO>();
            result.addAll(erpSsoInfoAppList);
            result.addAll(thirdSsoInfoAppList);
            result.addAll(preAppList);
            List filteredAppLinkList = this.filterBSAppList(user.getTenantId(), iamAppLinkList);
            result.addAll(filteredAppLinkList);
            return result;
        }
        catch (Exception e) {
            return new ArrayList<AppLinkDTO>();
        }
    }

    public List<AppLinkDTO> queryMobileManageListSync(AuthoredUser user) {
        try {
            CompletableFuture<List> mobileSsoAppList = CompletableFuture.supplyAsync(() -> this.queryMobileAppLink(user), this.asyncTaskExecutor);
            CompletableFuture<List> iamAppList = CompletableFuture.supplyAsync(() -> this.queryDefaultGroup(user), this.asyncTaskExecutor);
            CompletableFuture.allOf(mobileSsoAppList, iamAppList);
            List mobileSsoList = mobileSsoAppList.get();
            List iamAppLinkList = iamAppList.get();
            ArrayList<AppLinkDTO> result = new ArrayList<AppLinkDTO>(mobileSsoList);
            List filteredAppLinkList = this.filterBSAppList(user.getTenantId(), iamAppLinkList);
            result.addAll(filteredAppLinkList);
            return result;
        }
        catch (Exception e) {
            log.error("query mobile manage list sync error.", (Throwable)e);
            return new ArrayList<AppLinkDTO>();
        }
    }

    public String parseJumpUrl(String url, AppLinkDTO appLinkDTO) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        String finalUrl = null;
        if (Objects.equals(ProtocolTypeEnum.OAUTH.getType(), appLinkDTO.getProtocolType())) {
            if (!appLinkDTO.getType().equals(PreinstalledApplicationTypeEnum.SPECIAL_APPLICATION.getValue())) {
                if (Constants.APP_TYPE_BS.equals(appLinkDTO.getSystemType())) {
                    finalUrl = url + (url.contains("?") ? "&" : "?") + "appToken=" + appLinkDTO.getAppToken() + "&tenantId=" + user.getTenantId() + "&appCode=" + appLinkDTO.getCode() + "&appId=" + appLinkDTO.getApplicationAppId() + "&curLocale=" + LocaleContextHolder.getLocale() + "&bindMode=" + appLinkDTO.getUserBindFlag();
                }
                if (Constants.APP_TYPE_CS.equals(appLinkDTO.getSystemType())) {
                    StringBuilder cloudwebsite = new StringBuilder(appLinkDTO.getCloudwebsite());
                    com.alibaba.fastjson.JSONObject jsonObject = null;
                    try {
                        jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)url);
                    }
                    catch (Exception e) {
                        return null;
                    }
                    for (String key : jsonObject.keySet()) {
                        Object value = jsonObject.get((Object)key);
                        cloudwebsite.append("&").append(key).append("=").append(value);
                    }
                    finalUrl = cloudwebsite.toString();
                }
            } else if ("100".equals(appLinkDTO.getProductCode())) {
                finalUrl = appLinkDTO.getCloudwebsite();
                List preInstalledAppList = this.preinstalledApplicationService.queryPreinstalledAppList(AppAuthContextHolder.getContext().getAuthoredUser());
                List T100AppList = preInstalledAppList.stream().filter(x -> "100".equals(x.getProductCode()) && appLinkDTO.getPrimaryId().equals(String.valueOf(x.getId()))).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(T100AppList)) {
                    return finalUrl;
                }
                if (StringUtils.isBlank((CharSequence)url) || url.split("&").length < 4) {
                    return finalUrl;
                }
                PreinstalledApplicationInstance applicationInstance = this.preinstalledApplicationService.getPreINstance(((PreinstalledApplication)T100AppList.get(0)).getId(), "", "");
                List<String> paramList = Arrays.asList(url.split("&"));
                String[] argOne = paramList.get(0).split("=");
                finalUrl = finalUrl.replace("azzi000", argOne[1]);
                String companyCode = Optional.ofNullable(applicationInstance.getApplicationExtConfig()).map(object -> object.getString("companyCode")).orElse("");
                finalUrl = finalUrl.replace("Arg=" + companyCode, paramList.get(1));
                finalUrl = finalUrl + "&" + paramList.get(2) + "&" + paramList.get(3);
            } else if ("06".equals(appLinkDTO.getProductCode())) {
                String cloudwebsite = appLinkDTO.getCloudwebsite();
                List preInstalledAppList = this.preinstalledApplicationService.queryPreinstalledAppList(AppAuthContextHolder.getContext().getAuthoredUser());
                List TTAppList = preInstalledAppList.stream().filter(x -> "06".equals(x.getProductCode())).collect(Collectors.toList());
                com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)url);
                StringBuilder arg = new StringBuilder();
                for (String key : jsonObject.keySet()) {
                    Object value = jsonObject.get((Object)key);
                    arg.append("&").append(key).append("=").append(value);
                }
                for (PreinstalledApplication x2 : TTAppList) {
                    if (!appLinkDTO.getPrimaryId().equals(String.valueOf(x2.getId()))) continue;
                    ErpSsoSpecialDTO erpSsoSpecialDTO = (ErpSsoSpecialDTO)Optional.ofNullable(com.alibaba.fastjson.JSONObject.parseObject((String)x2.getApplicationConfig(), ErpSsoSpecialDTO.class)).orElse(new ErpSsoSpecialDTO());
                    finalUrl = cloudwebsite.replaceAll("&Arg=" + erpSsoSpecialDTO.getJobCode(), arg.toString());
                }
            }
        }
        return finalUrl;
    }

    public List<AppLinkDTO> queryAllAuthorizedList(String authId) {
        List<Object> authAppList = Lists.newArrayList();
        QueryWrapper condition = (QueryWrapper)new QueryWrapper().eq((Object)"auth_id", (Object)authId);
        List bizObjAuthRelList = this.bizObjAuthRelService.getBaseMapper().selectList((Wrapper)condition);
        if (CollectionUtils.isEmpty((Collection)bizObjAuthRelList)) {
            return authAppList;
        }
        authAppList = bizObjAuthRelList.stream().map(x -> {
            AppLinkDTO appLinkDTO = new AppLinkDTO();
            appLinkDTO.setPrimaryId(x.getBizObjId());
            appLinkDTO.setType(String.valueOf(x.getBizObjSubType()));
            return appLinkDTO;
        }).collect(Collectors.toList());
        return authAppList;
    }

    public GetSsoUrlResp getSsoUrl(GetSsoUrlReq req) {
        GetSsoUrlResp resp = new GetSsoUrlResp();
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        if (!ApplicationTypeEnum.BS_APPLICATION.getType().toString().equals(req.getAppType())) {
            return resp;
        }
        String callBackUrl = "";
        if (StringUtils.isNotEmpty((CharSequence)req.getSsoSourceType()) && SsoSourceTypeEnum.MANUAL.getValue().equals(req.getSsoSourceType())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"valid_status", (Object)Constants.VALID_STATUS_ENABLE);
            queryWrapper.eq((Object)"app_code", (Object)req.getSsoAppCode());
            List infos = this.thirdSsoInfoService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)infos)) {
                return resp;
            }
            ThirdSsoInfo info = (ThirdSsoInfo)infos.get(0);
            callBackUrl = info.getCallBackUrl();
        } else {
            List preinstalledAppList = this.preinstalledApplicationService.queryPreinstalledAppList(AppAuthContextHolder.getContext().getAuthoredUser());
            if (CollectionUtils.isEmpty((Collection)preinstalledAppList)) {
                return resp;
            }
            PreinstalledApplication preinstalledApp = preinstalledAppList.stream().filter(x -> req.getSsoAppCode().equals(x.getApplicationCode())).findFirst().orElse(null);
            if (null == preinstalledApp || StringUtils.isEmpty((CharSequence)preinstalledApp.getApplicationConfig())) {
                return resp;
            }
            ThirdSsoInfoDto thirdSsoInfoDto = (ThirdSsoInfoDto)Optional.ofNullable(JSON.toJavaObject((JSON)com.alibaba.fastjson.JSONObject.parseObject((String)preinstalledApp.getApplicationConfig()), ThirdSsoInfoDto.class)).orElse(new ThirdSsoInfoDto());
            callBackUrl = thirdSsoInfoDto.getCallBackUrl();
        }
        if (null == req.getSsoLogin() || !req.getSsoLogin().booleanValue()) {
            resp.setAddress(callBackUrl);
            return resp;
        }
        String ssoAddress = String.format(SSO_LOGIN_URL, callBackUrl, user.getToken(), LocaleContextHolder.getLocale());
        resp.setSsoAddress(ssoAddress);
        if (MapUtils.isEmpty((Map)req.getDynamicParams())) {
            return resp;
        }
        for (Map.Entry entry : req.getDynamicParams().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)key) || !StringUtils.isNotBlank((CharSequence)value)) continue;
            ssoAddress = ssoAddress + "&" + key + "=" + value;
            resp.setSsoAddress(ssoAddress);
        }
        return resp;
    }

    public AppLinkDTO queryApplicationByDataType(Integer dataType, String appPrimaryId, AuthoredUser user) {
        List appLinkDTOList;
        if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(dataType)) {
            appLinkDTOList = this.queryErpSsoInfoAppLinks(user);
        } else if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(dataType)) {
            appLinkDTOList = this.queryThirdSsoInfoAppLinks(user);
        } else if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(dataType)) {
            appLinkDTOList = this.queryPerInstallAppGroup(user);
        } else {
            appLinkDTOList = this.queryDefaultGroup(user);
            appLinkDTOList = this.filterBSAppList(user.getTenantId(), appLinkDTOList);
        }
        return appLinkDTOList.stream().filter(x -> appPrimaryId.equals(x.getPrimaryId())).findFirst().orElse(null);
    }

    public List<AppLinkDTO> querySsoConfigListSync(List<String> appIdList) {
        try {
            CompletableFuture<List> erpSsoInfoList = CompletableFuture.supplyAsync(() -> {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.in(ErpSsoInfo::getAppId, (Collection)appIdList);
                return this.erpSsoInfoService.getBaseMapper().selectList((Wrapper)wrapper);
            }, this.asyncTaskExecutor);
            CompletableFuture<List> thirdSsoInfoList = CompletableFuture.supplyAsync(() -> {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.in(ThirdSsoInfo::getAppId, (Collection)appIdList);
                return this.thirdSsoInfoService.getBaseMapper().selectList((Wrapper)wrapper);
            }, this.asyncTaskExecutor);
            CompletableFuture<List> preSsoInfoList = CompletableFuture.supplyAsync(() -> {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.in(PreinstalledApplicationInstance::getAppId, (Collection)appIdList);
                return this.preinstalledApplicationInstanceMapper.getPreInsBy(Utils.getTenantId(), null, appIdList);
            }, this.asyncTaskExecutor);
            CompletableFuture.allOf(erpSsoInfoList, thirdSsoInfoList, preSsoInfoList).join();
            List csAppList = erpSsoInfoList.get();
            List bsAppList = thirdSsoInfoList.get();
            List preAppList = preSsoInfoList.get();
            ArrayList resultList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)csAppList)) {
                csAppList.forEach(x -> {
                    AppLinkDTO appLinkDTO = new AppLinkDTO();
                    appLinkDTO.setApplicationAppId(x.getAppId());
                    appLinkDTO.setName(x.getName());
                    resultList.add(appLinkDTO);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)bsAppList)) {
                bsAppList.forEach(x -> {
                    AppLinkDTO appLinkDTO = new AppLinkDTO();
                    appLinkDTO.setApplicationAppId(x.getAppId());
                    appLinkDTO.setName(x.getAppName());
                    resultList.add(appLinkDTO);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)preAppList)) {
                preAppList.forEach(x -> {
                    AppLinkDTO appLinkDTO = new AppLinkDTO();
                    appLinkDTO.setApplicationAppId(x.getAppId());
                    appLinkDTO.setName(x.getPreinstalledApplicationName());
                    resultList.add(appLinkDTO);
                });
            }
            return resultList;
        }
        catch (Exception e) {
            log.error("query sso config list error. appIdList:{}", appIdList, (Object)e);
            return new ArrayList<AppLinkDTO>();
        }
    }
}

