/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.bench.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.SyncReadListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.bench.JobBench;
import com.digiwin.athena.semc.entity.bench.JobBenchCustom;
import com.digiwin.athena.semc.entity.bench.JobBenchImport;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.bench.JobBenchCustomMapper;
import com.digiwin.athena.semc.mapper.bench.JobBenchImportMapper;
import com.digiwin.athena.semc.mapper.bench.JobBenchMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.proxy.mdc.MdcService;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.bench.JobBenchService;
import com.digiwin.athena.semc.service.bench.impl.JobBenchWriteHandler;
import com.digiwin.athena.semc.service.mobile.MobileUserAuthService;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.service.portal.LabelSystemCustomService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.bench.JobBenchExportVo;
import com.digiwin.athena.semc.vo.bench.JobBenchImportVo;
import com.digiwin.athena.semc.vo.bench.JobBenchSaveVO;
import com.digiwin.athena.semc.vo.bench.OrderBenchLaneVO;
import com.digiwin.athena.semc.vo.bench.OrderLaneJobVO;
import com.digiwin.athena.semc.vo.common.UserAuthSystemLabelVo;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobBenchServiceImpl
extends ServiceImpl<JobBenchMapper, JobBench>
implements JobBenchService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobBenchServiceImpl.class);
    @Autowired
    JobBenchMapper jobBenchMapper;
    @Autowired
    JobBenchCustomMapper jobBenchCustomMapper;
    @Resource
    private TranslateService translateService;
    @Resource
    private EnvProperties envProperties;
    @Autowired
    MdcService mdcService;
    @Autowired
    private LabelSystemCustomService labelSystemCustomService;
    @Resource
    private IImportRecordService importRecordService;
    @Resource
    private JobBenchImportMapper jobBenchImportMapper;
    @Resource
    MobileUserAuthService mobileUserAuthService;
    @Resource
    LabelSystemDataMapper labelSystemDataMapper;

    public List<JobBench> getBenchList(JobBench req) {
        List jobBenchList = this.selectByName(req);
        return jobBenchList;
    }

    public List<JobBench> queryAllBench(List<Long> customIdList, List<Long> allSystemIdList) {
        JobBench req = new JobBench();
        req.setParentId(Long.valueOf(0L));
        List jobBenchList = this.getBenchList(req);
        if (CollectionUtils.isEmpty((Collection)jobBenchList)) {
            return new ArrayList<JobBench>();
        }
        for (JobBench jobBench : jobBenchList) {
            this.getBenchChild(jobBench, customIdList, allSystemIdList);
        }
        return jobBenchList;
    }

    public List<JobBench> queryTempBenchList() {
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        parentIdList.add(0L);
        return this.jobBenchMapper.selectBenchByTemp(parentIdList, null);
    }

    public List<JobBench> queryAuthAllBench(List<Long> customIdList) {
        HashSet customIdSet;
        List systemDataList;
        UserAuthSystemLabelVo authSystemLabelVo;
        LabelSystemAllVo req = new LabelSystemAllVo();
        req.setDataCategoryList(Collections.singletonList(Constants.DataCategoryEnum.BUSINESS_TODO.getVal()));
        List systemCustomList = this.labelSystemCustomService.queryCustomSystem(req);
        List businessTodoIdList = systemCustomList.stream().map(LabelSystemCustom::getId).collect(Collectors.toList());
        customIdList.addAll(businessTodoIdList);
        ArrayList allBenchSystemIdList = new ArrayList();
        List jobBenchList = this.queryAllBench(null, allBenchSystemIdList);
        if (CollectionUtils.isNotEmpty(allBenchSystemIdList) && null != (authSystemLabelVo = this.mobileUserAuthService.buildSystemIdApp(systemDataList = this.labelSystemDataMapper.queryBySystemIdList(customIdSet = new HashSet(allBenchSystemIdList)))) && CollectionUtils.isNotEmpty((Collection)authSystemLabelVo.getPermSystemIdList())) {
            customIdList.addAll(authSystemLabelVo.getPermSystemIdList());
        }
        ArrayList<JobBench> jobUserBenchList = new ArrayList<JobBench>();
        for (JobBench jobBench : jobBenchList) {
            List laneSystemIdList;
            Boolean isPermissionAll;
            if (CollectionUtils.isEmpty((Collection)jobBench.getLaneList()) || !(isPermissionAll = Boolean.valueOf(CollectionUtils.containsAny((Collection)(laneSystemIdList = this.getAllSystemId(jobBench)), customIdList))).booleanValue()) continue;
            boolean flag = laneSystemIdList.stream().allMatch(x -> businessTodoIdList.contains(x));
            if (flag) {
                jobBench.setNeedDetermineHidden(Boolean.TRUE);
            }
            ArrayList<JobBench> laneList = new ArrayList<JobBench>();
            for (JobBench lean : jobBench.getLaneList()) {
                List ngSystemIdList = lean.getJobList().stream().map(JobBenchCustom::getSystemId).collect(Collectors.toList());
                boolean isToDoSystemId = ngSystemIdList.stream().anyMatch(businessTodoIdList::contains);
                for (JobBenchCustom job : lean.getJobList()) {
                    job.setIsPermission(Boolean.valueOf(false));
                    if (customIdList.contains(job.getSystemId())) {
                        job.setIsPermission(Boolean.valueOf(true));
                    }
                    if (isToDoSystemId && !businessTodoIdList.contains(job.getSystemId()) && !job.getIsPermission().booleanValue()) {
                        jobBench.setNeedDetermineHidden(Boolean.TRUE);
                    }
                    if (isToDoSystemId && !businessTodoIdList.contains(job.getSystemId()) && job.getIsPermission().booleanValue()) {
                        jobBench.setNeedDetermineHidden(Boolean.FALSE);
                    }
                    if (!businessTodoIdList.contains(job.getSystemId())) continue;
                    job.setLabelDataCategory(Constants.DataCategoryEnum.BUSINESS_TODO.getVal());
                }
                laneList.add(lean);
            }
            jobBench.setLaneList(laneList);
            jobUserBenchList.add(jobBench);
        }
        return jobUserBenchList;
    }

    public List<Long> getAllSystemId(JobBench jobBench) {
        ArrayList<Long> systemIdList = new ArrayList<Long>();
        for (JobBench lean : jobBench.getLaneList()) {
            if (!CollectionUtils.isNotEmpty((Collection)lean.getJobList())) continue;
            List systemIds = lean.getJobList().stream().map(JobBenchCustom::getSystemId).collect(Collectors.toList());
            systemIdList.addAll(systemIds);
        }
        return systemIdList;
    }

    public void getBenchChild(JobBench jobBench, List<Long> systemIdList, List<Long> allSystemIdList) {
        JobBench req = new JobBench();
        req.setParentId(jobBench.getId());
        List jobBenchList = this.getBenchList(req);
        if (CollectionUtils.isEmpty((Collection)jobBenchList)) {
            List jobBenchCustomList = this.jobBenchCustomMapper.selectBenchJob(systemIdList, jobBench.getId());
            if (CollectionUtils.isNotEmpty((Collection)jobBenchCustomList)) {
                List systemIds = jobBenchCustomList.stream().map(JobBenchCustom::getSystemId).collect(Collectors.toList());
                allSystemIdList.addAll(systemIds);
            }
            jobBench.setJobList(jobBenchCustomList);
        } else {
            jobBench.setLaneList(jobBenchList);
            for (JobBench jobBenchChild : jobBenchList) {
                this.getBenchChild(jobBenchChild, systemIdList, allSystemIdList);
            }
        }
    }

    public void transJobName(List<JobBenchCustom> jobBenchCustomList) {
        for (JobBenchCustom jobBenchCustom : jobBenchCustomList) {
            String name = this.translateService.translateTextCache(jobBenchCustom.getNameZh(), "");
            jobBenchCustom.setNameZh(name);
        }
    }

    @Transactional
    public Long saveBench(JobBench jobBench) {
        if (null != jobBench.getId()) {
            this.jobBenchMapper.updateById((Object)jobBench);
        } else {
            jobBench.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            this.jobBenchMapper.insert((Object)jobBench);
        }
        return jobBench.getId();
    }

    public List<JobBench> selectByName(JobBench req) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"label_index");
        if (StringUtils.isNotEmpty((CharSequence)req.getName())) {
            queryWrapper.eq((Object)"name", (Object)req.getName());
        }
        if (null != req.getId()) {
            queryWrapper.notIn((Object)"id", new Object[]{req.getId()});
        }
        if (null != req.getParentId()) {
            queryWrapper.eq((Object)"parent_id", (Object)req.getParentId());
        }
        return this.jobBenchMapper.selectList((Wrapper)queryWrapper);
    }

    @Transactional
    public Integer saveJobList(JobBenchSaveVO saveVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != saveVO.getBenchId()) {
            queryWrapper.eq((Object)"bench_id", (Object)saveVO.getBenchId());
        }
        this.jobBenchCustomMapper.delete((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saveVO.getSystemIdList())) {
            return null;
        }
        return this.jobBenchCustomMapper.insertBatch(this.packageBenchCustom(saveVO));
    }

    public List<JobBenchCustom> selectBySystem(JobBenchSaveVO req) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"label_index");
        if (null != req.getBenchId()) {
            queryWrapper.eq((Object)"bench_id", (Object)req.getBenchId());
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getSystemIdList())) {
            queryWrapper.in((Object)"system_id", (Collection)req.getSystemIdList());
        }
        return this.jobBenchCustomMapper.selectList((Wrapper)queryWrapper);
    }

    @Transactional
    public Integer delLaneJob(JobBenchSaveVO saveVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != saveVO.getBenchId()) {
            queryWrapper.eq((Object)"bench_id", (Object)saveVO.getBenchId());
        }
        if (null != saveVO.getBenchId()) {
            queryWrapper.in((Object)"system_id", (Collection)saveVO.getSystemIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)saveVO.getBenchIdList())) {
            queryWrapper.in((Object)"bench_id", (Collection)saveVO.getBenchIdList());
        }
        return this.jobBenchCustomMapper.delete((Wrapper)queryWrapper);
    }

    @Transactional
    public Integer delBeanLane(Long id) {
        List jobBenchList = this.getJobBenchList(id);
        if (CollectionUtils.isEmpty((Collection)jobBenchList)) {
            return null;
        }
        List benchIdList = jobBenchList.stream().map(JobBench::getId).collect(Collectors.toList());
        this.jobBenchMapper.deleteBatchIds(benchIdList);
        JobBenchSaveVO saveVO = new JobBenchSaveVO();
        saveVO.setBenchIdList(benchIdList);
        return this.delLaneJob(saveVO);
    }

    @Transactional
    public Integer orderBenchLane(OrderBenchLaneVO req) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        if (null == req.getId()) {
            req.setId(Long.valueOf(0L));
        }
        List jobBenchList = this.jobBenchMapper.selectBenchList(req.getBenchLaneList(), req.getId(), tenantId);
        Map benchIndexMap = this.addBenchIndex(req.getBenchLaneList());
        for (JobBench jobBench : jobBenchList) {
            Integer labelIndex = (Integer)benchIndexMap.get(jobBench.getId());
            if (null == labelIndex) continue;
            jobBench.setLabelIndex(labelIndex);
            this.jobBenchMapper.updateById((Object)jobBench);
        }
        return null;
    }

    @Transactional
    public Integer orderLaneJob(OrderLaneJobVO req) {
        if (null != req.getOldBenchId() && null != req.getOldSystemId()) {
            JobBenchSaveVO jobVO = new JobBenchSaveVO();
            jobVO.setBenchId(req.getOldBenchId());
            ArrayList<Long> systemIdList = new ArrayList<Long>();
            systemIdList.add(req.getOldSystemId());
            jobVO.setSystemIdList(systemIdList);
            this.delLaneJob(jobVO);
        }
        JobBenchSaveVO saveVO = new JobBenchSaveVO();
        saveVO.setBenchId(req.getNowBenchId());
        saveVO.setSystemIdList(req.getNowSystemIdList());
        return this.saveJobList(saveVO);
    }

    public Map<Long, Integer> addBenchIndex(List<Long> benchLaneList) {
        HashMap<Long, Integer> benchIndexMap = new HashMap<Long, Integer>();
        int i = 0;
        for (Long benchLaneId : benchLaneList) {
            benchIndexMap.put(benchLaneId, i);
            ++i;
        }
        return benchIndexMap;
    }

    public List<JobBench> getJobBenchList(Long id) {
        ArrayList<JobBench> jobBenchList = new ArrayList<JobBench>();
        JobBench jobBench = (JobBench)this.jobBenchMapper.selectById((Serializable)id);
        if (null != jobBench) {
            jobBenchList.add(jobBench);
        }
        JobBench req = new JobBench();
        req.setParentId(id);
        List jobBenchChildList = this.selectByName(req);
        if (CollectionUtils.isNotEmpty((Collection)jobBenchChildList)) {
            jobBenchList.addAll(jobBenchChildList);
        }
        return jobBenchList;
    }

    public List<JobBenchCustom> packageBenchCustom(JobBenchSaveVO saveVO) {
        ArrayList<JobBenchCustom> jobBenchCustoms = new ArrayList<JobBenchCustom>();
        int i = 0;
        for (Long systemId : saveVO.getSystemIdList()) {
            JobBenchCustom jobBenchCustom = new JobBenchCustom();
            jobBenchCustom.setBenchId(saveVO.getBenchId());
            jobBenchCustom.setSystemId(systemId);
            jobBenchCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            jobBenchCustom.setLabelIndex(Integer.valueOf(i));
            ++i;
            jobBenchCustoms.add(jobBenchCustom);
        }
        return jobBenchCustoms;
    }

    public List<JobBenchImportVo> readExcel(String fileId) {
        List excelVoList;
        DMC dmcInstance = this.mdcService.buildDmc();
        try {
            byte[] byteArray = dmcInstance.download(fileId);
            ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
            SyncReadListener excelListener = new SyncReadListener();
            ExcelReader excelReader = EasyExcelFactory.read((InputStream)input).build();
            excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)0).head(JobBenchImportVo.class)).headRowNumber(Integer.valueOf(2))).registerReadListener((ReadListener)excelListener)).build()});
            excelReader.finish();
            excelVoList = this.mdcService.doReadSync(excelListener);
        }
        catch (Exception e) {
            log.error("JobBenchImport read excel occur error", (Throwable)e);
            throw new RuntimeException(e);
        }
        return excelVoList;
    }

    @Transactional
    public ImportExcelResp importReport(List<JobBenchImportVo> jobBenchImportVoList) {
        ImportExcelResp excelResp = new ImportExcelResp();
        Map<Object, Object> systemCustomMap = new HashMap();
        HashMap<String, ArrayList<String>> jobNameMap = new HashMap<String, ArrayList<String>>();
        HashMap benchNameIdMap = new HashMap();
        HashMap laneIdMap = new HashMap();
        LabelSystemAllVo req = new LabelSystemAllVo();
        ArrayList<Integer> dataCategoryList = new ArrayList<Integer>();
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        req.setDataCategoryList(dataCategoryList);
        List systemCustomList = this.labelSystemCustomService.queryCustomList(req);
        if (CollectionUtils.isNotEmpty((Collection)systemCustomList)) {
            systemCustomMap = systemCustomList.stream().collect(Collectors.toMap(LabelSystemCustom::getNameZh, Function.identity(), (a, b) -> a));
        }
        List<Object> benchNameList = new ArrayList();
        Integer benchIndex = 0;
        List jobBenchList = this.jobBenchMapper.selectBenchList(new ArrayList(), Long.valueOf(0L), Utils.getTenantId());
        if (CollectionUtils.isNotEmpty((Collection)jobBenchList)) {
            benchIndex = ((JobBench)jobBenchList.get(jobBenchList.size() - 1)).getLabelIndex() + 1;
            benchNameList = jobBenchList.stream().map(JobBench::getName).collect(Collectors.toList());
        }
        int successNum = 0;
        int failNum = 0;
        Integer laneIndex = 0;
        Integer jobIndex = 0;
        for (JobBenchImportVo jobBenchImportVo : jobBenchImportVoList) {
            StringBuilder errorSb = this.validateData(jobBenchImportVo, benchNameList, systemCustomMap, jobNameMap);
            if (StringUtils.isNotBlank((CharSequence)errorSb.toString())) {
                ++failNum;
                jobBenchImportVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                continue;
            }
            ArrayList<String> jobNameList = (ArrayList<String>)jobNameMap.get(jobBenchImportVo.getBenchName() + "_" + jobBenchImportVo.getLaneName());
            if (CollectionUtils.isEmpty((Collection)jobNameList)) {
                jobNameList = new ArrayList<String>();
            }
            jobNameList.add(jobBenchImportVo.getJobName());
            jobNameMap.put(jobBenchImportVo.getBenchName() + "_" + jobBenchImportVo.getLaneName(), jobNameList);
            jobBenchImportVo.setFailDesc(errorSb.toString());
            this.initJobBench(jobBenchImportVo, systemCustomMap, benchNameIdMap, benchIndex.intValue(), laneIndex.intValue(), jobIndex.intValue(), laneIdMap);
            ++successNum;
        }
        String nowTime = DateUtils.getNowTime((String)"yyyyMMddHHmmss");
        String pathName = "\u4f5c\u4e1a\u5de5\u4f5c\u53f0\u5bfc\u5165\u8bb0\u5f55_" + nowTime + ".xlsx";
        ShareInfo shareInfo = this.importRecordService.uploadExcel(this.write(jobBenchImportVoList, pathName));
        this.initDataImport(shareInfo.getFileId(), Integer.valueOf(successNum), Integer.valueOf(failNum), nowTime);
        excelResp.setFailFileId(shareInfo.getFileId());
        excelResp.setFailFileName(shareInfo.getFileName());
        excelResp.setFailFileUrl(shareInfo.getUrl());
        String resultCode = successNum > 0 && failNum == 0 ? "2001" : (successNum > 0 && failNum > 0 ? "2002" : (successNum == 0 && failNum > 0 ? "2003" : "2003"));
        excelResp.setResultCode(resultCode);
        excelResp.setFailCount(Integer.valueOf(failNum));
        excelResp.setSuccessCount(Integer.valueOf(successNum));
        return excelResp;
    }

    public JobBenchImport initDataImport(String fileId, Integer successCount, Integer failCount, String nowTime) {
        JobBenchImport importRecord = new JobBenchImport();
        importRecord.setFileId(fileId);
        importRecord.setSuccessCount(successCount);
        importRecord.setFailCount(failCount);
        importRecord.setCreateUserName(Utils.getUserName());
        importRecord.setCreateUserId(Utils.getUserId());
        importRecord.setCreateTime(DateUtils.getDateFormat((String)nowTime, (String)"yyyyMMddHHmmss", (String)"yyyy-MM-dd HH:mm:ss"));
        importRecord.setModifyTime(DateUtils.getDateFormat((String)nowTime, (String)"yyyyMMddHHmmss", (String)"yyyy-MM-dd HH:mm:ss"));
        importRecord.setModifyUserId(Utils.getUserId());
        importRecord.setTenantId(Utils.getTenantId());
        this.jobBenchImportMapper.insert((Object)importRecord);
        return importRecord;
    }

    public File write(List<JobBenchImportVo> list, String pathName) {
        File file = new File(pathName);
        ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((File)file, JobBenchImportVo.class).registerWriteHandler((WriteHandler)Utils.initHorizontalCell())).relativeHeadRowIndex(Integer.valueOf(1))).registerWriteHandler((WriteHandler)new JobBenchWriteHandler())).sheet("\u4f5c\u4e1a\u5de5\u4f5c\u53f0").doWrite(list);
        return file;
    }

    public void initJobBench(JobBenchImportVo jobBenchImportVo, Map<String, LabelSystemCustom> systemCustomMap, Map<String, Long> benchNameIdMap, int benchIndex, int laneIndex, int jobIndex, Map<String, Long> laneNameIdMap) {
        String laneKey;
        Long laneId;
        Long benchId = benchNameIdMap.get(jobBenchImportVo.getBenchName());
        if (null == benchId) {
            JobBench jobBench = new JobBench();
            jobBench.setName(jobBenchImportVo.getBenchName());
            jobBench.setLabelIndex(Integer.valueOf(benchIndex));
            jobBench.setParentId(Long.valueOf(0L));
            jobBench.setCreateUserId(Utils.getUserId());
            jobBench.setCreateTime(DateUtils.getNowTime((String)""));
            jobBench.setModifyTime(DateUtils.getNowTime((String)""));
            jobBench.setModifyUserId(Utils.getUserId());
            jobBench.setTenantId(Utils.getTenantId());
            this.jobBenchMapper.insert((Object)jobBench);
            benchNameIdMap.put(jobBenchImportVo.getBenchName(), jobBench.getId());
            benchId = jobBench.getId();
            ++benchIndex;
        }
        if (null == (laneId = laneNameIdMap.get(laneKey = jobBenchImportVo.getBenchName() + jobBenchImportVo.getLaneName()))) {
            JobBench lane = new JobBench();
            lane.setName(jobBenchImportVo.getLaneName());
            lane.setLabelIndex(Integer.valueOf(laneIndex));
            lane.setParentId(benchId);
            lane.setCreateUserId(Utils.getUserId());
            lane.setCreateTime(DateUtils.getNowTime((String)""));
            lane.setModifyTime(DateUtils.getNowTime((String)""));
            lane.setModifyUserId(Utils.getUserId());
            lane.setTenantId(Utils.getTenantId());
            this.jobBenchMapper.insert((Object)lane);
            laneNameIdMap.put(laneKey, lane.getId());
            laneId = lane.getId();
            ++laneIndex;
        }
        JobBenchCustom jobBenchCustom = new JobBenchCustom();
        jobBenchCustom.setBenchId(laneId);
        jobBenchCustom.setCreateUserId(Utils.getUserId());
        jobBenchCustom.setCreateTime(DateUtils.getNowTime((String)""));
        jobBenchCustom.setTenantId(Utils.getTenantId());
        jobBenchCustom.setLabelIndex(Integer.valueOf(jobIndex));
        LabelSystemCustom systemCustom = systemCustomMap.get(jobBenchImportVo.getJobName());
        if (null != systemCustom) {
            jobBenchCustom.setSystemId(systemCustom.getId());
            this.jobBenchCustomMapper.insert((Object)jobBenchCustom);
            ++jobIndex;
        }
    }

    private StringBuilder validateData(JobBenchImportVo jobBenchImportVo, List<String> benchNameList, Map<String, LabelSystemCustom> systemCustomMap, Map<String, List<String>> jobNameMap) {
        StringBuilder errorSb = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)jobBenchImportVo.getBenchName())) {
            errorSb.append("\u201c\u5de5\u4f5c\u53f0\u540d\u79f0\u201d\u672a\u586b\u5199").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)jobBenchImportVo.getBenchName()) && jobBenchImportVo.getBenchName().length() > 12) {
            errorSb.append("\u201c\u5de5\u4f5c\u53f0\u540d\u79f0\u201d\u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236").append(",");
        }
        if (benchNameList.contains(jobBenchImportVo.getBenchName())) {
            errorSb.append("\u201c\u5de5\u4f5c\u53f0\u540d\u79f0\u201d\u91cd\u540d").append(",");
        }
        if (StringUtils.isEmpty((CharSequence)jobBenchImportVo.getLaneName())) {
            errorSb.append("\u201c\u6cf3\u9053\u540d\u79f0\u201d\u672a\u586b\u5199").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)jobBenchImportVo.getLaneName()) && jobBenchImportVo.getLaneName().length() > 12) {
            errorSb.append("\u201c\u6cf3\u9053\u540d\u79f0\u201d\u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)jobBenchImportVo.getBenchName()) && StringUtils.isNotEmpty((CharSequence)jobBenchImportVo.getLaneName())) {
            List<String> jobNameList = jobNameMap.get(jobBenchImportVo.getBenchName() + "_" + jobBenchImportVo.getLaneName());
            if (CollectionUtils.isEmpty(jobNameList)) {
                jobNameList = new ArrayList<String>();
            }
            if (StringUtils.isNotEmpty((CharSequence)jobBenchImportVo.getJobName()) && jobNameList.contains(jobBenchImportVo.getJobName())) {
                errorSb.append("\u201c\u4f5c\u4e1a\u540d\u79f0\u201d\u91cd\u540d").append(",");
            }
        }
        if (StringUtils.isEmpty((CharSequence)jobBenchImportVo.getJobName())) {
            errorSb.append("\u201c\u4f5c\u4e1a\u540d\u79f0\u201d\u672a\u586b\u5199").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)jobBenchImportVo.getJobName()) && null == systemCustomMap.get(jobBenchImportVo.getJobName())) {
            errorSb.append("\u201c\u4f5c\u4e1a\u540d\u79f0\u201d\u503c\u9519\u8bef").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)jobBenchImportVo.getJobName()) && null != systemCustomMap.get(jobBenchImportVo.getJobName())) {
            LabelSystemCustom systemCustom = systemCustomMap.get(jobBenchImportVo.getJobName());
            if (systemCustom.getValidStatus().equals(Constants.VALID_STATUS_UNUSABLE)) {
                errorSb.append("\u5173\u8054\u4f5c\u4e1a\u672a\u542f\u7528").append(",");
            }
            if (!systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_WORK.getVal()) && !systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_APP.getVal())) {
                errorSb.append("\u201c\u4f5c\u4e1a\u540d\u79f0\u201d\u503c\u9519\u8bef").append(",");
            }
        }
        return errorSb;
    }

    public PageInfoResp<JobBenchImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isBlank((CharSequence)queryImportRecordReq.getStartTime()) || StringUtils.isBlank((CharSequence)queryImportRecordReq.getEndTime())) {
            String currentDate = DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss");
            condition.ge((Object)"create_time", (Object)DateUtils.addDate((String)currentDate, (String)"yyyy-MM-dd HH:mm:ss", (int)-1, (String)"year"));
            condition.le((Object)"create_time", (Object)currentDate);
        } else {
            condition.ge((Object)"create_time", (Object)queryImportRecordReq.getStartTime());
            condition.le((Object)"create_time", (Object)queryImportRecordReq.getEndTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryImportRecordReq.getUserIdName())) {
            condition.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.like((Object)"create_user_name", (Object)queryImportRecordReq.getUserIdName())).or()).like((Object)"create_user_id", (Object)queryImportRecordReq.getUserIdName());
            });
        }
        condition.orderByDesc((Object)"create_time");
        PageInfoResp pageInfoResp = new PageInfoResp();
        Page pageResult = (Page)this.jobBenchImportMapper.selectPage((IPage)new Page((long)queryImportRecordReq.getPageNum().intValue(), (long)queryImportRecordReq.getPageSize().intValue()), (Wrapper)condition);
        if (pageResult == null) {
            pageResult = new Page();
        }
        List<Object> respList = new ArrayList();
        if (pageResult != null && CollectionUtils.isNotEmpty((Collection)pageResult.getRecords())) {
            respList = pageResult.getRecords().stream().map(x -> {
                x.setFileUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + x.getFileId().trim());
                return x;
            }).collect(Collectors.toList());
        }
        pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
        pageInfoResp.setPageNo(queryImportRecordReq.getPageNum().intValue());
        pageInfoResp.setPageSize(queryImportRecordReq.getPageSize().intValue());
        pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
        pageInfoResp.setList(respList);
        return pageInfoResp;
    }

    public List<JobBenchExportVo> exportReport() {
        ArrayList<JobBenchExportVo> jobBenchExportVoList = new ArrayList<JobBenchExportVo>();
        Map<Object, Object> systemCustomMap = new HashMap();
        LabelSystemAllVo req = new LabelSystemAllVo();
        ArrayList<Integer> dataCategoryList = new ArrayList<Integer>();
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        req.setDataCategoryList(dataCategoryList);
        List systemCustomList = this.labelSystemCustomService.queryCustomList(req);
        if (CollectionUtils.isNotEmpty((Collection)systemCustomList)) {
            systemCustomMap = systemCustomList.stream().collect(Collectors.toMap(LabelSystemCustom::getId, Function.identity(), (a, b) -> a));
        }
        JobBench reqBench = new JobBench();
        reqBench.setParentId(Long.valueOf(0L));
        List jobBenchList = this.getBenchList(reqBench);
        for (JobBench jobBench : jobBenchList) {
            JobBench reqLane = new JobBench();
            reqLane.setParentId(jobBench.getId());
            List laneList = this.getBenchList(reqLane);
            if (CollectionUtils.isEmpty((Collection)laneList)) {
                jobBenchExportVoList.add(this.initJobBench(jobBench.getName(), ""));
                continue;
            }
            List laneIdList = laneList.stream().map(JobBench::getId).collect(Collectors.toList());
            List jobBenchCustomList = this.jobBenchCustomMapper.selectBenchBy(laneIdList);
            Map<Object, Object> laneSystemMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)jobBenchCustomList)) {
                laneSystemMap = jobBenchCustomList.stream().collect(Collectors.groupingBy(JobBenchCustom::getBenchId));
            }
            for (JobBench lane : laneList) {
                JobBenchExportVo jobBenchExportVo = new JobBenchExportVo();
                jobBenchExportVo.setBenchName(jobBench.getName());
                jobBenchExportVo.setLaneName(lane.getName());
                List benchCustomList = (List)laneSystemMap.get(lane.getId());
                if (CollectionUtils.isEmpty((Collection)benchCustomList)) {
                    jobBenchExportVoList.add(jobBenchExportVo);
                    continue;
                }
                for (JobBenchCustom benchCustom : benchCustomList) {
                    JobBenchExportVo jobExportVo = new JobBenchExportVo();
                    jobExportVo.setBenchName(jobBench.getName());
                    jobExportVo.setLaneName(lane.getName());
                    LabelSystemCustom systemCustom = (LabelSystemCustom)systemCustomMap.get(benchCustom.getSystemId());
                    if (null == systemCustom) continue;
                    jobExportVo.setJobName(systemCustom.getNameZh());
                    jobBenchExportVoList.add(jobExportVo);
                }
            }
        }
        return jobBenchExportVoList;
    }

    public JobBenchExportVo initJobBench(String benchName, String laneName) {
        JobBenchExportVo jobBenchExportVo = new JobBenchExportVo();
        if (StringUtils.isNotEmpty((CharSequence)benchName)) {
            jobBenchExportVo.setBenchName(benchName);
        }
        if (StringUtils.isNotEmpty((CharSequence)laneName)) {
            jobBenchExportVo.setLaneName(laneName);
        }
        return jobBenchExportVo;
    }
}

