/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.bench.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.portal.JobSyncReq;
import com.digiwin.athena.semc.entity.bench.SyncJobHistory;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.mapper.bench.SyncJobHistoryMapper;
import com.digiwin.athena.semc.mapper.bench.SyncJobInfoMapper;
import com.digiwin.athena.semc.service.bench.SyncJobInfoService;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncJobInfoServiceImpl
extends ServiceImpl<SyncJobInfoMapper, SyncJobInfo>
implements SyncJobInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SyncJobInfoServiceImpl.class);
    @Autowired
    SyncJobInfoMapper syncJobInfoMapper;
    @Autowired
    SyncJobHistoryMapper syncJobHistoryMapper;

    @Transactional
    public Integer jobSyncSave(JobSyncReq req) {
        if (req.getSyncModel() == 0) {
            if (null == req.getSyncType() || !req.getSyncType().equals(Constants.syncTypeEnum.DEL.getFlag())) {
                this.addJobInfo(req.getAppIdCode(), req.getAppId(), req.getJobList());
            }
        } else {
            if (null == req.getSyncType() || !req.getSyncType().equals(Constants.syncTypeEnum.DEL.getFlag())) {
                this.addIncrementJob(req.getAppIdCode(), req.getAppId(), req.getJobList());
            }
            if (null != req.getSyncType() && req.getSyncType().equals(Constants.syncTypeEnum.DEL.getFlag())) {
                this.delJobInfo(req.getAppId(), req.getJobList());
            }
        }
        return null;
    }

    public Integer jobSyncHistorySave(JobSyncReq req, Integer syncStatus, String resp) {
        SyncJobHistory syncJobHistory = new SyncJobHistory();
        syncJobHistory.setAppId(req.getAppId());
        syncJobHistory.setRespJson(resp);
        String reqJson = JSON.toJSONString((Object)req);
        if (reqJson.length() > 200) {
            reqJson = reqJson.substring(200);
        }
        syncJobHistory.setReqJson(reqJson);
        syncJobHistory.setSyncStatus(syncStatus);
        return this.syncJobHistoryMapper.insert((Object)syncJobHistory);
    }

    public List<SyncJobInfo> selectJobList(String appId, List<String> accountIdList) {
        QueryWrapper condition = new QueryWrapper();
        condition.orderByAsc((Object)"id");
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            condition.eq((Object)"app_id", (Object)appId);
        }
        if (CollectionUtils.isNotEmpty(accountIdList)) {
            condition.in((Object)"account_id", accountIdList);
        }
        return this.syncJobInfoMapper.selectList((Wrapper)condition);
    }

    public List<String> getJobAppIdList(List<String> appIdList) {
        return this.syncJobInfoMapper.getJobAppIdList(appIdList);
    }

    public void addIncrementJob(String appIdCode, String appId, List<SyncJobInfo> jobList) {
        ArrayList<String> delJobCodeList = new ArrayList<String>();
        ArrayList<SyncJobInfo> insertJobList = new ArrayList<SyncJobInfo>();
        for (SyncJobInfo job : jobList) {
            job.setAppIdCode(appIdCode);
            job.setAppId(appId);
            if (StringUtils.isEmpty((CharSequence)job.getJobCode())) continue;
            delJobCodeList.add(job.getJobCode());
            insertJobList.add(job);
        }
        if (CollectionUtils.isNotEmpty(delJobCodeList)) {
            QueryWrapper condition = new QueryWrapper();
            condition.eq((Object)"app_id", (Object)appId);
            condition.in((Object)"job_code", delJobCodeList);
            this.syncJobInfoMapper.delete((Wrapper)condition);
        }
        if (CollectionUtils.isNotEmpty(insertJobList)) {
            this.saveBatch(insertJobList);
        }
    }

    public void addJobInfo(String appIdCode, String appId, List<SyncJobInfo> jobList) {
        ArrayList<SyncJobInfo> insertJobList = new ArrayList<SyncJobInfo>();
        ArrayList<String> accountIdList = new ArrayList<String>();
        for (SyncJobInfo job : jobList) {
            job.setAppIdCode(appIdCode);
            job.setAppId(appId);
            if (StringUtils.isEmpty((CharSequence)job.getJobCode())) continue;
            insertJobList.add(job);
            accountIdList.add(job.getAccountId());
        }
        if (CollectionUtils.isNotEmpty(insertJobList)) {
            QueryWrapper condition = new QueryWrapper();
            condition.eq((Object)"app_id", (Object)appId);
            if (CollectionUtils.isNotEmpty(accountIdList)) {
                condition.in((Object)"account_id", accountIdList);
            }
            this.syncJobInfoMapper.delete((Wrapper)condition);
            this.saveBatch(insertJobList);
        }
    }

    public QueryWrapper getCondition(String appId, SyncJobInfo job) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)job.getVersion())) {
            condition.eq((Object)"version", (Object)job.getVersion());
        }
        if (StringUtils.isNotEmpty((CharSequence)job.getJobCode())) {
            condition.eq((Object)"job_code", (Object)job.getJobCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            condition.eq((Object)"app_id", (Object)appId);
        }
        return condition;
    }

    public void delJobInfo(String appId, List<SyncJobInfo> jobList) {
        for (SyncJobInfo job : jobList) {
            QueryWrapper condition = this.getCondition(appId, job);
            this.syncJobInfoMapper.delete((Wrapper)condition);
        }
    }
}

