/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.bench.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.dto.message.DeleteMessageConfigReq;
import com.digiwin.athena.semc.dto.message.QueryThirdMessageConfigReq;
import com.digiwin.athena.semc.dto.portal.JobSyncReq;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.bench.ThirdJobConfig;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.bench.ThirdJobConfigMapper;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.service.bench.SyncJobInfoService;
import com.digiwin.athena.semc.service.bench.ThirdJobConfigService;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.sso.IErpSsoInfoService;
import com.digiwin.athena.semc.service.sso.IThirdSsoInfoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdJobConfigServiceImpl
extends ServiceImpl<ThirdJobConfigMapper, ThirdJobConfig>
implements ThirdJobConfigService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdJobConfigServiceImpl.class);
    @Autowired
    ThirdJobConfigMapper thirdJobConfigMapper;
    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;
    @Autowired
    IErpSsoInfoService erpSsoInfoService;
    @Autowired
    IThirdSsoInfoService thirdSsoInfoService;
    @Resource
    private ESPService espService;
    @Resource
    EnvProperties envProperties;
    @Autowired
    TripartiteService tripartiteService;
    @Resource
    private SyncJobInfoService syncJobInfoService;

    public Integer saveThirdJob(ThirdJobConfig req) {
        if (null == req.getId()) {
            this.thirdJobConfigMapper.insert((Object)req);
        } else {
            this.thirdJobConfigMapper.updateById((Object)req);
        }
        return null;
    }

    public Integer delThirdJob(DeleteMessageConfigReq req) {
        return this.thirdJobConfigMapper.deleteBatchIds((Collection)req.getIdList());
    }

    public PageInfoResp<ThirdJobConfig> queryConfigPage(QueryThirdMessageConfigReq req) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)req.getAppPrimaryId())) {
            condition.eq((Object)"app_primary_id", (Object)req.getAppPrimaryId());
        }
        if (req.getValidStatus() != null) {
            condition.eq((Object)"valid_status", (Object)req.getValidStatus());
        }
        if (req.getAppSource() != null) {
            condition.eq((Object)"app_source", (Object)req.getAppSource());
        }
        if (req.getDataGetType() != null) {
            condition.eq((Object)"data_get_type", (Object)req.getDataGetType());
        }
        condition.orderByDesc((Object)"modify_time");
        condition.eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        PageInfoResp pageInfoResp = new PageInfoResp();
        Page pageResult = (Page)this.thirdJobConfigMapper.selectPage((IPage)new Page((long)req.getPageNum().intValue(), (long)req.getPageSize().intValue()), (Wrapper)condition);
        if (pageResult == null || CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return pageInfoResp;
        }
        List jobConfigList = pageResult.getRecords();
        this.packageAppCodeName(jobConfigList);
        pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
        pageInfoResp.setPageNo(req.getPageNum().intValue());
        pageInfoResp.setPageSize(req.getPageSize().intValue());
        pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
        pageInfoResp.setList(jobConfigList);
        return pageInfoResp;
    }

    public boolean validJobConfigExist(ThirdJobConfig req) {
        ThirdJobConfig config;
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"app_source", (Object)req.getAppSource());
        condition.eq((Object)"app_primary_id", (Object)req.getAppPrimaryId());
        if (req.getId() != null) {
            condition.ne((Object)"id", (Object)req.getId());
        }
        return null != (config = (ThirdJobConfig)this.thirdJobConfigMapper.selectOne((Wrapper)condition));
    }

    public void packageAppCodeName(List<ThirdJobConfig> jobConfigList) {
        List csList = jobConfigList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getAppSource())).collect(Collectors.toList());
        List csIdList = csList.stream().map(ThirdJobConfig::getAppPrimaryId).collect(Collectors.toList());
        Map erpInfoMap = this.erpSsoInfoService.getErpInfoMap(csIdList);
        List bsList = jobConfigList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getAppSource())).collect(Collectors.toList());
        List bsIdList = bsList.stream().map(ThirdJobConfig::getAppPrimaryId).collect(Collectors.toList());
        Map thirdSsoInfoMap = this.thirdSsoInfoService.getSsoInfoMap(bsIdList);
        Map preInfoMap = this.preinstalledApplicationService.getPreInfoMap();
        for (ThirdJobConfig jobConfig : jobConfigList) {
            PreinstalledApplication preinstalledApplication;
            ThirdSsoInfo thirdSsoInfo;
            ErpSsoInfo erpSsoInfo;
            String appName = "";
            if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(jobConfig.getAppSource()) && null != (erpSsoInfo = (ErpSsoInfo)erpInfoMap.get(Long.parseLong(jobConfig.getAppPrimaryId())))) {
                appName = erpSsoInfo.getName();
            }
            if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(jobConfig.getAppSource()) && (thirdSsoInfo = (ThirdSsoInfo)thirdSsoInfoMap.get(Long.parseLong(jobConfig.getAppPrimaryId()))) != null) {
                appName = thirdSsoInfo.getAppName();
            }
            if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(jobConfig.getAppSource()) && null != (preinstalledApplication = (PreinstalledApplication)preInfoMap.get(Long.parseLong(jobConfig.getAppPrimaryId())))) {
                appName = preinstalledApplication.getApplicationName();
            }
            jobConfig.setAppName(appName);
        }
    }

    public List<SyncJobInfo> getThirdJobList(String appPrimaryId, Integer appSource, String appToken, String appId, String appIdCode) {
        List<Object> jobInfoList = new ArrayList<SyncJobInfo>();
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"app_source", (Object)appSource);
        condition.eq((Object)"app_primary_id", (Object)appPrimaryId);
        ThirdJobConfig config = (ThirdJobConfig)this.thirdJobConfigMapper.selectOne((Wrapper)condition);
        if (null == config || null == config.getDataGetType() || config.getDataGetType() == 1 || config.getValidStatus().equals(Constants.ValidStatusEnum.VALID_STATUS_ON.getVal())) {
            return jobInfoList;
        }
        try {
            String string = appToken = StringUtils.isBlank((CharSequence)appToken) ? this.envProperties.getAppToken() : appToken;
            if (null != config.getAppAccessModel() && config.getAppAccessModel().equals(Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal())) {
                HashMap<String, String> extHeader = new HashMap<String, String>();
                String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
                extHeader.put("digi-userToken", token);
                extHeader.put("digi-appToken", appToken);
                Map result = this.espService.queryByEsp(config.getMiddleSystemName(), config.getMiddleSystemUid(), EAIServiceNameEnum.THIRD_JOB_QUERY.getServiceName(), extHeader, null, null, null);
                if (Objects.isNull(result.get("jobList"))) {
                    return jobInfoList;
                }
                jobInfoList = JSONArray.parseArray((String)JSON.toJSONString(result.get("jobList")), SyncJobInfo.class);
            }
            if (null != config.getAppAccessModel() && config.getAppAccessModel().equals(Constants.DataModelEnum.MODEL_CLOUD.getVal())) {
                JSONArray jobData = this.tripartiteService.queryThirdData(config.getDomain() + "/eai/mocksys/data/queryJobData", appToken);
                if (null == jobData) {
                    return jobInfoList;
                }
                jobInfoList = JSONArray.parseArray((String)jobData.toJSONString(), SyncJobInfo.class);
            }
        }
        catch (Exception e) {
            log.error("\u62c9\u53d6\u4e09\u65b9\u7cfb\u7edf\u4f5c\u4e1a \u5f02\u5e38,req:{},errorMsg:{}", (Object)JSON.toJSONString((Object)config), (Object)e);
            return jobInfoList;
        }
        if (CollectionUtils.isNotEmpty(jobInfoList)) {
            JobSyncReq req = new JobSyncReq();
            req.setAppId(appId);
            req.setAppIdCode(appIdCode);
            req.setSyncType(Integer.valueOf(0));
            req.setSyncModel(0);
            boolean accountFlag = req.getJobList().stream().anyMatch(x -> StringUtils.isNotBlank((CharSequence)x.getAccountId()));
            if (accountFlag) {
                List syncJobInfos = jobInfoList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getAccountId())).collect(Collectors.toList());
                HashSet<String> jobCodeList = new HashSet<String>();
                ArrayList<SyncJobInfo> filterJobs = new ArrayList<SyncJobInfo>();
                for (SyncJobInfo syncJobInfo : syncJobInfos) {
                    String jobCode = syncJobInfo.getAccountId() + "-" + syncJobInfo.getJobCode();
                    if (!jobCodeList.add(jobCode)) continue;
                    syncJobInfo.setJobCode(jobCode);
                    filterJobs.add(syncJobInfo);
                }
                req.setJobList(filterJobs);
            } else {
                req.setJobList(jobInfoList);
            }
            this.syncJobInfoService.jobSyncSave(req);
            return req.getJobList();
        }
        return Collections.emptyList();
    }

    public ThirdJobConfig getJobConfigBy(String appCode, String appId) {
        return this.thirdJobConfigMapper.getJobConfigBy(appCode, appId);
    }
}

