/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.cache;

import com.digiwin.athena.appcore.util.SpringUtil;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Deprecated
public class RedisLock {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisLock.class);
    private static final int DEFAULT_ACQUIRY_RESOLUTION_MILLIS = 100;
    private RedisTemplate redisTemplate = (RedisTemplate)SpringUtil.getBean((String)"redisTemplate", RedisTemplate.class);
    private String lockKey;
    private int expireMsecs = 60000;
    private int timeoutMsecs = 10000;
    private volatile boolean locked = false;

    public RedisLock(String lockKey) {
        this.lockKey = "semc:cache:" + lockKey + "_lock";
    }

    private String get(String key) {
        Object obj = null;
        try {
            obj = this.redisTemplate.execute(connection -> {
                StringRedisSerializer serializer = new StringRedisSerializer();
                byte[] data = connection.get(serializer.serialize(key));
                connection.close();
                if (data == null) {
                    return null;
                }
                return serializer.deserialize(data);
            });
        }
        catch (Exception e) {
            log.error("get redis error, key : {}", (Object)key);
        }
        return obj != null ? obj.toString() : null;
    }

    private boolean setNX(String key, String value) {
        Object obj = null;
        try {
            obj = this.redisTemplate.execute(connection -> {
                StringRedisSerializer serializer = new StringRedisSerializer();
                Boolean success = connection.setNX(serializer.serialize(key), serializer.serialize(value));
                connection.close();
                return success;
            });
        }
        catch (Exception e) {
            log.error("setNX redis error, key : {}", (Object)key);
        }
        return obj != null ? (Boolean)obj : false;
    }

    private String getSet(String key, String value) {
        Object obj = null;
        try {
            obj = this.redisTemplate.execute(connection -> {
                StringRedisSerializer serializer = new StringRedisSerializer();
                byte[] ret = connection.getSet(serializer.serialize(key), serializer.serialize(value));
                connection.close();
                return serializer.deserialize(ret);
            });
        }
        catch (Exception e) {
            log.error("setNX redis error, key : {}", (Object)key);
        }
        return obj != null ? (String)obj : null;
    }

    public synchronized boolean lock() throws InterruptedException {
        for (int timeout = this.timeoutMsecs; timeout >= 0; timeout -= 100) {
            String oldValueStr;
            long expires = System.currentTimeMillis() + (long)this.expireMsecs + 1L;
            String expiresStr = String.valueOf(expires);
            if (this.setNX(this.lockKey, expiresStr)) {
                this.locked = true;
                return true;
            }
            String currentValueStr = this.get(this.lockKey);
            if (currentValueStr != null && Long.parseLong(currentValueStr) < System.currentTimeMillis() && (oldValueStr = this.getSet(this.lockKey, expiresStr)) != null && oldValueStr.equals(currentValueStr)) {
                this.locked = true;
                return true;
            }
            this.wait(100L);
        }
        return false;
    }

    public synchronized void unlock() {
        if (this.locked) {
            this.redisTemplate.delete((Object)this.lockKey);
            this.locked = false;
        }
    }

    @Generated
    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    @Generated
    public String getLockKey() {
        return this.lockKey;
    }

    @Generated
    public int getExpireMsecs() {
        return this.expireMsecs;
    }

    @Generated
    public int getTimeoutMsecs() {
        return this.timeoutMsecs;
    }

    @Generated
    public boolean isLocked() {
        return this.locked;
    }

    @Generated
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Generated
    public void setLockKey(String lockKey) {
        this.lockKey = lockKey;
    }

    @Generated
    public void setExpireMsecs(int expireMsecs) {
        this.expireMsecs = expireMsecs;
    }

    @Generated
    public void setTimeoutMsecs(int timeoutMsecs) {
        this.timeoutMsecs = timeoutMsecs;
    }

    @Generated
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisLock)) {
            return false;
        }
        RedisLock other = (RedisLock)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getExpireMsecs() != other.getExpireMsecs()) {
            return false;
        }
        if (this.getTimeoutMsecs() != other.getTimeoutMsecs()) {
            return false;
        }
        if (this.isLocked() != other.isLocked()) {
            return false;
        }
        RedisTemplate this$redisTemplate = this.getRedisTemplate();
        RedisTemplate other$redisTemplate = other.getRedisTemplate();
        if (this$redisTemplate == null ? other$redisTemplate != null : !this$redisTemplate.equals(other$redisTemplate)) {
            return false;
        }
        String this$lockKey = this.getLockKey();
        String other$lockKey = other.getLockKey();
        return !(this$lockKey == null ? other$lockKey != null : !this$lockKey.equals(other$lockKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RedisLock;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getExpireMsecs();
        result = result * 59 + this.getTimeoutMsecs();
        result = result * 59 + (this.isLocked() ? 79 : 97);
        RedisTemplate $redisTemplate = this.getRedisTemplate();
        result = result * 59 + ($redisTemplate == null ? 43 : $redisTemplate.hashCode());
        String $lockKey = this.getLockKey();
        result = result * 59 + ($lockKey == null ? 43 : $lockKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RedisLock(redisTemplate=" + this.getRedisTemplate() + ", lockKey=" + this.getLockKey() + ", expireMsecs=" + this.getExpireMsecs() + ", timeoutMsecs=" + this.getTimeoutMsecs() + ", locked=" + this.isLocked() + ")";
    }
}

