/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.cache.impl;

import com.digiwin.athena.semc.service.cache.ICacheService;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class CacheServiceImpl
implements ICacheService {
    public static final String KEY_PREFIX = "semc:cache:";
    public static final Duration DEFAULT_DURATION = Duration.ofDays(7L);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public Long incr(String key) {
        return this.stringRedisTemplate.opsForValue().increment((Object)(KEY_PREFIX + key));
    }

    public boolean hasKey(String key) {
        return this.stringRedisTemplate.hasKey((Object)(KEY_PREFIX + key));
    }

    public boolean hasKey(String serviceName, String functionName, String paraStr) {
        return this.hasKey(this.getFormatKey(serviceName, functionName, paraStr));
    }

    public void delete(String key) {
        this.stringRedisTemplate.delete((Object)(KEY_PREFIX + key));
    }

    public void deleteByPrex(String prex) {
        Set keys = this.stringRedisTemplate.keys((Object)(KEY_PREFIX + prex));
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            this.stringRedisTemplate.delete((Collection)keys);
        }
    }

    public void cache(String key, String value) {
        this.stringRedisTemplate.boundValueOps((Object)(KEY_PREFIX + key)).set((Object)value);
    }

    public void cache(String key, String value, Duration duration) {
        this.stringRedisTemplate.boundValueOps((Object)(KEY_PREFIX + key)).set((Object)value, duration);
    }

    public void cache(String serviceName, String functionName, String paraStr, String value) {
        this.cache(this.getFormatKey(serviceName, functionName, paraStr), value);
    }

    public void cache(String serviceName, String functionName, String paraStr, String value, Duration duration) {
        this.cache(this.getFormatKey(serviceName, functionName, paraStr), value, duration);
    }

    public Object get(String key) {
        key = KEY_PREFIX + key;
        return this.stringRedisTemplate.boundValueOps((Object)key).get();
    }

    public String getValue(String key) {
        key = KEY_PREFIX + key;
        return (String)this.stringRedisTemplate.boundValueOps((Object)key).get();
    }

    public Object get(String serviceName, String functionName, String paraStr) {
        return this.get(this.getFormatKey(serviceName, functionName, paraStr));
    }

    private String getFormatKey(String serviceName, String functionName, String paraStr) {
        return String.format("%s.%s(%s)", serviceName, functionName, paraStr);
    }

    public void batchDelete(String pattern) {
        Set keys = this.stringRedisTemplate.keys((Object)(KEY_PREFIX + pattern));
        this.stringRedisTemplate.delete((Collection)keys);
    }

    public void cacheNoPrefix(String key, String value) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
    }
}

