/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.cache.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.dto.config.MobilePortalCacheConfigParam;
import com.digiwin.athena.semc.dto.fineReport.FineReportConfigDTO;
import com.digiwin.athena.semc.service.cache.CommonConfigService;
import com.digiwin.athena.semc.service.cache.ICacheService;
import com.digiwin.athena.semc.service.cache.impl.CacheServiceImpl;
import com.digiwin.athena.semc.service.common.EnvService;
import io.vavr.Tuple2;
import java.time.Duration;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommonConfigServiceImpl
implements CommonConfigService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonConfigServiceImpl.class);
    private final ICacheService cacheService;
    private final EnvService envService;
    public static final String PREFIX_KEY = "cc:";
    public static final String MOBILE_PORTAL_CACHE_CONFIG_PARAM_KEY = "cc:MobilePortalCacheConfigParam";
    public static final String NEWS_PUBLISH_EDIT_FLAG = "cc:NewsPublishEditFlag";
    public static final String IAM_USER_AUTH_INFO_CONFIG = "cc:IamUserAuthInfoConfig";
    public static final String SUPER_ADMIN_FLAG_SWITCH = "cc:SuperAdminFlagSwitch";
    public static final String BACKEND_MENU_OPERATE_FLAG = "cc:BackendMenuOperateFlag";
    public static final String BACKEND_MENU_OPERATE_USER = "zhouyxa@digiwin.com,chendda@digiwin.com,chenzlc@digiwin.com,dengkw@digiwin.com,hongyana@digiwin.com,liujxb@digiwin.com,liuyanb@digiwin.com,liypb@digiwin.com,songcla@digiwin.com,sungqz@digiwin.com,sunztf@digiwin.com,xueah@digiwin.com,yufei@digiwin.com,xiaozm@digiwin.com";
    public static final String NEWS_SEND_NOTICE_USER_COUNT = "cc:NewsSendNoticeUserCount";
    public static final String NEWS_SEND_NOTICE_OUTER_USER_FLAG = "cc:NewsSendNoticeOuterUserFlag";
    public static final String FINE_REPORT_CACHE_CONFIG_KEY = "cc:FineReportCacheConfig:";

    public String getCommonConfig(String key) {
        try {
            return this.cacheService.getValue(key);
        }
        catch (Exception e) {
            log.error("getCommonConfigEx", (Throwable)e);
            return "";
        }
    }

    public boolean setCommonConfig(String key, String value) {
        return this.setCommonConfig(key, value, CacheServiceImpl.DEFAULT_DURATION);
    }

    public boolean setCommonConfig(String key, String value, Duration duration) {
        try {
            if (duration != null) {
                this.cacheService.cache(key, value, duration);
            } else {
                this.cacheService.cache(key, value);
            }
            return true;
        }
        catch (Exception e) {
            log.error("setCommonConfigEx", (Throwable)e);
            return false;
        }
    }

    public boolean removeCommonConfig(String key) {
        try {
            this.cacheService.delete(key);
            return true;
        }
        catch (Exception e) {
            log.error("removeCommonConfigEx", (Throwable)e);
            return false;
        }
    }

    public MobilePortalCacheConfigParam getMobilePortalCacheConfigParam() {
        String value = this.getCommonConfig(MOBILE_PORTAL_CACHE_CONFIG_PARAM_KEY);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return (MobilePortalCacheConfigParam)JSON.parseObject((String)value, MobilePortalCacheConfigParam.class);
    }

    public boolean setMobilePortalCacheConfigParam(MobilePortalCacheConfigParam param) {
        if (param == null) {
            return false;
        }
        String value = JSON.toJSONString((Object)param);
        return this.setCommonConfig(MOBILE_PORTAL_CACHE_CONFIG_PARAM_KEY, value);
    }

    public boolean getNewsPublishEditFlag() {
        String value = this.getCommonConfig(NEWS_PUBLISH_EDIT_FLAG);
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        return Boolean.TRUE.toString().equals(value);
    }

    public Tuple2<Boolean, Integer> getIamUserAuthInfoConfig() {
        String value = this.getCommonConfig(IAM_USER_AUTH_INFO_CONFIG);
        if (StringUtils.isBlank((CharSequence)value)) {
            return new Tuple2((Object)true, (Object)900);
        }
        JSONObject jsonObject = JSON.parseObject((String)value);
        return new Tuple2((Object)jsonObject.getBoolean("switch"), (Object)jsonObject.getInteger("expire"));
    }

    public Tuple2<Boolean, Integer> querySuperAdminFlagSwitch() {
        String value = this.getCommonConfig(SUPER_ADMIN_FLAG_SWITCH);
        if (StringUtils.isBlank((CharSequence)value)) {
            return new Tuple2((Object)true, (Object)900);
        }
        JSONObject jsonObject = JSON.parseObject((String)value);
        return new Tuple2((Object)jsonObject.getBoolean("switch"), (Object)jsonObject.getInteger("expire"));
    }

    public boolean getBackendMenuOperateFlag() {
        if (!this.envService.isOnline()) {
            return true;
        }
        String value = this.getCommonConfig(BACKEND_MENU_OPERATE_FLAG);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = BACKEND_MENU_OPERATE_USER;
        }
        String userId = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
        return Arrays.asList(value.split(",")).contains(userId);
    }

    public Integer querySendNewsNoticeUserCount() {
        String count = this.getCommonConfig(NEWS_SEND_NOTICE_USER_COUNT);
        if (StringUtils.isBlank((CharSequence)count)) {
            return 200;
        }
        return Integer.parseInt(count);
    }

    public boolean querySendNewsNoticeOuterFlag() {
        String value = this.getCommonConfig(NEWS_SEND_NOTICE_OUTER_USER_FLAG);
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        return Boolean.TRUE.toString().equals(value);
    }

    public FineReportConfigDTO queryFineReportConfigCache(String tenantId) {
        String value = this.getCommonConfig(FINE_REPORT_CACHE_CONFIG_KEY + tenantId);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return (FineReportConfigDTO)JSON.parseObject((String)value, FineReportConfigDTO.class);
    }

    public void setFineReportConfigCache(FineReportConfigDTO fineReportConfigDTO, String tenantId) {
        if (ObjectUtils.isEmpty((Object)fineReportConfigDTO)) {
            return;
        }
        String value = JSON.toJSONString((Object)fineReportConfigDTO);
        this.setCommonConfig(FINE_REPORT_CACHE_CONFIG_KEY + tenantId, value);
    }

    @Generated
    public CommonConfigServiceImpl(ICacheService cacheService, EnvService envService) {
        this.cacheService = cacheService;
        this.envService = envService;
    }
}

