/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.common;

import com.digiwin.athena.semc.entity.homepage.UpgradeBrowseDetail;
import com.digiwin.athena.semc.service.common.UpgradeBrowseDetailHandler;
import com.digiwin.athena.semc.util.thread.NamedThreadFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessagePersistenceProcess {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagePersistenceProcess.class);
    private static MessagePersistenceProcess instance = new MessagePersistenceProcess();
    private ArrayBlockingQueue<UpgradeBrowseDetail> batchBlockQueue = null;

    private MessagePersistenceProcess() {
    }

    public static MessagePersistenceProcess getInstance() {
        if (instance == null) {
            instance = new MessagePersistenceProcess();
        }
        return instance;
    }

    private void initQueue() {
        this.batchBlockQueue = new ArrayBlockingQueue(1000);
    }

    private void startHandler() {
        ThreadPoolExecutor service = new ThreadPoolExecutor(0, 1000, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("StorageThreadPool"));
        UpgradeBrowseDetailHandler batchHandler = new UpgradeBrowseDetailHandler(this.batchBlockQueue);
        batchHandler.setName("storageBatch");
        service.execute((Runnable)batchHandler);
    }

    public void start() {
        this.initQueue();
        this.startHandler();
    }

    public void pushBatch(UpgradeBrowseDetail data) {
        try {
            this.batchBlockQueue.put(data);
        }
        catch (InterruptedException ie) {
            log.error("message persistence process push batch error", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error("message persistence process push batch error", (Throwable)e);
        }
    }
}

