/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.BizAuthTypeEnum;
import com.digiwin.athena.semc.common.enums.BizObjectTypeEnum;
import com.digiwin.athena.semc.entity.common.BizObjAuthRel;
import com.digiwin.athena.semc.entity.portal.KnowledgeApplicationRef;
import com.digiwin.athena.semc.mapper.common.BizObjAuthRelMapper;
import com.digiwin.athena.semc.mapper.portal.KnowledgeApplicationMapper;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.eoc.service.model.UserDeptInfoDTO;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.OrgRoleUserDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.UserDTO;
import com.digiwin.athena.semc.proxywrapper.IamUserService;
import com.digiwin.athena.semc.proxywrapper.dto.IamUserAuthInfo;
import com.digiwin.athena.semc.service.common.IBizObjAuthRelService;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchForLinkReq;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchVo;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.linpeilie.Converter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizObjAuthRelServiceImpl
extends ServiceImpl<BizObjAuthRelMapper, BizObjAuthRel>
implements IBizObjAuthRelService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BizObjAuthRelServiceImpl.class);
    @Resource
    private IamService iamService;
    @Resource
    private EocService eocService;
    @Autowired
    private KnowledgeApplicationMapper knowledgeApplicationMapper;
    @Resource
    BizObjAuthRelMapper bizObjAuthRelMapper;
    @Autowired
    private IamUserService iamUserService;
    @Resource
    private Converter converter;

    @Transactional
    public void addBizObjectAuthRel(BizObjAuthRelBatchVo bizObjAuthRelBatchVo, int bizObjectType) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"biz_obj_type", (Object)bizObjectType);
        condition.in((Object)"biz_obj_id", (Collection)bizObjAuthRelBatchVo.getIds());
        ((BizObjAuthRelMapper)this.baseMapper).delete((Wrapper)condition);
        ArrayList allBizObjAuthRelVoList = new ArrayList();
        allBizObjAuthRelVoList.addAll(bizObjAuthRelBatchVo.getOrg() == null ? Lists.newArrayList() : bizObjAuthRelBatchVo.getOrg());
        allBizObjAuthRelVoList.addAll(bizObjAuthRelBatchVo.getRole() == null ? Lists.newArrayList() : bizObjAuthRelBatchVo.getRole());
        allBizObjAuthRelVoList.addAll(bizObjAuthRelBatchVo.getUser() == null ? Lists.newArrayList() : bizObjAuthRelBatchVo.getUser());
        if (CollectionUtils.isNotEmpty(allBizObjAuthRelVoList)) {
            ArrayList bizObjAuthRelList = new ArrayList();
            allBizObjAuthRelVoList.forEach(x -> bizObjAuthRelBatchVo.getIds().forEach(id -> {
                BizObjAuthRel bizObjAuthRel = (BizObjAuthRel)this.converter.convert(x, BizObjAuthRel.class);
                bizObjAuthRel.setBizObjId(String.valueOf(id));
                bizObjAuthRelList.add(bizObjAuthRel);
            }));
            this.saveBatch(bizObjAuthRelList);
        }
    }

    @Transactional
    public void saveBizObjectAuthRelForLinkApp(BizObjAuthRelBatchForLinkReq bizObjAuthRelBatchForLinkReq) {
        List authList = bizObjAuthRelBatchForLinkReq.getAuthList();
        List authIdList = authList.stream().map(BizObjAuthRelBatchForLinkReq.AuthVO::getAuthId).collect(Collectors.toList());
        QueryWrapper condition = new QueryWrapper();
        condition.in((Object)"auth_id", authIdList);
        condition.eq((Object)"biz_obj_type", (Object)BizObjectTypeEnum.APPlICATION_MANAGEMENT.getValue());
        List currentRelList = this.bizObjAuthRelMapper.selectList((Wrapper)condition);
        if (CollectionUtils.isNotEmpty((Collection)currentRelList)) {
            ((BizObjAuthRelMapper)this.baseMapper).delete((Wrapper)condition);
        }
        List appList = bizObjAuthRelBatchForLinkReq.getAppList();
        ArrayList bizObjAuthRelList = new ArrayList();
        authList.forEach(authVO -> {
            for (BizObjAuthRelBatchForLinkReq.AppVO appVO : appList) {
                BizObjAuthRel bizObjAuthRel = new BizObjAuthRel();
                bizObjAuthRel.setAuthId(authVO.getAuthId());
                bizObjAuthRel.setAuthType(authVO.getAuthType());
                bizObjAuthRel.setAuthName(authVO.getAuthName());
                bizObjAuthRel.setBizObjId(appVO.getPrimaryId());
                bizObjAuthRel.setBizObjSubType(appVO.getBizObjSubType());
                bizObjAuthRel.setBizObjType(BizObjectTypeEnum.APPlICATION_MANAGEMENT.getValue());
                bizObjAuthRelList.add(bizObjAuthRel);
            }
        });
        List partList = Lists.partition(bizObjAuthRelList, (int)500);
        for (List tempList : partList) {
            this.saveBatch((Collection)tempList);
        }
        this.authorizeUserApp(currentRelList, bizObjAuthRelList, (BizObjAuthRelBatchForLinkReq.AuthVO)authList.get(0));
    }

    private void authorizeUserApp(List<BizObjAuthRel> currentRelList, List<BizObjAuthRel> bizObjAuthRelList, BizObjAuthRelBatchForLinkReq.AuthVO authVO) {
        log.info("BizObjAuthRelServiceImpl | batch user authorize app, currentRelList:{}, bizObjAuthRelList:{}, auth:{}", new Object[]{currentRelList, bizObjAuthRelList, authVO});
        List bizIdList = bizObjAuthRelList.stream().map(x -> x.getBizObjSubType() + "-" + x.getBizObjId()).collect(Collectors.toList());
        List deleteList = currentRelList.stream().filter(x -> !bizIdList.contains(x.getBizObjSubType() + "-" + x.getBizObjId())).collect(Collectors.toList());
        List idList = currentRelList.stream().map(x -> x.getBizObjSubType() + "-" + x.getBizObjId()).collect(Collectors.toList());
        List addList = bizObjAuthRelList.stream().filter(x -> !idList.contains(x.getBizObjSubType() + "-" + x.getBizObjId())).collect(Collectors.toList());
        ArrayList list = Lists.newArrayList();
        list.addAll(deleteList);
        list.addAll(addList);
        List kgAppList = this.knowledgeApplicationMapper.queryKgList((List)list);
        log.info("BizObjAuthRelServiceImpl | query kg list, param:{}, result:{}", (Object)list, (Object)kgAppList);
        if (CollectionUtils.isEmpty((Collection)kgAppList)) {
            return;
        }
        List authList = this.queryAuthListByAppId(kgAppList);
        log.info("BizObjAuthRelServiceImpl | query auth list by appId, param:{}, result:{}", (Object)kgAppList, (Object)authList);
        Map orgSidMap = this.buildOrgRoleMap(authList, authVO);
        Map roleSidMap = this.buildOrgRoleMap(authList, authVO);
        Map deptSidMap = this.buildOrgRoleMap(authList, authVO);
        ArrayList delAppList = Lists.newArrayList();
        ArrayList addAppList = Lists.newArrayList();
        kgAppList.forEach(x -> {
            deleteList.forEach(y -> {
                if (x.getApplicationType().equals(y.getBizObjSubType()) && x.getAppPrimaryId().equals(y.getBizObjId())) {
                    delAppList.add(x);
                }
            });
            addList.forEach(y -> {
                if (x.getApplicationType().equals(y.getBizObjSubType()) && x.getAppPrimaryId().equals(y.getBizObjId())) {
                    addAppList.add(x);
                }
            });
        });
        log.info("BizObjAuthRelServiceImpl | delAppList:{}, addAppList:{}", (Object)delAppList, (Object)addAppList);
        if (CollectionUtils.isNotEmpty((Collection)delAppList)) {
            Map<String, List<BizObjAuthRel>> appIdAuthMap = authList.stream().collect(Collectors.groupingBy(x -> x.getBizObjSubType() + "-" + x.getBizObjId()));
            for (KnowledgeApplicationRef knowledgeApplicationRef : delAppList) {
                if (BizAuthTypeEnum.USER.getValue().equals(authVO.getAuthType()) || BizAuthTypeEnum.EXTERNAL_USER.getValue().equals(authVO.getAuthType())) {
                    ArrayList userSidList = Lists.newArrayList();
                    List<BizObjAuthRel> authRelList = appIdAuthMap.get(knowledgeApplicationRef.getApplicationType() + "-" + knowledgeApplicationRef.getAppPrimaryId());
                    if (CollectionUtils.isNotEmpty(authRelList)) {
                        Object bizObjAuthRel2;
                        List orgList = authRelList.stream().filter(x -> BizAuthTypeEnum.ORG.getValue().equals(x.getAuthType())).collect(Collectors.toList());
                        for (Object bizObjAuthRel2 : orgList) {
                            if (ObjectUtils.isEmpty(orgSidMap.get(bizObjAuthRel2.getAuthId()))) continue;
                            userSidList.addAll(((List)orgSidMap.get(bizObjAuthRel2.getAuthId())).stream().map(UserDTO::getSid).collect(Collectors.toList()));
                        }
                        List roleList = authRelList.stream().filter(x -> BizAuthTypeEnum.ROLE.getValue().equals(x.getAuthType())).collect(Collectors.toList());
                        bizObjAuthRel2 = roleList.iterator();
                        while (bizObjAuthRel2.hasNext()) {
                            BizObjAuthRel bizObjAuthRel3 = (BizObjAuthRel)bizObjAuthRel2.next();
                            if (ObjectUtils.isEmpty(roleSidMap.get(bizObjAuthRel3.getAuthId()))) continue;
                            userSidList.addAll(((List)roleSidMap.get(bizObjAuthRel3.getAuthId())).stream().map(UserDTO::getSid).collect(Collectors.toList()));
                        }
                        List deptList = authRelList.stream().filter(x -> BizAuthTypeEnum.DEPARTMENT.getValue().equals(x.getAuthType())).collect(Collectors.toList());
                        for (BizObjAuthRel bizObjAuthRel4 : deptList) {
                            if (ObjectUtils.isEmpty(deptSidMap.get(bizObjAuthRel4.getAuthId()))) continue;
                            userSidList.addAll(((List)deptSidMap.get(bizObjAuthRel4.getAuthId())).stream().map(UserDTO::getSid).collect(Collectors.toList()));
                        }
                    }
                    if (userSidList.contains(authVO.getAuthId())) continue;
                    this.batchUserAuthorize(knowledgeApplicationRef, Collections.singletonList(authVO.getAuthId()), Constants.IamAuthorizeTypeEnum.DELETE.getVal());
                    continue;
                }
                if (!BizAuthTypeEnum.ORG.getValue().equals(authVO.getAuthType()) && !BizAuthTypeEnum.ROLE.getValue().equals(authVO.getAuthType()) && !BizAuthTypeEnum.DEPARTMENT.getValue().equals(authVO.getAuthType())) continue;
                List curOrgUserList = (List)orgSidMap.get(authVO.getAuthId());
                List curRoleUserList = (List)roleSidMap.get(authVO.getAuthId());
                List curDeptUserList = (List)deptSidMap.get(authVO.getAuthId());
                if (CollectionUtils.isEmpty((Collection)curOrgUserList) && CollectionUtils.isEmpty((Collection)curRoleUserList) && CollectionUtils.isEmpty((Collection)curDeptUserList)) continue;
                ArrayList allUserSidList = Lists.newArrayList();
                List<BizObjAuthRel> authRelList = appIdAuthMap.get(knowledgeApplicationRef.getApplicationType() + "-" + knowledgeApplicationRef.getAppPrimaryId());
                if (CollectionUtils.isNotEmpty(authRelList)) {
                    for (BizObjAuthRel bizObjAuthRel4 : authRelList) {
                        if (bizObjAuthRel4.getAuthId().equals(authVO.getAuthId())) continue;
                        ArrayList orgUserList = ObjectUtils.isEmpty(orgSidMap.get(bizObjAuthRel4.getAuthId())) ? Lists.newArrayList() : (List)orgSidMap.get(bizObjAuthRel4.getAuthId());
                        allUserSidList.addAll(orgUserList.stream().map(UserDTO::getSid).collect(Collectors.toList()));
                        ArrayList roleUserList = ObjectUtils.isEmpty(roleSidMap.get(bizObjAuthRel4.getAuthId())) ? Lists.newArrayList() : (List)roleSidMap.get(bizObjAuthRel4.getAuthId());
                        allUserSidList.addAll(roleUserList.stream().map(UserDTO::getSid).collect(Collectors.toList()));
                        ArrayList deptUserList = ObjectUtils.isEmpty(deptSidMap.get(bizObjAuthRel4.getAuthId())) ? Lists.newArrayList() : (List)deptSidMap.get(bizObjAuthRel4.getAuthId());
                        allUserSidList.addAll(deptUserList.stream().map(UserDTO::getSid).collect(Collectors.toList()));
                        if (!BizAuthTypeEnum.USER.getValue().equals(bizObjAuthRel4.getAuthType()) && !BizAuthTypeEnum.EXTERNAL_USER.getValue().equals(bizObjAuthRel4.getAuthType())) continue;
                        allUserSidList.add(bizObjAuthRel4.getAuthId());
                    }
                }
                List<Object> userSidList = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)curOrgUserList)) {
                    userSidList = curOrgUserList.stream().map(UserDTO::getSid).filter(sid -> !allUserSidList.contains(sid)).collect(Collectors.toList());
                } else if (CollectionUtils.isNotEmpty((Collection)curRoleUserList)) {
                    userSidList = curRoleUserList.stream().map(UserDTO::getSid).filter(sid -> !allUserSidList.contains(sid)).collect(Collectors.toList());
                } else if (CollectionUtils.isNotEmpty((Collection)curDeptUserList)) {
                    userSidList = curDeptUserList.stream().map(UserDTO::getSid).filter(sid -> !allUserSidList.contains(sid)).collect(Collectors.toList());
                }
                this.batchUserAuthorize(knowledgeApplicationRef, (List)userSidList, Constants.IamAuthorizeTypeEnum.DELETE.getVal());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addAppList)) {
            this.batchUserAuthorizeAddApp(orgSidMap, roleSidMap, deptSidMap, authVO, (List)addAppList, Constants.IamAuthorizeTypeEnum.INSERT.getVal());
        }
    }

    private Map<Long, List<UserDTO>> buildOrgRoleMap(List<BizObjAuthRel> authList, BizObjAuthRelBatchForLinkReq.AuthVO authVO) {
        Map<Object, Object> orgRoleMap = Maps.newHashMap();
        if (BizAuthTypeEnum.ORG.getValue().equals(authVO.getAuthType())) {
            List orgSidList = authList.stream().filter(x -> BizAuthTypeEnum.ORG.getValue().equals(x.getAuthType())).map(BizObjAuthRel::getAuthId).distinct().collect(Collectors.toList());
            orgSidList.add(authVO.getAuthId());
            if (CollectionUtils.isNotEmpty(orgSidList)) {
                List orgUserList = this.iamService.queryUserByAllOrgSidList(orgSidList);
                log.info("BizObjAuthRelServiceImpl | query org user by orgSidList, param:{}, result:{}", (Object)JSONObject.toJSONString(orgSidList), (Object)JSONObject.toJSONString((Object)orgUserList));
                orgRoleMap = orgUserList.stream().collect(Collectors.toMap(OrgRoleUserDTO::getOrgSid, OrgRoleUserDTO::getUsers));
            }
        }
        if (BizAuthTypeEnum.ROLE.getValue().equals(authVO.getAuthType())) {
            List roleSidList = authList.stream().filter(x -> BizAuthTypeEnum.ROLE.getValue().equals(x.getAuthType())).map(BizObjAuthRel::getAuthId).distinct().collect(Collectors.toList());
            roleSidList.add(authVO.getAuthId());
            if (CollectionUtils.isNotEmpty(roleSidList)) {
                List roleUserList = this.iamService.queryUserByAllRoleSidList(roleSidList);
                orgRoleMap = roleUserList.stream().collect(Collectors.toMap(OrgRoleUserDTO::getRoleSid, OrgRoleUserDTO::getUsers));
            }
        }
        if (BizAuthTypeEnum.DEPARTMENT.getValue().equals(authVO.getAuthType())) {
            List deptSidList = authList.stream().filter(x -> BizAuthTypeEnum.DEPARTMENT.getValue().equals(x.getAuthType())).map(BizObjAuthRel::getAuthId).distinct().collect(Collectors.toList());
            deptSidList.add(authVO.getAuthId());
            if (CollectionUtils.isNotEmpty(deptSidList)) {
                List deptUserList = this.eocService.queryUserByDeptSidList(deptSidList);
                log.info("BizObjAuthRelServiceImpl | query user by deptSidList, param:{}, result:{}", (Object)JSONObject.toJSONString(deptSidList), (Object)JSONObject.toJSONString((Object)deptUserList));
                orgRoleMap = deptUserList.stream().collect(Collectors.toMap(UserDeptInfoDTO::getDeptSid, x -> {
                    ArrayList userDTOList = Lists.newArrayList();
                    x.getEmps().forEach(empInfo -> {
                        if (ObjectUtils.isNotEmpty((Object)empInfo.getEmpUserSid())) {
                            UserDTO userDTO = new UserDTO();
                            userDTO.setSid(empInfo.getEmpUserSid());
                            userDTO.setId(empInfo.getEmpUserId());
                            userDTO.setName(empInfo.getEmpUserName());
                            userDTOList.add(userDTO);
                        }
                    });
                    return userDTOList;
                }));
            }
        }
        return orgRoleMap;
    }

    private void batchUserAuthorizeAddApp(Map<Long, List<UserDTO>> orgSidMap, Map<Long, List<UserDTO>> roleSidMap, Map<Long, List<UserDTO>> deptSidMap, BizObjAuthRelBatchForLinkReq.AuthVO authVO, List<KnowledgeApplicationRef> addAppList, Integer actionType) {
        for (KnowledgeApplicationRef knowledgeApplicationRef : addAppList) {
            ArrayList deptUserDTOList;
            ArrayList roleUserDTOList;
            ArrayList orgUserDTOList;
            if (BizAuthTypeEnum.USER.getValue().equals(authVO.getAuthType()) || BizAuthTypeEnum.EXTERNAL_USER.getValue().equals(authVO.getAuthType())) {
                this.batchUserAuthorize(knowledgeApplicationRef, Collections.singletonList(authVO.getAuthId()), Constants.IamAuthorizeTypeEnum.INSERT.getVal());
                continue;
            }
            if (!BizAuthTypeEnum.ORG.getValue().equals(authVO.getAuthType()) && !BizAuthTypeEnum.ROLE.getValue().equals(authVO.getAuthType()) && !BizAuthTypeEnum.DEPARTMENT.getValue().equals(authVO.getAuthType())) continue;
            List<Object> userSidList = Lists.newArrayList();
            List<Object> list = orgUserDTOList = ObjectUtils.isEmpty(orgSidMap.get(authVO.getAuthId())) ? Lists.newArrayList() : orgSidMap.get(authVO.getAuthId());
            if (CollectionUtils.isNotEmpty((Collection)orgUserDTOList)) {
                userSidList = orgUserDTOList.stream().map(UserDTO::getSid).collect(Collectors.toList());
            }
            List<Object> list2 = roleUserDTOList = ObjectUtils.isEmpty(roleSidMap.get(authVO.getAuthId())) ? Lists.newArrayList() : roleSidMap.get(authVO.getAuthId());
            if (CollectionUtils.isNotEmpty((Collection)roleUserDTOList)) {
                userSidList = roleUserDTOList.stream().map(UserDTO::getSid).collect(Collectors.toList());
            }
            List<Object> list3 = deptUserDTOList = ObjectUtils.isEmpty(deptSidMap.get(authVO.getAuthId())) ? Lists.newArrayList() : deptSidMap.get(authVO.getAuthId());
            if (CollectionUtils.isNotEmpty((Collection)deptUserDTOList)) {
                userSidList = deptUserDTOList.stream().map(UserDTO::getSid).collect(Collectors.toList());
            }
            this.batchUserAuthorize(knowledgeApplicationRef, (List)userSidList, actionType);
        }
    }

    private void batchUserAuthorize(KnowledgeApplicationRef knowledgeApplicationRef, List<Long> userSidList, Integer actionType) {
        if (CollectionUtils.isEmpty(userSidList)) {
            return;
        }
        List userPartList = Lists.partition(userSidList, (int)100);
        for (List tempList : userPartList) {
            log.info("BizObjAuthRelServiceImpl | start batch user authorize app, appId:{}, userSid:{}, actionType:{}", new Object[]{knowledgeApplicationRef.getKnowledgeId(), tempList, actionType});
            this.iamService.batchUserAuthorizeApp(knowledgeApplicationRef.getKnowledgeId(), tempList, actionType);
        }
    }

    public List<BizObjAuthRel> qryBizObjAuthRel(Integer bizObjType) {
        String userId = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        Long userSid = AppAuthContextHolder.getContext().getAuthoredUser().getSid();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        IamUserAuthInfo iamUserAuthInfo = this.iamUserService.getUserAuthSids(userId, tenantId, userToken);
        QueryWrapper cond = (QueryWrapper)new QueryWrapper().eq((Object)"biz_obj_type", (Object)bizObjType);
        StringBuilder authCond = new StringBuilder();
        if (iamUserAuthInfo != null && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getOrgSids())) {
            authCond.append("(auth_type = 1 and auth_id in(" + Joiner.on((String)",").join((Iterable)iamUserAuthInfo.getOrgSids()) + "))");
        }
        if (iamUserAuthInfo != null && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getRoleSids())) {
            if (StringUtils.isNotEmpty((CharSequence)authCond.toString())) {
                authCond.append("or (auth_type = 2 and auth_id in(" + Joiner.on((String)",").join((Iterable)iamUserAuthInfo.getRoleSids()) + "))");
            } else {
                authCond.append("(auth_type = 2 and auth_id in(" + Joiner.on((String)",").join((Iterable)iamUserAuthInfo.getRoleSids()) + "))");
            }
        }
        if (iamUserAuthInfo != null && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getDeptSids())) {
            if (StringUtils.isNotEmpty((CharSequence)authCond.toString())) {
                authCond.append("or (auth_type = 5 and auth_id in(" + Joiner.on((String)",").join((Iterable)iamUserAuthInfo.getDeptSids()) + "))");
            } else {
                authCond.append("(auth_type = 5 and auth_id in (" + Joiner.on((String)",").join((Iterable)iamUserAuthInfo.getDeptSids()) + "))");
            }
        }
        if (ObjectUtils.isNotEmpty((Object)userSid)) {
            if (StringUtils.isNotEmpty((CharSequence)authCond.toString())) {
                authCond.append("or (auth_type = 3 and auth_id = " + userSid + ")");
            } else {
                authCond.append("(auth_type = 3 and auth_id = " + userSid + ")");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)authCond.toString())) {
            cond.apply("(" + authCond + ")", new Object[0]);
        }
        List bizObjAuthRelList = ((BizObjAuthRelMapper)this.getBaseMapper()).selectList((Wrapper)cond);
        log.debug("FineReportService query business auth relation result:{}", (Object)JSONObject.toJSONString((Object)bizObjAuthRelList));
        return bizObjAuthRelList;
    }

    public List<BizObjAuthRel> queryAuthListByAppId(List<KnowledgeApplicationRef> bizObjAuthRelList) {
        return this.bizObjAuthRelMapper.queryAuthListByAppId(bizObjAuthRelList);
    }
}

