/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.enums.BizObjectTypeEnum;
import com.digiwin.athena.semc.common.enums.FolderLevelEnum;
import com.digiwin.athena.semc.common.enums.FolderTypeEnum;
import com.digiwin.athena.semc.entity.common.Folder;
import com.digiwin.athena.semc.entity.portal.FineReport;
import com.digiwin.athena.semc.mapper.common.FolderMapper;
import com.digiwin.athena.semc.service.common.IBizObjAuthRelService;
import com.digiwin.athena.semc.service.common.IFolderService;
import com.digiwin.athena.semc.service.portal.IFineReportService;
import com.digiwin.athena.semc.vo.common.FolderLevelVo;
import com.digiwin.athena.semc.vo.common.MoveFolderChildVo;
import com.digiwin.athena.semc.vo.common.MoveFolderVo;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FolderServiceImpl
extends ServiceImpl<FolderMapper, Folder>
implements IFolderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FolderServiceImpl.class);
    @Resource
    private IFineReportService fineReportService;
    @Resource
    private IBizObjAuthRelService bizObjAuthRelService;

    @Transactional
    public int addOrModFolder(Folder folder) {
        if (Objects.isNull(folder.getId())) {
            Integer maxOrder = ((FolderMapper)this.baseMapper).queryMaxOrder(folder.getParentFolderId());
            log.debug("FolderService query maxOrder result:{}", (Object)maxOrder);
            if (Objects.isNull(folder.getParentFolderId())) {
                folder.setFolderOrder(Integer.valueOf((maxOrder == null ? 0 : maxOrder) + 1));
            } else if (Objects.isNull(maxOrder)) {
                Folder parent = (Folder)((FolderMapper)this.baseMapper).selectById((Serializable)folder.getParentFolderId());
                folder.setFolderOrder(Integer.valueOf(parent.getFolderOrder() * 10 + 1));
            } else {
                folder.setFolderOrder(Integer.valueOf(maxOrder + 1));
            }
            folder.setCreateUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
            folder.setObjType(FolderTypeEnum.FINE_REPORT.getValue());
            ((FolderMapper)this.baseMapper).insert((Object)folder);
        } else {
            this.updateById((Object)folder);
        }
        return Integer.parseInt(String.valueOf(folder.getId()));
    }

    @Transactional
    public void delFolder(Long id, int folderType) {
        if (FolderTypeEnum.FINE_REPORT.getValue() == folderType) {
            List folderList = ((FolderMapper)this.baseMapper).qryCurrentAndChildFolderList(folderType, id.longValue());
            List folderIdList = folderList.stream().map(Folder::getId).collect(Collectors.toList());
            log.debug("FolderService folder id:{} query children result:{}", (Object)id, (Object)JSONObject.toJSONString(folderIdList));
            List fineReportList = this.fineReportService.getBaseMapper().selectList((Wrapper)new QueryWrapper().in((Object)"folder_id", folderIdList));
            if (CollectionUtils.isNotEmpty((Collection)fineReportList)) {
                List fineReportIdList = fineReportList.stream().map(FineReport::getId).collect(Collectors.toList());
                this.bizObjAuthRelService.getBaseMapper().delete((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"biz_obj_id", fineReportIdList)).eq((Object)"biz_obj_type", (Object)BizObjectTypeEnum.FINE_REPORT.getValue()));
                this.fineReportService.getBaseMapper().deleteBatchIds(fineReportIdList);
            }
            ((FolderMapper)this.baseMapper).deleteBatchIds(folderIdList);
        }
    }

    @Transactional
    public void moveFolder(List<MoveFolderVo> moveFolderVoList, Map<Long, MoveFolderChildVo> childrenFolderMap) {
        HashMap firstFolderMap = Maps.newHashMap();
        moveFolderVoList.forEach(moveFolderVo -> firstFolderMap.put(moveFolderVo.getId(), moveFolderVo));
        List firstFolderList = ((FolderMapper)this.baseMapper).selectBatchIds(firstFolderMap.keySet());
        firstFolderList.forEach(firstFolder -> {
            firstFolder.setParentFolderId(null);
            firstFolder.setFolderOrder(((MoveFolderVo)firstFolderMap.get(firstFolder.getId())).getFolderOrder());
            firstFolder.setLevel(FolderLevelEnum.FIRST.getValue());
        });
        this.saveOrUpdateBatch((Collection)firstFolderList);
        if (CollectionUtils.isNotEmpty(childrenFolderMap.keySet())) {
            List childrenFolderList = ((FolderMapper)this.baseMapper).selectBatchIds(childrenFolderMap.keySet());
            childrenFolderList.forEach(childFolder -> {
                Long childFolderId = childFolder.getId();
                childFolder.setParentFolderId(((MoveFolderChildVo)childrenFolderMap.get(childFolderId)).getParentFolderId());
                childFolder.setFolderOrder(((MoveFolderChildVo)childrenFolderMap.get(childFolderId)).getFolderOrder());
                childFolder.setLevel(((MoveFolderChildVo)childrenFolderMap.get(childFolderId)).getLevel());
            });
            this.saveOrUpdateBatch((Collection)childrenFolderList);
        }
    }

    public List<Folder> qryFolder(int folderType) {
        if (FolderTypeEnum.FINE_REPORT.getValue() == folderType) {
            List parentList = ((FolderMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().isNull((Object)"parent_folder_id")).eq((Object)"obj_type", (Object)folderType)).orderByAsc((Object)"folder_order"));
            log.debug("FineReporterService query parent result:{}", (Object)JSONObject.toJSONString((Object)parentList));
            if (CollectionUtils.isNotEmpty((Collection)parentList)) {
                parentList.stream().forEach(parent -> {
                    List children = ((FolderMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_folder_id", (Object)parent.getId())).eq((Object)"obj_type", (Object)folderType)).orderByAsc((Object)"folder_order"));
                    log.debug("FineReporterService folder id:{} query children result:{}", (Object)parent.getId(), (Object)JSONObject.toJSONString((Object)children));
                    parent.setChildren(children);
                });
            }
            log.debug("FineReporterService query folder tree result:{}", (Object)JSONObject.toJSONString((Object)parentList));
            return parentList;
        }
        return null;
    }

    public boolean isExistChild(Long parentFolderId, int folderType) {
        return this.exists((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"obj_type", (Object)folderType)).eq((Object)"parent_folder_id", (Object)parentFolderId));
    }

    public List<FolderLevelVo> qryCurrentAndParentFolderList(int type, long folderId) {
        return ((FolderMapper)this.baseMapper).qryCurrentAndParentFolderList(type, folderId);
    }

    public boolean exists(Wrapper<Folder> queryWrapper) {
        Long count = ((FolderMapper)this.baseMapper).selectCount(queryWrapper);
        return null != count && count > 0L;
    }
}

