/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.device;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.context.i18n.LocaleContextHolder;

public class DeviceBindDataWriteHandler
implements SheetWriteHandler {
    private static final String CN_MSG = "\u8bf4\u660e\uff1a\n1\u3001\u6240\u6709\u5b57\u6bb5\u90fd\u5fc5\u987b\u586b\u5199\n2\u3001\u8bbe\u5907\u7ec8\u7aef\u7c7b\u578b\u9009\u62e9\u201cPC\uff0cAPP\u201d\u4e8c\u8005\u4e4b\u4e00\u7684\u503c\n3\u3001\u5bfc\u5165\u7684\u6570\u636e\u90fd\u4e3a\u542f\u7528\u6570\u636e";
    private static final String TW_MSG = "\u8aaa\u660e\uff1a\n1\u3001\u6240\u6709\u6b04\u4f4d\u90fd\u5fc5\u9808\u586b\u5beb\n2\u3001\u8a2d\u5099\u7d42\u7aef\u985e\u578b\u9078\u64c7\u300cPC\uff0cAPP\u300d\u4e8c\u8005\u4e4b\u4e00\u7684\u503c\n3\u3001\u532f\u5165\u7684\u8cc7\u6599\u90fd\u70ba\u555f\u7528\u8cc7\u6599";
    private static final String EN_MSG = "Instructions: \n1. All fields must be filled in\n2. For the device terminal type, select one of the values: \"PC, APP\"\n3. All imported data are enabled data";

    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        Workbook workbook = writeWorkbookHolder.getWorkbook();
        Sheet sheet = workbook.getSheetAt(0);
        Locale locale = LocaleContextHolder.getLocale();
        String word = CN_MSG;
        if (Locale.TAIWAN.equals(locale)) {
            word = TW_MSG;
        } else if (Locale.ENGLISH.equals(locale)) {
            word = EN_MSG;
        }
        Row row0 = sheet.createRow(0);
        this.setRow(row0, workbook, word, (short)2000, (short)220, 0);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 3));
    }

    private void setRow(Row row, Workbook workbook, String word, short height, short fontHeight, int cellNum) {
        row.setHeight(height);
        Cell cell = row.createCell(cellNum);
        cell.setCellValue(word);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setWrapText(true);
        Font font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)11);
        font.setFontHeight(fontHeight);
        cellStyle.setFont(font);
        cell.setCellStyle(cellStyle);
    }
}

