/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.device.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.device.DeviceAuthorizeVO;
import com.digiwin.athena.semc.dto.device.DeviceBindConfigDTO;
import com.digiwin.athena.semc.dto.device.DeviceDTO;
import com.digiwin.athena.semc.entity.device.DeviceInfo;
import com.digiwin.athena.semc.entity.device.UserBindDevice;
import com.digiwin.athena.semc.mapper.device.UserBindDeviceMapper;
import com.digiwin.athena.semc.service.cache.LockClient;
import com.digiwin.athena.semc.service.device.IDeviceAuthService;
import com.digiwin.athena.semc.service.device.IDeviceBindConfigService;
import com.digiwin.athena.semc.service.device.IDeviceInfoService;
import com.digiwin.athena.semc.service.device.IUserBindDeviceService;
import com.digiwin.athena.semc.util.Utils;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeviceAuthServiceImpl
implements IDeviceAuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceAuthServiceImpl.class);
    private static final String LOCK_KEY = "try:auto:bind";
    @Resource
    private IDeviceInfoService deviceInfoService;
    @Resource
    private UserBindDeviceMapper userBindDeviceMapper;
    @Resource
    private IDeviceBindConfigService iDeviceBindConfigService;
    @Resource
    private IUserBindDeviceService iUserBindDeviceService;
    @Resource
    private LockClient lockClient;
    @Resource
    private MessageUtils messageUtils;

    public DeviceAuthorizeVO authorize(DeviceDTO device) {
        boolean existBind;
        DeviceAuthorizeVO deviceAuthorizeVO = new DeviceAuthorizeVO();
        DeviceBindConfigDTO config = this.iDeviceBindConfigService.getConfig();
        deviceAuthorizeVO.setBindConfig(config);
        if (!BooleanUtils.isTrue((Boolean)config.getBindEnabled())) {
            deviceAuthorizeVO.setDeviceAuthorize(Boolean.valueOf(true));
            return deviceAuthorizeVO;
        }
        deviceAuthorizeVO.setDeviceAuthorize(Boolean.valueOf(false));
        String userId = Utils.getUserId();
        DeviceInfo deviceInfo = this.deviceInfoService.selectByTenantIdAndDeviceId(device.getDeviceId());
        UserBindDevice userBindDevice = Objects.isNull(deviceInfo) ? null : this.userBindDeviceMapper.findByUserAndDeviceId(userId, device.getDeviceId());
        boolean bl = existBind = Objects.nonNull(userBindDevice) && userBindDevice.getStatus() == 0;
        if (existBind) {
            deviceAuthorizeVO.setDeviceAuthorize(Boolean.valueOf(true));
            deviceAuthorizeVO.setDeviceExistBinding(Boolean.valueOf(true));
            deviceAuthorizeVO.setAccountExistBinding(Boolean.valueOf(true));
            deviceAuthorizeVO.setDeviceExistStatus(Boolean.valueOf(true));
            this.deviceInfoService.updateDeviceInfo(deviceInfo.getId().longValue(), device);
            return deviceAuthorizeVO;
        }
        if (Objects.nonNull(userBindDevice)) {
            deviceAuthorizeVO.setAccountExistBinding(Boolean.valueOf(true));
            deviceAuthorizeVO.setDeviceExistStatus(Boolean.valueOf(userBindDevice.getStatus() == 0));
        } else {
            Integer counted = this.userBindDeviceMapper.countByTenantIdAndUserIdOrTerminalType(userId, device.getTerminalType());
            deviceAuthorizeVO.setAccountExistBinding(Boolean.valueOf(Objects.nonNull(counted) && counted > 0));
        }
        Integer counted1 = this.userBindDeviceMapper.countByTenantIdAndDeviceId(device.getDeviceId());
        deviceAuthorizeVO.setDeviceExistBinding(Boolean.valueOf(Objects.nonNull(counted1) && counted1 > 0));
        return deviceAuthorizeVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryAutoBind(DeviceAuthorizeVO deviceAuthorize, DeviceDTO device) {
        if (deviceAuthorize.getAccountExistBinding().booleanValue()) {
            return;
        }
        RLock lock = null;
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String key = LOCK_KEY + authoredUser.getTenantId() + ":" + authoredUser.getUserId();
        try {
            lock = this.lockClient.getLock(key);
            boolean lockResult = lock.tryLock(3L, 5L, TimeUnit.SECONDS);
            if (!lockResult) {
                deviceAuthorize.setDeviceExistBinding(Boolean.valueOf(true));
                log.error("tryAutoBind tryLock fail key:{}", (Object)key);
            } else {
                Integer counted1 = this.userBindDeviceMapper.countByTenantIdAndDeviceId(device.getDeviceId());
                boolean deviceExistBind = Objects.nonNull(counted1) && counted1 > 0;
                deviceAuthorize.setDeviceExistBinding(Boolean.valueOf(deviceExistBind));
                if (!deviceExistBind) {
                    this.iUserBindDeviceService.autoBind(device);
                    deviceAuthorize.setDeviceAuthorize(Boolean.valueOf(true));
                    deviceAuthorize.setDeviceExistBinding(Boolean.valueOf(true));
                    deviceAuthorize.setAccountExistBinding(Boolean.valueOf(true));
                }
            }
        }
        catch (InterruptedException e) {
            log.error("tryAutoBind is error key:{}", (Object)key, (Object)e);
        }
        finally {
            this.lockClient.unlock(lock);
        }
    }

    public Boolean autoBind(DeviceDTO device) {
        RLock lock = null;
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String key = LOCK_KEY + authoredUser.getTenantId() + ":" + authoredUser.getUserId();
        try {
            lock = this.lockClient.getLock(key);
            boolean lockResult = lock.tryLock(3L, 5L, TimeUnit.SECONDS);
            if (!lockResult) {
                log.error("autoBind tryLock fail key:{}", (Object)key);
                Boolean bl = false;
                return bl;
            }
            DeviceBindConfigDTO config = this.iDeviceBindConfigService.getConfig();
            if (BooleanUtils.isTrue((Boolean)config.getBindEnabled()) && BooleanUtils.isTrue((Boolean)config.getBindDeviceStatus())) {
                Integer counted = this.userBindDeviceMapper.countByTenantIdAndUserIdOrTerminalType(Utils.getUserId(), device.getTerminalType());
                if (Objects.nonNull(counted) && counted > 0) {
                    log.error("autoBind fail Account Exist Binding key:{}", (Object)key);
                    Boolean bl = false;
                    return bl;
                }
                this.iUserBindDeviceService.autoBind(device);
                Boolean bl = true;
                return bl;
            }
            log.error("autoBind fail DeviceBindConfig Not Supported key:{}", (Object)key);
            Boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            log.error("autoBind fail InterruptedException key:{}", (Object)key, (Object)e);
            throw BizException.getDefaultBizException((Integer)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("system.exception.api.fail"));
        }
        finally {
            this.lockClient.unlock(lock);
        }
    }
}

