/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.device.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.dto.config.TenantAttributeDto;
import com.digiwin.athena.semc.dto.device.DeviceBindConfigDTO;
import com.digiwin.athena.semc.dto.mq.MessageDO;
import com.digiwin.athena.semc.service.device.IDeviceBindConfigService;
import com.digiwin.athena.semc.service.mq.MessageSendService;
import com.digiwin.athena.semc.service.tenant.TenantAttributeService;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Service;

@Service
public class DeviceBindConfigServiceImpl
implements IDeviceBindConfigService {
    private static final String BIND_DEVICE_CODE = "bind_device_code";
    @Resource
    private MessageSendService messageSendService;
    @Resource
    private TenantAttributeService tenantAttributeService;

    public DeviceBindConfigDTO getConfig() {
        DeviceBindConfigDTO deviceBindConfigDTO = new DeviceBindConfigDTO();
        deviceBindConfigDTO.setBindEnabled(Boolean.valueOf(false));
        deviceBindConfigDTO.setBindDeviceStatus(Boolean.valueOf(false));
        TenantAttributeDto deviceBindConfig = this.tenantAttributeService.queryTenantAttributeByCode(BIND_DEVICE_CODE);
        if (Objects.nonNull(deviceBindConfig) && Objects.nonNull(deviceBindConfig.getAttributeValue())) {
            String configCode = (String)deviceBindConfig.getAttributeValue();
            if ("enable".equals(configCode)) {
                deviceBindConfigDTO.setBindEnabled(Boolean.valueOf(true));
                deviceBindConfigDTO.setBindDeviceStatus(Boolean.valueOf(false));
            } else if ("enableAutoBind".equals(configCode)) {
                deviceBindConfigDTO.setBindEnabled(Boolean.valueOf(true));
                deviceBindConfigDTO.setBindDeviceStatus(Boolean.valueOf(true));
            } else {
                deviceBindConfigDTO.setBindEnabled(Boolean.valueOf(false));
                deviceBindConfigDTO.setBindDeviceStatus(Boolean.valueOf(false));
            }
        }
        return deviceBindConfigDTO;
    }

    public Boolean saveConfig(DeviceBindConfigDTO config) {
        TenantAttributeDto deviceBindConfig = this.tenantAttributeService.queryTenantAttributeByCode(BIND_DEVICE_CODE);
        String oldConfigCode = "notActivated";
        if (Objects.nonNull(deviceBindConfig) && Objects.nonNull(deviceBindConfig.getAttributeValue())) {
            oldConfigCode = (String)deviceBindConfig.getAttributeValue();
        }
        String configCode = "notActivated";
        if (BooleanUtils.isTrue((Boolean)config.getBindEnabled())) {
            configCode = BooleanUtils.isTrue((Boolean)config.getBindDeviceStatus()) ? "enableAutoBind" : "enable";
        }
        deviceBindConfig.setAttributeValue((Object)configCode);
        this.tenantAttributeService.updateAttributeValue(deviceBindConfig);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        MessageDO payload = new MessageDO();
        payload.setTenantId(authoredUser.getTenantId());
        payload.setType(Integer.valueOf(3));
        this.messageSendService.sendToClient(authoredUser.getUserId(), payload, authoredUser.getTenantId() + "/" + "USER_DEVICE_CONFIG_CHANGE");
        return true;
    }
}

