/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.device.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.dto.device.DeviceBindSaveDTO;
import com.digiwin.athena.semc.dto.device.DeviceDTO;
import com.digiwin.athena.semc.entity.device.DeviceInfo;
import com.digiwin.athena.semc.mapper.device.DeviceInfoMapper;
import com.digiwin.athena.semc.service.device.IDeviceInfoService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import org.springframework.stereotype.Service;

@Service
public class DeviceInfoServiceImpl
extends ServiceImpl<DeviceInfoMapper, DeviceInfo>
implements IDeviceInfoService {
    public DeviceInfo selectByTenantIdAndDeviceId(String deviceId) {
        return ((DeviceInfoMapper)this.baseMapper).selectByTenantIdAndDeviceId(deviceId);
    }

    public void updateDeviceInfo(long id, DeviceDTO device) {
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setId(Long.valueOf(id));
        deviceInfo.setDeviceName(device.getDeviceName());
        deviceInfo.setDeviceModel(device.getDeviceModel());
        deviceInfo.setHardwareUuid(device.getHardwareUuid());
        deviceInfo.setOsType(device.getOsType());
        deviceInfo.setTerminalType(device.getTerminalType());
        deviceInfo.setMacAddress(device.getMacAddress());
        deviceInfo.setModifyTime(DateUtils.getNowTime((String)""));
        deviceInfo.setModifyUserId(Utils.getUserId());
        this.updateById((Object)deviceInfo);
    }

    public DeviceInfo save(DeviceDTO device) {
        String userId = Utils.getUserId();
        String tenantId = Utils.getTenantId();
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setDeviceId(device.getDeviceId());
        deviceInfo.setDeviceName(device.getDeviceName());
        deviceInfo.setDeviceModel(device.getDeviceModel());
        deviceInfo.setTerminalType(device.getTerminalType());
        deviceInfo.setMacAddress(device.getMacAddress());
        deviceInfo.setOsType(device.getOsType());
        deviceInfo.setSource(Integer.valueOf(1));
        deviceInfo.setHardwareUuid(device.getHardwareUuid());
        deviceInfo.setCreateTime(DateUtils.getNowTime());
        deviceInfo.setCreateUserId(userId);
        deviceInfo.setModifyUserId(userId);
        deviceInfo.setTenantId(tenantId);
        this.save((Object)deviceInfo);
        return deviceInfo;
    }

    public DeviceInfo save(DeviceBindSaveDTO device) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setDeviceId(device.getDeviceId());
        deviceInfo.setTerminalType(device.getTerminalType());
        deviceInfo.setOsType("Other");
        deviceInfo.setSource(Integer.valueOf(0));
        deviceInfo.setTenantId(authoredUser.getTenantId());
        deviceInfo.setCreateUserId(authoredUser.getUserId());
        deviceInfo.setCreateTime(DateUtils.getNowTime());
        this.save((Object)deviceInfo);
        return deviceInfo;
    }

    public void updateDeviceTerminalType(long id, int terminalType) {
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setId(Long.valueOf(id));
        deviceInfo.setTerminalType(Integer.valueOf(terminalType));
        deviceInfo.setModifyTime(DateUtils.getNowTime((String)""));
        deviceInfo.setModifyUserId(Utils.getUserId());
        this.updateById((Object)deviceInfo);
    }
}

