/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.device.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.SyncReadListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.enums.FolderTypeEnum;
import com.digiwin.athena.semc.dto.device.DeviceBindConfigDTO;
import com.digiwin.athena.semc.dto.device.DeviceBindImportDTO;
import com.digiwin.athena.semc.dto.device.DeviceBindImportTemplateVo;
import com.digiwin.athena.semc.entity.common.ImportRecord;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.RoleDTO;
import com.digiwin.athena.semc.proxy.mdc.MdcService;
import com.digiwin.athena.semc.service.device.DeviceBindDataWriteHandler;
import com.digiwin.athena.semc.service.device.IDeviceBindConfigService;
import com.digiwin.athena.semc.service.device.IUserBindDeviceFileService;
import com.digiwin.athena.semc.service.device.IUserBindDeviceService;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.service.utils.ValidationMsgUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserBindDeviceFileServiceImpl
implements IUserBindDeviceFileService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserBindDeviceFileServiceImpl.class);
    @Resource
    private IamService iamService;
    @Resource
    private MdcService mdcService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private IDeviceBindConfigService iDeviceBindConfigService;
    @Resource
    private IImportRecordService importRecordService;
    @Resource
    private IUserBindDeviceService iUserBindDeviceService;

    public ImportExcelResp importRecords(DeviceBindImportDTO req) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        DeviceBindConfigDTO config = this.iDeviceBindConfigService.getConfig();
        Assert.isTrue((boolean)config.getBindEnabled(), () -> BizException.getDefaultBizException((Integer)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.user.device.config.empty")));
        List deviceBindVos = this.parse(req.getFileId());
        int successNum = 0;
        int failNum = 0;
        if (CollUtil.isNotEmpty((Collection)deviceBindVos)) {
            for (int i = 0; i < deviceBindVos.size(); ++i) {
                DeviceBindImportTemplateVo deviceBindVo = (DeviceBindImportTemplateVo)deviceBindVos.get(i);
                try {
                    if (StrUtil.isBlank((CharSequence)deviceBindVo.getFailMsg())) {
                        this.iUserBindDeviceService.importDeviceBind(deviceBindVo, authoredUser);
                        ++successNum;
                        continue;
                    }
                    ++failNum;
                    continue;
                }
                catch (Exception e) {
                    log.error("user.device.import error,deviceBindVo:{}", (Object)JSONUtil.toJsonStr((Object)deviceBindVo), (Object)e);
                    deviceBindVo.setFailMsg(e.getMessage());
                    ++failNum;
                }
            }
        }
        File file = new File("\u8bbe\u5907\u5bfc\u5165\u6a21\u677f_\u9519\u8bef\u65e5\u5fd7.xlsx");
        ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((File)file, DeviceBindImportTemplateVo.class).relativeHeadRowIndex(Integer.valueOf(1))).registerWriteHandler((WriteHandler)Utils.initHorizontalCell())).registerWriteHandler((WriteHandler)new DeviceBindDataWriteHandler())).sheet("\u8bbe\u5907\u5bfc\u5165").doWrite((Collection)deviceBindVos);
        ShareInfo shareInfo = this.importRecordService.uploadExcel(file);
        ImportRecord importRecord = new ImportRecord();
        importRecord.setFileId(req.getFileId());
        importRecord.setFileName(StrUtil.isNotBlank((CharSequence)req.getFileName()) ? req.getFileName() : shareInfo.getFileName());
        importRecord.setSuccessCount(Integer.valueOf(successNum));
        importRecord.setFailCount(Integer.valueOf(failNum));
        importRecord.setObjType(FolderTypeEnum.DEVICE_REPORT.getValue());
        importRecord.setTenantId(authoredUser.getTenantId());
        importRecord.setCreateUserId(authoredUser.getUserId());
        importRecord.setCreateUserName(authoredUser.getUserName());
        importRecord.setFailFileId(shareInfo.getFileId());
        importRecord.setFailFileName(shareInfo.getFileName());
        importRecord.setFailFileUrl(shareInfo.getUrl());
        this.importRecordService.insertImportRecord(importRecord);
        ImportExcelResp importExcelResp = new ImportExcelResp();
        importExcelResp.setSuccessCount(Integer.valueOf(successNum));
        importExcelResp.setFailCount(Integer.valueOf(failNum));
        importExcelResp.setFailFileId(shareInfo.getFileId());
        importExcelResp.setFailFileName(shareInfo.getFileName());
        importExcelResp.setFailFileUrl(shareInfo.getUrl());
        return importExcelResp;
    }

    private List<DeviceBindImportTemplateVo> parse(String fileId) {
        List excelVoList;
        DMC dmcInstance = this.mdcService.buildDmc();
        try {
            byte[] byteArray = dmcInstance.download(fileId);
            ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
            SyncReadListener excelListener = new SyncReadListener();
            ExcelReader excelReader = EasyExcelFactory.read((InputStream)input).build();
            excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)0).head(DeviceBindImportTemplateVo.class)).headRowNumber(Integer.valueOf(2))).registerReadListener((ReadListener)excelListener)).build()});
            excelReader.finish();
            excelVoList = this.mdcService.doReadSync(excelListener);
            this.validateDeviceBindings(excelVoList);
        }
        catch (Exception e) {
            log.error("userBindDevice read excel occur error", (Throwable)e);
            return new ArrayList<DeviceBindImportTemplateVo>();
        }
        return excelVoList;
    }

    private void validateDeviceBindings(List<DeviceBindImportTemplateVo> deviceBindImportTemplateVos) {
        if (CollUtil.isNotEmpty(deviceBindImportTemplateVos)) {
            List roleDTOS = this.iamService.queryAllUserList();
            Map<String, String> userIdNameMap = CollUtil.emptyIfNull((List)roleDTOS).stream().collect(Collectors.toMap(RoleDTO::getId, RoleDTO::getName));
            for (int i = 0; i < deviceBindImportTemplateVos.size(); ++i) {
                DeviceBindImportTemplateVo deviceBindVo = deviceBindImportTemplateVos.get(i).trim();
                BaseResultDTO validated = ValidationMsgUtil.validateAll((Object)deviceBindVo, (String)",");
                if (!validated.isOK()) {
                    deviceBindVo.setFailMsg(StrUtil.toString((Object)validated.getErrorMessage()));
                    continue;
                }
                String userId = deviceBindVo.getUserId();
                if (userIdNameMap.containsKey(userId)) {
                    deviceBindVo.setUserName(userIdNameMap.get(userId));
                    continue;
                }
                deviceBindVo.setFailMsg(ValidationMsgUtil.getMessage((String)"{Athena.Account}{Not.exist}", (Pair[])new Pair[0]));
            }
        }
    }
}

