/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.device.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.device.DeviceBindConfigDTO;
import com.digiwin.athena.semc.dto.device.DeviceBindExportQueryDTO;
import com.digiwin.athena.semc.dto.device.DeviceBindExportVO;
import com.digiwin.athena.semc.dto.device.DeviceBindImportTemplateVo;
import com.digiwin.athena.semc.dto.device.DeviceBindQueryDTO;
import com.digiwin.athena.semc.dto.device.DeviceBindRecordVO;
import com.digiwin.athena.semc.dto.device.DeviceBindSaveDTO;
import com.digiwin.athena.semc.dto.device.DeviceBindUpdateDTO;
import com.digiwin.athena.semc.dto.device.DeviceBindUpdateStatusDTO;
import com.digiwin.athena.semc.dto.device.DeviceDTO;
import com.digiwin.athena.semc.dto.mq.MessageDO;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.device.DeviceInfo;
import com.digiwin.athena.semc.entity.device.UserBindDevice;
import com.digiwin.athena.semc.mapper.device.UserBindDeviceMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.UserInfoDTO;
import com.digiwin.athena.semc.service.cache.LockClient;
import com.digiwin.athena.semc.service.device.IDeviceBindConfigService;
import com.digiwin.athena.semc.service.device.IDeviceInfoService;
import com.digiwin.athena.semc.service.device.IUserBindDeviceService;
import com.digiwin.athena.semc.service.mq.MessageSendService;
import com.digiwin.athena.semc.service.utils.ValidationMsgUtil;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserBindDeviceServiceImpl
extends ServiceImpl<UserBindDeviceMapper, UserBindDevice>
implements IUserBindDeviceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserBindDeviceServiceImpl.class);
    @Autowired
    private MessageUtils messageUtils;
    @Resource
    private LockClient lockClient;
    @Resource
    private IDeviceInfoService iDeviceInfoService;
    @Resource
    private IDeviceBindConfigService iDeviceBindConfigService;
    @Resource
    private MessageSendService messageSendService;
    @Resource
    private IamService iamService;
    private static final String LOCK_KEY = "try:auto:device_bind_update";

    public PageInfoResp<DeviceBindRecordVO> list(DeviceBindQueryDTO request) {
        Page page = new Page((long)request.getPageNum().intValue(), (long)request.getPageSize().intValue());
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        IPage deviceBindRecordVOIPage = ((UserBindDeviceMapper)this.baseMapper).selectDeviceBindPage(page, request, tenantId);
        PageInfoResp pageInfoResp = new PageInfoResp();
        pageInfoResp.setList(deviceBindRecordVOIPage.getRecords());
        pageInfoResp.setTotalRecords((int)deviceBindRecordVOIPage.getTotal());
        pageInfoResp.setTotalPages((int)deviceBindRecordVOIPage.getPages());
        return pageInfoResp;
    }

    @Transactional
    public DeviceBindRecordVO save(DeviceBindSaveDTO record) {
        DeviceBindConfigDTO config = this.iDeviceBindConfigService.getConfig();
        Assert.isTrue((boolean)config.getBindEnabled(), () -> BizException.getDefaultBizException((Integer)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.user.device.config.empty")));
        record.setUserName(this.getUserNameAndCheck(record.getUserId()));
        DeviceBindRecordVO deviceBindRecordVO = this.saveAction(record, AppAuthContextHolder.getContext().getAuthoredUser());
        this.sendMqtt(deviceBindRecordVO.getTenantId(), deviceBindRecordVO.getUserId());
        return deviceBindRecordVO;
    }

    private DeviceBindRecordVO saveAction(DeviceBindSaveDTO record, AuthoredUser authoredUser) {
        Integer existBind = ((UserBindDeviceMapper)this.baseMapper).countByUserIdAndDeviceId(record.getUserId(), record.getDeviceId());
        Assert.isFalse((existBind > 0 ? 1 : 0) != 0, () -> BizException.getDefaultBizException((Integer)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.already.exists")));
        DeviceInfo deviceInfo = this.iDeviceInfoService.selectByTenantIdAndDeviceId(record.getDeviceId());
        if (Objects.isNull(deviceInfo)) {
            deviceInfo = this.iDeviceInfoService.save(record);
        } else {
            deviceInfo.setTerminalType(record.getTerminalType());
            this.iDeviceInfoService.updateDeviceTerminalType(deviceInfo.getId().longValue(), record.getTerminalType().intValue());
        }
        UserBindDevice newUserBindDevice = new UserBindDevice();
        newUserBindDevice.setDeviceId(deviceInfo.getDeviceId());
        newUserBindDevice.setTenantId(authoredUser.getTenantId());
        newUserBindDevice.setUserId(record.getUserId());
        newUserBindDevice.setUserName(record.getUserName());
        newUserBindDevice.setStatus(record.getStatus());
        newUserBindDevice.setCreateUserId(authoredUser.getUserId());
        newUserBindDevice.setCreateUserName(authoredUser.getUserName());
        newUserBindDevice.setCreateTime(DateUtils.getNowTime());
        newUserBindDevice.setModifyUserId(authoredUser.getUserId());
        newUserBindDevice.setModifyUserName(authoredUser.getUserName());
        newUserBindDevice.setModifyTime(DateUtils.getNowTime());
        ((UserBindDeviceMapper)this.baseMapper).insert((Object)newUserBindDevice);
        return DeviceBindRecordVO.build((UserBindDevice)newUserBindDevice, (DeviceInfo)deviceInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public DeviceBindRecordVO update(DeviceBindUpdateDTO update) {
        block11: {
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            update.setUserName(this.getUserNameAndCheck(update.getUserId()));
            DeviceBindConfigDTO config = this.iDeviceBindConfigService.getConfig();
            Assert.isTrue((boolean)config.getBindEnabled(), () -> BizException.getDefaultBizException((Integer)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.user.device.config.empty")));
            UserBindDevice userBindDevice = (UserBindDevice)((UserBindDeviceMapper)this.baseMapper).selectById((Serializable)update.getId());
            Assert.notNull((Object)userBindDevice, () -> BizException.getDefaultBizException((Integer)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.not.exists")));
            String key = LOCK_KEY + userBindDevice.getId();
            RLock lock = null;
            try {
                DeviceInfo deviceInfo;
                lock = this.lockClient.getLock(key);
                boolean lockResult = lock.tryLock(3L, 5L, TimeUnit.SECONDS);
                if (!lockResult) {
                    log.error("tryAutoBind tryLock fail key:{}", (Object)key);
                    break block11;
                }
                if (!userBindDevice.getUserId().equals(update.getUserId()) || !userBindDevice.getDeviceId().equals(update.getDeviceId())) {
                    Integer existBind = ((UserBindDeviceMapper)this.baseMapper).countByUserIdAndDeviceId(update.getUserId(), update.getDeviceId());
                    Assert.isFalse((existBind > 0 ? 1 : 0) != 0, () -> BizException.getDefaultBizException((Integer)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.already.exists")));
                }
                if (Objects.isNull(deviceInfo = this.iDeviceInfoService.selectByTenantIdAndDeviceId(update.getDeviceId()))) {
                    deviceInfo = this.iDeviceInfoService.save((DeviceBindSaveDTO)update);
                } else if (!update.getTerminalType().equals(deviceInfo.getTerminalType())) {
                    deviceInfo.setTerminalType(update.getTerminalType());
                    this.iDeviceInfoService.updateDeviceTerminalType(deviceInfo.getId().longValue(), update.getTerminalType().intValue());
                }
                UserBindDevice newUserBindDevice = new UserBindDevice();
                newUserBindDevice.setId(update.getId());
                newUserBindDevice.setDeviceId(update.getDeviceId());
                newUserBindDevice.setUserId(update.getUserId());
                newUserBindDevice.setStatus(update.getStatus());
                newUserBindDevice.setUserName(update.getUserName());
                newUserBindDevice.setModifyUserId(authoredUser.getUserId());
                newUserBindDevice.setModifyUserName(authoredUser.getUserName());
                newUserBindDevice.setModifyTime(DateUtils.getNowTime());
                ((UserBindDeviceMapper)this.baseMapper).updateById((Object)newUserBindDevice);
                if (!userBindDevice.getUserId().equals(newUserBindDevice.getUserId())) {
                    this.sendMqtt(userBindDevice.getTenantId(), userBindDevice.getUserId());
                }
                this.sendMqtt(userBindDevice.getTenantId(), update.getUserId());
                DeviceBindRecordVO deviceBindRecordVO = DeviceBindRecordVO.build((UserBindDevice)newUserBindDevice, (DeviceInfo)deviceInfo);
                return deviceBindRecordVO;
            }
            catch (InterruptedException e) {
                log.error("tryAutoBind is error key:{}", (Object)key, (Object)e);
            }
            finally {
                this.lockClient.unlock(lock);
            }
        }
        return null;
    }

    private String getUserNameAndCheck(String userId) {
        try {
            UserInfoDTO user = this.iamService.queryUser(userId, null, Utils.getUserToken());
            if (Objects.isNull(user) || StringUtils.isBlank((CharSequence)user.getId())) {
                String key = ValidationMsgUtil.buildKeys((String[])new String[]{"Athena.Account", "Not.exist"});
                throw BizException.getDefaultBizException((Integer)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)ValidationMsgUtil.getMessage((String)key, (Pair[])new Pair[0]));
            }
            return user.getName();
        }
        catch (BizException e) {
            log.error("getUserNameAndCheck BizException userId:{}", (Object)userId, (Object)e);
            throw e;
        }
        catch (Exception e) {
            log.error("getUserNameAndCheck is error userId:{}", (Object)userId, (Object)e);
            throw BizException.getDefaultBizException((Integer)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)ValidationMsgUtil.getMessage((String)ValidationMsgUtil.buildKeys((String[])new String[]{"Athena.Account", "Not.exist"}), (Pair[])new Pair[0]));
        }
    }

    public Boolean updateValidStatus(DeviceBindUpdateStatusDTO update) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        DeviceBindConfigDTO config = this.iDeviceBindConfigService.getConfig();
        Assert.isTrue((boolean)config.getBindEnabled(), () -> BizException.getDefaultBizException((Integer)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.user.device.config.empty")));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(UserBindDevice::getId, (Object)update.getId())).set(UserBindDevice::getStatus, (Object)update.getStatus())).set(BaseEntity::getModifyUserId, (Object)authoredUser.getUserId())).set(UserBindDevice::getModifyUserName, (Object)authoredUser.getUserName())).set(BaseEntity::getModifyTime, (Object)DateUtils.getNowTime());
        this.update((Wrapper)updateWrapper);
        UserBindDevice userBindDevice = (UserBindDevice)((UserBindDeviceMapper)this.baseMapper).selectById((Serializable)update.getId());
        if (Objects.nonNull(userBindDevice)) {
            this.sendMqtt(userBindDevice.getTenantId(), userBindDevice.getUserId());
        }
        return Boolean.TRUE;
    }

    public Boolean delete(List<Long> ids) {
        List deviceBindRecordVOS = ((UserBindDeviceMapper)this.baseMapper).selectByIds(ids);
        if (CollUtil.isNotEmpty((Collection)deviceBindRecordVOS)) {
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            ((UserBindDeviceMapper)this.baseMapper).deleteBatchByIds(ids, authoredUser.getUserId());
            deviceBindRecordVOS.forEach(user -> this.sendMqtt(user.getTenantId(), user.getUserId()));
        }
        return Boolean.TRUE;
    }

    private void sendMqtt(String tenantId, String userId) {
        MessageDO payload = new MessageDO();
        payload.setTenantId(tenantId);
        payload.setType(Integer.valueOf(3));
        String topicSuffix = tenantId + "/" + userId + "/" + "USER_DEVICE_STATUS_CHANGE";
        this.messageSendService.sendToClient(userId, payload, topicSuffix);
    }

    @Transactional
    public void importDeviceBind(DeviceBindImportTemplateVo deviceBindVo, AuthoredUser authoredUser) {
        DeviceBindSaveDTO deviceBindSave = new DeviceBindSaveDTO();
        deviceBindSave.setUserId(deviceBindVo.getUserId());
        deviceBindSave.setUserName(deviceBindVo.getUserName());
        deviceBindSave.setDeviceId(deviceBindVo.getDeviceId());
        deviceBindSave.setStatus(Integer.valueOf(0));
        deviceBindSave.setTerminalType(Constants.TerminalTypeEnum.getTypeByCode((String)deviceBindVo.getTerminalType()));
        this.saveAction(deviceBindSave, authoredUser);
    }

    public List<DeviceBindExportVO> exportReport(DeviceBindExportQueryDTO req) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List deviceBindRecords = ((UserBindDeviceMapper)this.baseMapper).selectExportList(req, tenantId);
        if (CollectionUtils.isNotEmpty((Collection)deviceBindRecords)) {
            return deviceBindRecords.stream().map(DeviceBindExportVO::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<DeviceBindRecordVO> queryUserDevice() {
        if (!this.getBindEnabled()) {
            return Collections.emptyList();
        }
        return ((UserBindDeviceMapper)this.baseMapper).selectDeviceByUserOrDevice(Utils.getUserId(), null, null);
    }

    private boolean getBindEnabled() {
        DeviceBindConfigDTO config = this.iDeviceBindConfigService.getConfig();
        return BooleanUtils.isTrue((Boolean)config.getBindEnabled());
    }

    @Transactional
    public void autoBind(DeviceDTO device) {
        DeviceInfo deviceInfo = this.iDeviceInfoService.selectByTenantIdAndDeviceId(device.getDeviceId());
        if (Objects.isNull(deviceInfo)) {
            deviceInfo = this.iDeviceInfoService.save(device);
        } else {
            this.iDeviceInfoService.updateDeviceInfo(deviceInfo.getId().longValue(), device);
        }
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (Objects.isNull(authoredUser)) {
            authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        }
        String nowTime = DateUtils.getNowTime();
        UserBindDevice newUserBindDevice = new UserBindDevice();
        newUserBindDevice.setDeviceId(deviceInfo.getDeviceId());
        newUserBindDevice.setTenantId(authoredUser.getTenantId());
        newUserBindDevice.setUserId(authoredUser.getUserId());
        newUserBindDevice.setUserName(authoredUser.getUserName());
        newUserBindDevice.setStatus(Integer.valueOf(0));
        newUserBindDevice.setCreateUserId(authoredUser.getUserId());
        newUserBindDevice.setCreateUserName(authoredUser.getUserName());
        newUserBindDevice.setCreateTime(nowTime);
        newUserBindDevice.setModifyUserId(authoredUser.getUserId());
        newUserBindDevice.setModifyUserName(authoredUser.getUserName());
        newUserBindDevice.setModifyTime(nowTime);
        ((UserBindDeviceMapper)this.baseMapper).insert((Object)newUserBindDevice);
    }
}

