/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.eai.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.DigiSrvcode;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.dto.message.ReceiveThirdMessageReq;
import com.digiwin.athena.semc.dto.news.ThirdNewsAnnouncementReq;
import com.digiwin.athena.semc.dto.portal.JobSyncReq;
import com.digiwin.athena.semc.dto.portal.TodoFieldDto;
import com.digiwin.athena.semc.dto.portal.TodoListDto;
import com.digiwin.athena.semc.dto.portal.TodoReceiveDto;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.bench.ThirdJobConfig;
import com.digiwin.athena.semc.entity.message.ThirdMessageConfig;
import com.digiwin.athena.semc.entity.message.ThirdMessageInfo;
import com.digiwin.athena.semc.entity.portal.SyncToDoRecord;
import com.digiwin.athena.semc.entity.portal.ThirdTodoConfig;
import com.digiwin.athena.semc.entity.portal.TodoList;
import com.digiwin.athena.semc.entity.portal.TodoRead;
import com.digiwin.athena.semc.mapper.bench.ThirdJobConfigMapper;
import com.digiwin.athena.semc.mapper.portal.SyncToDoRecordMapper;
import com.digiwin.athena.semc.mapper.portal.ThirdTodoConfigMapper;
import com.digiwin.athena.semc.service.bench.SyncJobInfoService;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.eai.EaiService;
import com.digiwin.athena.semc.service.message.ThirdSystemMessageService;
import com.digiwin.athena.semc.service.news.ThirdNewsAnnouncementService;
import com.digiwin.athena.semc.service.portal.TodoListService;
import com.digiwin.athena.semc.service.portal.TodoReadService;
import com.digiwin.athena.semc.service.portal.impl.TodoNoticeMq;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.vo.portal.NoticeVO;
import com.google.common.collect.Maps;
import io.vavr.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class EAIServiceImpl
implements EaiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EAIServiceImpl.class);
    @Resource
    private ThirdSystemMessageService thirdSystemMessageService;
    @Resource
    private SyncJobInfoService syncJobInfoService;
    @Resource
    private TodoListService todoListService;
    @Resource
    private TodoReadService todoReadService;
    @Resource
    private TodoNoticeMq todoNoticeMq;
    @Autowired
    private SyncToDoRecordMapper syncToDoRecordMapper;
    @Autowired
    private ThirdNewsAnnouncementService thirdNewsAnnouncementService;
    @Autowired
    private ThirdTodoConfigMapper thirdTodoConfigMapper;
    @Autowired
    private ThirdJobConfigMapper thirdJobConfigMapper;

    @EAIService(id="third.news.push")
    public DWEAIResult receiveThirdNews(JSONObject jsonObject) throws Exception {
        log.info("invoke esp semc service third.news.push, param:{}", (Object)jsonObject);
        HashMap parameterResult = Maps.newHashMap();
        try {
            JSONObject std_data = jsonObject.getJSONObject("std_data");
            JSONObject parameter = std_data.getJSONObject("parameter");
            String appCode = parameter.getString("appCode");
            String appId = parameter.getString("appId");
            Tuple3 tuple3 = this.thirdNewsAnnouncementService.checkAppCode(appId, appCode);
            String error = (String)tuple3._1;
            String tenantId = (String)tuple3._2;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)error) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tenantId)) {
                throw new Exception(error);
            }
            JSONArray jsonArray = parameter.getJSONArray("thirdNewsAnnouncementReqs");
            List newsInfoList = JSONArray.parseArray((String)jsonArray.toJSONString(), ThirdNewsAnnouncementReq.class);
            String errorMsg = this.thirdNewsAnnouncementService.checkNewsIsValid(newsInfoList);
            if (StringUtils.hasText((String)errorMsg)) {
                throw new Exception(errorMsg);
            }
            this.thirdNewsAnnouncementService.saveNewsList(newsInfoList, appId, appCode, tenantId, (ApplicationTypeEnum)tuple3._3);
        }
        catch (Exception e) {
            log.error("invoke esp semc service third.news.push error. param:{}", (Object)jsonObject, (Object)e);
            throw new Exception("invoke esp semc service third.news.push error, msg:" + e.getMessage());
        }
        parameterResult.put("response", true);
        return new DWEAIResult(DigiSrvcode.SUCCESS.getCode(), "0", "", (Map)parameterResult);
    }

    @EAIService(id="third.message.push")
    public DWEAIResult receiveThirdMessage(JSONObject jsonObject) throws Exception {
        log.info("invoke esp semc service third.message.push, param:{}", (Object)jsonObject);
        HashMap parameterResult = Maps.newHashMap();
        try {
            JSONObject std_data = jsonObject.getJSONObject("std_data");
            JSONObject parameter = std_data.getJSONObject("parameter");
            String appCode = parameter.getString("app_code");
            String appId = parameter.getString("app_id");
            List thirdMessageConfigList = this.thirdSystemMessageService.queryConfigByAppCode(appCode, appId);
            if (CollectionUtils.isEmpty((Collection)thirdMessageConfigList)) {
                throw new Exception("\u5f53\u524d\u5e94\u7528\u4e0d\u5728\u914d\u7f6e\u4e2d\uff0c\u65e0\u6743\u63a8\u9001\u6d88\u606f");
            }
            List filteredList = thirdMessageConfigList.stream().filter(x -> Constants.VALID_STATUS_ENABLE.equals(x.getValidStatus())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(filteredList)) {
                throw new Exception("\u5f53\u524d\u5e94\u7528\u672a\u542f\u7528\uff0c\u65e0\u6743\u63a8\u9001\u6d88\u606f");
            }
            JSONArray jsonArray = parameter.getJSONArray("message_list");
            List messageInfoList = JSONArray.parseArray((String)jsonArray.toJSONString(), ThirdMessageInfo.class);
            for (ThirdMessageInfo info : messageInfoList) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)info.getMessageId())) {
                    throw new Exception("\u6d88\u606fid\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)info.getMessagePublishTime())) {
                    throw new Exception("\u6d88\u606f\u53d1\u5e03\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!DateUtils.validateDate((String)info.getMessagePublishTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
                    throw new Exception("\u6d88\u606f\u53d1\u5e03\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)info.getMessageTitle()) || !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)info.getMessageContent())) continue;
                throw new Exception("\u6d88\u606f\u6807\u9898\u548c\u6d88\u606f\u5185\u5bb9\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            ReceiveThirdMessageReq receiveThirdMessageReq = new ReceiveThirdMessageReq();
            receiveThirdMessageReq.setAppCode(appCode);
            receiveThirdMessageReq.setAppId(appId);
            receiveThirdMessageReq.setMessageList(messageInfoList);
            String sendChannel = ((ThirdMessageConfig)filteredList.get(0)).getSendChannel();
            receiveThirdMessageReq.setSendChannel(sendChannel);
            this.thirdSystemMessageService.receiveMessage(receiveThirdMessageReq);
        }
        catch (Exception e) {
            log.error("invoke esp semc service third.message.push error. param:{}", (Object)jsonObject, (Object)e);
            throw new Exception("invoke esp semc service third.message.push error, msg:" + e.getMessage());
        }
        parameterResult.put("response", true);
        return new DWEAIResult(DigiSrvcode.SUCCESS.getCode(), "0", "", (Map)parameterResult);
    }

    @EAIService(id="third.job.push")
    public DWEAIResult receiveThirdJob(JSONObject jsonObject) throws Exception {
        ThirdJobConfig thirdJobConfig;
        log.info("third.job.push  param:{}", (Object)JSON.toJSONString((Object)jsonObject));
        HashMap parameterResult = Maps.newHashMap();
        JobSyncReq req = new JobSyncReq();
        JSONObject std_data = jsonObject.getJSONObject("std_data");
        JSONObject parameter = std_data.getJSONObject("parameter");
        String appId = parameter.getString("appId");
        Integer syncType = parameter.getInteger("syncType");
        Integer syncModel = parameter.getInteger("syncModel");
        JSONArray jsonArrayJob = parameter.getJSONArray("jobList");
        req.setAppId(appId);
        req.setSyncType(syncType);
        if (null == syncModel) {
            syncModel = 0;
        }
        if (null == (thirdJobConfig = this.thirdJobConfigMapper.getJobConfigBy("", appId))) {
            throw new Exception("\u5f53\u524d\u5e94\u7528\u4e0d\u5728\u914d\u7f6e\u4e2d\uff0c\u65e0\u6743\u63a8\u9001\u4f5c\u4e1a");
        }
        if (Constants.VALID_STATUS_UNUSABLE.equals(thirdJobConfig.getValidStatus())) {
            throw new Exception("\u5f53\u524d\u5e94\u7528\u672a\u542f\u7528\uff0c\u65e0\u6743\u63a8\u9001\u4f5c\u4e1a");
        }
        req.setSyncModel(syncModel.intValue());
        try {
            List jobList = JSONArray.parseArray((String)jsonArrayJob.toJSONString(), SyncJobInfo.class);
            if (CollectionUtils.isEmpty((Collection)jobList)) {
                return new DWEAIResult(DigiSrvcode.FAILURE.getCode(), "0", "\u4f5c\u4e1a\u4fe1\u606f\u4e3a\u7a7a", (Map)parameterResult);
            }
            req.setJobList(jobList);
        }
        catch (Exception e) {
            log.error("third.job.push  parseObject error", (Throwable)e);
            return new DWEAIResult(DigiSrvcode.FAILURE.getCode(), "0", "\u5165\u53c2\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u662f\u5426\u6b63\u786e", (Map)parameterResult);
        }
        try {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)req.getAppId())) {
                return new DWEAIResult(DigiSrvcode.FAILURE.getCode(), "0", "AppId\u4e3a\u7a7a", (Map)parameterResult);
            }
            boolean accountFlag = req.getJobList().stream().anyMatch(x -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)x.getAccountId()));
            if (accountFlag) {
                boolean flag = req.getJobList().stream().anyMatch(x -> org.apache.commons.lang3.StringUtils.isBlank((CharSequence)x.getAccountId()));
                if (flag) {
                    return new DWEAIResult(DigiSrvcode.FAILURE.getCode(), "0", "missing accountId", (Map)parameterResult);
                }
                ArrayList jobCodeList = Lists.newArrayList();
                for (SyncJobInfo syncJobInfo : req.getJobList()) {
                    String jobCode = syncJobInfo.getAccountId() + "-" + syncJobInfo.getJobCode();
                    if (jobCodeList.contains(jobCode)) {
                        return new DWEAIResult(DigiSrvcode.FAILURE.getCode(), "0", "exist repeated accountId and jobCode", (Map)parameterResult);
                    }
                    syncJobInfo.setJobCode(jobCode);
                    jobCodeList.add(jobCode);
                }
            }
            this.syncJobInfoService.jobSyncSave(req);
        }
        catch (Exception e) {
            log.error("third.job.push  jobSyncSave error", (Throwable)e);
            throw new Exception("third.job.push error, msg:" + e.getMessage());
        }
        parameterResult.put("response", true);
        return new DWEAIResult(DigiSrvcode.SUCCESS.getCode(), "0", "", (Map)parameterResult);
    }

    @EAIService(id="third.todo.push")
    public DWEAIResult receiveThirdToDo(JSONObject jsonObject) throws Exception {
        log.info("third.todo.push  param:{}", (Object)JSON.toJSONString((Object)jsonObject));
        HashMap parameterResult = Maps.newHashMap();
        TodoReceiveDto receiveDto = new TodoReceiveDto();
        JSONObject std_data = jsonObject.getJSONObject("std_data");
        JSONObject parameter = std_data.getJSONObject("parameter");
        String appCode = parameter.getString("app_code");
        String appIdCode = parameter.getString("app_id_code");
        receiveDto.setAppCode(appCode);
        receiveDto.setAppIdCode(appIdCode);
        JSONArray jsonArrayToDoList = parameter.getJSONArray("to_do_list");
        JSONArray jsonArrayToDoField = parameter.getJSONArray("display_field_list");
        ThirdTodoConfig thirdTodoConfig = this.thirdTodoConfigMapper.getToDoConfigBy("", appCode);
        if (null == thirdTodoConfig) {
            throw new Exception("\u5f53\u524d\u5e94\u7528\u4e0d\u5728\u914d\u7f6e\u4e2d\uff0c\u65e0\u6743\u63a8\u9001\u5f85\u529e");
        }
        if (Constants.VALID_STATUS_UNUSABLE.equals(thirdTodoConfig.getValidStatus())) {
            throw new Exception("\u5f53\u524d\u5e94\u7528\u672a\u542f\u7528\uff0c\u65e0\u6743\u63a8\u9001\u5f85\u529e");
        }
        try {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)receiveDto.getAppCode())) {
                return new DWEAIResult(DigiSrvcode.FAILURE.getCode(), "0", "AppCode\u4e3a\u7a7a", (Map)parameterResult);
            }
            List toDoList = JSONArray.parseArray((String)jsonArrayToDoList.toJSONString(), TodoListDto.class);
            if (CollectionUtils.isEmpty((Collection)toDoList)) {
                return new DWEAIResult(DigiSrvcode.FAILURE.getCode(), "0", "\u5f85\u529e\u5217\u8868\u4e3a\u7a7a", (Map)parameterResult);
            }
            List toDoFieldList = JSONArray.parseArray((String)jsonArrayToDoField.toJSONString(), TodoFieldDto.class);
            if (CollectionUtils.isEmpty((Collection)toDoFieldList)) {
                return new DWEAIResult(DigiSrvcode.FAILURE.getCode(), "0", "\u5f85\u529e\u663e\u793a\u5b57\u6bb5\u5217\u8868\u4e3a\u7a7a", (Map)parameterResult);
            }
            receiveDto.setDisplayFieldList(toDoFieldList);
            receiveDto.setToDoList(toDoList);
            this.todoListService.toDoReceive(receiveDto);
        }
        catch (Exception e) {
            log.error("third.todo.push   error", (Throwable)e);
            throw new Exception("third.todo.push error, msg:" + e.getMessage());
        }
        parameterResult.put("response", true);
        return new DWEAIResult(DigiSrvcode.SUCCESS.getCode(), "0", "", (Map)parameterResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EAIService(id="third.todo.notice")
    public DWEAIResult noticeThirdToDo(JSONObject jsonObject) {
        log.info("third.todo.notice  param:{}", (Object)JSON.toJSONString((Object)jsonObject));
        HashMap map = Maps.newHashMap();
        NoticeVO noticeVO = new NoticeVO();
        JSONObject stdData = jsonObject.getJSONObject("std_data");
        JSONObject parameter = stdData.getJSONObject("parameter");
        noticeVO.setBizId(parameter.getString("biz_id"));
        noticeVO.setAppName(parameter.getString("app_name"));
        noticeVO.setAppId(parameter.getString("app_id"));
        SyncToDoRecord toDoRecord = new SyncToDoRecord();
        toDoRecord.setAppId(parameter.getString("app_id"));
        toDoRecord.setDataModel(Integer.valueOf(0));
        toDoRecord.setReqJson(JSON.toJSONString((Object)jsonObject));
        toDoRecord.setSyncType(Integer.valueOf(0));
        toDoRecord.setSyncStatus(Integer.valueOf(0));
        toDoRecord.setToDoId(parameter.getString("biz_id"));
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)noticeVO.getBizId())) {
            return new DWEAIResult(DigiSrvcode.FAILURE.getCode(), "0", "bizId\u4e3a\u7a7a", (Map)map);
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)noticeVO.getAppId())) {
            return new DWEAIResult(DigiSrvcode.FAILURE.getCode(), "0", "appId\u4e3a\u7a7a", (Map)map);
        }
        RedisLock redisLock = new RedisLock("thirdTodoNotice:" + noticeVO.getBizId());
        try {
            if (!redisLock.lock()) {
                return new DWEAIResult(DigiSrvcode.SUCCESS.getCode(), "0", "", (Map)map);
            }
        }
        catch (InterruptedException e) {
            return new DWEAIResult(DigiSrvcode.SUCCESS.getCode(), "0", "", (Map)map);
        }
        try {
            List todoListDb = this.todoNoticeMq.selectToDoBy(noticeVO.getAppId(), noticeVO.getBizId());
            LambdaUpdateWrapper updateTodoListWrapper = new LambdaUpdateWrapper();
            updateTodoListWrapper.eq(TodoList::getAppId, (Object)noticeVO.getAppId());
            updateTodoListWrapper.eq(TodoList::getToDoId, (Object)noticeVO.getBizId());
            this.todoListService.remove((Wrapper)updateTodoListWrapper);
            LambdaUpdateWrapper updateTodoReadWrapper = new LambdaUpdateWrapper();
            updateTodoReadWrapper.eq(TodoRead::getAppId, (Object)noticeVO.getAppId());
            updateTodoReadWrapper.eq(TodoRead::getToDoId, (Object)noticeVO.getBizId());
            this.todoReadService.remove((Wrapper)updateTodoReadWrapper);
            this.todoNoticeMq.sendMessageToMqtt(noticeVO, todoListDb);
        }
        catch (Exception e) {
            toDoRecord.setSyncStatus(Integer.valueOf(1));
            toDoRecord.setRespJson(e.getMessage());
            log.error("third.todo.notice   error", (Throwable)e);
        }
        finally {
            redisLock.unlock();
        }
        this.syncToDoRecordMapper.addRecord(toDoRecord);
        return new DWEAIResult(DigiSrvcode.SUCCESS.getCode(), "0", "", (Map)map);
    }
}

