/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.event.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.EventTypeEnum;
import com.digiwin.athena.semc.converter.event.EventTrackingConverter;
import com.digiwin.athena.semc.dto.event.EventTrackingReq;
import com.digiwin.athena.semc.dto.event.PageQueryEventTrackingDTO;
import com.digiwin.athena.semc.entity.event.EventTracking;
import com.digiwin.athena.semc.event.EventTrackingEvent;
import com.digiwin.athena.semc.mapper.event.EventTrackingMapper;
import com.digiwin.athena.semc.service.event.EventTrackingService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.vo.event.PageQueryEventTrackingVO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class EventTrackingServiceImpl
extends ServiceImpl<EventTrackingMapper, EventTracking>
implements EventTrackingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventTrackingServiceImpl.class);
    private final EventTrackingMapper eventTrackingMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final EventTrackingConverter eventTrackingConverter;

    public Integer saveTracking(EventTrackingReq req) {
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        Map common = req.getCommon();
        if (CollectionUtils.isEmpty((Collection)req.getEvents())) {
            return 0;
        }
        List eventTrackingList = req.getEvents().stream().map(eventDto -> {
            EventTracking event = new EventTracking();
            event.setTenantId(user.getTenantId());
            event.setUserId(user.getUserId());
            event.setTenantName(user.getTenantName());
            event.setUserName(user.getUserName());
            event.setEventTime(req.getTs());
            event.setSource(Integer.valueOf(Integer.parseInt(String.valueOf(common.get("source")))));
            event.setEventId(eventDto.getEventCode());
            event.setCreateTime(DateUtils.getNowTime((String)""));
            event.setContent(JSON.toJSONString((Object)req));
            return event;
        }).collect(Collectors.toList());
        int result = this.eventTrackingMapper.batchInsert(eventTrackingList);
        boolean isSendEvent = req.getEvents().stream().anyMatch(m -> "loginOutConfirmClick".equals(m.getEventCode()) || "tenantSwitchButtonClick".equals(m.getEventCode()));
        if (isSendEvent) {
            EventTrackingEvent eventTrackingEvent = new EventTrackingEvent((Object)this, user.getTenantId(), user.getUserId());
            this.eventPublisher.publishEvent((ApplicationEvent)eventTrackingEvent);
        }
        return result;
    }

    public PageInfoResp<PageQueryEventTrackingVO> pageQuery(PageQueryEventTrackingDTO pageQueryEventTrackingDTO) {
        List eventIds = CollectionUtils.isEmpty((Collection)pageQueryEventTrackingDTO.getEventTypes()) ? EventTypeEnum.getWorkbenchEventName() : EventTypeEnum.getEventIdByEventType((List)pageQueryEventTrackingDTO.getEventTypes());
        Page result = (Page)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(StrUtil.isNotBlank((CharSequence)pageQueryEventTrackingDTO.getEventName()), EventTracking::getContent, (Object)pageQueryEventTrackingDTO.getEventName())).between(StrUtil.isNotBlank((CharSequence)pageQueryEventTrackingDTO.getCreateDateStart()) && StrUtil.isNotBlank((CharSequence)pageQueryEventTrackingDTO.getCreateDateEnd()), EventTracking::getCreateTime, (Object)pageQueryEventTrackingDTO.getCreateDateStart(), (Object)pageQueryEventTrackingDTO.getCreateDateEnd())).in(CollectionUtils.isNotEmpty((Collection)eventIds), EventTracking::getEventId, (Collection)eventIds)).eq(EventTracking::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId())).and(StrUtil.isNotBlank((CharSequence)pageQueryEventTrackingDTO.getUserContent()), wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(EventTracking::getUserId, (Object)pageQueryEventTrackingDTO.getUserContent())).or()).like(EventTracking::getUserName, (Object)pageQueryEventTrackingDTO.getUserContent());
        })).orderByDesc(EventTracking::getCreateTime)).page((IPage)new Page((long)pageQueryEventTrackingDTO.getPageNo().intValue(), (long)pageQueryEventTrackingDTO.getPageSize().intValue()));
        List pageQueryEventTrackingVOList = this.eventTrackingConverter.toPageQueryEventTrackingVOList(result.getRecords());
        return new PageInfoResp(pageQueryEventTrackingDTO.getPageNo().intValue(), pageQueryEventTrackingDTO.getPageSize().intValue(), Integer.parseInt(String.valueOf(result.getTotal())), pageQueryEventTrackingVOList);
    }

    public List<PageQueryEventTrackingVO> exportReport(PageQueryEventTrackingDTO pageQueryEventTrackingDTO) {
        List eventIds = CollectionUtils.isEmpty((Collection)pageQueryEventTrackingDTO.getEventTypes()) ? EventTypeEnum.getWorkbenchEventName() : EventTypeEnum.getEventIdByEventType((List)pageQueryEventTrackingDTO.getEventTypes());
        List eventTrackingList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(StrUtil.isNotBlank((CharSequence)pageQueryEventTrackingDTO.getEventName()), EventTracking::getContent, (Object)pageQueryEventTrackingDTO.getEventName())).between(StrUtil.isNotBlank((CharSequence)pageQueryEventTrackingDTO.getCreateDateStart()) && StrUtil.isNotBlank((CharSequence)pageQueryEventTrackingDTO.getCreateDateEnd()), EventTracking::getCreateTime, (Object)pageQueryEventTrackingDTO.getCreateDateStart(), (Object)pageQueryEventTrackingDTO.getCreateDateEnd())).in(CollectionUtils.isNotEmpty((Collection)eventIds), EventTracking::getEventId, (Collection)eventIds)).eq(EventTracking::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId())).and(StrUtil.isNotBlank((CharSequence)pageQueryEventTrackingDTO.getUserContent()), wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(EventTracking::getUserId, (Object)pageQueryEventTrackingDTO.getUserContent())).or()).like(EventTracking::getUserName, (Object)pageQueryEventTrackingDTO.getUserContent());
        })).orderByDesc(EventTracking::getCreateTime)).list();
        return this.eventTrackingConverter.toPageQueryEventTrackingVOList(eventTrackingList);
    }

    public static String splitEventName(EventTracking eventTracking) {
        String trackId;
        if (ObjectUtil.equals((Object)eventTracking.getEventId(), (Object)EventTypeEnum.LOGIN_OUT_CONFIRM_CLICK.getEventId())) {
            return String.format("\u7528\u6237[%s(%s)]\uff0c\u767b\u51fa\u79df\u6237[%s]\u6210\u529f", eventTracking.getUserName(), eventTracking.getUserId(), eventTracking.getTenantName());
        }
        if (ObjectUtil.equals((Object)eventTracking.getEventId(), (Object)EventTypeEnum.LOGIN_CLICK.getEventId())) {
            return String.format("\u7528\u6237[%s(%s)]\uff0c\u767b\u5165\u79df\u6237[%s]\u6210\u529f", eventTracking.getUserName(), eventTracking.getUserId(), eventTracking.getTenantName());
        }
        EventTrackingReq eventTrackingReq = (EventTrackingReq)JSON.parseObject((String)eventTracking.getContent(), EventTrackingReq.class);
        Map attr = (Map)((EventTrackingReq.EventsDTO)eventTrackingReq.getEvents().get(0)).getAttrs().get(0);
        if (ObjectUtil.equals((Object)eventTracking.getEventId(), (Object)EventTypeEnum.WORK_AUTHORIZATION.getEventId())) {
            String authId;
            StringBuilder labelName = new StringBuilder();
            JSONArray labelList = JSON.parseArray((String)JSON.toJSONString(attr.get("labelList")));
            for (Object e : labelList) {
                String labelId;
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(e));
                String newLabelName = null == jsonObject.get("labelName") ? "" : jsonObject.get("labelName").toString();
                String string = labelId = null == jsonObject.get("labelId") ? "" : jsonObject.get("labelId").toString();
                if (StrUtil.isBlank((CharSequence)newLabelName) && StrUtil.isBlank((CharSequence)labelId)) continue;
                labelName.append(newLabelName).append("(").append(labelId).append("),");
            }
            if (labelName.length() > 0) {
                labelName.deleteCharAt(labelName.length() - 1);
            }
            String authName = null == attr.get("authName") ? "" : attr.get("authName").toString();
            String string = authId = null == attr.get("authId") ? "" : attr.get("authId").toString();
            if (ObjectUtil.equals(attr.get("isRelated"), (Object)Boolean.TRUE)) {
                return String.format("\u7528\u6237[%s(%s)]\uff0c\u5c06\u7ba1\u7406\u540e\u53f0\u7684[%s]\u4f5c\u4e1a\u8d4b\u6743\u7ed9[%s(%s)]", eventTracking.getUserName(), eventTracking.getUserId(), labelName, authName, authId);
            }
            return String.format("\u7528\u6237[%s(%s)]\uff0c\u5c06\u7ba1\u7406\u540e\u53f0\u7684[%s]\u4f5c\u4e1a\u4ece[%s(%s)]\u89e3\u9664\u6743\u9650", eventTracking.getUserName(), eventTracking.getUserId(), labelName, authName, authId);
        }
        String trackName = null == attr.get("trackName") ? "" : attr.get("trackName").toString();
        String string = trackId = null == attr.get("trackId") ? "" : attr.get("trackId").toString();
        if (ObjectUtil.equals((Object)eventTracking.getEventId(), (Object)EventTypeEnum.THIRD_TODO_CLICK.getEventId())) {
            return String.format("\u7528\u6237[%s(%s)]\uff0c\u67e5\u770b\u5f85\u529e[%s(%s)]", eventTracking.getUserName(), eventTracking.getUserId(), trackName, trackId);
        }
        if (ObjectUtil.equals((Object)eventTracking.getEventId(), (Object)EventTypeEnum.THIRD_MESSAGE_CLICK.getEventId())) {
            return String.format("\u7528\u6237[%s(%s)]\uff0c\u67e5\u770b\u6d88\u606f[%s(%s)]", eventTracking.getUserName(), eventTracking.getUserId(), trackName, trackId);
        }
        if (ObjectUtil.equals((Object)eventTracking.getEventId(), (Object)EventTypeEnum.CUSTOM_PORTAL_CLICK.getEventId())) {
            return String.format("\u7528\u6237[%s(%s)]\uff0c\u4f7f\u7528\u5de5\u4f5c\u53f0[%s(%s)]", eventTracking.getUserName(), eventTracking.getUserId(), trackName, trackId);
        }
        if (ObjectUtil.equals((Object)eventTracking.getEventId(), (Object)EventTypeEnum.COMPONENT_CLICK.getEventId())) {
            return String.format("\u7528\u6237[%s(%s)]\uff0c\u70b9\u51fb\u90e8\u4ef6[%s(%s)]", eventTracking.getUserName(), eventTracking.getUserId(), trackName, trackId);
        }
        return "";
    }

    @Generated
    public EventTrackingServiceImpl(EventTrackingMapper eventTrackingMapper, ApplicationEventPublisher eventPublisher, EventTrackingConverter eventTrackingConverter) {
        this.eventTrackingMapper = eventTrackingMapper;
        this.eventPublisher = eventPublisher;
        this.eventTrackingConverter = eventTrackingConverter;
    }
}

