/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.fineReport.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.fineReport.FineReportConfigDTO;
import com.digiwin.athena.semc.dto.fineReport.QueryFineReportListReq;
import com.digiwin.athena.semc.dto.fineReport.SaveFineReportAuthReq;
import com.digiwin.athena.semc.entity.fineReport.FineReportAuth;
import com.digiwin.athena.semc.mapper.fineReport.FineReportAuthMapper;
import com.digiwin.athena.semc.proxy.fineReport.model.resp.FineReportTreeVO;
import com.digiwin.athena.semc.proxy.fineReport.service.FineReportProxyService;
import com.digiwin.athena.semc.proxywrapper.IamUserService;
import com.digiwin.athena.semc.proxywrapper.dto.IamUserAuthInfo;
import com.digiwin.athena.semc.service.fineReport.FineReportAuthService;
import com.digiwin.athena.semc.service.portal.TripartiteApplicationService;
import com.digiwin.athena.semc.util.Utils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class FineReportAuthServiceImpl
extends ServiceImpl<FineReportAuthMapper, FineReportAuth>
implements FineReportAuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FineReportAuthServiceImpl.class);
    @Resource
    private FineReportAuthMapper fineReportAuthMapper;
    @Resource
    private FineReportProxyService fineReportProxyService;
    @Resource
    private IamUserService iamUserService;
    @Resource
    private TripartiteApplicationService tripartiteApplicationService;

    public JSONObject queryFineReportList(QueryFineReportListReq queryFineReportListReq) {
        List<String> deviceTypeList;
        JSONObject resp = new JSONObject();
        FineReportConfigDTO fineReportConfigDTO = this.tripartiteApplicationService.queryFineReportConfig();
        if (ObjectUtils.isEmpty((Object)fineReportConfigDTO)) {
            resp.put("allAuthFlag", (Object)Constants.ALL_AUTH_FLAG_NO);
            resp.put("fineReportList", (Object)Lists.newArrayList());
            return resp;
        }
        ArrayList totalFineReportList = Lists.newArrayList();
        if (ObjectUtils.isEmpty((Object)queryFineReportListReq.getDeviceType())) {
            deviceTypeList = Arrays.asList(Constants.FineReportDeviceEnum.PC_DEVICVE.getFlag(), Constants.FineReportDeviceEnum.PAD_DEVICVE.getFlag(), Constants.FineReportDeviceEnum.PFONE_DEVICE.getFlag());
            deviceTypeList.forEach(x -> this.queryFineReportListByDeviceType(fineReportConfigDTO, x, totalFineReportList));
        } else if (Constants.PC_FINE_REPORT.equals(queryFineReportListReq.getDeviceType())) {
            this.queryFineReportListByDeviceType(fineReportConfigDTO, Constants.FineReportDeviceEnum.PC_DEVICVE.getFlag(), (List)totalFineReportList);
        } else if (Constants.MOBILE_FINE_REPORT.equals(queryFineReportListReq.getDeviceType())) {
            deviceTypeList = Arrays.asList(Constants.FineReportDeviceEnum.PAD_DEVICVE.getFlag(), Constants.FineReportDeviceEnum.PFONE_DEVICE.getFlag());
            deviceTypeList.forEach(x -> this.queryFineReportListByDeviceType(fineReportConfigDTO, x, totalFineReportList));
        }
        Map fineReprotIdMap = totalFineReportList.stream().collect(Collectors.toMap(FineReportTreeVO::getId, Function.identity(), (a, b) -> a));
        ArrayList fineReportTreeList = new ArrayList(fineReprotIdMap.values());
        if (CollectionUtils.isEmpty(fineReportTreeList)) {
            resp.put("allAuthFlag", (Object)Constants.ALL_AUTH_FLAG_NO);
            resp.put("fineReportList", fineReportTreeList);
            return resp;
        }
        if (StringUtils.isNotBlank((CharSequence)queryFineReportListReq.getAuthBizId())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(FineReportAuth::getAuthBizId, (Object)queryFineReportListReq.getAuthBizId());
            List fineReportAuthList = this.fineReportAuthMapper.selectList((Wrapper)queryWrapper);
            return FineReportAuthServiceImpl.buildFineReportList(fineReportTreeList, (List)fineReportAuthList);
        }
        if (ObjectUtils.isNotEmpty((Object)queryFineReportListReq.getDisplayPermissionFlag()) && Boolean.TRUE.equals(queryFineReportListReq.getDisplayPermissionFlag())) {
            List fineReportAuthList = this.queryFineReportAuthList();
            return FineReportAuthServiceImpl.buildFineReportList(fineReportTreeList, (List)fineReportAuthList);
        }
        resp.put("allAuthFlag", (Object)Constants.ALL_AUTH_FLAG_YES);
        resp.put("fineReportList", fineReportTreeList);
        return resp;
    }

    private void queryFineReportListByDeviceType(FineReportConfigDTO fineReportConfigDTO, String deviceType, List<FineReportTreeVO> totalFineReportList) {
        List fineReportTreeList = this.fineReportProxyService.queryFineReportEntryTree(fineReportConfigDTO.getClientId(), fineReportConfigDTO.getSecret(), deviceType);
        fineReportTreeList = fineReportTreeList.stream().filter(y -> Constants.FINE_REPORT_TYPE.equals(y.getEntryType())).sorted(Comparator.comparing(FineReportTreeVO::getSortIndex)).collect(Collectors.toList());
        totalFineReportList.addAll(fineReportTreeList);
    }

    public List<FineReportAuth> queryFineReportAuthList() {
        IamUserAuthInfo iamUserAuthInfo = this.iamUserService.getUserAuthSids(Utils.getUserId(), Utils.getTenantId(), Utils.getUserToken());
        ArrayList authIdList = Lists.newArrayList();
        if (ObjectUtils.isNotEmpty((Object)iamUserAuthInfo) && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getOrgSids())) {
            authIdList.addAll(iamUserAuthInfo.getOrgSids());
        }
        if (ObjectUtils.isNotEmpty((Object)iamUserAuthInfo) && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getRoleSids())) {
            authIdList.addAll(iamUserAuthInfo.getRoleSids());
        }
        if (ObjectUtils.isNotEmpty((Object)iamUserAuthInfo) && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getDeptSids())) {
            authIdList.addAll(iamUserAuthInfo.getDeptSids());
        }
        authIdList.add(Utils.getUserSid());
        List fineReportAuthList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)authIdList)) {
            Collections.sort(authIdList);
            QueryWrapper condition = new QueryWrapper();
            condition.apply("((auth_id in(" + Joiner.on((String)",").join((Iterable)authIdList) + ")))", new Object[0]);
            condition.select(new String[]{"all_auth_flag", "fine_report_id"});
            fineReportAuthList = this.fineReportAuthMapper.selectList((Wrapper)condition);
        }
        return fineReportAuthList;
    }

    private static JSONObject buildFineReportList(List<FineReportTreeVO> fineReportTreeList, List<FineReportAuth> fineReportAuthList) {
        JSONObject resp = new JSONObject();
        if (CollectionUtils.isEmpty(fineReportAuthList)) {
            fineReportTreeList.forEach(x -> x.setHavePermissionFlag(Boolean.FALSE));
            resp.put("allAuthFlag", (Object)Constants.ALL_AUTH_FLAG_NO);
            resp.put("fineReportList", fineReportTreeList);
            return resp;
        }
        boolean flag = fineReportAuthList.stream().anyMatch(x -> Constants.ALL_AUTH_FLAG_YES.equals(x.getAllAuthFlag()));
        if (flag) {
            fineReportTreeList.forEach(x -> x.setHavePermissionFlag(Boolean.TRUE));
            resp.put("allAuthFlag", (Object)Constants.ALL_AUTH_FLAG_YES);
            resp.put("fineReportList", fineReportTreeList);
        } else {
            List reprotIdList = fineReportAuthList.stream().map(FineReportAuth::getFineReportId).collect(Collectors.toList());
            fineReportTreeList.forEach(x -> x.setHavePermissionFlag(reprotIdList.contains(x.getId()) ? Boolean.TRUE : Boolean.FALSE));
            resp.put("allAuthFlag", (Object)Constants.ALL_AUTH_FLAG_NO);
            resp.put("fineReportList", fineReportTreeList);
        }
        return resp;
    }

    @Transactional
    public void saveFineReportAuth(SaveFineReportAuthReq saveFineReportAuthReq) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"auth_biz_id", (Object)saveFineReportAuthReq.getAuthBizId());
        this.fineReportAuthMapper.delete((Wrapper)condition);
        if (Constants.ALL_AUTH_FLAG_YES.equals(saveFineReportAuthReq.getAllAuthFlag())) {
            FineReportAuth fineReportAuth = new FineReportAuth();
            fineReportAuth.setAuthId(saveFineReportAuthReq.getAuthId());
            fineReportAuth.setAuthBizId(saveFineReportAuthReq.getAuthBizId());
            fineReportAuth.setAuthName(saveFineReportAuthReq.getAuthName());
            fineReportAuth.setAuthType(saveFineReportAuthReq.getAuthType());
            fineReportAuth.setAllAuthFlag(Constants.ALL_AUTH_FLAG_YES);
            this.save((Object)fineReportAuth);
        } else {
            if (CollectionUtils.isEmpty((Collection)saveFineReportAuthReq.getReportIdList())) {
                return;
            }
            List fineReportAuthList = saveFineReportAuthReq.getReportIdList().stream().map(x -> {
                FineReportAuth fineReportAuth = new FineReportAuth();
                fineReportAuth.setFineReportId(x);
                fineReportAuth.setAuthId(saveFineReportAuthReq.getAuthId());
                fineReportAuth.setAuthBizId(saveFineReportAuthReq.getAuthBizId());
                fineReportAuth.setAuthName(saveFineReportAuthReq.getAuthName());
                fineReportAuth.setAuthType(saveFineReportAuthReq.getAuthType());
                return fineReportAuth;
            }).collect(Collectors.toList());
            List partList = Lists.partition(fineReportAuthList, (int)500);
            for (List tempList : partList) {
                this.saveBatch((Collection)tempList);
            }
        }
    }
}

