/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.fineReport.impl;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.fineReport.FineReportConfigDTO;
import com.digiwin.athena.semc.dto.portal.FineReportQueryReq;
import com.digiwin.athena.semc.entity.fineReport.FineReportUserMapping;
import com.digiwin.athena.semc.entity.portal.TripartiteApplication;
import com.digiwin.athena.semc.mapper.fineReport.FineReportUserMappingMapper;
import com.digiwin.athena.semc.proxy.fineReport.model.resp.FineReportUserVO;
import com.digiwin.athena.semc.proxy.fineReport.service.FineReportProxyService;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.RoleDTO;
import com.digiwin.athena.semc.service.cache.CommonConfigService;
import com.digiwin.athena.semc.service.fineReport.FineReportManageService;
import com.digiwin.athena.semc.service.portal.TripartiteApplicationService;
import com.digiwin.athena.semc.util.Utils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FineReportManageServiceImpl
extends ServiceImpl<FineReportUserMappingMapper, FineReportUserMapping>
implements FineReportManageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FineReportManageServiceImpl.class);
    @Resource
    private FineReportUserMappingMapper fineReportUserMappingMapper;
    @Resource
    private TripartiteApplicationService tripartiteApplicationService;
    @Resource
    private CommonConfigService commonConfigService;
    @Resource
    private FineReportProxyService fineReportProxyService;
    @Resource
    private IamService iamService;

    public void saveFineReportConfig(FineReportConfigDTO fineReportConfigDTO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        String value = JSON.toJSONString((Object)fineReportConfigDTO);
        updateWrapper.set(TripartiteApplication::getApplicationConfig, (Object)value);
        updateWrapper.set(TripartiteApplication::getModifyUserId, (Object)Utils.getUserId());
        updateWrapper.set(TripartiteApplication::getModifyTime, (Object)LocalDateTime.now());
        updateWrapper.eq(TripartiteApplication::getTenantId, (Object)Utils.getTenantId());
        this.tripartiteApplicationService.update((Wrapper)updateWrapper);
        this.commonConfigService.setFineReportConfigCache(fineReportConfigDTO, Utils.getTenantId());
    }

    @Transactional
    public FineReportUserMapping saveUserMapping(FineReportUserMapping fineReportUserMapping) {
        Long id = fineReportUserMapping.getId();
        this.validateUserMapping(fineReportUserMapping, id);
        FineReportUserVO fineReportUserVO = new FineReportUserVO();
        fineReportUserVO.setRealName(fineReportUserMapping.getFrUserName());
        fineReportUserVO.setPassword(fineReportUserMapping.getFrUserPwd());
        fineReportUserVO.setEmail(fineReportUserMapping.getFrUserEmail());
        fineReportUserVO.setMobile(fineReportUserMapping.getFrUserMobile());
        FineReportConfigDTO fineReportConfigDTO = this.tripartiteApplicationService.queryFineReportConfig();
        if (ObjectUtils.isEmpty((Object)fineReportConfigDTO)) {
            throw new RuntimeException("\u65e0\u5e06\u8f6f\u62a5\u8868\u914d\u7f6e");
        }
        if (Objects.isNull(id)) {
            this.fineReportUserMappingMapper.insert((Object)fineReportUserMapping);
        } else {
            this.fineReportUserMappingMapper.updateById((Object)fineReportUserMapping);
        }
        List fineReportUsers = this.fineReportProxyService.queryFineReportUser(fineReportConfigDTO.getClientId(), fineReportConfigDTO.getSecret(), fineReportUserMapping.getFrUserId());
        boolean match = fineReportUsers.stream().anyMatch(u -> fineReportUserMapping.getFrUserId().equals(u.getUsername()));
        if (!match) {
            fineReportUserVO.setUsername(fineReportUserMapping.getFrUserId());
            this.fineReportProxyService.addFineReportUser(fineReportConfigDTO.getClientId(), fineReportConfigDTO.getSecret(), fineReportUserVO);
        } else {
            fineReportUserVO.setUser(fineReportUserMapping.getFrUserId());
            this.fineReportProxyService.updateFineReportUser(fineReportConfigDTO.getClientId(), fineReportConfigDTO.getSecret(), fineReportUserVO);
        }
        return fineReportUserMapping;
    }

    public ResultPageBean queryUserMappings(String tenantId, FineReportQueryReq req) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FineReportUserMapping::getTenantId, (Object)tenantId);
        queryWrapper.orderByDesc(FineReportUserMapping::getModifyTime);
        Page pageResult = (Page)this.fineReportUserMappingMapper.selectPage((IPage)new Page((long)req.getPageNum().intValue(), (long)req.getPageSize().intValue()), (Wrapper)queryWrapper);
        return ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)pageResult.getRecords(), (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)((int)pageResult.getTotal()))));
    }

    public void deleteUserMapping(Long id) {
        FineReportUserMapping fineReportUserMapping = (FineReportUserMapping)this.fineReportUserMappingMapper.selectById((Serializable)id);
        if (!Objects.isNull(fineReportUserMapping)) {
            this.fineReportUserMappingMapper.deleteById((Serializable)id);
            FineReportConfigDTO fineReportConfigDTO = this.tripartiteApplicationService.queryFineReportConfig();
            if (ObjectUtils.isNotEmpty((Object)fineReportConfigDTO)) {
                this.fineReportProxyService.deleteFineReportUser(fineReportConfigDTO.getClientId(), fineReportConfigDTO.getSecret(), fineReportUserMapping.getFrUserId());
            }
        }
    }

    private void validateUserMapping(FineReportUserMapping fineReportUserMapping, Long id) {
        Long userIdCount = this.fineReportUserMappingMapper.selectCount((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FineReportUserMapping::getUserId, (Object)fineReportUserMapping.getUserId())).eq(FineReportUserMapping::getTenantId, (Object)fineReportUserMapping.getTenantId()));
        if (!Objects.isNull(id) && userIdCount > 1L) {
            throw new RuntimeException("\u7528\u6237\u5df2\u7ed1\u5b9a");
        }
        if (Objects.isNull(id) && userIdCount > 0L) {
            throw new RuntimeException("\u7528\u6237\u5df2\u7ed1\u5b9a");
        }
        Long frUserIdCount = this.fineReportUserMappingMapper.selectCount((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FineReportUserMapping::getFrUserId, (Object)fineReportUserMapping.getFrUserId())).eq(FineReportUserMapping::getTenantId, (Object)fineReportUserMapping.getTenantId()));
        if (!Objects.isNull(id) && frUserIdCount > 1L) {
            throw new RuntimeException("\u5e06\u8f6f\u7528\u6237\u5df2\u5b58\u5728");
        }
        if (Objects.isNull(id) && frUserIdCount == 1L) {
            throw new RuntimeException("\u5e06\u8f6f\u7528\u6237\u5df2\u5b58\u5728");
        }
    }

    public FineReportUserMapping queryCurrentUserMapping() {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(FineReportUserMapping::getUserId, (Object)Utils.getUserId());
        wrapper.eq(FineReportUserMapping::getTenantId, (Object)Utils.getTenantId());
        List userMappingList = this.fineReportUserMappingMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)userMappingList)) {
            return (FineReportUserMapping)userMappingList.get(0);
        }
        return null;
    }

    public List<RoleDTO> queryAthenaUserList() {
        List roleDTOS = this.iamService.queryEnabledUserList();
        if (CollectionUtils.isNotEmpty((Collection)roleDTOS)) {
            String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.select(new SFunction[]{FineReportUserMapping::getUserId});
            queryWrapper.eq(FineReportUserMapping::getTenantId, (Object)tenantId);
            List fineReportUserMappings = this.fineReportUserMappingMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)fineReportUserMappings)) {
                List userIds = fineReportUserMappings.stream().map(FineReportUserMapping::getUserId).collect(Collectors.toList());
                roleDTOS.forEach(roleDTO -> {
                    if (userIds.contains(roleDTO.getId())) {
                        roleDTO.setDisabledRole(true);
                    }
                });
            }
            return roleDTOS;
        }
        return Collections.emptyList();
    }
}

