/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.homepage.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.dto.homepage.AdvertisementDTO;
import com.digiwin.athena.semc.dto.homepage.ReadAdvertisementReq;
import com.digiwin.athena.semc.entity.homepage.ReadAdvertisement;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.homepage.ReadAdvertisementMapper;
import com.digiwin.athena.semc.proxy.es.service.EsService;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.homepage.IAdvertisementService;
import com.digiwin.athena.semc.util.DateUtils;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertisementServiceImpl
implements IAdvertisementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdvertisementServiceImpl.class);
    @Resource
    private EsService esService;
    @Resource
    private EnvProperties envProperties;
    @Autowired
    ReadAdvertisementMapper readAdvertisementMapper;

    public List<AdvertisementDTO> queryAdListFromEs(String accessToken) {
        String serviceRegion = this.envProperties.getCountry();
        List adRespList = this.esService.queryAdList(serviceRegion, "DataAnalysis", accessToken);
        if (CollectionUtils.isEmpty((Collection)adRespList)) {
            return Lists.newArrayList();
        }
        List readAdvertisementList = this.queryReadList();
        List adIdList = readAdvertisementList.stream().map(ReadAdvertisement::getAdvertisementId).collect(Collectors.toList());
        Date nowDate = new Date();
        List sortedList = adRespList.stream().sorted(Comparator.comparing(AdvertisementDTO::getEffectiveTime).reversed().thenComparing(AdvertisementDTO::getAdTitle)).collect(Collectors.toList());
        return sortedList.stream().peek(x -> {
            x.setReadStatus(Boolean.valueOf(adIdList.contains(Long.valueOf(x.getId()))));
            try {
                String dateDifference = DateUtils.calDateDifference((Date)nowDate, (Date)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(x.getLostEffectiveTime()));
                x.setRemainingTime(dateDifference);
            }
            catch (ParseException e) {
                log.error("DateUtils.calDateDifference calculate date difference occur error", (Throwable)e);
            }
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertAdReadRecord(ReadAdvertisementReq readAdvertisementReq) {
        RedisLock redisLock = new RedisLock("insertAdvertisementRecord");
        try {
            redisLock.lock();
            ReadAdvertisement readAdvertisement = (ReadAdvertisement)this.readAdvertisementMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"advertisement_id", (Object)readAdvertisementReq.getAdId())).eq((Object)"create_user_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId()));
            if (readAdvertisement == null) {
                readAdvertisement = new ReadAdvertisement();
                readAdvertisement.setAdvertisementId(readAdvertisementReq.getAdId());
                readAdvertisement.setAdvertisementTitle(readAdvertisementReq.getAdTitle());
                readAdvertisement.setImportanceFlag(readAdvertisementReq.getImportanceFlag());
                readAdvertisement.setReadCount(Integer.valueOf(1));
                readAdvertisement.setReadDate(DateUtils.getNowTime((String)"yyyy-MM-dd"));
                readAdvertisement.setReadTime(DateUtils.getNowTime((String)"HH:mm:ss"));
                readAdvertisement.setFirstReadPlatform(readAdvertisementReq.getReadPlatform());
                readAdvertisement.setCreateUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
                readAdvertisement.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                this.readAdvertisementMapper.insert((Object)readAdvertisement);
            } else {
                readAdvertisement.setReadCount(Integer.valueOf(readAdvertisement.getReadCount() + 1));
                this.readAdvertisementMapper.updateById((Object)readAdvertisement);
            }
        }
        catch (Exception e) {
            log.error("AdvertisementServiceImpl | insert read record occur error. param:{}", (Object)readAdvertisementReq, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            redisLock.unlock();
        }
        return true;
    }

    public List<ReadAdvertisement> queryReadList() {
        return this.readAdvertisementMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"create_user_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId()));
    }
}

