/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.homepage.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.BizObjectTypeEnum;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.common.enums.HomeSearchTypeEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.homepage.HomeSearchDTO;
import com.digiwin.athena.semc.dto.homepage.HomeSearchReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.common.BizObjAuthRel;
import com.digiwin.athena.semc.entity.portal.LabelSystem;
import com.digiwin.athena.semc.entity.portal.News;
import com.digiwin.athena.semc.entity.portal.Notice;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.common.FolderMapper;
import com.digiwin.athena.semc.mapper.portal.LabelMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemMapper;
import com.digiwin.athena.semc.mapper.portal.NewsMapper;
import com.digiwin.athena.semc.mapper.portal.NoticeMapper;
import com.digiwin.athena.semc.mapper.sso.ThirdSsoInfoMapper;
import com.digiwin.athena.semc.proxy.athena.service.atmc.AtmcService;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.kbs.service.KbsService;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.cache.ICacheService;
import com.digiwin.athena.semc.service.common.IBizObjAuthRelService;
import com.digiwin.athena.semc.service.homepage.IHomeSearchService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.vo.portal.FineReportVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HomeSearchServiceImpl
implements IHomeSearchService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HomeSearchServiceImpl.class);
    @Autowired
    private AppLinkService appLinkService;
    @Autowired
    private NewsMapper newsMapper;
    @Autowired
    private NoticeMapper noticeMapper;
    @Autowired
    private LabelMapper labelMapper;
    @Autowired
    private LabelSystemMapper labelSystemMapper;
    @Autowired
    private ThirdSsoInfoMapper thirdSsoInfoMapper;
    @Resource
    private ESPService espService;
    @Resource
    private AtmcService atmcService;
    @Resource
    private FolderMapper folderMapper;
    @Resource
    private IBizObjAuthRelService bizObjAuthRelService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private KbsService kbsService;
    @Resource
    EnvProperties envProperties;

    public List<HomeSearchDTO> searchResult(HomeSearchReq homeSearchReq, AuthoredUser user) {
        ArrayList<HomeSearchDTO> searchResultList = new ArrayList<HomeSearchDTO>();
        List<Object> reportList = new ArrayList();
        long start = System.currentTimeMillis();
        if (null == homeSearchReq.getType() || null != homeSearchReq.getType() && homeSearchReq.getType() < HomeSearchTypeEnum.APP_LINK.getValue()) {
            List aiResultList = this.selectAiResult(homeSearchReq, user);
            long endAI = System.currentTimeMillis();
            log.info("search result \u5c0fAI\u8bf7\u6c42\u8017\u65f6:" + (endAI - start) + " ms");
            List itemList = aiResultList.stream().filter(item -> HomeSearchTypeEnum.ITEM_CARD.getValue().equals(item.getType())).collect(Collectors.toList());
            Collections.sort(itemList);
            searchResultList.addAll(itemList);
            List taskList = aiResultList.stream().filter(item -> HomeSearchTypeEnum.TASK_CARD.getValue().equals(item.getType())).collect(Collectors.toList());
            if (null == homeSearchReq.getType() || null != homeSearchReq.getType() && homeSearchReq.getType().equals(HomeSearchTypeEnum.TASK_CARD.getValue())) {
                long startTodo = System.currentTimeMillis();
                List toDoList = this.selectToDoEsp(homeSearchReq, user);
                long endTodo = System.currentTimeMillis();
                log.info("search result \u4e09\u65b9\u5f85\u529e\u8bf7\u6c42\u8017\u65f6:" + (endTodo - startTodo) + " ms");
                taskList.addAll(toDoList);
            }
            Collections.sort(taskList);
            searchResultList.addAll(taskList);
            List projectList = aiResultList.stream().filter(item -> HomeSearchTypeEnum.INITIATES_PROJECTS.getValue().equals(item.getType())).collect(Collectors.toList());
            Collections.sort(projectList);
            searchResultList.addAll(projectList);
            List basicDataList = aiResultList.stream().filter(item -> HomeSearchTypeEnum.BASIC_DATA.getValue().equals(item.getType())).collect(Collectors.toList());
            Collections.sort(basicDataList);
            searchResultList.addAll(basicDataList);
            long startReport = System.currentTimeMillis();
            reportList = aiResultList.stream().filter(item -> HomeSearchTypeEnum.REPORT.getValue().equals(item.getType())).collect(Collectors.toList());
            if (null == homeSearchReq.getType() || null != homeSearchReq.getType() && homeSearchReq.getType().equals(HomeSearchTypeEnum.REPORT.getValue())) {
                List threeReportList = this.selectReport(homeSearchReq, user);
                reportList.addAll(threeReportList);
                List fineReportList = this.selectFineReport(homeSearchReq, user);
                reportList.addAll(fineReportList);
            }
            Collections.sort(reportList);
            long endReport = System.currentTimeMillis();
            log.info("search result  \u62a5\u8868\u8bf7\u6c42\u8017\u65f6:" + (endReport - startReport) + " ms");
        }
        if (null == homeSearchReq.getType() || null != homeSearchReq.getType() && homeSearchReq.getType().equals(HomeSearchTypeEnum.APP_LINK.getValue())) {
            long startAppLink = System.currentTimeMillis();
            List appLinkList = this.selectAppLinkList(homeSearchReq, user);
            searchResultList.addAll(appLinkList);
            long endAppLink = System.currentTimeMillis();
            log.info("search result  \u53cb\u60c5\u94fe\u63a5\u8bf7\u6c42\u8017\u65f6:" + (endAppLink - startAppLink) + " ms");
        }
        if (!CollectionUtils.isEmpty(reportList)) {
            searchResultList.addAll(reportList);
        }
        if (null == homeSearchReq.getType() || null != homeSearchReq.getType() && homeSearchReq.getType() == 6) {
            List newsNoticeList = this.selectNewsNotice(homeSearchReq, user);
            searchResultList.addAll(newsNoticeList);
        }
        long end = System.currentTimeMillis();
        log.info("search result  \u8bf7\u6c42\u603b\u8017\u65f6:" + (end - start) + " ms");
        return searchResultList;
    }

    public JSONObject getKbsFileDetail(String fileId) {
        return this.kbsService.getFileDetail(fileId);
    }

    public HomeSearchDTO getSsoInfo(String appName, String tenantId, Map<String, HomeSearchDTO> ssoInfoMap) {
        String mapKey = tenantId + appName;
        HomeSearchDTO sslInfoDTOMap = ssoInfoMap.get(mapKey);
        if (null != sslInfoDTOMap) {
            return sslInfoDTOMap;
        }
        HomeSearchDTO sslInfoDTO = new HomeSearchDTO();
        List thirdSsoInfoList = this.thirdSsoInfoMapper.querySsoInfoBy(appName);
        if (!CollectionUtils.isEmpty((Collection)thirdSsoInfoList)) {
            sslInfoDTO.setAppId(((ThirdSsoInfo)thirdSsoInfoList.get(0)).getAppId());
            sslInfoDTO.setCallBackUrl(((ThirdSsoInfo)thirdSsoInfoList.get(0)).getCallBackUrl());
            sslInfoDTO.setSystemType(((ThirdSsoInfo)thirdSsoInfoList.get(0)).getExtend());
            sslInfoDTO.setUserBindFlag(((ThirdSsoInfo)thirdSsoInfoList.get(0)).getUserBindFlag());
            sslInfoDTO.setAppToken(((ThirdSsoInfo)thirdSsoInfoList.get(0)).getAppToken());
            ssoInfoMap.put(mapKey, sslInfoDTO);
        }
        return sslInfoDTO;
    }

    public List<HomeSearchDTO> selectAiResult(HomeSearchReq homeSearchReq, AuthoredUser user) {
        List aiList = this.atmcService.searchResult(homeSearchReq.getName(), user.getToken(), homeSearchReq.getType());
        for (HomeSearchDTO ai : aiList) {
            ai.setCopyCode(ai.getCode());
        }
        return aiList;
    }

    public List<HomeSearchDTO> selectToDoEsp(HomeSearchReq homeSearchReq, AuthoredUser user) {
        ArrayList<HomeSearchDTO> todoEspList = new ArrayList<HomeSearchDTO>();
        try {
            Long labelId = this.labelMapper.getByLabelKey(Constants.LabelEnum.THIRD_TO_DO.getKey());
            if (null == labelId) {
                return todoEspList;
            }
            HashMap ssoInfoMap = new HashMap();
            List labelSystemList = this.labelSystemMapper.selectByLabelId(labelId, "");
            HashMap<String, String> extHeader = new HashMap<String, String>();
            extHeader.put("digi-userToken", user.getToken());
            for (LabelSystem labelSystem : labelSystemList) {
                HomeSearchDTO searcshTodoMap;
                searcshTodoMap.setAppToken(StringUtils.isBlank((CharSequence)(searcshTodoMap = this.getSsoInfo(labelSystem.getSystemName(), user.getTenantId(), ssoInfoMap)).getAppToken()) ? this.envProperties.getAppToken() : searcshTodoMap.getAppToken());
                try {
                    extHeader.put("digi-appToken", searcshTodoMap.getAppToken());
                    Map result = this.espService.queryByEsp(labelSystem.getMiddleSystemName(), labelSystem.getMiddleSystemUid(), EAIServiceNameEnum.TODOLIST.getServiceName(), extHeader, null, homeSearchReq.getName(), PageInfo.getPageInfo((Integer)Constants.pageNum, (Integer)Constants.pageSize));
                    if (!Objects.nonNull(result.get("to_do_list"))) continue;
                    com.alibaba.fastjson.JSONArray array = com.alibaba.fastjson.JSONArray.parseArray((String)com.alibaba.fastjson.JSONObject.toJSONString(result.get("to_do_list")));
                    for (int i = 0; i < array.size(); ++i) {
                        com.alibaba.fastjson.JSONObject jsonObject = array.getJSONObject(i);
                        String toDoDataStr = jsonObject.getString("to_do_data");
                        com.alibaba.fastjson.JSONObject toDoData = com.alibaba.fastjson.JSONObject.parseObject((String)toDoDataStr);
                        String toDoUrl = jsonObject.getString("to_do_url");
                        toDoUrl = toDoUrl + (toDoUrl.contains("?") ? "&" : "?") + "appToken=" + searcshTodoMap.getAppToken() + "&tenantId=" + user.getTenantId() + "&bindMode=" + searcshTodoMap.getUserBindFlag();
                        HomeSearchDTO todoDTO = new HomeSearchDTO();
                        String name = "";
                        String title = toDoData.getString("title");
                        if (StringUtils.isNotEmpty((CharSequence)title)) {
                            name = title;
                        }
                        String subject = toDoData.getString("Subject");
                        if (StringUtils.isEmpty((CharSequence)name) && StringUtils.isNotEmpty((CharSequence)subject)) {
                            name = subject;
                        }
                        String taskName = toDoData.getString("task_name");
                        if (StringUtils.isEmpty((CharSequence)name) && StringUtils.isNotEmpty((CharSequence)taskName)) {
                            name = taskName;
                        }
                        todoDTO.setName(name);
                        todoDTO.setProjectDefCode(toDoUrl);
                        todoDTO.setType(HomeSearchTypeEnum.THREE_TODO.getValue());
                        todoDTO.setAppId(searcshTodoMap.getAppId());
                        todoDTO.setSystemType(searcshTodoMap.getSystemType());
                        todoDTO.setSystemId(labelSystem.getId());
                        todoDTO.setCallBackUrl(searcshTodoMap.getCallBackUrl());
                        if (!StringUtils.isNotEmpty((CharSequence)todoDTO.getName()) || !toDoDataStr.contains(homeSearchReq.getName())) continue;
                        todoEspList.add(todoDTO);
                    }
                }
                catch (Exception e) {
                    log.error("search result \u67e5\u8be2\u4e09\u65b9\u5f85\u529eESP error", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error("search result \u67e5\u8be2\u7b2c\u4e09\u65b9\u62a5\u8868 exception", (Throwable)e);
            return todoEspList;
        }
        return todoEspList;
    }

    public List<HomeSearchDTO> selectKbsFile(HomeSearchReq homeSearchReq) {
        ArrayList<HomeSearchDTO> fileList = new ArrayList<HomeSearchDTO>();
        try {
            JSONArray kbsFileJsonList = this.kbsService.selectKnowledgeInfo(homeSearchReq.getName());
            ArrayList<String> fileIds = new ArrayList<String>();
            for (Object kbsFileJson : kbsFileJsonList) {
                JSONObject jsonObjectKnowledgeInfo = JSONObject.fromObject(kbsFileJson);
                String knowledgeTitle = (String)jsonObjectKnowledgeInfo.get("knowledge_title");
                String knowledgeId = (String)jsonObjectKnowledgeInfo.get("knowledge_id");
                HomeSearchDTO fileDTO = new HomeSearchDTO();
                if (fileIds.contains(knowledgeId)) continue;
                fileDTO.setName(knowledgeTitle);
                fileDTO.setCode(knowledgeId);
                fileDTO.setId(knowledgeId);
                fileDTO.setType(HomeSearchTypeEnum.KBS_FILE.getValue());
                fileList.add(fileDTO);
                fileIds.add(knowledgeId);
            }
        }
        catch (Exception e) {
            log.error("search result \u77e5\u8bc6\u4e2d\u53f0\u6587\u6863\u641c\u7d22 exception", (Throwable)e);
            return fileList;
        }
        return fileList;
    }

    public List<HomeSearchDTO> selectNewsNotice(HomeSearchReq homeSearchReq, AuthoredUser user) {
        ArrayList<HomeSearchDTO> newsNoticeList = new ArrayList<HomeSearchDTO>();
        try {
            HashMap ssoInfoMap = new HashMap();
            News news = new News();
            news.setNewsUser(user.getUserId());
            news.setTenantId(user.getTenantId());
            news.setNewsTitle(homeSearchReq.getName());
            List newsList = this.newsMapper.selectByUser(news);
            for (News newsDb : newsList) {
                HomeSearchDTO homeSearchDTO = new HomeSearchDTO();
                homeSearchDTO.setName(newsDb.getNewsTitle());
                homeSearchDTO.setCode(newsDb.getId().toString());
                homeSearchDTO.setId(newsDb.getId().toString());
                homeSearchDTO.setType(HomeSearchTypeEnum.NEWS.getValue());
                homeSearchDTO.setProjectDefCode(newsDb.getNewsUrl());
                HomeSearchDTO searcshTodoMap = this.getSsoInfo(newsDb.getAppName(), user.getTenantId(), ssoInfoMap);
                homeSearchDTO.setAppId(searcshTodoMap.getAppId());
                homeSearchDTO.setCallBackUrl(searcshTodoMap.getCallBackUrl());
                homeSearchDTO.setSystemType(searcshTodoMap.getSystemType());
                homeSearchDTO.setStartTime(DateUtils.DateToString((Date)newsDb.getPublishTime()));
                newsNoticeList.add(homeSearchDTO);
            }
            Notice noticeQry = new Notice();
            noticeQry.setNoticeUser(user.getUserId());
            noticeQry.setTenantId(user.getTenantId());
            noticeQry.setNoticeTitle(homeSearchReq.getName());
            List noticeList = this.noticeMapper.selectByUser(noticeQry);
            for (Notice notice : noticeList) {
                HomeSearchDTO homeSearchDTO = new HomeSearchDTO();
                homeSearchDTO.setName(notice.getNoticeTitle());
                homeSearchDTO.setCode(notice.getId().toString());
                homeSearchDTO.setId(notice.getId().toString());
                homeSearchDTO.setType(HomeSearchTypeEnum.NOTICE.getValue());
                homeSearchDTO.setProjectDefCode(notice.getNoticeUrl());
                HomeSearchDTO searcshTodoMap = this.getSsoInfo(notice.getAppName(), user.getTenantId(), ssoInfoMap);
                homeSearchDTO.setAppId(searcshTodoMap.getAppId());
                homeSearchDTO.setCallBackUrl(searcshTodoMap.getCallBackUrl());
                homeSearchDTO.setSystemType(searcshTodoMap.getSystemType());
                homeSearchDTO.setStartTime(DateUtils.DateToString((Date)notice.getPublishTime()));
                newsNoticeList.add(homeSearchDTO);
            }
        }
        catch (Exception e) {
            log.error("search result selectNewsNotice exception", (Throwable)e);
            return newsNoticeList;
        }
        Collections.sort(newsNoticeList);
        return newsNoticeList;
    }

    public List<HomeSearchDTO> selectFineReport(HomeSearchReq homeSearchReq, AuthoredUser user) {
        ArrayList<HomeSearchDTO> reportList = new ArrayList<HomeSearchDTO>();
        try {
            Object result = this.cacheService.get("FineReport-Availability:" + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            Boolean isOpen = Objects.isNull(result) ? true : Boolean.parseBoolean(result.toString());
            if (!isOpen.booleanValue()) {
                return reportList;
            }
            List bizObjAuthRelList = this.bizObjAuthRelService.qryBizObjAuthRel(BizObjectTypeEnum.FINE_REPORT.getValue());
            if (CollectionUtils.isEmpty((Collection)bizObjAuthRelList)) {
                return reportList;
            }
            List reportIdList = bizObjAuthRelList.stream().map(BizObjAuthRel::getBizObjId).collect(Collectors.toList());
            List fineReportVoList = this.folderMapper.fineReportBy(homeSearchReq.getName(), user.getTenantId(), reportIdList);
            for (FineReportVo fineReportVo : fineReportVoList) {
                HomeSearchDTO reportDTO = new HomeSearchDTO();
                reportDTO.setId(fineReportVo.getId() + "");
                reportDTO.setName(fineReportVo.getName());
                reportDTO.setProjectDefCode(fineReportVo.getUrl());
                reportDTO.setType(HomeSearchTypeEnum.FINE_REPORT.getValue());
                reportList.add(reportDTO);
            }
        }
        catch (Exception e) {
            log.error("search result \u67e5\u8be2\u5e06\u8f6f\u62a5\u8868 exception", (Throwable)e);
            return reportList;
        }
        return reportList;
    }

    public List<HomeSearchDTO> selectReport(HomeSearchReq homeSearchReq, AuthoredUser user) {
        ArrayList<HomeSearchDTO> reportList = new ArrayList<HomeSearchDTO>();
        try {
            Long labelId = this.labelMapper.getByLabelKey(Constants.LabelEnum.REPORT_FORMS.getKey());
            if (null == labelId) {
                return reportList;
            }
            HashMap ssoInfoMap = new HashMap();
            List labelSystemList = this.labelSystemMapper.selectByLabelId(labelId, "");
            HashMap<String, String> extHeader = new HashMap<String, String>();
            extHeader.put("digi-userToken", user.getToken());
            for (LabelSystem labelSystem : labelSystemList) {
                HomeSearchDTO searcshTodoMap;
                searcshTodoMap.setAppToken(StringUtils.isBlank((CharSequence)(searcshTodoMap = this.getSsoInfo(labelSystem.getSystemName(), user.getTenantId(), ssoInfoMap)).getAppToken()) ? this.envProperties.getAppToken() : searcshTodoMap.getAppToken());
                try {
                    extHeader.put("digi-appToken", searcshTodoMap.getAppToken());
                    Map result = this.espService.queryByEsp(labelSystem.getMiddleSystemName(), labelSystem.getMiddleSystemUid(), EAIServiceNameEnum.REPORT.getServiceName(), extHeader, null, homeSearchReq.getName(), PageInfo.getPageInfo((Integer)Constants.pageNum, (Integer)Constants.pageSize));
                    if (!Objects.nonNull(result.get("report_info_list"))) continue;
                    com.alibaba.fastjson.JSONArray array = com.alibaba.fastjson.JSONArray.parseArray((String)com.alibaba.fastjson.JSONObject.toJSONString(result.get("report_info_list")));
                    for (int i = 0; i < array.size(); ++i) {
                        com.alibaba.fastjson.JSONObject jsonObject = array.getJSONObject(i);
                        String reportName = jsonObject.getString("report_name");
                        String reportUrl = jsonObject.getString("report_url");
                        reportUrl = reportUrl + (reportUrl.contains("?") ? "&" : "?") + "appToken=" + searcshTodoMap.getAppToken() + "&tenantId=" + user.getTenantId() + "&bindMode=" + searcshTodoMap.getUserBindFlag();
                        String createTime = jsonObject.getString("create_time");
                        String belongModule = jsonObject.getString("belong_module");
                        HomeSearchDTO reportDTO = new HomeSearchDTO();
                        reportDTO.setName(reportName);
                        reportDTO.setCode(belongModule);
                        reportDTO.setStartTime(createTime);
                        reportDTO.setProjectDefCode(reportUrl);
                        reportDTO.setType(HomeSearchTypeEnum.THREE_REPORT.getValue());
                        reportDTO.setAppId(searcshTodoMap.getAppId());
                        reportDTO.setSystemType(searcshTodoMap.getSystemType());
                        reportDTO.setSystemId(labelSystem.getId());
                        reportDTO.setCallBackUrl(searcshTodoMap.getCallBackUrl());
                        if (!StringUtils.isNotEmpty((CharSequence)reportDTO.getName()) || !reportName.contains(homeSearchReq.getName())) continue;
                        reportList.add(reportDTO);
                    }
                }
                catch (Exception e) {
                    log.error("search result \u67e5\u8be2\u7b2c\u4e09\u65b9\u62a5\u8868 error", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error("search result \u67e5\u8be2\u7b2c\u4e09\u65b9\u62a5\u8868 exception", (Throwable)e);
            return reportList;
        }
        return reportList;
    }

    public List<HomeSearchDTO> selectAppLinkList(HomeSearchReq homeSearchReq, AuthoredUser user) {
        ArrayList<HomeSearchDTO> appLinkList = new ArrayList<HomeSearchDTO>();
        try {
            List appLinkDTOList = this.appLinkService.queryDisplayList(user);
            for (AppLinkDTO link : appLinkDTOList) {
                HomeSearchDTO homeSearchDTO = new HomeSearchDTO();
                homeSearchDTO.setName(link.getName());
                homeSearchDTO.setCode(link.getId());
                homeSearchDTO.setId(link.getId());
                homeSearchDTO.setAppToken(link.getAppToken());
                homeSearchDTO.setProjectDefCode(link.getCloudwebsite());
                homeSearchDTO.setIsNeedSsoUrl(link.getIsNeedSsoUrl().intValue());
                homeSearchDTO.setTaskDefCode(link.getAppToken());
                homeSearchDTO.setType(HomeSearchTypeEnum.APP_LINK.getValue());
                homeSearchDTO.setSystemType(link.getSystemType() + "");
                homeSearchDTO.setApplicationAppId(link.getApplicationAppId());
                homeSearchDTO.setProtocolType(link.getProtocolType());
                homeSearchDTO.setCallBackUrl(link.getCallBackUrl());
                if (!StringUtils.isNotEmpty((CharSequence)homeSearchDTO.getName()) || !link.getName().contains(homeSearchReq.getName())) continue;
                appLinkList.add(homeSearchDTO);
            }
        }
        catch (Exception e) {
            log.error("search result \u53cb\u60c5\u94fe\u63a5 exception", (Throwable)e);
            return appLinkList;
        }
        Collections.sort(appLinkList);
        return appLinkList;
    }
}

