/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.homepage.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.UpgradePriorityEnum;
import com.digiwin.athena.semc.common.enums.UpgradeTypeEnum;
import com.digiwin.athena.semc.dto.homepage.UpgradeInfoDTO;
import com.digiwin.athena.semc.dto.homepage.UpgradeInfoReminderDTO;
import com.digiwin.athena.semc.entity.homepage.UpgradeBrowseDetail;
import com.digiwin.athena.semc.entity.homepage.UpgradeReadDetail;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.cac.service.CacService;
import com.digiwin.athena.semc.proxy.dmc.service.DmcService;
import com.digiwin.athena.semc.proxy.gmc.service.IGmcService;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.cache.ICacheService;
import com.digiwin.athena.semc.service.cache.impl.CacheServiceImpl;
import com.digiwin.athena.semc.service.homepage.IUpgradeBrowseDetailService;
import com.digiwin.athena.semc.service.homepage.IUpgradeInfoService;
import com.digiwin.athena.semc.service.homepage.IUpgradeReadDetailService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.vo.homepage.UpgradeInfoDetailResp;
import com.digiwin.athena.semc.vo.homepage.UpgradeInfoResp;
import com.digiwin.athena.semc.vo.homepage.UpgradeInfoVO;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UpgradeInfoServiceImpl
implements IUpgradeInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpgradeInfoServiceImpl.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private IGmcService gmcService;
    @Resource
    private DmcService dmcService;
    @Resource
    private CacService cacService;
    @Resource
    private TranslateService translateService;
    @Resource
    private IUpgradeReadDetailService upgradeReadDetailService;
    @Resource
    private IUpgradeBrowseDetailService upgradeBrowseDetailService;
    @Resource
    private EnvProperties envProperties;
    private static final String DMC_FILE_PREVIEW_PATH = "/api/dmc/v2/file/intelligententry/preview/";

    public List<UpgradeInfoReminderDTO> getReminder() {
        Object browseTime;
        List list;
        Object currentTime;
        String key;
        List upgradeInfoDTOList = this.gmcService.getDeploy(true, null);
        if (CollectionUtils.isEmpty((Collection)upgradeInfoDTOList)) {
            return new ArrayList<UpgradeInfoReminderDTO>();
        }
        Map<String, List<UpgradeInfoDTO>> upgradeInfoGroup = upgradeInfoDTOList.stream().collect(Collectors.groupingBy(UpgradeInfoDTO::getCode));
        List appIdList = this.queryCurUserAppList();
        appIdList.add("Athena");
        List<Object> upgradeInfoList = Lists.newArrayList();
        for (Map.Entry<String, List<UpgradeInfoDTO>> entry : upgradeInfoGroup.entrySet()) {
            if (!this.cacService.verifyAppAuthorized(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), entry.getKey()) || !appIdList.contains(entry.getKey())) continue;
            upgradeInfoList.addAll((Collection<Object>)entry.getValue());
        }
        if (CollectionUtils.isEmpty((Collection)upgradeInfoList)) {
            return new ArrayList<UpgradeInfoReminderDTO>();
        }
        upgradeInfoList = upgradeInfoList.stream().sorted(Comparator.comparing(UpgradeInfoDTO::getUpdateTime).reversed()).collect(Collectors.toList());
        AtomicLong isRed = new AtomicLong(0L);
        UpgradeInfoDTO upgradeInfoDTOFirst = (UpgradeInfoDTO)upgradeInfoList.get(0);
        if (UpgradeTypeEnum.UPGRADE_INSTRUCTIONS.getValue().equals(upgradeInfoDTOFirst.getInfoLevel())) {
            key = "upgrade-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":" + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
            currentTime = this.cacheService.get(key);
            if (currentTime == null && CollectionUtils.isNotEmpty((Collection)(list = this.queryBrowseTime(UpgradePriorityEnum.COMMON_UPGRADE.getValue())))) {
                browseTime = ((UpgradeBrowseDetail)list.get(0)).getBrowseTime();
                Object object = currentTime = StringUtils.isBlank((CharSequence)browseTime) ? null : Long.valueOf(DateUtil.parseDateTime((CharSequence)browseTime).getTime());
            }
            if (Objects.isNull(currentTime) || DateUtils.compare((Date)TimeUtils.parseDate((String)upgradeInfoDTOFirst.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (Date)new Date(Long.valueOf(String.valueOf(currentTime)))) > 1) {
                isRed.set(1L);
            }
        } else if (UpgradeTypeEnum.STRONG_REMINDER.getValue().equals(upgradeInfoDTOFirst.getInfoLevel())) {
            key = "strong-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":" + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
            currentTime = this.cacheService.get(key);
            if (currentTime == null && CollectionUtils.isNotEmpty((Collection)(list = this.queryBrowseTime(UpgradePriorityEnum.STRONG_REMINDER_UPGRADE.getValue())))) {
                browseTime = ((UpgradeBrowseDetail)list.get(0)).getBrowseTime();
                Object object = currentTime = StringUtils.isBlank((CharSequence)browseTime) ? null : Long.valueOf(DateUtil.parseDateTime((CharSequence)browseTime).getTime());
            }
            if (Objects.isNull(currentTime) || DateUtils.compare((Date)TimeUtils.parseDate((String)upgradeInfoDTOFirst.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (Date)new Date(Long.valueOf(String.valueOf(currentTime)))) > 1) {
                isRed.set(1L);
            }
        } else {
            key = "impt-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":" + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
            currentTime = this.cacheService.get(key);
            if (currentTime == null && CollectionUtils.isNotEmpty((Collection)(list = this.queryBrowseTime(UpgradePriorityEnum.IMPORTANT_UPGRADE.getValue())))) {
                browseTime = ((UpgradeBrowseDetail)list.get(0)).getBrowseTime();
                Object object = currentTime = StringUtils.isBlank((CharSequence)browseTime) ? null : Long.valueOf(DateUtil.parseDateTime((CharSequence)browseTime).getTime());
            }
            if (Objects.isNull(currentTime) || DateUtils.compare((Date)TimeUtils.parseDate((String)upgradeInfoDTOFirst.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (Date)new Date(Long.valueOf(String.valueOf(currentTime)))) > 1) {
                isRed.set(1L);
            }
        }
        Map<Integer, List<UpgradeInfoDTO>> upgradeInfoMap = upgradeInfoList.stream().collect(Collectors.groupingBy(UpgradeInfoDTO::getInfoLevel));
        AtomicLong imptUpgradeCount = new AtomicLong(0L);
        AtomicLong strongUpgradeCount = new AtomicLong(0L);
        for (Map.Entry entry : upgradeInfoMap.entrySet()) {
            ((List)entry.getValue()).stream().forEach(upgradeInfoDTO -> {
                if (UpgradeTypeEnum.IMPT_GRADE.getValue().equals(entry.getKey())) {
                    List list;
                    String key = "impt-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":" + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
                    Object currentTime = this.cacheService.get(key);
                    if (currentTime == null && CollectionUtils.isNotEmpty((Collection)(list = this.queryBrowseTime(UpgradePriorityEnum.IMPORTANT_UPGRADE.getValue())))) {
                        String browseTime = ((UpgradeBrowseDetail)list.get(0)).getBrowseTime();
                        Object object = currentTime = StringUtils.isBlank((CharSequence)browseTime) ? null : Long.valueOf(DateUtil.parseDateTime((CharSequence)browseTime).getTime());
                    }
                    if (Objects.isNull(currentTime) || DateUtils.compare((Date)TimeUtils.parseDate((String)upgradeInfoDTO.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (Date)new Date(Long.valueOf(String.valueOf(currentTime)))) > 1) {
                        imptUpgradeCount.getAndIncrement();
                    }
                } else if (UpgradeTypeEnum.STRONG_REMINDER.getValue().equals(entry.getKey())) {
                    List list;
                    String key = "strong-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":" + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
                    Object currentTime = this.cacheService.get(key);
                    if (currentTime == null && CollectionUtils.isNotEmpty((Collection)(list = this.queryBrowseTime(UpgradePriorityEnum.STRONG_REMINDER_UPGRADE.getValue())))) {
                        String browseTime = ((UpgradeBrowseDetail)list.get(0)).getBrowseTime();
                        Object object = currentTime = StringUtils.isBlank((CharSequence)browseTime) ? null : Long.valueOf(DateUtil.parseDateTime((CharSequence)browseTime).getTime());
                    }
                    if (Objects.isNull(currentTime) || DateUtils.compare((Date)TimeUtils.parseDate((String)upgradeInfoDTO.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (Date)new Date(Long.valueOf(String.valueOf(currentTime)))) > 1) {
                        strongUpgradeCount.getAndIncrement();
                    }
                }
            });
        }
        ArrayList strongUpgradeResultList = Lists.newArrayList();
        if (strongUpgradeCount.get() > 0L) {
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            List readDetailList = this.upgradeReadDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"tenant_id", (Object)authoredUser.getTenantId())).eq((Object)"user_id", (Object)authoredUser.getUserId()));
            List readInfoIdList = readDetailList.stream().map(UpgradeReadDetail::getUpgradeInfoId).collect(Collectors.toList());
            List strongUpgradeInfoList = upgradeInfoList.stream().filter(upgradeInfoDTO -> {
                Optional<UpgradeInfoDTO.DetailDTO> first;
                String title = null;
                if (CollectionUtils.isNotEmpty((Collection)upgradeInfoDTO.getDetails()) && (first = upgradeInfoDTO.getDetails().stream().filter(detail -> "\u6982\u8981\u603b\u89c8".equals(detail.getTitle())).findFirst()).isPresent() && CollectionUtils.isNotEmpty((Collection)first.get().getContent())) {
                    title = ((UpgradeInfoDTO.ContentDTO)first.get().getContent().get(0)).getText();
                }
                upgradeInfoDTO.setTitle(title);
                return StringUtils.isNotBlank(title) && UpgradeTypeEnum.STRONG_REMINDER.getValue().intValue() == upgradeInfoDTO.getInfoLevel() && !readInfoIdList.contains(upgradeInfoDTO.getSid());
            }).collect(Collectors.toList());
            strongUpgradeCount.set(strongUpgradeInfoList.size());
            Map<String, List<UpgradeInfoDTO>> strongUpgradeInfoGroup = strongUpgradeInfoList.stream().collect(Collectors.groupingBy(UpgradeInfoDTO::getCode));
            for (Map.Entry<String, List<UpgradeInfoDTO>> entry : strongUpgradeInfoGroup.entrySet()) {
                String appName = "Athena".equals(entry.getValue().get(0).getName()) ? "\u5e73\u53f0\u7248\u672c" : entry.getValue().get(0).getName();
                UpgradeInfoResp upgradeInfoResp = UpgradeInfoResp.builder().code(entry.getKey()).name(this.translateService.translateTextCache(appName, "")).build();
                List upgradeInfoVOList = entry.getValue().stream().map(upgradeInfoDTO -> {
                    UpgradeInfoVO upgradeInfoVO = UpgradeInfoVO.builder().upgradeInfoId(upgradeInfoDTO.getSid()).infoLevel(upgradeInfoDTO.getInfoLevel()).updateTime(upgradeInfoDTO.getUpdateTime()).title(upgradeInfoDTO.getTitle()).build();
                    if (readInfoIdList.contains(upgradeInfoDTO.getSid())) {
                        upgradeInfoVO.setRead(true);
                    }
                    return upgradeInfoVO;
                }).collect(Collectors.toList());
                upgradeInfoResp.setUpgradeInfoList(upgradeInfoVOList);
                strongUpgradeResultList.add(upgradeInfoResp);
            }
        }
        return Lists.newArrayList((Object[])new UpgradeInfoReminderDTO[]{UpgradeInfoReminderDTO.builder().reminderType(UpgradeTypeEnum.UPGRADE_INSTRUCTIONS.getValue().intValue()).unreadCount(Long.valueOf(isRed.get())).build(), UpgradeInfoReminderDTO.builder().reminderType(UpgradeTypeEnum.IMPT_GRADE.getValue().intValue()).unreadCount(Long.valueOf(imptUpgradeCount.get())).build(), UpgradeInfoReminderDTO.builder().reminderType(UpgradeTypeEnum.STRONG_REMINDER.getValue().intValue()).unreadCount(Long.valueOf(strongUpgradeCount.get())).list((List)strongUpgradeResultList).build()});
    }

    private List<UpgradeBrowseDetail> queryBrowseTime(Integer browseType) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UpgradeBrowseDetail::getUserId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        queryWrapper.eq(UpgradeBrowseDetail::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        queryWrapper.eq(UpgradeBrowseDetail::getBrowseType, (Object)browseType);
        return this.upgradeBrowseDetailService.list((Wrapper)queryWrapper);
    }

    private List<String> queryCurUserAppList() {
        JSONArray jsonArray = this.cacService.queryCurrentUserAppList();
        List<String> appIdList = jsonArray.stream().filter(x -> {
            LinkedHashMap map = (LinkedHashMap)x;
            String expiredTime = String.valueOf(map.get("expiredTime"));
            return LocalDateTime.now().compareTo(LocalDateTime.parse(expiredTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))) < 0;
        }).map(x -> String.valueOf(((LinkedHashMap)x).get("id"))).collect(Collectors.toList());
        return appIdList;
    }

    public void closeImptReminder() {
        String currentTime = String.valueOf(System.currentTimeMillis());
        String key = "impt-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":" + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        this.cacheService.cache(key, currentTime, CacheServiceImpl.DEFAULT_DURATION);
        this.updateBrowseTime(UpgradePriorityEnum.IMPORTANT_UPGRADE.getValue(), currentTime);
    }

    public void closeUpgradeReminder() {
        String currentTime = String.valueOf(System.currentTimeMillis());
        String key = "upgrade-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":" + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        this.cacheService.cache(key, currentTime, CacheServiceImpl.DEFAULT_DURATION);
        this.updateBrowseTime(UpgradePriorityEnum.COMMON_UPGRADE.getValue(), currentTime);
    }

    private void updateBrowseTime(Integer browseType, String currentTime) {
        UpgradeBrowseDetail upgradeBrowseDetail = new UpgradeBrowseDetail();
        upgradeBrowseDetail.setUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        upgradeBrowseDetail.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        upgradeBrowseDetail.setBrowseType(browseType.intValue());
        upgradeBrowseDetail.setBrowseTime(TimeUtils.format((Date)new Date(Long.parseLong(currentTime)), (String)"yyyy-MM-dd HH:mm:ss"));
        List list = this.queryBrowseTime(browseType);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            upgradeBrowseDetail.setId(((UpgradeBrowseDetail)list.get(0)).getId());
            this.upgradeBrowseDetailService.updateById((Object)upgradeBrowseDetail);
        } else {
            upgradeBrowseDetail.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
            this.upgradeBrowseDetailService.save((Object)upgradeBrowseDetail);
        }
    }

    @Transactional
    public UpgradeInfoDetailResp queryUpgradeDetail(String upgradeInfoId) {
        UpgradeInfoDetailResp upgradeInfoDetailResp = new UpgradeInfoDetailResp();
        List upgradeInfoDTOList = this.gmcService.getDeploy(true, upgradeInfoId);
        if (CollectionUtils.isEmpty((Collection)upgradeInfoDTOList)) {
            return upgradeInfoDetailResp;
        }
        UpgradeInfoDTO upgradeInfoDTO = (UpgradeInfoDTO)upgradeInfoDTOList.get(0);
        upgradeInfoDetailResp.setDeployNote(upgradeInfoDTO.getDeployNote());
        upgradeInfoDetailResp.setUpdateTime(upgradeInfoDTO.getUpdateTime());
        upgradeInfoDetailResp.setTitle(this.translateService.translateTextCache(upgradeInfoDTO.getTitle(), ""));
        if (CollectionUtils.isEmpty((Collection)upgradeInfoDTO.getDetails())) {
            return upgradeInfoDetailResp;
        }
        List details = upgradeInfoDTO.getDetails();
        details.forEach(detailDTO -> {
            List noTextContentList = detailDTO.getContent().stream().filter(contentDTO -> StringUtils.isNotBlank((CharSequence)contentDTO.getText())).collect(Collectors.toList());
            detailDTO.setContent(noTextContentList);
        });
        List detailList = details.stream().filter(detailDTO -> CollectionUtils.isNotEmpty((Collection)detailDTO.getContent())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(detailList)) {
            return upgradeInfoDetailResp;
        }
        detailList.stream().filter(x -> "\u6982\u8981\u603b\u89c8".equals(x.getTitle())).forEach(x -> {
            UpgradeInfoDTO.ContentDTO contentDTO = (UpgradeInfoDTO.ContentDTO)x.getContent().get(0);
            x.setContent(Collections.singletonList(contentDTO));
        });
        List fileIdList = this.filterFileIdList(detailList);
        Map fileIdMap = this.queryFileInfoList(fileIdList);
        List detailVOList = detailList.stream().map(detailDTO -> {
            UpgradeInfoDetailResp.UpgradeInfoDetailVO detailVO = new UpgradeInfoDetailResp.UpgradeInfoDetailVO();
            detailVO.setTitle(this.translateService.translateTextCache(detailDTO.getTitle(), ""));
            List contentVOList = detailDTO.getContent().stream().map(contentDTO -> {
                UpgradeInfoDetailResp.ContentVO contentVO = new UpgradeInfoDetailResp.ContentVO();
                contentVO.setText(this.translateService.translateTextCache(contentDTO.getText(), upgradeInfoId));
                List pictureList = this.buildDetailFileInfo(contentDTO.getImgUrl(), fileIdMap);
                contentVO.setPicture(pictureList);
                List videoList = this.buildDetailFileInfo(contentDTO.getVideoUrl(), fileIdMap);
                contentVO.setVideo(videoList);
                List attList = this.buildDetailFileInfo(contentDTO.getAttachmentUrl(), fileIdMap);
                List pdfAttList = attList.stream().filter(x -> "pdf".equals(x.getType())).collect(Collectors.toList());
                contentVO.setAttachment(pdfAttList);
                return contentVO;
            }).collect(Collectors.toList());
            detailVO.setContent(contentVOList);
            return detailVO;
        }).collect(Collectors.toList());
        upgradeInfoDetailResp.setDetails(detailVOList);
        this.readRecord(upgradeInfoId);
        return upgradeInfoDetailResp;
    }

    private void readRecord(String upgradeInfoId) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        UpgradeReadDetail upgradeReadDetail = (UpgradeReadDetail)this.upgradeReadDetailService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)authoredUser.getUserId())).eq((Object)"tenant_id", (Object)authoredUser.getTenantId())).eq((Object)"upgrade_info_id", (Object)upgradeInfoId));
        if (Objects.isNull(upgradeReadDetail)) {
            upgradeReadDetail = UpgradeReadDetail.builder().id(Long.valueOf(SnowflakeIdWorker.getInstance().newId())).userId(authoredUser.getUserId()).tenantId(authoredUser.getTenantId()).upgradeInfoId(upgradeInfoId).build();
            this.upgradeReadDetailService.save((Object)upgradeReadDetail);
        }
    }

    private List<UpgradeInfoDetailResp.DetailFile> buildDetailFileInfo(String fileIdStr, Map<String, Object> fileIdMap) {
        ArrayList pictureList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)fileIdStr) && MapUtils.isNotEmpty(fileIdMap)) {
            String[] fileIdArray;
            for (String fileId : fileIdArray = fileIdStr.split(",")) {
                UpgradeInfoDetailResp.DetailFile detailFile = new UpgradeInfoDetailResp.DetailFile();
                detailFile.setFileId(fileId.trim());
                pictureList.add(detailFile);
                if (Objects.isNull(fileIdMap.get(fileId.trim()))) continue;
                LinkedHashMap file = (LinkedHashMap)fileIdMap.get(fileId.trim());
                detailFile.setName(String.valueOf(file.get("fileName")));
                detailFile.setType(String.valueOf(file.get("extension")));
                detailFile.setUrl(this.envProperties.getDmcUri() + DMC_FILE_PREVIEW_PATH + fileId.trim());
            }
        }
        return pictureList;
    }

    private Map<String, Object> queryFileInfoList(List<String> fileIdList) {
        if (CollectionUtils.isEmpty(fileIdList)) {
            return Maps.newHashMap();
        }
        String dmcUserToken = this.dmcService.loginDmc();
        JSONArray fileInfoArray = this.dmcService.queryFileInfoList(fileIdList, dmcUserToken);
        Map<Object, Object> fileMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)fileInfoArray)) {
            fileMap = fileInfoArray.stream().collect(Collectors.toMap(x -> {
                LinkedHashMap map = (LinkedHashMap)x;
                return String.valueOf(map.get("id"));
            }, y -> y, (a, b) -> a));
        }
        return fileMap;
    }

    private List<String> filterFileIdList(List<UpgradeInfoDTO.DetailDTO> detailList) {
        ArrayList fileIdList = Lists.newArrayList();
        detailList.forEach(detailDTO -> detailDTO.getContent().forEach(contentDTO -> {
            if (StringUtils.isNotBlank((CharSequence)contentDTO.getImgUrl())) {
                Object[] imgIdArray = contentDTO.getImgUrl().split(",").length > Constants.NUMBER_TEN ? Arrays.copyOfRange(contentDTO.getImgUrl().split(","), 0, (int)Constants.NUMBER_TEN) : contentDTO.getImgUrl().split(",");
                fileIdList.addAll(Arrays.asList(imgIdArray));
                contentDTO.setImgUrl(Joiner.on((String)",").join(imgIdArray));
            }
            if (StringUtils.isNotBlank((CharSequence)contentDTO.getVideoUrl())) {
                Object[] videoIdArray = contentDTO.getVideoUrl().split(",").length > Constants.NUMBER_FIVE ? Arrays.copyOfRange(contentDTO.getVideoUrl().split(","), 0, (int)Constants.NUMBER_FIVE) : contentDTO.getVideoUrl().split(",");
                fileIdList.addAll(Arrays.asList(videoIdArray));
                contentDTO.setVideoUrl(Joiner.on((String)",").join(videoIdArray));
            }
            if (StringUtils.isNotBlank((CharSequence)contentDTO.getAttachmentUrl())) {
                Object[] attIdArray = contentDTO.getAttachmentUrl().split(",").length > Constants.NUMBER_TEN ? Arrays.copyOfRange(contentDTO.getAttachmentUrl().split(","), 0, (int)Constants.NUMBER_TEN) : contentDTO.getAttachmentUrl().split(",");
                fileIdList.addAll(Arrays.asList(attIdArray));
                contentDTO.setAttachmentUrl(Joiner.on((String)",").join(attIdArray));
            }
        }));
        return fileIdList.stream().map(String::trim).distinct().collect(Collectors.toList());
    }

    public List<UpgradeInfoResp> queryUpgradeInfoList() {
        List upgradeInfoDTOList = this.gmcService.getDeploy(false, null);
        if (CollectionUtils.isEmpty((Collection)upgradeInfoDTOList)) {
            return new ArrayList<UpgradeInfoResp>();
        }
        List appIdList = this.queryCurUserAppList();
        appIdList.add("Athena");
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        List readDetailList = this.upgradeReadDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"tenant_id", (Object)authoredUser.getTenantId())).eq((Object)"user_id", (Object)authoredUser.getUserId()));
        List readInfoIdList = readDetailList.stream().map(UpgradeReadDetail::getUpgradeInfoId).collect(Collectors.toList());
        Map<String, List<UpgradeInfoDTO>> upgradeInfoGroup = upgradeInfoDTOList.stream().collect(Collectors.groupingBy(UpgradeInfoDTO::getCode));
        ArrayList upgradeInfoList = Lists.newArrayList();
        for (Map.Entry<String, List<UpgradeInfoDTO>> entry : upgradeInfoGroup.entrySet()) {
            if (!this.cacService.verifyAppAuthorized(authoredUser.getTenantId(), entry.getKey()) || !appIdList.contains(entry.getKey())) continue;
            String appName = "Athena".equals(entry.getValue().get(0).getName()) ? "\u5e73\u53f0\u7248\u672c" : entry.getValue().get(0).getName();
            UpgradeInfoResp upgradeInfoResp = UpgradeInfoResp.builder().code(entry.getKey()).name(this.translateService.translateTextCache(appName, "")).build();
            List upgradeInfoVOList = entry.getValue().stream().map(upgradeInfoDTO -> {
                UpgradeInfoVO upgradeInfoVO = UpgradeInfoVO.builder().upgradeInfoId(upgradeInfoDTO.getSid()).infoLevel(upgradeInfoDTO.getInfoLevel()).updateTime(upgradeInfoDTO.getUpdateTime()).build();
                if (readInfoIdList.contains(upgradeInfoDTO.getSid())) {
                    upgradeInfoVO.setRead(true);
                }
                return upgradeInfoVO;
            }).collect(Collectors.toList());
            upgradeInfoResp.setUpgradeInfoList(upgradeInfoVOList);
            upgradeInfoList.add(upgradeInfoResp);
        }
        upgradeInfoList.sort(Comparator.comparing(UpgradeInfoResp::getName));
        List athenaUpgradeList = upgradeInfoList.stream().filter(x -> "Athena".equals(x.getCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(athenaUpgradeList)) {
            upgradeInfoList.removeIf(x -> "Athena".equals(x.getCode()));
            upgradeInfoList.add(0, athenaUpgradeList.get(0));
        }
        return upgradeInfoList;
    }

    public void closeUpgradeStrongReminder() {
        String currentTime = String.valueOf(System.currentTimeMillis());
        String key = "strong-reminder:" + AppAuthContextHolder.getContext().getAuthoredUser().getUserId() + ":" + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        this.cacheService.cache(key, currentTime, CacheServiceImpl.DEFAULT_DURATION);
        this.updateBrowseTime(UpgradePriorityEnum.STRONG_REMINDER_UPGRADE.getValue(), currentTime);
    }
}

