/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.machine.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.common.CompanyFactory;
import com.digiwin.athena.semc.entity.machine.TopicPreset;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourcePreset;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.mobile.MobileDatasourcePresetMapper;
import com.digiwin.athena.semc.mapper.portal.CompanyFactoryMapper;
import com.digiwin.athena.semc.mapper.portal.TopicPresetMapper;
import com.digiwin.athena.semc.proxy.cac.service.CacService;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.machine.TopicPresetService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.common.PermissionUserFunctionalDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationModulesDTO;
import com.digiwin.athena.semc.vo.machine.TopicPresetJobResp;
import com.digiwin.athena.semc.vo.machine.TopicPresetMyAppResp;
import com.digiwin.athena.semc.vo.machine.TopicPresetResp;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TopicPresetServiceImpl
extends ServiceImpl<TopicPresetMapper, TopicPreset>
implements TopicPresetService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopicPresetServiceImpl.class);
    @Resource
    private TopicPresetMapper topicPresetMapper;
    @Resource
    private CompanyFactoryMapper companyFactoryMapper;
    @Resource
    private IamService iamService;
    @Resource
    private EnvProperties envProperties;
    @Resource
    private CacService cacService;
    @Resource
    private MobileDatasourcePresetMapper mobileDatasourcePresetMapper;

    public TopicPresetResp queryUserAuth() {
        TopicPresetResp resp = new TopicPresetResp();
        resp.setIsHavePreset(Boolean.valueOf(false));
        List topicPresetList = this.topicPresetMapper.selectList(null);
        if (CollectionUtils.isEmpty((Collection)topicPresetList)) {
            return resp;
        }
        JSONArray userAppArray = this.cacService.queryCurrentUserAppList();
        if (null == userAppArray) {
            return resp;
        }
        List enabledModules = JSONArray.parseArray((String)JSONObject.toJSONString((Object)userAppArray), UserApplicationModulesDTO.class);
        if (CollectionUtils.isEmpty((Collection)enabledModules)) {
            return resp;
        }
        List myPreList = topicPresetList.stream().filter(x -> x.getTitle().equals("\u6211\u7684\u5e94\u7528")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(myPreList)) {
            return resp;
        }
        TopicPreset myPre = (TopicPreset)myPreList.get(0);
        if (null == myPre || StringUtils.isEmpty((CharSequence)myPre.getPresetContent())) {
            return resp;
        }
        List myAppRespList = JSONArray.parseArray((String)myPre.getPresetContent(), TopicPresetMyAppResp.class);
        List moduleIdList = myAppRespList.stream().map(TopicPresetMyAppResp::getModuleId).collect(Collectors.toList());
        block0: for (UserApplicationModulesDTO modules : enabledModules) {
            long nowMilli;
            Date expiredTime;
            long expiredMilli;
            String moduleId = modules.getId() + "\u00a7";
            if (modules.getId().toLowerCase().equals("tipbiubi") || (expiredMilli = (expiredTime = DateUtils.strToDate((String)modules.getExpiredTime())).getTime()) < (nowMilli = new Date().getTime())) continue;
            for (String moduleIdStr : moduleIdList) {
                if (!moduleIdStr.contains(moduleId)) continue;
                resp.setIsHavePreset(Boolean.valueOf(true));
                continue block0;
            }
        }
        return resp;
    }

    public List<TopicPresetResp> queryAllJob(List<String> caseIdList) {
        ArrayList<TopicPresetResp> topicPresetRespList = new ArrayList<TopicPresetResp>();
        List topicPresetList = this.topicPresetMapper.selectList(null);
        if (CollectionUtils.isEmpty((Collection)topicPresetList)) {
            return topicPresetRespList;
        }
        JSONArray userAppArray = this.cacService.queryCurrentUserAppList();
        if (null == userAppArray) {
            return topicPresetRespList;
        }
        List enabledModules = JSONArray.parseArray((String)JSONObject.toJSONString((Object)userAppArray), UserApplicationModulesDTO.class);
        if (CollectionUtils.isEmpty((Collection)enabledModules)) {
            return topicPresetRespList;
        }
        Map topicPresetMap = topicPresetList.stream().collect(Collectors.toMap(TopicPreset::getTopicPresetId, Function.identity(), (a, b) -> a));
        List myPreList = topicPresetList.stream().filter(x -> x.getTitle().equals("\u6211\u7684\u5e94\u7528")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(myPreList)) {
            return topicPresetRespList;
        }
        TopicPreset myPre = (TopicPreset)myPreList.get(0);
        if (null == myPre || StringUtils.isEmpty((CharSequence)myPre.getPresetContent())) {
            return topicPresetRespList;
        }
        List myAppRespList = JSONArray.parseArray((String)myPre.getPresetContent(), TopicPresetMyAppResp.class);
        List moduleIdList = myAppRespList.stream().map(TopicPresetMyAppResp::getModuleId).collect(Collectors.toList());
        ArrayList<String> targetList = new ArrayList<String>();
        for (UserApplicationModulesDTO modules : enabledModules) {
            long nowMilli;
            String moduleId = modules.getId() + "\u00a7";
            if (modules.getId().toLowerCase().equals("tipbiubi")) continue;
            String target = "drn:iam:app:" + modules.getId();
            Date expiredTime = DateUtils.strToDate((String)modules.getExpiredTime());
            long expiredMilli = expiredTime.getTime();
            if (expiredMilli < (nowMilli = new Date().getTime())) continue;
            for (String moduleIdStr : moduleIdList) {
                if (!moduleIdStr.startsWith(moduleId) || targetList.contains(target)) continue;
                targetList.add(target);
            }
        }
        List sidList = this.getUserJobSidList(targetList);
        if (CollectionUtils.isEmpty((Collection)sidList)) {
            return topicPresetRespList;
        }
        List interSidList = new ArrayList();
        interSidList.addAll(sidList);
        if (CollectionUtils.isNotEmpty(caseIdList)) {
            interSidList = Utils.intersect((List)sidList, caseIdList);
        }
        ArrayList finalInterSidList = interSidList;
        myAppRespList = myAppRespList.stream().filter(x -> finalInterSidList.contains(x.getCaseId())).collect(Collectors.toList());
        this.packageTopicPreset(myAppRespList, topicPresetRespList, topicPresetMap);
        return topicPresetRespList;
    }

    public void packageTopicPreset(List<TopicPresetMyAppResp> myAppRespList, List<TopicPresetResp> topicPresetRespList, Map<String, TopicPreset> topicPresetMap) {
        HashMap<String, TopicPresetResp> respMap = new HashMap<String, TopicPresetResp>();
        String locale = LocaleContextHolder.getLocale().toString();
        for (TopicPresetMyAppResp myAppResp : myAppRespList) {
            TopicPreset topicPreset = topicPresetMap.get(myAppResp.getTopicpresetId());
            TopicPresetJobResp jobResp = new TopicPresetJobResp();
            jobResp.setCaseId(myAppResp.getCaseId());
            jobResp.setTopicPresetId(myAppResp.getTopicpresetId());
            String topicPresetName = this.getTopicPresetName(myAppResp.getTopicpresetName(), locale, topicPreset);
            jobResp.setTopicPresetName(topicPresetName);
            if (StringUtils.isNotEmpty((CharSequence)topicPreset.getCustomPicId())) {
                String topicPresetIcon = this.envProperties.getAppIconUrl() + topicPreset.getCustomPicId().trim();
                jobResp.setTopicPresetIcon(topicPresetIcon);
            }
            String topicPresetUrl = this.getTopicPresetUrl(locale, topicPreset, jobResp);
            jobResp.setTopicPresetUrl(topicPresetUrl);
            TopicPresetResp presetResp = (TopicPresetResp)respMap.get(myAppResp.getModuleId());
            if (null == presetResp) {
                presetResp = new TopicPresetResp();
                String moduleName = this.getModuleName(myAppResp.getModuleName(), locale, myAppResp);
                presetResp.setModuleName(moduleName);
                presetResp.setModuleId(myAppResp.getModuleId());
                ArrayList<TopicPresetJobResp> topicpPreList = new ArrayList<TopicPresetJobResp>();
                topicpPreList.add(jobResp);
                presetResp.setTopicpList(topicpPreList);
            } else {
                List topicpPreList = presetResp.getTopicpList();
                topicpPreList.add(jobResp);
                presetResp.setTopicpList(topicpPreList);
            }
            respMap.put(myAppResp.getModuleId(), presetResp);
        }
        Set entries = respMap.entrySet();
        for (Map.Entry entry : entries) {
            TopicPresetResp presetResp = new TopicPresetResp();
            String key = (String)entry.getKey();
            TopicPresetResp value = (TopicPresetResp)entry.getValue();
            presetResp.setModuleId(key);
            presetResp.setModuleName(value.getModuleName());
            presetResp.setTopicpList(value.getTopicpList());
            topicPresetRespList.add(presetResp);
        }
    }

    public String getModuleName(String moduleName, String locale, TopicPresetMyAppResp myAppResp) {
        if (null == myAppResp.getMutiPageTitle()) {
            return moduleName;
        }
        if (locale.equals("zh_CN")) {
            locale = "zh_CH";
        }
        String key = "mutiPageTitle_" + locale;
        if (StringUtils.isEmpty((CharSequence)((CharSequence)myAppResp.getMutiPageTitle().get(key)))) {
            return moduleName;
        }
        moduleName = (String)myAppResp.getMutiPageTitle().get(key);
        return moduleName;
    }

    public String getTopicPresetUrl(String locale, TopicPreset topicPreset, TopicPresetJobResp jobResp) {
        String jobUrl = "";
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        String userId = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map presetContentMap = (Map)mapper.readValue(topicPreset.getPresetContent(), Map.class);
            String url = (String)presetContentMap.get("url");
            jobUrl = this.envProperties.getAppCustomizeUrl() + Utils.getInfo((String)url, (String)userToken, (String)locale, (String)userId, (String)tenantId);
            CompanyFactory companyFactory = this.getUserCompany();
            jobResp.setIsSetCompany(Boolean.valueOf(false));
            if (null == companyFactory) {
                return jobUrl;
            }
            jobResp.setIsSetCompany(Boolean.valueOf(true));
            jobUrl = jobUrl + this.packageCompUrl(companyFactory);
        }
        catch (JsonProcessingException e) {
            log.error("getTopicPresetUrl PresetContent:{},errorMessage:{}", (Object)topicPreset.getPresetContent(), (Object)e.getMessage());
            return jobUrl;
        }
        return jobUrl;
    }

    public String packageCompUrl(CompanyFactory companyFactory) {
        String compUrl = "&enterpriseFactoryInfo=";
        JSONObject obj = new JSONObject(true);
        obj.put("thirdPartySystemId", (Object)this.envProperties.getThirdPartySystemId());
        obj.put("enterpriseId", (Object)companyFactory.getCompany());
        obj.put("factoryId", (Object)companyFactory.getFactory());
        JSONArray array = new JSONArray();
        array.add((Object)obj);
        try {
            compUrl = compUrl + URLEncoder.encode(JSONObject.toJSONString((Object)array), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("packageCompUrl URLEncoder\u62a5\u9519\uff0c e\uff1a{}", (Throwable)e);
        }
        return compUrl;
    }

    public CompanyFactory getUserCompany() {
        String userId = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getCreateUserId, (Object)userId);
        return (CompanyFactory)this.companyFactoryMapper.selectOne((Wrapper)wrapper);
    }

    public String getTopicPresetUrl(String url) {
        String locale = LocaleContextHolder.getLocale().toString();
        url = Utils.getInfo((String)url, (String)Utils.getUserToken(), (String)locale, (String)Utils.getUserId(), (String)Utils.getTenantId());
        CompanyFactory companyFactory = this.getUserCompany();
        if (null == companyFactory) {
            return url;
        }
        url = url + this.packageCompUrl(companyFactory);
        return url;
    }

    public String getTopicPresetName(String topicPresetName, String locale, TopicPreset topicPreset) {
        if (null == topicPreset) {
            return topicPresetName;
        }
        if (StringUtils.isEmpty((CharSequence)topicPreset.getPresetContent())) {
            return topicPresetName;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map presetContentMap = (Map)mapper.readValue(topicPreset.getPresetContent(), Map.class);
            String key = "title_" + locale;
            if (StringUtils.isEmpty((CharSequence)((CharSequence)presetContentMap.get(key)))) {
                return topicPresetName;
            }
            topicPresetName = (String)presetContentMap.get(key);
        }
        catch (JsonProcessingException e) {
            log.error("getTopicPresetName PresetContent:{},errorMessage:{}", (Object)topicPreset.getPresetContent(), (Object)e.getMessage());
            return topicPresetName;
        }
        return topicPresetName;
    }

    public List<String> getUserJobSidList(List<String> targetList) {
        ArrayList<String> sidList = new ArrayList<String>();
        for (String target : targetList) {
            List sIdList;
            List userFunctionalDTOS = this.iamService.queryUserFunctional(target, AppAuthContextHolder.getContext().getAuthoredUser());
            if (!CollectionUtils.isNotEmpty((Collection)userFunctionalDTOS) || !CollectionUtils.isNotEmpty(sIdList = userFunctionalDTOS.stream().map(PermissionUserFunctionalDTO::getSid).collect(Collectors.toList()))) continue;
            sidList.addAll(sIdList);
        }
        return sidList;
    }

    @Transactional
    public Integer initPresetData(String tenantId) throws JsonProcessingException {
        List topicPresetList = this.topicPresetMapper.selectList(null);
        Map topicPresetMap = topicPresetList.stream().collect(Collectors.toMap(TopicPreset::getTopicPresetId, Function.identity(), (a, b) -> a));
        List myPreList = topicPresetList.stream().filter(x -> x.getTitle().equals("\u6211\u7684\u5e94\u7528")).collect(Collectors.toList());
        TopicPreset myPre = (TopicPreset)myPreList.get(0);
        List myAppRespList = JSONArray.parseArray((String)myPre.getPresetContent(), TopicPresetMyAppResp.class);
        for (TopicPresetMyAppResp myAppResp : myAppRespList) {
            ObjectMapper mapper;
            Map presetContentMap;
            MobileDatasourcePreset preset = new MobileDatasourcePreset();
            preset.setModuleName(myAppResp.getModuleName());
            preset.setJobName(myAppResp.getTopicpresetName());
            preset.setTenantId(tenantId);
            String[] iamId = myAppResp.getModuleId().split("\u00a7");
            preset.setIamApplicationId(iamId[0]);
            preset.setIamModuleId(iamId[1]);
            preset.setSpecialSign(Integer.valueOf(1));
            TopicPreset topicPreset = (TopicPreset)topicPresetMap.get(myAppResp.getTopicpresetId());
            if (null != topicPreset && null != (presetContentMap = (Map)(mapper = new ObjectMapper()).readValue(topicPreset.getPresetContent(), Map.class))) {
                String url = (String)presetContentMap.get("url");
                String applicationConfig = this.envProperties.getAppCustomizeUrl() + url;
                preset.setApplicationConfig(applicationConfig);
            }
            this.mobileDatasourcePresetMapper.insert((Object)preset);
        }
        return null;
    }
}

