/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.menu.impl;

import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.common.EnvService;
import com.digiwin.athena.semc.service.menu.AuthService;
import com.digiwin.athena.semc.service.menu.ManageMenuService;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.menu.UserManageMenulVO;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl
implements AuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    private final IamService iamService;
    private final ManageMenuService manageMenuService;
    private final EnvService envService;

    public boolean isSuperAdmin() {
        List roleDTOList = this.iamService.queryUserRoles(Utils.getUserId(), Utils.getUserToken());
        boolean flag = roleDTOList.stream().anyMatch(x -> x.getId().equals("superadmin"));
        return flag;
    }

    public boolean hasMenuAuth(String menuKey) {
        UserManageMenulVO req = new UserManageMenulVO();
        req.setEnvironmentFlag(Integer.valueOf(0));
        req.setMenuKey(menuKey);
        req.setEnvironmentFlag(Integer.valueOf(this.envService.isOnline() ? 1 : 2));
        UserManageMenulVO userManageMenulVO = this.manageMenuService.queryUserMenuFlag(req);
        return userManageMenulVO != null && Boolean.TRUE.equals(userManageMenulVO.getIsHaveMenu());
    }

    public boolean hasAuth(String menuKey) {
        if (this.isSuperAdmin()) {
            return true;
        }
        return this.hasMenuAuth(menuKey);
    }

    @Generated
    public AuthServiceImpl(IamService iamService, ManageMenuService manageMenuService, EnvService envService) {
        this.iamService = iamService;
        this.manageMenuService = manageMenuService;
        this.envService = envService;
    }
}

