/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.menu.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.menu.DeleteMenuTemplateReq;
import com.digiwin.athena.semc.dto.menu.QueryMenuTemplateReq;
import com.digiwin.athena.semc.dto.menu.UpdateMenuTemplateReq;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.mapper.menu.CustomizedMenuTemplateMapper;
import com.digiwin.athena.semc.mapper.portal.PortalInfoMapper;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.service.menu.CustomizedMenuTemplateService;
import com.digiwin.athena.semc.service.portal.PortalInfoService;
import com.digiwin.athena.semc.service.tenant.TenantAppService;
import com.digiwin.athena.semc.service.workbench.util.WorkbenchUtils;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomizedMenuTemplateServiceImpl
extends ServiceImpl<CustomizedMenuTemplateMapper, CustomizedMenuTemplate>
implements CustomizedMenuTemplateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomizedMenuTemplateServiceImpl.class);
    @Resource
    private CustomizedMenuTemplateMapper customizedMenuTemplateMapper;
    @Resource
    private PortalInfoService portalInfoService;
    @Resource
    private PortalInfoMapper portalInfoMapper;
    @Resource
    private TenantAppService tenantAppService;
    @Autowired
    private KmService kmService;

    public PageInfoResp<CustomizedMenuTemplate> queryMenuTemplateList(QueryMenuTemplateReq queryMenuTemplateReq) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        boolean isOnlyAsa = this.tenantAppService.isOnlyAsaSalesPlan(tenantId);
        PageInfoResp pageInfoResp = new PageInfoResp();
        Integer startNum = (queryMenuTemplateReq.getPageNum() - 1) * queryMenuTemplateReq.getPageSize();
        List templateList = new ArrayList();
        templateList = isOnlyAsa ? this.customizedMenuTemplateMapper.queryTenantTempPageList(queryMenuTemplateReq.getTemplateName(), queryMenuTemplateReq.getTemplateStatus(), startNum, queryMenuTemplateReq.getPageSize(), tenantId) : this.customizedMenuTemplateMapper.queryTempPageList(queryMenuTemplateReq.getTemplateName(), queryMenuTemplateReq.getTemplateStatus(), startNum, queryMenuTemplateReq.getPageSize(), tenantId);
        if (CollectionUtils.isEmpty(templateList)) {
            return pageInfoResp;
        }
        Integer totalCount = 0;
        totalCount = isOnlyAsa ? Integer.valueOf(this.customizedMenuTemplateMapper.queryTenantTempCount(queryMenuTemplateReq.getTemplateName(), queryMenuTemplateReq.getTemplateStatus(), tenantId)) : Integer.valueOf(this.customizedMenuTemplateMapper.queryTempCount(queryMenuTemplateReq.getTemplateName(), queryMenuTemplateReq.getTemplateStatus(), tenantId));
        int totalPages = totalCount % queryMenuTemplateReq.getPageSize() == 0 ? totalCount / queryMenuTemplateReq.getPageSize() : totalCount / queryMenuTemplateReq.getPageSize() + 1;
        pageInfoResp.setTotalPages(totalPages);
        pageInfoResp.setPageNo(queryMenuTemplateReq.getPageNum().intValue());
        pageInfoResp.setPageSize(queryMenuTemplateReq.getPageSize().intValue());
        pageInfoResp.setTotalRecords(totalCount.intValue());
        if (!isOnlyAsa) {
            QueryWrapper portalInfoWrapper = new QueryWrapper();
            portalInfoWrapper.select(new String[]{"id", "menu_template_id", "name"});
            List portalInfoList = this.portalInfoMapper.selectList((Wrapper)portalInfoWrapper);
            if (CollectionUtils.isEmpty((Collection)portalInfoList)) {
                pageInfoResp.setList(templateList);
                return pageInfoResp;
            }
            Map<Long, List<PortalInfo>> menuTempIdMap = portalInfoList.stream().collect(Collectors.groupingBy(PortalInfo::getMenuTemplateId));
            templateList.forEach(x -> {
                List portalList = (List)menuTempIdMap.get(x.getId());
                if (CollectionUtils.isNotEmpty((Collection)portalList)) {
                    List nameList = portalList.stream().map(PortalInfo::getName).collect(Collectors.toList());
                    x.setPortalList(nameList);
                }
            });
        }
        pageInfoResp.setList(templateList);
        return pageInfoResp;
    }

    public List<CustomizedMenuTemplate> queryEnableMenuTemplateList() {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        boolean isOnlyAsa = this.tenantAppService.isOnlyAsaSalesPlan(tenantId);
        List templateList = new ArrayList();
        templateList = isOnlyAsa ? this.customizedMenuTemplateMapper.queryTenantEnableTempList(null, tenantId) : this.customizedMenuTemplateMapper.queryEnableTempList(null, tenantId);
        return templateList;
    }

    public Boolean updateStatus(UpdateMenuTemplateReq updateMenuTemplateReq) {
        if (updateMenuTemplateReq.getIdList().size() == Constants.NUMBER_ONE.intValue()) {
            CustomizedMenuTemplate menuTemplate = new CustomizedMenuTemplate();
            menuTemplate.setId((Long)updateMenuTemplateReq.getIdList().get(0));
            menuTemplate.setTemplateStatus(updateMenuTemplateReq.getTemplateStatus());
            menuTemplate.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            this.customizedMenuTemplateMapper.updateById((Object)menuTemplate);
        } else {
            List portalInfoList = this.portalInfoService.queryPortalByMenuTempId(updateMenuTemplateReq.getIdList());
            List idList = portalInfoList.stream().map(PortalInfo::getMenuTemplateId).distinct().collect(Collectors.toList());
            updateMenuTemplateReq.getIdList().removeAll(idList);
            if (CollectionUtils.isNotEmpty((Collection)updateMenuTemplateReq.getIdList())) {
                UpdateWrapper updateWrapper = new UpdateWrapper();
                ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"template_status", (Object)updateMenuTemplateReq.getTemplateStatus())).set((Object)"modify_user_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId())).set((Object)"modify_user_name", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserName())).set((Object)"modify_time", (Object)LocalDateTime.now());
                updateWrapper.in((Object)"id", (Collection)updateMenuTemplateReq.getIdList());
                this.update((Wrapper)updateWrapper);
            }
        }
        return true;
    }

    public Boolean deleteTemplateById(DeleteMenuTemplateReq deleteMenuTemplateReq) {
        if (deleteMenuTemplateReq.getIdList().size() == Constants.NUMBER_ONE.intValue()) {
            this.customizedMenuTemplateMapper.delete((Wrapper)new QueryWrapper().eq((Object)"id", deleteMenuTemplateReq.getIdList().get(0)));
        } else {
            List portalInfoList = this.portalInfoService.queryPortalByMenuTempId(deleteMenuTemplateReq.getIdList());
            List idList = portalInfoList.stream().map(PortalInfo::getMenuTemplateId).distinct().collect(Collectors.toList());
            deleteMenuTemplateReq.getIdList().removeAll(idList);
            if (CollectionUtils.isNotEmpty((Collection)deleteMenuTemplateReq.getIdList())) {
                this.customizedMenuTemplateMapper.delete((Wrapper)new QueryWrapper().in((Object)"id", (Collection)deleteMenuTemplateReq.getIdList()));
            }
        }
        return true;
    }

    public ResultPageBean queryPortalTempList(QueryMenuTemplateReq queryMenuTemplateReq, Long portalMenuTempId) {
        List templateList = this.customizedMenuTemplateMapper.queryEnableTempList(queryMenuTemplateReq.getTemplateName(), AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        CustomizedMenuTemplate isvMenuTemplate = null;
        if (queryMenuTemplateReq.getPortalId() != null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(CustomizedMenuTemplate::getPortalId, (Object)queryMenuTemplateReq.getPortalId());
            isvMenuTemplate = (CustomizedMenuTemplate)InterceptorIgnoreUtil.handler(() -> (CustomizedMenuTemplate)this.customizedMenuTemplateMapper.selectOne((Wrapper)wrapper));
            if (ObjectUtils.isNotEmpty((Object)isvMenuTemplate)) {
                templateList.add(isvMenuTemplate);
            }
        }
        if (CollectionUtils.isEmpty((Collection)templateList)) {
            return ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)templateList, (PageInfo)PageInfo.getPageInfo((Integer)queryMenuTemplateReq.getPageNum(), (Integer)queryMenuTemplateReq.getPageSize(), (Integer)0)));
        }
        Map templateIdMap = templateList.stream().collect(Collectors.toMap(CustomizedMenuTemplate::getId, Function.identity()));
        if (ObjectUtils.isNotEmpty((Object)portalMenuTempId) && ObjectUtils.isNotEmpty(templateIdMap.get(portalMenuTempId))) {
            ((CustomizedMenuTemplate)templateIdMap.get(portalMenuTempId)).setRelatedFlag(Boolean.TRUE);
            List relatedTemp = templateList.stream().filter(x -> x.getRelatedFlag().equals(Boolean.TRUE)).collect(Collectors.toList());
            templateList.removeIf(x -> x.getRelatedFlag().equals(Boolean.TRUE));
            CustomizedMenuTemplate current = (CustomizedMenuTemplate)relatedTemp.get(0);
            templateList.add(0, current);
            if (isvMenuTemplate != null) {
                if (portalMenuTempId.equals(isvMenuTemplate.getId())) {
                    List generalTemp = templateList.stream().filter(x -> x.getGeneralFlag().equals(Constants.GENERAL_MENU_FLAG_YES)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(generalTemp)) {
                        templateList.remove(generalTemp.get(0));
                        templateList.add(1, generalTemp.get(0));
                    }
                } else {
                    templateList.remove(isvMenuTemplate);
                    templateList.add(1, isvMenuTemplate);
                    List generalTemp = templateList.stream().filter(x -> x.getGeneralFlag().equals(Constants.GENERAL_MENU_FLAG_YES)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(generalTemp) && !current.getId().equals(((CustomizedMenuTemplate)generalTemp.get(0)).getId())) {
                        templateList.remove(generalTemp.get(0));
                        templateList.add(2, generalTemp.get(0));
                    }
                }
            } else {
                List generalTemp = templateList.stream().filter(x -> x.getGeneralFlag().equals(Constants.GENERAL_MENU_FLAG_YES)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(generalTemp) && !current.getId().equals(((CustomizedMenuTemplate)generalTemp.get(0)).getId())) {
                    templateList.remove(generalTemp.get(0));
                    templateList.add(1, generalTemp.get(0));
                }
            }
        } else {
            List generalTemp = templateList.stream().filter(x -> x.getGeneralFlag().equals(Constants.GENERAL_MENU_FLAG_YES)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(generalTemp)) {
                ((CustomizedMenuTemplate)generalTemp.get(0)).setRelatedFlag(Boolean.TRUE);
                templateList.removeIf(x -> x.getRelatedFlag().equals(Boolean.TRUE));
                templateList.add(0, generalTemp.get(0));
            }
        }
        ResultPageBean resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(templateList.stream().skip((long)(queryMenuTemplateReq.getPageNum() - 1) * queryMenuTemplateReq.getPageSize().longValue()).limit(queryMenuTemplateReq.getPageSize().intValue()).collect(Collectors.toList()), (PageInfo)PageInfo.getPageInfo((Integer)queryMenuTemplateReq.getPageNum(), (Integer)queryMenuTemplateReq.getPageSize(), (Integer)templateList.size())));
        return resultPageBean;
    }

    public Boolean validExist(Long templateId, String templateName) {
        List templateList = this.customizedMenuTemplateMapper.validExist(templateName, templateId, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        return CollectionUtils.isNotEmpty((Collection)templateList);
    }

    public CustomizedMenuTemplate queryTemplateById(Long templateId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"id", (Object)templateId);
        wrapper.in((Object)"tenant_id", (Collection)WorkbenchUtils.getTenantIds());
        return (CustomizedMenuTemplate)InterceptorIgnoreUtil.handler(() -> (CustomizedMenuTemplate)this.customizedMenuTemplateMapper.selectOne((Wrapper)wrapper));
    }

    public CustomizedMenuTemplate queryTemplateByDesignerId(Long menuDesignerId) {
        String tenantVersion = this.kmService.queryTenantVersionWithDefault();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(CustomizedMenuTemplate::getMenuDesignerId, (Object)menuDesignerId);
        wrapper.eq(CustomizedMenuTemplate::getVersion, (Object)tenantVersion);
        return (CustomizedMenuTemplate)InterceptorIgnoreUtil.handler(() -> (CustomizedMenuTemplate)this.customizedMenuTemplateMapper.selectOne((Wrapper)wrapper));
    }

    public List<CustomizedMenuTemplate> queryTemplateByIds(List<Long> templateIds) {
        return (List)InterceptorIgnoreUtil.handler(() -> this.customizedMenuTemplateMapper.selectBatchIds((Collection)templateIds));
    }

    public Boolean unusableOtherTemplate(UpdateMenuTemplateReq updateMenuTemplateReq, String tenantId) {
        this.customizedMenuTemplateMapper.updateOtherTemplateStatus((Long)updateMenuTemplateReq.getIdList().get(0), Constants.VALID_STATUS_UNUSABLE, tenantId);
        return true;
    }
}

