/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.menu.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.menu.SaveMenuReq;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuWork;
import com.digiwin.athena.semc.entity.portal.LabelSystemAuth;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.mapper.menu.CustomizedMenuTemplateMapper;
import com.digiwin.athena.semc.mapper.menu.CustomizedMenuWorkMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemCustomMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemPreMapper;
import com.digiwin.athena.semc.proxy.athena.service.audc.AudcService;
import com.digiwin.athena.semc.proxy.athena.service.audc.model.AuthorityMenuDTO;
import com.digiwin.athena.semc.proxy.athena.service.audc.model.SystemMenuDTO;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.menu.CustomizedMenuWorkService;
import com.digiwin.athena.semc.service.mobile.MobileUserAuthService;
import com.digiwin.athena.semc.service.portal.LabelSystemAuthService;
import com.digiwin.athena.semc.service.workbench.constant.PublishSourceEnum;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.common.UserAuthSystemLabelVo;
import com.digiwin.athena.semc.vo.menu.CustomizedMenuWorkResp;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.linpeilie.Converter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomizedMenuWorkServiceImpl
extends ServiceImpl<CustomizedMenuWorkMapper, CustomizedMenuWork>
implements CustomizedMenuWorkService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomizedMenuWorkServiceImpl.class);
    @Resource
    private CustomizedMenuWorkMapper customizedMenuWorkMapper;
    @Resource
    private CustomizedMenuTemplateMapper customizedMenuTemplateMapper;
    @Resource
    private LabelSystemDataMapper labelSystemDataMapper;
    @Resource
    private LabelSystemPreMapper labelSystemPreMapper;
    @Resource
    private LabelSystemCustomMapper labelSystemCustomMapper;
    @Resource
    private KmService kmService;
    @Resource
    private AudcService audcService;
    @Resource
    private TranslateService translateService;
    @Resource
    private MobileUserAuthService mobileUserAuthService;
    @Autowired
    private LabelSystemAuthService labelSystemAuthService;
    @Resource
    private Converter converter;
    public static final String ATMC_SYS_MENU_FLAG = "sysMenu";
    private static final Map<String, String> jobTypeMap = new HashMap();

    public List<CustomizedMenuWorkResp> queryManageMenu(Long templateId) {
        ArrayList menuRespList = Lists.newArrayList();
        List menuList = (List)InterceptorIgnoreUtil.handler(() -> this.customizedMenuWorkMapper.selectList((Wrapper)this.getMenuWorkWrapper(templateId)));
        if (CollectionUtils.isEmpty((Collection)menuList)) {
            return menuRespList;
        }
        for (CustomizedMenuWork menuWork : menuList) {
            if (!ObjectUtils.isEmpty((Object)menuWork.getParentId())) continue;
            CustomizedMenuWorkResp resp = (CustomizedMenuWorkResp)this.converter.convert((Object)menuWork, CustomizedMenuWorkResp.class);
            menuRespList.add(this.findChildById(resp, menuList));
        }
        return menuRespList;
    }

    private void buildLabelMenuName(List<CustomizedMenuWork> menuList) {
        List customLabelIdList;
        List preLabelIdList = menuList.stream().filter(x -> Constants.CustomizedMenuTypeEnum.LABEL.getType().equals(x.getMenuType()) && Constants.LabelTypeEnum.SYSTEM_PRE.getVal().equals(x.getMenuLabelType())).map(CustomizedMenuWork::getMenuLabelId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(preLabelIdList)) {
            List preLabelList = this.labelSystemPreMapper.selectBatchIds(preLabelIdList);
            Map preIdMap = preLabelList.stream().collect(Collectors.toMap(LabelSystemPre::getId, Function.identity(), (a, b) -> a));
            menuList.forEach(x -> {
                if (Constants.CustomizedMenuTypeEnum.LABEL.getType().equals(x.getMenuType()) && Constants.LabelTypeEnum.SYSTEM_PRE.getVal().equals(x.getMenuLabelType())) {
                    LabelSystemPre systemPre = (LabelSystemPre)preIdMap.get(x.getId());
                    x.setMenuName("zh_TW".equals(LocaleContextHolder.getLocale().toString()) && ObjectUtils.isNotEmpty((Object)systemPre) ? systemPre.getNameTw() : systemPre.getName());
                }
            });
        }
        if (CollectionUtils.isNotEmpty(customLabelIdList = menuList.stream().filter(x -> Constants.CustomizedMenuTypeEnum.LABEL.getType().equals(x.getMenuType()) && Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal().equals(x.getMenuLabelType())).map(CustomizedMenuWork::getMenuLabelId).collect(Collectors.toList()))) {
            List customLabelList = this.labelSystemCustomMapper.selectBatchIds(customLabelIdList);
            Map customIdMap = customLabelList.stream().collect(Collectors.toMap(LabelSystemCustom::getId, Function.identity(), (a, b) -> a));
            menuList.forEach(x -> {
                if (Constants.CustomizedMenuTypeEnum.LABEL.getType().equals(x.getMenuType()) && Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal().equals(x.getMenuLabelType())) {
                    LabelSystemCustom customLabel = (LabelSystemCustom)customIdMap.get(x.getId());
                    x.setMenuName(ObjectUtils.isNotEmpty((Object)customLabel) ? customLabel.getNameZh() : x.getMenuName());
                }
            });
        }
    }

    private CustomizedMenuWorkResp findChildById(CustomizedMenuWorkResp resp, List<CustomizedMenuWork> menuWorkList) {
        ArrayList childList = Lists.newArrayList();
        for (CustomizedMenuWork node : menuWorkList) {
            if (!Objects.equals(node.getParentId(), resp.getId())) continue;
            CustomizedMenuWorkResp childResp = (CustomizedMenuWorkResp)this.converter.convert((Object)node, CustomizedMenuWorkResp.class);
            childList.add(this.findChildById(childResp, menuWorkList));
        }
        resp.setChildren((List)childList);
        return resp;
    }

    @Transactional
    public Boolean saveMenu(SaveMenuReq saveMenuReq, List<CustomizedMenuWork> menuList) {
        CustomizedMenuTemplate customizedMenuTemplate;
        if (ObjectUtils.isEmpty((Object)saveMenuReq.getTemplateId())) {
            customizedMenuTemplate = new CustomizedMenuTemplate();
            this.buildTemplate(saveMenuReq, customizedMenuTemplate);
            customizedMenuTemplate.setCreateUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            this.customizedMenuTemplateMapper.insert((Object)customizedMenuTemplate);
            saveMenuReq.setTemplateId(customizedMenuTemplate.getId());
        } else {
            customizedMenuTemplate = new CustomizedMenuTemplate();
            customizedMenuTemplate.setId(saveMenuReq.getTemplateId());
            this.buildTemplate(saveMenuReq, customizedMenuTemplate);
            this.customizedMenuTemplateMapper.updateById((Object)customizedMenuTemplate);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"template_id", (Object)saveMenuReq.getTemplateId());
        this.customizedMenuWorkMapper.delete((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty(menuList)) {
            for (int i = 0; i < menuList.size(); ++i) {
                menuList.get(i).setTemplateId(saveMenuReq.getTemplateId());
                menuList.get(i).setMenuOrder(Integer.valueOf(i));
            }
            return this.saveBatch(menuList);
        }
        return true;
    }

    private void buildTemplate(SaveMenuReq saveMenuReq, CustomizedMenuTemplate customizedMenuTemplate) {
        customizedMenuTemplate.setTemplateName(saveMenuReq.getTemplateName());
        customizedMenuTemplate.setTemplateNameTw(saveMenuReq.getTemplateNameTw());
        customizedMenuTemplate.setTemplateDesc(saveMenuReq.getTemplateDesc());
        customizedMenuTemplate.setTemplateStatus(saveMenuReq.getTemplateStatus());
        customizedMenuTemplate.setSystemMenuFlag(saveMenuReq.getSystemMenuFlag());
        customizedMenuTemplate.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
    }

    public JSONObject queryDisplayMenu(Long templateId, Integer systemMenuFlag) {
        JSONObject menuResp = new JSONObject(true);
        List menuList = (List)InterceptorIgnoreUtil.handler(() -> this.customizedMenuWorkMapper.selectList((Wrapper)this.getMenuWorkWrapper(templateId)));
        for (int i = 0; i < menuList.size(); ++i) {
            ((CustomizedMenuWork)menuList.get(i)).setMenuOrder(Integer.valueOf(i));
        }
        List authorityMenuList = this.queryAuthorityJobList(menuList);
        Map<String, List<AuthorityMenuDTO>> kmTypeMap = authorityMenuList.stream().filter(x -> !ATMC_SYS_MENU_FLAG.equals(x.getType())).collect(Collectors.groupingBy(AuthorityMenuDTO::getType));
        List menuRespList = this.buildCustomMenu(menuList, kmTypeMap);
        menuResp.put("customList", (Object)menuRespList);
        if (Constants.SYSTEM_MENU_FLAG_YES.equals(systemMenuFlag)) {
            List systemCodeList = authorityMenuList.stream().filter(x -> ATMC_SYS_MENU_FLAG.equals(x.getType())).map(AuthorityMenuDTO::getCode).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(systemCodeList)) {
                List systemMenuDTOList = this.buildSystemMenu(systemCodeList);
                menuResp.put("systemList", (Object)systemMenuDTOList);
            } else {
                menuResp.put("systemList", (Object)Lists.newArrayList());
            }
        } else {
            menuResp.put("systemList", (Object)Lists.newArrayList());
        }
        return menuResp;
    }

    private List<AuthorityMenuDTO> queryAuthorityJobList(List<CustomizedMenuWork> menuList) {
        List<Object> workList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(menuList)) {
            workList = menuList.stream().filter(x -> Constants.CustomizedMenuTypeEnum.WORK.getType().equals(x.getMenuType())).collect(Collectors.toList());
        }
        JSONArray reqBody = new JSONArray();
        if (CollectionUtils.isNotEmpty((Collection)workList)) {
            Map<String, List<CustomizedMenuWork>> jobMap = workList.stream().filter(x -> !ObjectUtils.isEmpty((Object)x.getAppCode())).collect(Collectors.groupingBy(CustomizedMenuWork::getAppCode));
            jobMap.forEach((x, y) -> {
                JSONObject item = new JSONObject();
                reqBody.add((Object)item);
                JSONArray configArray = new JSONArray();
                item.put("appCode", x);
                item.put("jobCodeList", (Object)configArray);
                ArrayList existList = Lists.newArrayList();
                for (CustomizedMenuWork o : y) {
                    JSONObject jsonObject = JSONObject.parseObject((String)o.getWorkConfig());
                    if (!jsonObject.containsKey((Object)"code") || !ObjectUtils.isNotEmpty((Object)jsonObject.get((Object)"code")) || !jsonObject.containsKey((Object)"name") || !ObjectUtils.isNotEmpty((Object)jsonObject.get((Object)"name")) || !jsonObject.containsKey((Object)"type") || !ObjectUtils.isNotEmpty((Object)jsonObject.get((Object)"type"))) continue;
                    Object code = jsonObject.get((Object)"code");
                    Object name = jsonObject.get((Object)"name");
                    Object type = jsonObject.get((Object)"type");
                    StringBuilder key = new StringBuilder().append(code).append(name).append(type);
                    if (existList.contains(key.toString())) continue;
                    JSONObject configReq = new JSONObject();
                    configReq.put("code", code);
                    configReq.put("name", name);
                    String parseType = (String)jobTypeMap.get(type.toString());
                    configReq.put("type", (Object)(StringUtils.isBlank((CharSequence)parseType) ? type.toString() : parseType));
                    configArray.add((Object)configReq);
                    existList.add(key.toString());
                }
            });
        }
        if (CollectionUtils.isEmpty((Collection)reqBody)) {
            JSONObject item = new JSONObject();
            item.put("appCode", (Object)"Athena");
            reqBody.add((Object)item);
        }
        return this.audcService.queryAuthorityMenu(reqBody);
    }

    public QueryWrapper<CustomizedMenuWork> getMenuWorkWrapper(Long templateId) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"template_id", (Object)templateId);
        condition.orderByAsc((Object)"menu_order");
        condition.orderByAsc((Object)"id");
        return condition;
    }

    private List<CustomizedMenuWorkResp> buildCustomMenu(List<CustomizedMenuWork> menuList, Map<String, List<AuthorityMenuDTO>> typeMap) {
        ArrayList menuRespList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(menuList)) {
            return menuRespList;
        }
        List workLabelList = menuList.stream().filter(x -> Arrays.asList(Constants.CustomizedMenuTypeEnum.WORK.getType(), Constants.CustomizedMenuTypeEnum.LABEL.getType()).contains(x.getMenuType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(workLabelList)) {
            return menuRespList;
        }
        List workList = this.filterPermissionWorkList(typeMap, menuList);
        List permissionLabelList = this.filterPermissionLabelList(menuList);
        workList.addAll(permissionLabelList);
        if (CollectionUtils.isEmpty((Collection)workList)) {
            return menuRespList;
        }
        List<Object> finalMenuList = Lists.newArrayList();
        ArrayList menuIdList = Lists.newArrayList();
        for (CustomizedMenuWork menu : menuList) {
            boolean bl = workList.stream().anyMatch(x -> ObjectUtils.isNotEmpty((Object)x.getParentId()) && x.getParentId().equals(menu.getId()));
            if (!bl || menuIdList.contains(menu.getId())) continue;
            finalMenuList.add(menu);
            menuIdList.add(menu.getId());
        }
        List secondMenuList = finalMenuList.stream().filter(x -> Constants.CustomizedMenuLevelEnum.SECOND.getLevel().equals(x.getLevel())).collect(Collectors.toList());
        for (CustomizedMenuWork customizedMenuWork : menuList) {
            boolean matchFlag = secondMenuList.stream().anyMatch(x -> x.getParentId().equals(menu.getId()));
            if (!matchFlag || menuIdList.contains(customizedMenuWork.getId())) continue;
            finalMenuList.add(customizedMenuWork);
            menuIdList.add(customizedMenuWork.getId());
        }
        finalMenuList.addAll(workList);
        finalMenuList = finalMenuList.stream().sorted(Comparator.comparing(CustomizedMenuWork::getMenuOrder)).collect(Collectors.toList());
        for (CustomizedMenuWork customizedMenuWork : finalMenuList) {
            if (!ObjectUtils.isEmpty((Object)customizedMenuWork.getParentId())) continue;
            CustomizedMenuWorkResp resp = (CustomizedMenuWorkResp)this.converter.convert((Object)customizedMenuWork, CustomizedMenuWorkResp.class);
            menuRespList.add(this.findChildById(resp, finalMenuList));
        }
        return menuRespList;
    }

    private List<CustomizedMenuWork> filterPermissionWorkList(Map<String, List<AuthorityMenuDTO>> typeMap, List<CustomizedMenuWork> menuList) {
        if (MapUtils.isEmpty(typeMap)) {
            return Lists.newArrayList();
        }
        List<CustomizedMenuWork> workList = menuList.stream().filter(x -> Constants.CustomizedMenuTypeEnum.WORK.getType().equals(x.getMenuType())).collect(Collectors.toList());
        workList = workList.stream().filter(x -> {
            AppJobDTO.Job job = (AppJobDTO.Job)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)x.getWorkConfig()), AppJobDTO.Job.class);
            String jobType = (String)jobTypeMap.get(job.getType());
            if (MapUtils.isNotEmpty((Map)typeMap) && CollectionUtils.isNotEmpty((Collection)((Collection)typeMap.get(jobType)))) {
                List authorityList = ((List)typeMap.get(jobType)).stream().map(AuthorityMenuDTO::getCode).collect(Collectors.toList());
                return authorityList.contains(job.getCode());
            }
            return false;
        }).collect(Collectors.toList());
        return workList;
    }

    private List<CustomizedMenuWork> filterPermissionLabelList(List<CustomizedMenuWork> menuList) {
        ArrayList permissionLabelList = Lists.newArrayList();
        List customLabelList = menuList.stream().filter(x -> Constants.CustomizedMenuTypeEnum.LABEL.getType().equals(x.getMenuType()) && Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal().equals(x.getMenuLabelType())).collect(Collectors.toList());
        List preLabelList = menuList.stream().filter(x -> Constants.CustomizedMenuTypeEnum.LABEL.getType().equals(x.getMenuType()) && Constants.LabelTypeEnum.SYSTEM_PRE.getVal().equals(x.getMenuLabelType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(customLabelList) && CollectionUtils.isEmpty(preLabelList)) {
            return permissionLabelList;
        }
        Map<Object, Object> preDataTypeMap = Maps.newHashMap();
        Map<Object, Object> preIdMap = Maps.newHashMap();
        boolean flag = Boolean.TRUE;
        if (CollectionUtils.isNotEmpty(preLabelList)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(LabelSystemPre::getTenantId, (Object)Utils.getTenantId());
            wrapper.eq(LabelSystemPre::getClientType, (Object)Constants.ClientTypeTypeEnum.PC.getFlag());
            List systemPres = (List)InterceptorIgnoreUtil.handler(() -> this.labelSystemPreMapper.selectList((Wrapper)wrapper));
            preDataTypeMap = systemPres.stream().collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a));
            preIdMap = systemPres.stream().collect(Collectors.toMap(LabelSystemPre::getId, Function.identity(), (a, b) -> a));
            flag = systemPres.stream().anyMatch(x -> !Arrays.asList(Constants.DataTypeEnum.TYPE_TODO.getVal(), Constants.DataTypeEnum.TYPE_USE.getVal(), Constants.DataTypeEnum.TYPE_COLLECT.getVal(), Constants.DataTypeEnum.TYPE_INFO.getVal()).contains(x.getDataType()));
        }
        HashMap labelSystemAuthMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(customLabelList) || flag) {
            QueryWrapper condition = new QueryWrapper();
            List bizObjAuthRelList = this.labelSystemAuthService.getBaseMapper().selectList((Wrapper)this.labelSystemAuthService.getUserAuthCon(condition));
            Map<String, LabelSystemAuth> customMap = bizObjAuthRelList.stream().collect(Collectors.toMap(value -> value.getLabelId() + "-" + value.getLabelType(), value -> value, (key1, key2) -> key1));
            labelSystemAuthMap.putAll(customMap);
            HashMap finalPreIdMap = preIdMap;
            bizObjAuthRelList.stream().filter(x -> Constants.LabelTypeEnum.SYSTEM_PRE.getVal().equals(x.getLabelType())).forEach(x -> {
                if (finalPreIdMap.containsKey(x.getLabelId())) {
                    LabelSystemPre pre = (LabelSystemPre)finalPreIdMap.get(x.getLabelId());
                    labelSystemAuthMap.put(pre.getDataType() + "", x);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(customLabelList)) {
            Set customLabelIdSet = customLabelList.stream().map(CustomizedMenuWork::getMenuLabelId).collect(Collectors.toSet());
            List systemDataList = this.labelSystemDataMapper.queryBySystemIdList(customLabelIdSet);
            UserAuthSystemLabelVo authSystemLabelVo = this.mobileUserAuthService.buildSystemIdApp(systemDataList);
            this.labelSystemAuthService.addAuthLabelMap((Map)labelSystemAuthMap, authSystemLabelVo);
            Set labelKeySet = labelSystemAuthMap.keySet();
            customLabelList = customLabelList.stream().filter(x -> labelKeySet.contains(x.getMenuLabelId() + "-" + x.getMenuLabelType())).collect(Collectors.toList());
            permissionLabelList.addAll(customLabelList);
        }
        if (CollectionUtils.isNotEmpty(preLabelList)) {
            for (CustomizedMenuWork menuWork : preLabelList) {
                LabelSystemPre preLabel = null;
                preLabel = menuWork.getDataType() == null ? (LabelSystemPre)preIdMap.get(menuWork.getMenuLabelId()) : (LabelSystemPre)preDataTypeMap.get(menuWork.getDataType());
                if (ObjectUtils.isEmpty((Object)preLabel) || !Arrays.asList(Constants.DataTypeEnum.TYPE_TODO.getVal(), Constants.DataTypeEnum.TYPE_USE.getVal(), Constants.DataTypeEnum.TYPE_COLLECT.getVal(), Constants.DataTypeEnum.TYPE_INFO.getVal()).contains(preLabel.getDataType()) && !ObjectUtils.isNotEmpty(labelSystemAuthMap.get(menuWork.getMenuLabelId() + "-" + menuWork.getMenuLabelType())) && !ObjectUtils.isNotEmpty(labelSystemAuthMap.get(menuWork.getDataType() + ""))) continue;
                menuWork.setPreLabelDataType(preLabel.getDataType());
                permissionLabelList.add(menuWork);
            }
        }
        return permissionLabelList;
    }

    private List<SystemMenuDTO> buildSystemMenu(List<String> systemCodeList) {
        List systemMenuDTOList = this.audcService.querySystemMenu();
        if (CollectionUtils.isEmpty((Collection)systemMenuDTOList)) {
            return systemMenuDTOList;
        }
        ArrayList systemRespList = Lists.newArrayList();
        for (SystemMenuDTO systemMenuDTO : systemMenuDTOList) {
            if (systemMenuDTO.getIsDirectory().booleanValue()) {
                List subMenuList = systemMenuDTO.getSubMenus();
                if (CollectionUtils.isEmpty((Collection)subMenuList)) continue;
                ArrayList subSystemRespList = Lists.newArrayList();
                for (SystemMenuDTO subMenuDTO : subMenuList) {
                    if (!systemCodeList.contains(subMenuDTO.getCode())) continue;
                    subSystemRespList.add(subMenuDTO);
                }
                if (!CollectionUtils.isNotEmpty((Collection)subSystemRespList) || subSystemRespList.size() <= 0) continue;
                systemMenuDTO.setSubMenus((List)subSystemRespList);
                systemRespList.add(systemMenuDTO);
                continue;
            }
            if (!systemCodeList.contains(systemMenuDTO.getCode())) continue;
            systemRespList.add(systemMenuDTO);
        }
        return systemRespList;
    }

    public List<AppJobDTO> queryAppJobList() {
        String locale = LocaleContextHolder.getLocale().toString();
        List appJobDTOS = this.kmService.queryAppJobListBy();
        appJobDTOS.forEach(item -> {
            List datas = item.getData();
            String s = this.translateService.translateTextCache(item.getAppName(), "");
            item.setAppName(s);
            Iterator iterator = datas.iterator();
            while (iterator.hasNext()) {
                AppJobDTO.Job job = (AppJobDTO.Job)iterator.next();
                job.setAppCode(item.getAppCode());
                if (!StringUtils.isBlank((CharSequence)job.getName()) && !StringUtils.isBlank((CharSequence)job.getCode()) && !StringUtils.isBlank((CharSequence)job.getType())) continue;
                iterator.remove();
            }
        });
        return appJobDTOS;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean initData() {
        List tenantTemplates = (List)InterceptorIgnoreUtil.handler(() -> this.customizedMenuTemplateMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"publish_source", (Object)PublishSourceEnum.TENANT.name())).select(new String[]{"id", "tenant_id"})));
        if (CollectionUtils.isEmpty((Collection)tenantTemplates)) {
            log.info("initData: no TENANT templates found, skip.");
            return true;
        }
        Map<Long, String> templateTenantMap = tenantTemplates.stream().filter(t -> t.getId() != null && t.getTenantId() != null).collect(Collectors.toMap(CustomizedMenuTemplate::getId, CustomizedMenuTemplate::getTenantId, (a, b) -> a));
        if (templateTenantMap.isEmpty()) {
            log.info("initData: no template-tenant mapping found, skip.");
            return true;
        }
        Map<String, Long> tenantTodoPreIdMap = ((List)InterceptorIgnoreUtil.handler(() -> this.labelSystemPreMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"tenant_id", templateTenantMap.values())).eq((Object)"data_type", (Object)Constants.DataTypeEnum.TYPE_TODO.getVal())).eq((Object)"client_type", (Object)Constants.ClientTypeTypeEnum.PC.getFlag())).select(new String[]{"id", "tenant_id", "data_type", "client_type"})))).stream().filter(p -> p.getId() != null && p.getTenantId() != null).collect(Collectors.toMap(LabelSystemPre::getTenantId, LabelSystemPre::getId, (a, b) -> a));
        if (tenantTodoPreIdMap.isEmpty()) {
            log.info("initData: no LabelSystemPre(data_type=TODO) found for target tenants, skip.");
            return true;
        }
        Set existIds = ((List)InterceptorIgnoreUtil.handler(() -> this.customizedMenuWorkMapper.selectList((Wrapper)new QueryWrapper().select(new String[]{"id"})))).stream().map(CustomizedMenuWork::getId).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
        ArrayList<Long> allTemplateIds = new ArrayList<Long>(templateTenantMap.keySet());
        int batchSize = 200;
        for (int from = 0; from < allTemplateIds.size(); from += 200) {
            int to = Math.min(from + 200, allTemplateIds.size());
            List batchTemplateIds = allTemplateIds.subList(from, to);
            Map<Long, List<CustomizedMenuWork>> menuByTemplateId = ((List)InterceptorIgnoreUtil.handler(() -> this.customizedMenuWorkMapper.selectList((Wrapper)new QueryWrapper().in((Object)"template_id", (Collection)batchTemplateIds)))).stream().collect(Collectors.groupingBy(CustomizedMenuWork::getTemplateId));
            long currentIdCandidate = 1L;
            for (Long templateId : batchTemplateIds) {
                List<CustomizedMenuWork> oneTemplateMenus;
                boolean existTodo;
                String tenantId = templateTenantMap.get(templateId);
                Long todoPreId = tenantTodoPreIdMap.get(tenantId);
                if (todoPreId == null || (existTodo = (oneTemplateMenus = menuByTemplateId.getOrDefault(templateId, Collections.emptyList())).stream().anyMatch(x -> Constants.LabelTypeEnum.SYSTEM_PRE.getVal().equals(x.getMenuLabelType()) && (x.getDataType() != null && Objects.equals(x.getDataType(), Constants.DataTypeEnum.TYPE_TODO.getVal()) || Objects.equals(x.getMenuLabelId(), todoPreId))))) continue;
                while (existIds.contains(currentIdCandidate)) {
                    ++currentIdCandidate;
                }
                long currentId = currentIdCandidate++;
                CustomizedMenuWork todoMenu = new CustomizedMenuWork();
                todoMenu.setId(Long.valueOf(currentId));
                todoMenu.setTemplateId(templateId);
                todoMenu.setMenuIcon("23");
                todoMenu.setMenuName("\u5f85\u529e");
                todoMenu.setOriginalName("\u5f85\u529e");
                todoMenu.setMenuNameTw("\u5f85\u8fa6");
                todoMenu.setMenuType(Constants.CustomizedMenuTypeEnum.LABEL.getType());
                todoMenu.setLabelTypeSource(Constants.LabelTypeSourceEnum.TENANT.getFlag());
                todoMenu.setMenuLabelId(todoPreId);
                todoMenu.setMenuLabelType(Constants.LabelTypeEnum.SYSTEM_PRE.getVal());
                todoMenu.setLevel(Constants.CustomizedMenuLevelEnum.FIRST.getLevel());
                todoMenu.setMenuOrder(Integer.valueOf(0));
                todoMenu.setTenantId(tenantId);
                todoMenu.setDataType(null);
                long minIdOfTemplate = oneTemplateMenus.stream().map(CustomizedMenuWork::getId).filter(Objects::nonNull).min(Long::compareTo).orElse(Long.MAX_VALUE);
                if (currentId < minIdOfTemplate) {
                    InterceptorIgnoreUtil.handler(() -> this.save((Object)todoMenu));
                    existIds.add(currentId);
                    continue;
                }
                todoMenu.setId(null);
                InterceptorIgnoreUtil.handler(() -> this.save((Object)todoMenu));
                List<Long> oldIds = oneTemplateMenus.stream().map(CustomizedMenuWork::getId).filter(Objects::nonNull).collect(Collectors.toList());
                if (!oldIds.isEmpty()) {
                    InterceptorIgnoreUtil.handler(() -> this.remove((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"template_id", (Object)templateId)).in((Object)"id", (Collection)oldIds)));
                    oneTemplateMenus.forEach(x -> x.setId(null));
                    InterceptorIgnoreUtil.handler(() -> this.saveBatch((Collection)oneTemplateMenus));
                }
                oldIds.forEach(existIds::remove);
                existIds.add(todoMenu.getId());
                existIds.addAll(oneTemplateMenus.stream().map(CustomizedMenuWork::getId).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
        log.info("initData: completed initialization for TENANT templates.");
        return true;
    }

    static {
        jobTypeMap.put("baseDataEntry", "baseDataEntry");
        jobTypeMap.put("statement", "report");
        jobTypeMap.put("manualStartProject", "startProject");
    }
}

