/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.menu.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.menu.manage.SaveMenuAuthReq;
import com.digiwin.athena.semc.entity.menu.manage.ManageMenuAuth;
import com.digiwin.athena.semc.mapper.menu.manage.ManageMenuAuthMapper;
import com.digiwin.athena.semc.proxywrapper.IamUserService;
import com.digiwin.athena.semc.proxywrapper.dto.IamUserAuthInfo;
import com.digiwin.athena.semc.service.menu.ManageMenuAuthService;
import com.digiwin.athena.semc.util.Utils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ManageMenuAuthServiceImpl
extends ServiceImpl<ManageMenuAuthMapper, ManageMenuAuth>
implements ManageMenuAuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManageMenuAuthServiceImpl.class);
    @Resource
    private ManageMenuAuthMapper manageMenuAuthMapper;
    @Resource
    private IamUserService iamUserService;

    public List<ManageMenuAuth> queryAuthRelMenu(String authId) {
        QueryWrapper condition = (QueryWrapper)new QueryWrapper().eq((Object)"auth_id", (Object)authId);
        return this.manageMenuAuthMapper.selectList((Wrapper)condition);
    }

    @Transactional
    public void saveAuthRelMenu(SaveMenuAuthReq saveMenuAuthReq) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"auth_id", (Object)saveMenuAuthReq.getAuthId());
        this.manageMenuAuthMapper.delete((Wrapper)condition);
        if (Constants.ALL_AUTH_FLAG_YES.equals(saveMenuAuthReq.getAllMenuAuthFlag())) {
            ManageMenuAuth manageMenuAuth = new ManageMenuAuth();
            manageMenuAuth.setAuthId(saveMenuAuthReq.getAuthId());
            manageMenuAuth.setAuthName(saveMenuAuthReq.getAuthName());
            manageMenuAuth.setAuthType(saveMenuAuthReq.getAuthType());
            manageMenuAuth.setAllMenuAuthFlag(Constants.ALL_AUTH_FLAG_YES);
            this.save((Object)manageMenuAuth);
        } else {
            if (CollectionUtils.isEmpty((Collection)saveMenuAuthReq.getMenuKeyList())) {
                return;
            }
            List menuAuthList = saveMenuAuthReq.getMenuKeyList().stream().map(x -> {
                ManageMenuAuth manageMenuAuth = new ManageMenuAuth();
                manageMenuAuth.setMenuKey(x);
                manageMenuAuth.setAuthId(saveMenuAuthReq.getAuthId());
                manageMenuAuth.setAuthName(saveMenuAuthReq.getAuthName());
                manageMenuAuth.setAuthType(saveMenuAuthReq.getAuthType());
                return manageMenuAuth;
            }).collect(Collectors.toList());
            List partList = Lists.partition(menuAuthList, (int)500);
            for (List tempList : partList) {
                this.saveBatch((Collection)tempList);
            }
        }
    }

    public List<ManageMenuAuth> queryUserMenuList() {
        Long userSid;
        IamUserAuthInfo iamUserAuthInfo = this.iamUserService.getUserAuthSids(Utils.getUserId(), Utils.getTenantId(), Utils.getUserToken());
        ArrayList authIdList = Lists.newArrayList();
        if (iamUserAuthInfo != null && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getOrgSids())) {
            authIdList.addAll(iamUserAuthInfo.getOrgSids());
        }
        if (iamUserAuthInfo != null && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getRoleSids())) {
            authIdList.addAll(iamUserAuthInfo.getRoleSids());
        }
        if (iamUserAuthInfo != null && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getDeptSids())) {
            authIdList.addAll(iamUserAuthInfo.getDeptSids());
        }
        if (ObjectUtils.isNotEmpty((Object)(userSid = Long.valueOf(AppAuthContextHolder.getContext().getAuthoredUser().getSid())))) {
            authIdList.add(userSid);
        }
        List menuAuthList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)authIdList)) {
            Collections.sort(authIdList);
            StringBuilder authCondition = new StringBuilder("(auth_id in(" + Joiner.on((String)",").join((Iterable)authIdList) + "))");
            QueryWrapper condition = new QueryWrapper();
            condition.apply("(" + authCondition + ")", new Object[0]);
            condition.select(new String[]{"menu_key", "all_menu_auth_flag"});
            menuAuthList = this.manageMenuAuthMapper.selectList((Wrapper)condition);
        }
        return menuAuthList;
    }
}

