/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.menu.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.config.TenantAttributeDto;
import com.digiwin.athena.semc.dto.menu.manage.SaveSpecialTenantIdReq;
import com.digiwin.athena.semc.entity.menu.manage.ManageMenu;
import com.digiwin.athena.semc.entity.menu.manage.ManageMenuAuth;
import com.digiwin.athena.semc.mapper.menu.manage.ManageMenuAuthMapper;
import com.digiwin.athena.semc.mapper.menu.manage.ManageMenuMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.TenantSimpleDTO;
import com.digiwin.athena.semc.service.common.EnvService;
import com.digiwin.athena.semc.service.menu.ManageMenuAuthService;
import com.digiwin.athena.semc.service.menu.ManageMenuService;
import com.digiwin.athena.semc.service.tenant.TenantAppService;
import com.digiwin.athena.semc.service.tenant.TenantAttributeService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.MenuUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.menu.UserManageMenulVO;
import com.digiwin.athena.semc.vo.tenant.TenantSalesPlanVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ManageMenuServiceImpl
extends ServiceImpl<ManageMenuMapper, ManageMenu>
implements ManageMenuService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManageMenuServiceImpl.class);
    @Resource
    private ManageMenuMapper manageMenuMapper;
    @Resource
    private ManageMenuAuthMapper manageMenuAuthMapper;
    @Resource
    private IamService iamService;
    @Resource
    private ManageMenuAuthService manageMenuAuthService;
    @Resource
    private EnvService envService;
    @Resource
    private TenantAppService tenantAppService;
    @Resource
    private TenantAttributeService tenantAttributeService;
    public static final int ONLY_PRE_AREA_YES = 1;
    public static final int ONLY_PRE_AREA_NO = 0;

    public List<ManageMenu> queryManageMenuConfigList() {
        ArrayList manageMenuListResp = Lists.newArrayList();
        List manageMenuList = this.manageMenuMapper.selectList((Wrapper)Wrappers.emptyWrapper());
        if (CollectionUtils.isEmpty((Collection)manageMenuList)) {
            return manageMenuListResp;
        }
        manageMenuList = manageMenuList.stream().sorted(Comparator.comparing(ManageMenu::getMenuSort, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
        for (ManageMenu menu : manageMenuList) {
            if (!ObjectUtils.isEmpty((Object)menu.getParentMenuKey())) continue;
            manageMenuListResp.add(ManageMenuServiceImpl.findChildById((ManageMenu)menu, manageMenuList));
        }
        return manageMenuListResp;
    }

    private static ManageMenu findChildById(ManageMenu menu, List<ManageMenu> manageMenuList) {
        ArrayList childList = Lists.newArrayList();
        for (ManageMenu node : manageMenuList) {
            if (!Objects.equals(node.getParentMenuKey(), menu.getMenuKey())) continue;
            childList.add(ManageMenuServiceImpl.findChildById((ManageMenu)node, manageMenuList));
        }
        menu.setChildrenList((List)childList);
        return menu;
    }

    public List<ManageMenu> existMenuKey(ManageMenu manageMenu) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectUtils.isNotEmpty((Object)manageMenu.getId())) {
            queryWrapper.ne((Object)"id", (Object)manageMenu.getId());
        }
        queryWrapper.eq((Object)"menu_key", (Object)manageMenu.getMenuKey());
        return this.manageMenuMapper.selectList((Wrapper)queryWrapper);
    }

    public ManageMenu insertManageMenu(ManageMenu manageMenu) {
        String nowTime = DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss");
        manageMenu.setCreateTime(nowTime);
        manageMenu.setCreateUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        manageMenu.setModifyTime(nowTime);
        manageMenu.setModifyUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        this.manageMenuMapper.insert(manageMenu);
        return manageMenu;
    }

    public ManageMenu updateManageMenu(ManageMenu manageMenu) {
        manageMenu.setModifyTime(DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss"));
        manageMenu.setModifyUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        this.manageMenuMapper.update(manageMenu);
        return manageMenu;
    }

    @Transactional
    public void deleteByMenuKeyList(List<String> menuKeyList, List<ManageMenu> manageMenuList) {
        ArrayList allKeyList = Lists.newArrayList();
        for (String menuKey : menuKeyList) {
            allKeyList.add(menuKey);
            List childrenIds = ManageMenuServiceImpl.getAllChildrenIds((String)menuKey, manageMenuList);
            allKeyList.addAll(childrenIds);
        }
        this.manageMenuMapper.deleteByMenuKeyList((List)allKeyList);
        this.manageMenuAuthMapper.deleteByMenuKeyList((List)allKeyList);
    }

    private static List<String> getAllChildrenIds(String parentMenuKey, List<ManageMenu> manageMenuList) {
        ArrayList childrenIds = Lists.newArrayList();
        for (ManageMenu node : manageMenuList) {
            if (!ObjectUtils.isNotEmpty((Object)node.getParentMenuKey()) || !node.getParentMenuKey().equals(parentMenuKey)) continue;
            childrenIds.add(node.getMenuKey());
            childrenIds.addAll(ManageMenuServiceImpl.getAllChildrenIds((String)node.getMenuKey(), manageMenuList));
        }
        return childrenIds;
    }

    public List<ManageMenu> queryManageMenuList(Integer environmentFlag) {
        List<ManageMenu> manageMenuListResp = Lists.newArrayList();
        String version = this.getTenantVersion();
        List manageMenuList = this.queryBaseManageMenu(environmentFlag, true, version);
        if (CollectionUtils.isEmpty((Collection)manageMenuList)) {
            return manageMenuListResp;
        }
        if (CollectionUtils.isEmpty(manageMenuList = manageMenuList.stream().filter(x -> StringUtils.isBlank((CharSequence)x.getTenantId())).collect(Collectors.toList()))) {
            return manageMenuListResp;
        }
        manageMenuList = manageMenuList.stream().sorted(Comparator.comparing(ManageMenu::getMenuSort, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
        for (ManageMenu menu : manageMenuList) {
            if (!ObjectUtils.isEmpty((Object)menu.getParentMenuKey())) continue;
            manageMenuListResp.add(ManageMenuServiceImpl.findChildById((ManageMenu)menu, manageMenuList));
        }
        manageMenuListResp = this.filterParentMenu((List)manageMenuListResp);
        manageMenuListResp = this.resetNanaMenu((List)manageMenuListResp);
        return manageMenuListResp;
    }

    public List<ManageMenu> filterParentMenu(List<ManageMenu> menuList) {
        ArrayList<ManageMenu> menuNewList = new ArrayList<ManageMenu>();
        for (ManageMenu menu : menuList) {
            boolean isFilter = this.isNeedFilter(menu);
            if (isFilter) continue;
            menuNewList.add(menu);
        }
        return menuNewList;
    }

    public boolean isNeedFilter(ManageMenu menu) {
        if (menu.getMenuType().equals(Constants.ManageMenuTypeEnum.LINK.getType()) || StringUtils.isNotEmpty((CharSequence)menu.getRoutePath())) {
            return false;
        }
        if (menu.getMenuType().equals(Constants.ManageMenuTypeEnum.MENU.getType()) && StringUtils.isEmpty((CharSequence)menu.getRoutePath()) && CollectionUtils.isEmpty((Collection)menu.getChildrenList())) {
            return true;
        }
        ArrayList<ManageMenu> childrenNewList = new ArrayList<ManageMenu>();
        boolean isNeedFilteChild = true;
        for (ManageMenu childrenMenu : menu.getChildrenList()) {
            boolean isNeedChild = this.isNeedFilter(childrenMenu);
            if (!isNeedChild) {
                childrenNewList.add(childrenMenu);
            }
            if (!isNeedFilteChild) continue;
            isNeedFilteChild = isNeedChild;
        }
        menu.setChildrenList(childrenNewList);
        return isNeedFilteChild;
    }

    public List<ManageMenu> queryBaseManageMenu(Integer environmentFlag, boolean filterPre, String version) {
        QueryWrapper condition = new QueryWrapper();
        condition.and(x -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"belonging_environment_flag", (Object)Constants.MenuEnvironmentFlag.ALL.getFlag())).or()).eq((Object)"belonging_environment_flag", (Object)environmentFlag);
        });
        if (StringUtils.isNotEmpty((CharSequence)version)) {
            condition.and(x -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.isNull((Object)"version")).or()).eq((Object)"version", (Object)version);
            });
        }
        condition.eq((Object)"visible_flag", (Object)Constants.VALID_STATUS_ENABLE);
        List list = this.manageMenuMapper.selectList((Wrapper)condition);
        if (Constants.MenuEnvironmentFlag.CUSTOM.getFlag().equals(environmentFlag)) {
            return list;
        }
        if (!filterPre) {
            return list;
        }
        boolean anyMatch = list.stream().anyMatch(m -> Integer.valueOf(1).equals(m.getOnlyPreArea()));
        if (!anyMatch) {
            return list;
        }
        boolean preFlag = this.envService.tenantIsPre();
        return list.stream().filter(m -> {
            if (Integer.valueOf(0).equals(m.getOnlyPreArea())) {
                return true;
            }
            return preFlag;
        }).collect(Collectors.toList());
    }

    public List<ManageMenu> queryManageMenuTree(Integer environmentFlag) {
        List<ManageMenu> manageMenuListResp = Lists.newArrayList();
        String version = this.getTenantVersion();
        List manageMenuList = this.queryFinalManageMenu(environmentFlag, version);
        if (CollectionUtils.isEmpty((Collection)manageMenuList)) {
            return manageMenuListResp;
        }
        manageMenuList = manageMenuList.stream().sorted(Comparator.comparing(ManageMenu::getMenuSort, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
        for (ManageMenu menu : manageMenuList) {
            if (!ObjectUtils.isEmpty((Object)menu.getParentMenuKey())) continue;
            manageMenuListResp.add(ManageMenuServiceImpl.findChildById((ManageMenu)menu, manageMenuList));
        }
        manageMenuListResp = this.filterParentMenu((List)manageMenuListResp);
        manageMenuListResp = this.resetNanaMenu((List)manageMenuListResp);
        return manageMenuListResp;
    }

    private List<ManageMenu> queryFinalManageMenu(Integer environmentFlag, String version) {
        List manageMenuList = this.queryBaseManageMenu(environmentFlag, true, version);
        if (CollectionUtils.isEmpty((Collection)manageMenuList)) {
            return Lists.newArrayList();
        }
        List<ManageMenu> commonMenuList = manageMenuList.stream().filter(x -> StringUtils.isBlank((CharSequence)x.getTenantId())).collect(Collectors.toList());
        List<ManageMenu> specialMenuList = manageMenuList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getTenantId()) && x.getTenantId().equals(Utils.getTenantId()) && x.getBelongingUsers().contains(Utils.getUserId())).collect(Collectors.toList());
        List roleDTOList = this.iamService.queryUserRoles(Utils.getUserId(), Utils.getUserToken());
        boolean flag = roleDTOList.stream().anyMatch(x -> x.getId().equals("superadmin"));
        if (flag) {
            commonMenuList.addAll(specialMenuList);
            return commonMenuList;
        }
        List menuAuthList = this.manageMenuAuthService.queryUserMenuList();
        if (CollectionUtils.isEmpty((Collection)menuAuthList)) {
            return specialMenuList;
        }
        boolean allFlag = menuAuthList.stream().anyMatch(x -> Constants.ALL_AUTH_FLAG_YES.equals(x.getAllMenuAuthFlag()));
        if (allFlag) {
            commonMenuList.addAll(specialMenuList);
            return commonMenuList;
        }
        List menuKeyList = menuAuthList.stream().map(ManageMenuAuth::getMenuKey).collect(Collectors.toList());
        List specialMenuKeyList = specialMenuList.stream().map(ManageMenu::getMenuKey).collect(Collectors.toList());
        menuKeyList.addAll(specialMenuKeyList);
        List menuList = manageMenuList.stream().filter(x -> menuKeyList.contains(x.getMenuKey())).collect(Collectors.toList());
        List allMenuList = Lists.newArrayList();
        Map menuKeyMap = manageMenuList.stream().collect(Collectors.toMap(ManageMenu::getMenuKey, Function.identity(), (a, b) -> a));
        for (ManageMenu menu : menuList) {
            allMenuList.add(menu);
            List parentList = this.queryAllParentList(menu, menuKeyMap);
            allMenuList.addAll(parentList);
        }
        allMenuList = allMenuList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ManageMenu>(Comparator.comparing(ManageMenu::getMenuKey))), ArrayList::new));
        return allMenuList;
    }

    private List<ManageMenu> queryAllParentList(ManageMenu manageMenu, Map<String, ManageMenu> menuKeyMap) {
        ArrayList parentList = Lists.newArrayList();
        String parentMenuKey = manageMenu.getParentMenuKey();
        if (StringUtils.isNotBlank((CharSequence)parentMenuKey)) {
            ManageMenu parentMenu = menuKeyMap.get(parentMenuKey);
            parentList.add(parentMenu);
            parentList.addAll(this.queryAllParentList(parentMenu, menuKeyMap));
        }
        return parentList;
    }

    public String getTenantVersion() {
        String version = "";
        TenantSimpleDTO simpleDTO = this.iamService.queryTenantSimple();
        if (null == simpleDTO) {
            return version;
        }
        version = StringUtils.isEmpty((CharSequence)simpleDTO.getVersion()) ? "v1" : simpleDTO.getVersion();
        return version;
    }

    public boolean validMenuAuth(Integer environmentFlag, ManageMenu manageMenu) {
        String version = this.getTenantVersion();
        boolean flag = Boolean.FALSE;
        List manageMenuList = this.queryFinalManageMenu(environmentFlag, version);
        if (CollectionUtils.isEmpty((Collection)manageMenuList)) {
            return flag;
        }
        if (StringUtils.isNotEmpty((CharSequence)manageMenu.getVersion()) && !version.equals(manageMenu.getVersion())) {
            return flag;
        }
        Integer secondPageFlag = manageMenu.getSecondPageFlag();
        String menuKey = manageMenu.getMenuKey();
        if (Constants.SecondPageFlagEnum.NO.getFlag().equals(secondPageFlag)) {
            flag = manageMenuList.stream().anyMatch(x -> x.getMenuKey().equals(menuKey));
        } else {
            String parentMenuKey = manageMenu.getParentMenuKey();
            flag = manageMenuList.stream().anyMatch(x -> x.getMenuKey().equals(parentMenuKey));
        }
        return flag;
    }

    public void saveTenantId(SaveSpecialTenantIdReq saveSpecialTenantIdReq) {
        String str = String.join((CharSequence)",", saveSpecialTenantIdReq.getUserIdList());
        this.manageMenuMapper.updateTenantIdByIdList(saveSpecialTenantIdReq.getIdList(), saveSpecialTenantIdReq.getTenantId(), str);
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean handMenuVersion(ManageMenu manageMenu) {
        this.handParentMenuVersion(manageMenu);
        List childMenuList = this.selectManageMenu("", manageMenu.getMenuKey());
        if (CollectionUtils.isNotEmpty((Collection)childMenuList)) {
            this.handChildMenuVersion(childMenuList, manageMenu.getVersion());
            return true;
        }
        return false;
    }

    public void handChildMenuVersion(List<ManageMenu> childMenuList, String version) {
        if (CollectionUtils.isEmpty(childMenuList)) {
            return;
        }
        for (ManageMenu childMenu : childMenuList) {
            if (StringUtils.isNotEmpty((CharSequence)childMenu.getVersion())) continue;
            childMenu.setVersion(version);
            List childList = this.selectManageMenu("", childMenu.getMenuKey());
            if (CollectionUtils.isNotEmpty((Collection)childList)) {
                childMenu.setVersion(null);
            }
            this.manageMenuMapper.updateById((Object)childMenu);
            this.handChildMenuVersion(childMenu.getChildrenList(), version);
        }
    }

    public void handParentMenuVersion(ManageMenu manageMenu) {
        if (StringUtils.isNotEmpty((CharSequence)manageMenu.getParentMenuKey())) {
            List parentMenuList = this.selectManageMenu(manageMenu.getParentMenuKey(), "");
            for (ManageMenu parentMenu : parentMenuList) {
                parentMenu.setVersion(null);
                this.manageMenuMapper.updateById((Object)parentMenu);
                this.handParentMenuVersion(parentMenu);
            }
        }
    }

    public List<ManageMenu> selectManageMenu(String menuKey, String parentMenuKey) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)parentMenuKey)) {
            queryWrapper.eq((Object)"parent_menu_key", (Object)parentMenuKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)menuKey)) {
            queryWrapper.eq((Object)"menu_key", (Object)menuKey);
        }
        return this.manageMenuMapper.selectList((Wrapper)queryWrapper);
    }

    public UserManageMenulVO queryUserMenuFlag(UserManageMenulVO req) {
        UserManageMenulVO manageMenulVO = new UserManageMenulVO();
        manageMenulVO.setIsHaveMenu(Boolean.FALSE);
        String version = this.getTenantVersion();
        List manageMenuList = this.queryFinalManageMenu(req.getEnvironmentFlag(), version);
        if (CollectionUtils.isEmpty((Collection)manageMenuList)) {
            return manageMenulVO;
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getMenuKey())) {
            List menuKeyList = manageMenuList.stream().filter(x -> req.getMenuKey().equals(x.getMenuKey())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(menuKeyList)) {
                manageMenulVO.setIsHaveMenu(Boolean.TRUE);
            }
            return manageMenulVO;
        }
        for (ManageMenu manageMenu : manageMenuList) {
            if (!manageMenu.getMenuType().equals(Constants.ManageMenuTypeEnum.LINK.getType()) && !StringUtils.isNotEmpty((CharSequence)manageMenu.getRoutePath())) continue;
            manageMenulVO.setIsHaveMenu(Boolean.TRUE);
            return manageMenulVO;
        }
        return manageMenulVO;
    }

    private List<ManageMenu> resetNanaMenu(List<ManageMenu> menuTreeList) {
        try {
            TenantSalesPlanVO tenantSalesPlan = this.tenantAppService.queryTenantSalesPlan(Utils.getTenantId());
            if (Objects.nonNull(tenantSalesPlan)) {
                TenantAttributeDto nanaSalesPackageMenu;
                if ("ASA".equals(tenantSalesPlan.getSalesPlan())) {
                    TenantAttributeDto nanaSalesPackageMenu2 = this.tenantAttributeService.queryTenantAttributeByCode("nanaSalesPackageMenu");
                    if (Objects.nonNull(nanaSalesPackageMenu2) && Objects.nonNull(nanaSalesPackageMenu2.getAttributeValue()) && nanaSalesPackageMenu2.getAttributeValue() instanceof String) {
                        String menuStr = (String)nanaSalesPackageMenu2.getAttributeValue();
                        return StringUtils.isBlank((CharSequence)menuStr) ? menuTreeList : MenuUtils.resetNanaMenu(menuTreeList, (String)menuStr);
                    }
                } else if ("intelligententry".equals(tenantSalesPlan.getSalesPlan()) && Objects.nonNull(nanaSalesPackageMenu = this.tenantAttributeService.queryTenantAttributeByCode("nanaFullSalesPackageMenu")) && Objects.nonNull(nanaSalesPackageMenu.getAttributeValue()) && nanaSalesPackageMenu.getAttributeValue() instanceof String) {
                    String menuStr = (String)nanaSalesPackageMenu.getAttributeValue();
                    return StringUtils.isBlank((CharSequence)menuStr) ? menuTreeList : MenuUtils.resetNanaMenu((List)menuTreeList, (String)menuStr);
                }
            }
            return menuTreeList;
        }
        catch (Exception e) {
            log.error("resetNanaMenu is error", (Throwable)e);
            return menuTreeList;
        }
    }
}

