/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.menu.impl;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.entity.news.NewsAnnouncement;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementType;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementMapper;
import com.digiwin.athena.semc.service.cache.ICacheService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementTypeService;
import com.digiwin.athena.semc.service.news.NewsDataAssignService;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class NewsDataAssignServiceImpl
implements NewsDataAssignService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewsDataAssignServiceImpl.class);
    @Qualifier(value="semcAsyncExecutor")
    private final Executor asyncTaskExecutor;
    private final ICacheService cacheService;
    private final NewsAnnouncementMapper newsAnnouncementMapper;
    private final NewsAnnouncementTypeService newsAnnouncementTypeService;
    private static final String NEWS_DATA_ASSIGN_KEY = "NewsDataAssignKey";
    private final JdbcTemplate jdbcTemplate;

    public String startAssign(Boolean removeLockKey) {
        if (Boolean.TRUE.equals(removeLockKey)) {
            this.cacheService.delete(NEWS_DATA_ASSIGN_KEY);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cacheService.getValue(NEWS_DATA_ASSIGN_KEY))) {
            log.info("\u516c\u544a\u6570\u636e\u6b63\u5728\u521d\u59cb\u5316\uff0c\u7a0d\u540e\u8fdb\u884c\u91cd\u8bd5");
            return "\u516c\u544a\u6570\u636e\u6b63\u5728\u521d\u59cb\u5316\uff0c\u7a0d\u540e\u8fdb\u884c\u91cd\u8bd5";
        }
        this.asyncTaskExecutor.execute(() -> this.handlerAssign(removeLockKey));
        return "\u516c\u544a\u6570\u636e\u521d\u59cb\u5316\u5f00\u59cb";
    }

    private void handlerAssign(Boolean removeLockKey) {
        try {
            log.info("\u516c\u544a\u6570\u636e\u521d\u59cb\u5316\u5f00\u59cb");
            this.cacheService.cache(NEWS_DATA_ASSIGN_KEY, JSON.toJSONString((Object)removeLockKey), Duration.ofHours(4L));
            this.jdbcTemplate.execute("update t_news_announcement set news_type_path = news_type_id where news_type_path is null or news_type_path = ''");
            this.jdbcTemplate.execute("delete from t_news_announcement_auth where news_id not in (select id from t_news_announcement)");
            this.jdbcTemplate.execute("update t_news_announcement_auth a set a.news_type_id = (select b.news_type_id from t_news_announcement b where b.id = a.news_id)");
            InterceptorIgnoreUtil.handler(() -> {
                List newsAnnouncementList = this.newsAnnouncementMapper.selectList((Wrapper)Wrappers.emptyWrapper());
                Map<Long, List<NewsAnnouncement>> newsTypeIdMap = newsAnnouncementList.stream().collect(Collectors.groupingBy(NewsAnnouncement::getNewsTypeId));
                newsTypeIdMap.forEach((k, v) -> {
                    Integer totalCount = v.size();
                    Long publishedCount = v.stream().filter(x -> Constants.NewsAnnouncementStatusEnum.PUBLISHED.getFlag().equals(x.getNewsStatus())).count();
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)updateWrapper.set(NewsAnnouncementType::getNewsCount, (Object)totalCount)).set(NewsAnnouncementType::getPublishedNewsCount, (Object)publishedCount);
                    updateWrapper.eq(NewsAnnouncementType::getId, k);
                    this.newsAnnouncementTypeService.update((Wrapper)updateWrapper);
                });
            });
        }
        catch (Exception e) {
            log.error("\u516c\u544a\u6570\u636e\u521d\u59cb\u5316\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)removeLockKey), (Object)e);
        }
        finally {
            this.cacheService.delete(NEWS_DATA_ASSIGN_KEY);
            log.info("\u516c\u544a\u6570\u636e\u521d\u59cb\u5316\u7ed3\u675f");
        }
    }

    @Generated
    public NewsDataAssignServiceImpl(@Qualifier(value="semcAsyncExecutor") Executor asyncTaskExecutor, ICacheService cacheService, NewsAnnouncementMapper newsAnnouncementMapper, NewsAnnouncementTypeService newsAnnouncementTypeService, JdbcTemplate jdbcTemplate) {
        this.asyncTaskExecutor = asyncTaskExecutor;
        this.cacheService = cacheService;
        this.newsAnnouncementMapper = newsAnnouncementMapper;
        this.newsAnnouncementTypeService = newsAnnouncementTypeService;
        this.jdbcTemplate = jdbcTemplate;
    }
}

