/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.menu.impl;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.semc.dto.menu.manage.UserMenuDataTransferReqDTO;
import com.digiwin.athena.semc.entity.menu.manage.ManageMenuAuth;
import com.digiwin.athena.semc.mapper.menu.manage.ManageMenuAuthMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.req.UserAllPermissionReqDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.resp.AppTenantRespVO;
import com.digiwin.athena.semc.proxy.iam.service.model.resp.TenantUserRespVO;
import com.digiwin.athena.semc.proxy.iam.service.model.resp.UserAllPermissionBaseRespVO;
import com.digiwin.athena.semc.service.cache.ICacheService;
import com.digiwin.athena.semc.service.menu.UserMenuDataTransferService;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class UserMenuDataTransferServiceImpl
implements UserMenuDataTransferService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserMenuDataTransferServiceImpl.class);
    @Qualifier(value="semcAsyncExecutor")
    private final Executor asyncTaskExecutor;
    private final ICacheService cacheService;
    private final IamService iamService;
    private final ManageMenuAuthMapper manageMenuAuthMapper;
    private static final String USER_MENU_DATA_TRANSFER_KEY = "UserMenuDataTransferKey";
    private static final String IT_MAINTENANCE = "it-maintenance";
    private static final String AUTHORIZATION_CODE = "authorization-code";
    private static final String CARD_LOGIN_MANAGE = "card-login-manage";
    private static final String ALLOW = "allow";
    private static final Map<String, String> USER_MENU_DATA_TRANSFER_COMMON_MAP = new /* Unavailable Anonymous Inner Class!! */;

    public String startTransfer(UserMenuDataTransferReqDTO reqDTO) {
        if (Boolean.TRUE.equals(reqDTO.getRemoveLockKey())) {
            this.cacheService.delete(USER_MENU_DATA_TRANSFER_KEY);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cacheService.getValue(USER_MENU_DATA_TRANSFER_KEY))) {
            log.info("\u7528\u6237\u83dc\u5355\u6b63\u5728\u8fc1\u79fb\uff0c\u7a0d\u540e\u8fdb\u884c\u91cd\u8bd5");
            return "\u7528\u6237\u83dc\u5355\u6b63\u5728\u8fc1\u79fb\uff0c\u7a0d\u540e\u8fdb\u884c\u91cd\u8bd5";
        }
        if (StringUtils.isNotBlank((CharSequence)reqDTO.getUserId()) && StringUtils.isBlank((CharSequence)reqDTO.getTenantSid())) {
            log.info("\u53c2\u6570\u6709\u8bef\uff0c\u6307\u5b9a\u7528\u6237\u65f6\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
            return "\u53c2\u6570\u6709\u8bef\uff0c\u6307\u5b9a\u7528\u6237\u65f6\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a";
        }
        this.asyncTaskExecutor.execute(() -> this.handlerTransfer(reqDTO));
        return "\u7528\u6237\u83dc\u5355\u5f00\u59cb\u8fc1\u79fb";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlerTransfer(UserMenuDataTransferReqDTO reqDTO) {
        try {
            log.info("\u7528\u6237\u83dc\u5355\u8fc1\u79fb\u5f00\u59cb");
            String appId = "Athena";
            this.cacheService.cache(USER_MENU_DATA_TRANSFER_KEY, JSON.toJSONString((Object)reqDTO), Duration.ofHours(4L));
            List appTenantRespVOList = this.iamService.queryBuyTenantListByAppId(appId);
            if (CollectionUtils.isEmpty((Collection)appTenantRespVOList)) {
                log.info("\u67e5\u8be2\u8d2d\u4e70\u4e86\u6307\u5b9a\u5e94\u7528\u7684\u79df\u6237id\u4e3a\u7a7a\uff1a{}", (Object)appId);
                return;
            }
            for (AppTenantRespVO appTenantRespVO : appTenantRespVOList) {
                String tenantSid = appTenantRespVO.getSid();
                String tenantId = appTenantRespVO.getId();
                if (StringUtils.isNotBlank((CharSequence)reqDTO.getTenantSid()) && !reqDTO.getTenantSid().equals(tenantSid)) continue;
                List tenantUserRespVOList = this.iamService.queryUserListByTenantId(tenantSid);
                if (CollectionUtils.isEmpty((Collection)tenantUserRespVOList)) {
                    log.info("\u83b7\u53d6\u79df\u6237\u4e0b\u7528\u6237\u5217\u8868\u4e3a\u7a7a\uff1a{}", (Object)tenantSid);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)reqDTO.getUserId())) {
                    tenantUserRespVOList.stream().filter(m -> m.getId().equals(reqDTO.getUserId())).findFirst().ifPresent(tenantUserRespVO -> this.handlerUserMenuTransfer(tenantUserRespVO, tenantId));
                    break;
                }
                for (TenantUserRespVO tenantUserRespVO2 : tenantUserRespVOList) {
                    this.handlerUserMenuTransfer(tenantUserRespVO2, tenantId);
                }
            }
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u83dc\u5355\u8fc1\u79fb\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)reqDTO), (Object)e);
        }
        finally {
            this.cacheService.delete(USER_MENU_DATA_TRANSFER_KEY);
            log.info("\u7528\u6237\u83dc\u5355\u8fc1\u79fb\u7ed3\u675f");
        }
    }

    private void handlerUserMenuTransfer(TenantUserRespVO tenantUserRespVO, String tenantId) {
        String userId = tenantUserRespVO.getId();
        UserAllPermissionReqDTO userAllPermissionReqDTO = new UserAllPermissionReqDTO();
        userAllPermissionReqDTO.setUserId(userId);
        userAllPermissionReqDTO.setTenantId(tenantId);
        UserAllPermissionBaseRespVO userAllPermissionBaseRespVO = this.iamService.queryUserAllPermission(userAllPermissionReqDTO);
        if (userAllPermissionBaseRespVO == null || userAllPermissionBaseRespVO.getResult() == null) {
            log.info("\u83b7\u53d6\u7528\u6237\u7684\u529f\u80fd\u6743\u9650\u4e3a\u7a7a\uff1a{}", (Object)userId);
            return;
        }
        List permissionList = userAllPermissionBaseRespVO.getResult().getPermissions();
        List modules = userAllPermissionBaseRespVO.getResult().getModules();
        Map moduleMap = modules.stream().collect(Collectors.toMap(UserAllPermissionBaseRespVO.Module::getId, Function.identity(), (v1, v2) -> v1));
        if (CollectionUtils.isEmpty((Collection)permissionList)) {
            log.info("\u83b7\u53d6\u7528\u6237\u7684\u529f\u80fd\u6743\u9650\u96c6\u5408\u4e3a\u7a7a\uff1a{}", (Object)userId);
            return;
        }
        this.handlerItMainTenance(moduleMap, permissionList, tenantUserRespVO, tenantId);
        for (UserAllPermissionBaseRespVO.Permission permission : permissionList) {
            if (!USER_MENU_DATA_TRANSFER_COMMON_MAP.containsKey(permission.getId())) continue;
            if (!ALLOW.equals(permission.getEffect())) {
                log.info("\u7528\u6237\u8be5\u83dc\u5355\u6ca1\u6709\u6743\u9650\u8df3\u8fc7\uff1a{}\uff0c{}\uff0c{}", new Object[]{userId, permission.getId(), permission.getName()});
                continue;
            }
            this.saveManageMenuAuth(tenantUserRespVO, tenantId, permission);
        }
    }

    private void handlerItMainTenance(Map<String, UserAllPermissionBaseRespVO.Module> moduleMap, List<UserAllPermissionBaseRespVO.Permission> permissionList, TenantUserRespVO tenantUserRespVO, String tenantId) {
        UserAllPermissionBaseRespVO.Module module = moduleMap.get(IT_MAINTENANCE);
        if (module == null) {
            return;
        }
        if (!ALLOW.equals(module.getEffect())) {
            return;
        }
        boolean anyMatch = permissionList.stream().anyMatch(m -> m.getModuleId().equals(IT_MAINTENANCE) && m.getId().equals("module-enable") && m.getEffect().equals(ALLOW));
        if (!anyMatch) {
            return;
        }
        UserAllPermissionBaseRespVO.Permission permission = new UserAllPermissionBaseRespVO.Permission();
        permission.setModuleId(IT_MAINTENANCE);
        permission.setId(IT_MAINTENANCE);
        this.saveManageMenuAuth(tenantUserRespVO, tenantId, permission);
    }

    private void saveManageMenuAuth(TenantUserRespVO tenantUserRespVO, String tenantId, UserAllPermissionBaseRespVO.Permission permission) {
        ManageMenuAuth manageMenuAuth = new ManageMenuAuth();
        manageMenuAuth.setMenuKey(permission.getId());
        if (permission.getId().equals(AUTHORIZATION_CODE) || permission.getId().equals(CARD_LOGIN_MANAGE)) {
            manageMenuAuth.setMenuKey("user-card");
        }
        manageMenuAuth.setAuthId(tenantUserRespVO.getSid());
        manageMenuAuth.setAuthName(tenantUserRespVO.getName());
        manageMenuAuth.setAuthType(Integer.valueOf(3));
        manageMenuAuth.setTenantId(tenantId);
        manageMenuAuth.setDelFlag(Integer.valueOf(0));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ManageMenuAuth::getMenuKey, (Object)manageMenuAuth.getMenuKey());
        queryWrapper.eq(ManageMenuAuth::getAuthId, (Object)manageMenuAuth.getAuthId());
        queryWrapper.eq(ManageMenuAuth::getTenantId, (Object)manageMenuAuth.getTenantId());
        queryWrapper.eq(ManageMenuAuth::getAuthType, (Object)manageMenuAuth.getAuthType());
        InterceptorIgnoreUtil.handler(() -> {
            Long count = this.manageMenuAuthMapper.selectCount((Wrapper)queryWrapper);
            if (count != null && count <= 0L) {
                this.manageMenuAuthMapper.insert((Object)manageMenuAuth);
            }
        });
    }

    @Generated
    public UserMenuDataTransferServiceImpl(@Qualifier(value="semcAsyncExecutor") Executor asyncTaskExecutor, ICacheService cacheService, IamService iamService, ManageMenuAuthMapper manageMenuAuthMapper) {
        this.asyncTaskExecutor = asyncTaskExecutor;
        this.cacheService = cacheService;
        this.iamService = iamService;
        this.manageMenuAuthMapper = manageMenuAuthMapper;
    }
}

