/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.message.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.dto.message.SaveBlackWhiteReq;
import com.digiwin.athena.semc.entity.message.MessageBlackWhite;
import com.digiwin.athena.semc.mapper.message.MessageBlackWhiteMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.RoleDTO;
import com.digiwin.athena.semc.service.message.MessageBlackWhiteService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessageBlackWhiteServiceImpl
extends ServiceImpl<MessageBlackWhiteMapper, MessageBlackWhite>
implements MessageBlackWhiteService {
    @Resource
    private MessageBlackWhiteMapper messageBlackWhiteMapper;
    @Resource
    private IamService iamService;

    public List<MessageBlackWhite> queryUserList(Integer type, String key, String tenantId) {
        List blackWhiteList;
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        }
        if (CollectionUtils.isEmpty((Collection)(blackWhiteList = this.messageBlackWhiteMapper.queryUserListByCondition(tenantId, type, StringUtils.isNotBlank((CharSequence)key) ? key.trim() : key)))) {
            return blackWhiteList;
        }
        if (type != null) {
            List userList = this.iamService.queryAllUserList();
            Map<String, String> idMap = userList.stream().collect(Collectors.toMap(RoleDTO::getId, RoleDTO::getName));
            blackWhiteList.forEach(x -> {
                if (idMap.get(x.getUserId()) != null) {
                    x.setUserName((String)idMap.get(x.getUserId()));
                }
            });
            this.saveOrUpdateBatch((Collection)blackWhiteList);
        }
        return blackWhiteList;
    }

    public void delUser(Long id) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"id", (Object)id);
        this.messageBlackWhiteMapper.delete((Wrapper)wrapper);
    }

    @Transactional
    public void saveUser(SaveBlackWhiteReq saveBlackWhiteReq) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"type", (Object)saveBlackWhiteReq.getType());
        if (CollectionUtils.isEmpty((Collection)saveBlackWhiteReq.getUserList())) {
            this.messageBlackWhiteMapper.delete((Wrapper)wrapper);
            return;
        }
        List idList = saveBlackWhiteReq.getUserList().stream().map(SaveBlackWhiteReq.UserDTO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(idList)) {
            wrapper.notIn((Object)"id", idList);
        }
        this.messageBlackWhiteMapper.delete((Wrapper)wrapper);
        List userIdList = saveBlackWhiteReq.getUserList().stream().filter(x -> x.getId() != null).map(SaveBlackWhiteReq.UserDTO::getUserId).collect(Collectors.toList());
        List userList = saveBlackWhiteReq.getUserList().stream().filter(x -> x.getId() == null).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        ArrayList blackWhiteList = Lists.newArrayList();
        for (SaveBlackWhiteReq.UserDTO userDTO : userList) {
            if (userIdList.contains(userDTO.getUserId())) continue;
            userIdList.add(userDTO.getUserId());
            MessageBlackWhite blackWhite = new MessageBlackWhite();
            blackWhite.setUserSid(userDTO.getUserSid());
            blackWhite.setUserId(userDTO.getUserId());
            blackWhite.setUserName(userDTO.getUserName());
            blackWhite.setTenantId(tenantId);
            blackWhite.setType(saveBlackWhiteReq.getType());
            blackWhiteList.add(blackWhite);
        }
        if (CollectionUtils.isNotEmpty((Collection)blackWhiteList)) {
            this.saveBatch((Collection)blackWhiteList);
        }
    }
}

