/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.message.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.entity.message.MessageChannel;
import com.digiwin.athena.semc.mapper.message.MessageChannelMapper;
import com.digiwin.athena.semc.proxy.aim.service.AimService;
import com.digiwin.athena.semc.service.message.MessageChannelService;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class MessageChannelServiceImpl
extends ServiceImpl<MessageChannelMapper, MessageChannel>
implements MessageChannelService {
    @Resource
    private MessageChannelMapper messageChannelMapper;
    @Resource
    private AimService aimService;
    public static final int CHANNEL_LEVEL_TENANT = 1;
    public static final int CHANNEL_LEVEL_USER = 2;

    public MessageChannel queryChannel(String userId, String tenantId) {
        if (StringUtils.isEmpty((String)tenantId)) {
            tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        }
        int channelLevel = StringUtils.isNotBlank((String)userId) ? 2 : 1;
        return this.messageChannelMapper.queryChannelByCondition(tenantId, userId, Integer.valueOf(channelLevel));
    }

    public String queryChannelFlag(String userId, String tenantId) {
        int channelLevel;
        String result;
        if (StringUtils.isEmpty((String)tenantId)) {
            tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        }
        if (StringUtils.isBlank((String)(result = this.messageChannelMapper.queryChannelFlagByCondition(tenantId, userId, Integer.valueOf(channelLevel = StringUtils.isNotBlank((String)userId) ? 2 : 1))))) {
            return "";
        }
        return result;
    }

    public Long saveChannel(String channelStr) {
        MessageChannel messageChannel = this.queryChannel(null, "");
        if (messageChannel == null) {
            messageChannel = new MessageChannel();
            messageChannel.setChannelFlag(channelStr);
            this.messageChannelMapper.insert((Object)messageChannel);
            this.aimService.removeMessageChannel(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            return messageChannel.getId();
        }
        messageChannel.setChannelFlag(channelStr);
        this.messageChannelMapper.updateById((Object)messageChannel);
        this.aimService.removeMessageChannel(messageChannel.getTenantId());
        return messageChannel.getId();
    }
}

