/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.message.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.message.CopyTemplateReq;
import com.digiwin.athena.semc.dto.message.QueryTemplateListReq;
import com.digiwin.athena.semc.dto.message.QueryTemplateListResp;
import com.digiwin.athena.semc.dto.message.QueryTemplateRelResp;
import com.digiwin.athena.semc.dto.message.SaveTemplateReq;
import com.digiwin.athena.semc.dto.message.TemplateRelReq;
import com.digiwin.athena.semc.entity.message.DingtalkTemplateRel;
import com.digiwin.athena.semc.entity.message.EmailTemplateRel;
import com.digiwin.athena.semc.entity.message.MessageChannelTemplate;
import com.digiwin.athena.semc.entity.message.SmsTemplateRel;
import com.digiwin.athena.semc.entity.message.WecomTemplateRel;
import com.digiwin.athena.semc.mapper.message.DingtalkTemplateRelMapper;
import com.digiwin.athena.semc.mapper.message.EmailTemplateRelMapper;
import com.digiwin.athena.semc.mapper.message.MessageChannelTemplateMapper;
import com.digiwin.athena.semc.mapper.message.SmsTemplateRelMapper;
import com.digiwin.athena.semc.mapper.message.WecomTemplateRelMapper;
import com.digiwin.athena.semc.proxy.emc.service.EmcService;
import com.digiwin.athena.semc.proxy.emc.service.model.OmEventResp;
import com.digiwin.athena.semc.proxy.emc.service.model.OmEventTemplateDTO;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.message.DingtalkTemplateRelService;
import com.digiwin.athena.semc.service.message.EmailTemplateRelService;
import com.digiwin.athena.semc.service.message.MessageChannelTemplateService;
import com.digiwin.athena.semc.service.message.SmsTemplateRelService;
import com.digiwin.athena.semc.service.message.WecomTemplateRelService;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessageChannelTemplateServiceImpl
extends ServiceImpl<MessageChannelTemplateMapper, MessageChannelTemplate>
implements MessageChannelTemplateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageChannelTemplateServiceImpl.class);
    @Resource
    private MessageChannelTemplateMapper messageChannelTemplateMapper;
    @Resource
    private EmailTemplateRelService emailTemplateRelService;
    @Resource
    private EmailTemplateRelMapper emailTemplateRelMapper;
    @Resource
    private SmsTemplateRelService smsTemplateRelService;
    @Resource
    private SmsTemplateRelMapper smsTemplateRelMapper;
    @Resource
    private WecomTemplateRelService wecomTemplateRelService;
    @Resource
    private WecomTemplateRelMapper wecomTemplateRelMapper;
    @Resource
    private DingtalkTemplateRelService dingtalkTemplateRelService;
    @Resource
    private DingtalkTemplateRelMapper dingtalkTemplateRelMapper;
    @Resource
    private EmcService emcService;
    @Resource
    private IamService iamService;
    public static final int EVENT_LIST_LENGTH_ONE = 1;

    public List<QueryTemplateListResp> queryTemplateList(QueryTemplateListReq queryTemplateListReq) {
        List<Object> templateListRespList = Lists.newArrayList();
        List omEventList = this.emcService.queryOmTemplateList(queryTemplateListReq.getChannelFlag(), queryTemplateListReq.getNameCondition());
        if (CollectionUtils.isEmpty((Collection)(omEventList = this.filterEvent(queryTemplateListReq, omEventList)))) {
            return templateListRespList;
        }
        String tenantId = StringUtils.isBlank((CharSequence)queryTemplateListReq.getTenantId()) ? AppAuthContextHolder.getContext().getAuthoredUser().getTenantId() : queryTemplateListReq.getTenantId();
        List eventIdList = omEventList.stream().map(OmEventResp::getId).collect(Collectors.toList());
        List templateList = this.messageChannelTemplateMapper.queryTemplateByCondition(tenantId, null, queryTemplateListReq.getChannelFlag(), eventIdList);
        Integer previewType = Constants.PreviewTypeEnum.parseTypeByFlag((String)queryTemplateListReq.getChannelFlag());
        if (CollectionUtils.isEmpty((Collection)templateList)) {
            templateListRespList = omEventList.stream().map(x -> {
                QueryTemplateListResp resp = new QueryTemplateListResp();
                resp.setEventId(x.getId());
                resp.setName(x.getName());
                resp.setRemark(x.getDescription());
                resp.setChannelFlag(queryTemplateListReq.getChannelFlag());
                resp.setValidStatus(Constants.VALID_STATUS_ENABLE);
                resp.setModifyUserName(x.getModifyBy());
                resp.setModifyTime(x.getModifyDate());
                x.getTemplates().forEach(y -> y.setPreviewType(previewType));
                resp.setTemplateList(x.getTemplates());
                return resp;
            }).collect(Collectors.toList());
            templateListRespList = templateListRespList.stream().sorted(Comparator.comparing(QueryTemplateListResp::getModifyTime, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
            if (queryTemplateListReq.getStatus() != null) {
                templateListRespList = templateListRespList.stream().filter(x -> x.getValidStatus().equals(queryTemplateListReq.getStatus())).collect(Collectors.toList());
            }
        } else {
            List parentList = templateList.stream().filter(x -> x.getParentId() == null).collect(Collectors.toList());
            Map eventIdMap = parentList.stream().collect(Collectors.toMap(MessageChannelTemplate::getEventId, Function.identity(), (a, b) -> a));
            templateListRespList = omEventList.stream().map(x -> {
                QueryTemplateListResp resp = new QueryTemplateListResp();
                resp.setEventId(x.getId());
                resp.setName(x.getName());
                resp.setRemark(x.getDescription());
                resp.setChannelFlag(queryTemplateListReq.getChannelFlag());
                resp.setValidStatus(Constants.VALID_STATUS_ENABLE);
                resp.setModifyUserName(x.getModifyBy());
                resp.setModifyTime(x.getModifyDate());
                MessageChannelTemplate template = (MessageChannelTemplate)eventIdMap.get(x.getId());
                if (template != null) {
                    resp.setId(template.getId());
                    resp.setParentId(template.getParentId());
                    resp.setValidStatus(template.getValidStatus());
                    resp.setRemark(template.getRemark());
                    if (StringUtils.isBlank((CharSequence)x.getModifyDate()) || template.getModifyTime().compareTo(x.getModifyDate()) > 0) {
                        resp.setModifyUserId(template.getModifyUserId());
                        resp.setModifyUserName(template.getModifyUserName());
                        resp.setModifyTime(template.getModifyTime());
                    }
                }
                x.getTemplates().forEach(y -> y.setPreviewType(previewType));
                resp.setTemplateList(x.getTemplates());
                return resp;
            }).collect(Collectors.toList());
            templateListRespList = templateListRespList.stream().sorted(Comparator.comparing(QueryTemplateListResp::getModifyTime, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
            if (queryTemplateListReq.getStatus() != null) {
                templateListRespList = templateListRespList.stream().filter(x -> x.getValidStatus().equals(queryTemplateListReq.getStatus())).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(templateListRespList)) {
                return templateListRespList;
            }
            List parentIdList = templateListRespList.stream().map(QueryTemplateListResp::getId).filter(Objects::nonNull).collect(Collectors.toList());
            Map omEventIdMap = omEventList.stream().collect(Collectors.toMap(OmEventResp::getId, Function.identity(), (a, b) -> a));
            List childList = templateList.stream().filter(x -> x.getParentId() != null).collect(Collectors.toList());
            List<Object> childRespList = Lists.newArrayList();
            for (MessageChannelTemplate x2 : childList) {
                if (!parentIdList.contains(x2.getParentId())) continue;
                QueryTemplateListResp resp = new QueryTemplateListResp();
                resp.setId(x2.getId());
                resp.setEventId(x2.getEventId());
                resp.setRemark(x2.getRemark());
                resp.setValidStatus(x2.getValidStatus());
                resp.setChannelFlag(queryTemplateListReq.getChannelFlag());
                resp.setParentId(x2.getParentId());
                resp.setModifyUserId(x2.getModifyUserId());
                resp.setModifyUserName(x2.getModifyUserName());
                resp.setModifyTime(x2.getModifyTime());
                OmEventResp eventResp = (OmEventResp)omEventIdMap.get(x2.getEventId());
                eventResp.getTemplates().forEach(y -> y.setPreviewType(previewType));
                resp.setTemplateList(eventResp.getTemplates());
                resp.setName(eventResp.getName());
                childRespList.add(resp);
            }
            childRespList = childRespList.stream().sorted(Comparator.comparing(QueryTemplateListResp::getId)).collect(Collectors.toList());
            templateListRespList.addAll(childRespList);
        }
        if (StringUtils.isNotBlank((CharSequence)queryTemplateListReq.getRemark())) {
            templateListRespList = templateListRespList.stream().filter(x -> queryTemplateListReq.getRemark().equals(x.getRemark())).collect(Collectors.toList());
        }
        return templateListRespList;
    }

    private List<OmEventResp> filterEvent(QueryTemplateListReq queryTemplateListReq, List<OmEventResp> omEventList) {
        if (CollectionUtils.isEmpty(omEventList)) {
            return omEventList;
        }
        omEventList.removeIf(x -> "ATHENA_SEMC_MESSAGE_DEFAULT".equals(x.getId()));
        omEventList.removeIf(x -> CollectionUtils.isEmpty((Collection)x.getTemplates()));
        if (Constants.MessageChannelEnum.EMAIL.getFlag().equals(queryTemplateListReq.getChannelFlag())) {
            for (OmEventResp resp : omEventList) {
                List templateList = resp.getTemplates().stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getTemplateUrl())).collect(Collectors.toList());
                resp.setTemplates(templateList);
            }
            omEventList.removeIf(x -> CollectionUtils.isEmpty((Collection)x.getTemplates()));
        }
        if (CollectionUtils.isEmpty(omEventList)) {
            return omEventList;
        }
        if (StringUtils.isNotBlank((CharSequence)queryTemplateListReq.getEventId())) {
            omEventList = omEventList.stream().filter(x -> queryTemplateListReq.getEventId().equals(x.getId())).collect(Collectors.toList());
            return omEventList;
        }
        return omEventList;
    }

    public Long updateStatus(SaveTemplateReq saveTemplateReq) {
        MessageChannelTemplate template;
        String userName = AppAuthContextHolder.getContext().getAuthoredUser().getUserName();
        if (saveTemplateReq.getTemplateId() == null) {
            template = this.buildTemplate(saveTemplateReq, userName);
            template.setValidStatus(saveTemplateReq.getStatus());
            this.messageChannelTemplateMapper.insert((Object)template);
        } else {
            template = this.queryMessageChannelTemplate(saveTemplateReq);
            template.setModifyUserName(userName);
            template.setValidStatus(saveTemplateReq.getStatus());
            this.messageChannelTemplateMapper.updateById((Object)template);
        }
        return template.getId();
    }

    private MessageChannelTemplate queryMessageChannelTemplate(SaveTemplateReq saveTemplateReq) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"id", (Object)saveTemplateReq.getTemplateId());
        return (MessageChannelTemplate)this.messageChannelTemplateMapper.selectOne((Wrapper)wrapper);
    }

    private MessageChannelTemplate buildTemplate(SaveTemplateReq saveTemplateReq, String userName) {
        MessageChannelTemplate template = new MessageChannelTemplate();
        template.setEventId(saveTemplateReq.getEventId());
        template.setRemark(saveTemplateReq.getRemark());
        template.setChannelFlag(saveTemplateReq.getChannelFlag());
        template.setModifyUserName(userName);
        return template;
    }

    public Long updateTemplate(SaveTemplateReq saveTemplateReq) {
        MessageChannelTemplate template;
        String userName = AppAuthContextHolder.getContext().getAuthoredUser().getUserName();
        if (saveTemplateReq.getTemplateId() == null) {
            template = this.buildTemplate(saveTemplateReq, userName);
            this.messageChannelTemplateMapper.insert((Object)template);
        } else {
            template = this.queryMessageChannelTemplate(saveTemplateReq);
            template.setModifyUserName(userName);
            template.setRemark(saveTemplateReq.getRemark());
            this.messageChannelTemplateMapper.updateById((Object)template);
        }
        return template.getId();
    }

    public QueryTemplateRelResp queryRelPerson(TemplateRelReq templateRelReq) {
        String tenantId;
        QueryTemplateRelResp relResp = new QueryTemplateRelResp();
        String string = tenantId = StringUtils.isBlank((CharSequence)templateRelReq.getTenantId()) ? AppAuthContextHolder.getContext().getAuthoredUser().getTenantId() : templateRelReq.getTenantId();
        if (Constants.MessageChannelEnum.EMAIL.getFlag().equals(templateRelReq.getChannelFlag())) {
            List emailTemplateRelList = this.emailTemplateRelMapper.queryEmailByCondition(tenantId, templateRelReq);
            if (CollectionUtils.isEmpty((Collection)emailTemplateRelList)) {
                return relResp;
            }
            Map<Integer, List<EmailTemplateRel>> contactList = emailTemplateRelList.stream().collect(Collectors.groupingBy(EmailTemplateRel::getEmailType));
            contactList.forEach((k, v) -> {
                if (Constants.EmailTypeEnum.CONTACT.getFlag().equals(k)) {
                    List personDTOList = this.buildRelPersonList(v);
                    relResp.setContactList(personDTOList);
                } else if (Constants.EmailTypeEnum.CCCONTACT.getFlag().equals(k)) {
                    List personDTOList = this.buildRelPersonList(v);
                    relResp.setCcContactList(personDTOList);
                } else {
                    List personDTOList = this.buildRelPersonList(v);
                    relResp.setBccContactList(personDTOList);
                }
            });
        } else if (Constants.MessageChannelEnum.SMS.getFlag().equals(templateRelReq.getChannelFlag())) {
            List smsTemplateRelList = this.smsTemplateRelMapper.queryTelephoneByCondition(tenantId, templateRelReq.getEventId(), templateRelReq.getLanguage());
            if (CollectionUtils.isEmpty((Collection)smsTemplateRelList)) {
                return relResp;
            }
            List telephoneList = smsTemplateRelList.stream().map(x -> {
                QueryTemplateRelResp.RelPersonDTO personDTO = new QueryTemplateRelResp.RelPersonDTO();
                personDTO.setId(x.getId());
                personDTO.setValue(x.getTelephone());
                personDTO.setLanguage(x.getLanguage());
                return personDTO;
            }).collect(Collectors.toList());
            relResp.setContactList(telephoneList);
        } else if (Constants.MessageChannelEnum.WECOM.getFlag().equals(templateRelReq.getChannelFlag())) {
            List wecomTemplateRelList = this.wecomTemplateRelMapper.queryWeComUserByCondition(tenantId, templateRelReq.getEventId(), templateRelReq.getLanguage());
            if (CollectionUtils.isEmpty((Collection)wecomTemplateRelList)) {
                return relResp;
            }
            List wecomUserIdList = wecomTemplateRelList.stream().map(x -> {
                QueryTemplateRelResp.RelPersonDTO personDTO = new QueryTemplateRelResp.RelPersonDTO();
                personDTO.setId(x.getId());
                personDTO.setValue(x.getUserId());
                personDTO.setLanguage(x.getLanguage());
                return personDTO;
            }).collect(Collectors.toList());
            relResp.setContactList(wecomUserIdList);
        } else if (Constants.MessageChannelEnum.DINGTALK.getFlag().equals(templateRelReq.getChannelFlag())) {
            List dingtalkTemplateRelList = this.dingtalkTemplateRelMapper.queryDingTalkUserByCondition(tenantId, templateRelReq.getEventId(), templateRelReq.getLanguage());
            if (CollectionUtils.isEmpty((Collection)dingtalkTemplateRelList)) {
                return relResp;
            }
            List wecomUserIdList = dingtalkTemplateRelList.stream().map(x -> {
                QueryTemplateRelResp.RelPersonDTO personDTO = new QueryTemplateRelResp.RelPersonDTO();
                personDTO.setId(x.getId());
                personDTO.setValue(x.getUserId());
                personDTO.setLanguage(x.getLanguage());
                return personDTO;
            }).collect(Collectors.toList());
            relResp.setContactList(wecomUserIdList);
        }
        return relResp;
    }

    private List<QueryTemplateRelResp.RelPersonDTO> buildRelPersonList(List<EmailTemplateRel> emailTemplateRelList) {
        return emailTemplateRelList.stream().map(x -> {
            QueryTemplateRelResp.RelPersonDTO personDTO = new QueryTemplateRelResp.RelPersonDTO();
            personDTO.setId(x.getId());
            personDTO.setValue(x.getContact());
            personDTO.setLanguage(x.getLanguage());
            return personDTO;
        }).collect(Collectors.toList());
    }

    @Transactional
    public void addRelPerson(TemplateRelReq templateRelReq) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        TreeSet noRepeatList = new TreeSet(templateRelReq.getContactList());
        QueryTemplateRelResp relResp = this.queryRelPerson(templateRelReq);
        if (Constants.MessageChannelEnum.EMAIL.getFlag().equals(templateRelReq.getChannelFlag())) {
            if (Constants.EmailTypeEnum.CONTACT.getFlag().equals(templateRelReq.getEmailType()) && CollectionUtils.isNotEmpty((Collection)relResp.getContactList())) {
                this.removeDuplicate(noRepeatList, relResp.getContactList());
            } else if (Constants.EmailTypeEnum.CCCONTACT.getFlag().equals(templateRelReq.getEmailType()) && CollectionUtils.isNotEmpty((Collection)relResp.getCcContactList())) {
                this.removeDuplicate(noRepeatList, relResp.getCcContactList());
            } else if (Constants.EmailTypeEnum.BCCCONTACT.getFlag().equals(templateRelReq.getEmailType()) && CollectionUtils.isNotEmpty((Collection)relResp.getBccContactList())) {
                this.removeDuplicate(noRepeatList, relResp.getBccContactList());
            }
            MessageChannelTemplate template = new MessageChannelTemplate();
            if (templateRelReq.getTemplateId() == null) {
                List omEventList = this.emcService.queryOmTemplateList(Constants.MessageChannelEnum.EMAIL.getFlag(), templateRelReq.getEventId());
                omEventList = omEventList.stream().filter(x -> templateRelReq.getEventId().equals(x.getId())).collect(Collectors.toList());
                template.setEventId(templateRelReq.getEventId());
                template.setRemark(CollectionUtils.isNotEmpty(omEventList) ? ((OmEventResp)omEventList.get(0)).getDescription() : "");
                template.setValidStatus(Constants.VALID_STATUS_ENABLE);
                template.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
                template.setChannelFlag(Constants.MessageChannelEnum.EMAIL.getFlag());
                this.messageChannelTemplateMapper.insert((Object)template);
                templateRelReq.setTemplateId(template.getId());
            }
            List emailTemplateRelList = noRepeatList.stream().map(x -> {
                EmailTemplateRel emailTemplateRel = new EmailTemplateRel();
                emailTemplateRel.setTemplateId(template.getId() != null ? template.getId() : templateRelReq.getTemplateId());
                emailTemplateRel.setEventId(templateRelReq.getEventId());
                emailTemplateRel.setLanguage(templateRelReq.getLanguage());
                emailTemplateRel.setEmailType(templateRelReq.getEmailType());
                emailTemplateRel.setContact(x);
                return emailTemplateRel;
            }).collect(Collectors.toList());
            List partList = Lists.partition(emailTemplateRelList, (int)500);
            for (List tempList : partList) {
                this.emailTemplateRelService.saveBatch((Collection)tempList);
            }
        } else if (Constants.MessageChannelEnum.SMS.getFlag().equals(templateRelReq.getChannelFlag())) {
            this.removeDuplicate(noRepeatList, relResp.getContactList());
            List emailTemplateRelList = noRepeatList.stream().map(x -> {
                SmsTemplateRel smsTemplateRel = new SmsTemplateRel();
                smsTemplateRel.setEventId(templateRelReq.getEventId());
                smsTemplateRel.setLanguage(templateRelReq.getLanguage());
                smsTemplateRel.setTelephone(x);
                smsTemplateRel.setTenantId(tenantId);
                return smsTemplateRel;
            }).collect(Collectors.toList());
            List partList = Lists.partition(emailTemplateRelList, (int)500);
            for (List tempList : partList) {
                this.smsTemplateRelService.saveBatch((Collection)tempList);
            }
        } else if (Constants.MessageChannelEnum.WECOM.getFlag().equals(templateRelReq.getChannelFlag())) {
            this.removeDuplicate(noRepeatList, relResp.getContactList());
            List wecomTemplateRelList = noRepeatList.stream().map(x -> {
                WecomTemplateRel wecomTemplateRel = new WecomTemplateRel();
                wecomTemplateRel.setEventId(templateRelReq.getEventId());
                wecomTemplateRel.setLanguage(templateRelReq.getLanguage());
                wecomTemplateRel.setUserId(x);
                wecomTemplateRel.setTenantId(tenantId);
                return wecomTemplateRel;
            }).collect(Collectors.toList());
            List partList = Lists.partition(wecomTemplateRelList, (int)500);
            for (List tempList : partList) {
                this.wecomTemplateRelService.saveBatch((Collection)tempList);
            }
        } else if (Constants.MessageChannelEnum.DINGTALK.getFlag().equals(templateRelReq.getChannelFlag())) {
            this.removeDuplicate(noRepeatList, relResp.getContactList());
            List dingtalkTemplateRelList = noRepeatList.stream().map(x -> {
                DingtalkTemplateRel dingtalkTemplateRel = new DingtalkTemplateRel();
                dingtalkTemplateRel.setEventId(templateRelReq.getEventId());
                dingtalkTemplateRel.setLanguage(templateRelReq.getLanguage());
                dingtalkTemplateRel.setUserId(x);
                dingtalkTemplateRel.setTenantId(tenantId);
                return dingtalkTemplateRel;
            }).collect(Collectors.toList());
            List partList = Lists.partition(dingtalkTemplateRelList, (int)500);
            for (List tempList : partList) {
                this.dingtalkTemplateRelService.saveBatch((Collection)tempList);
            }
        }
        this.updateTemplateTime(templateRelReq);
    }

    private void removeDuplicate(TreeSet<String> noRepeatList, List<QueryTemplateRelResp.RelPersonDTO> contactList) {
        if (CollectionUtils.isEmpty(noRepeatList) || CollectionUtils.isEmpty(contactList)) {
            return;
        }
        List<String> existList = contactList.stream().map(QueryTemplateRelResp.RelPersonDTO::getValue).collect(Collectors.toList());
        existList.forEach(noRepeatList::remove);
    }

    private void updateTemplateTime(TemplateRelReq templateRelReq) {
        String userId = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
        String userName = AppAuthContextHolder.getContext().getAuthoredUser().getUserName();
        this.messageChannelTemplateMapper.updateTemplateByCondition(userId, userName, LocalDateTime.now(), templateRelReq.getTemplateId());
    }

    @Transactional
    public void delRelPerson(TemplateRelReq templateRelReq) {
        if (Constants.MessageChannelEnum.EMAIL.getFlag().equals(templateRelReq.getChannelFlag())) {
            QueryWrapper emailWrapper = new QueryWrapper();
            emailWrapper.eq((Object)"id", (Object)templateRelReq.getId());
            this.emailTemplateRelMapper.delete((Wrapper)emailWrapper);
        } else if (Constants.MessageChannelEnum.SMS.getFlag().equals(templateRelReq.getChannelFlag())) {
            QueryWrapper smsWrapper = new QueryWrapper();
            smsWrapper.eq((Object)"id", (Object)templateRelReq.getId());
            this.smsTemplateRelMapper.delete((Wrapper)smsWrapper);
        } else if (Constants.MessageChannelEnum.WECOM.getFlag().equals(templateRelReq.getChannelFlag())) {
            QueryWrapper wecomWrapper = new QueryWrapper();
            wecomWrapper.eq((Object)"id", (Object)templateRelReq.getId());
            this.wecomTemplateRelMapper.delete((Wrapper)wecomWrapper);
        } else if (Constants.MessageChannelEnum.DINGTALK.getFlag().equals(templateRelReq.getChannelFlag())) {
            QueryWrapper dingTalkWrapper = new QueryWrapper();
            dingTalkWrapper.eq((Object)"id", (Object)templateRelReq.getId());
            this.dingtalkTemplateRelMapper.delete((Wrapper)dingTalkWrapper);
        }
        this.updateTemplateTime(templateRelReq);
    }

    public List<String> queryEventIdList(String tenantId, String remark) {
        List templateList = this.messageChannelTemplateMapper.queryTemplateByCondition(tenantId, remark, Constants.MessageChannelEnum.EMAIL.getFlag(), null);
        log.info("MessageChannelTemplateServiceImpl | query event id list result:{}. tenantId:{}, remark:{}", new Object[]{templateList, tenantId, remark});
        if (CollectionUtils.isEmpty((Collection)templateList)) {
            List omEventList = this.emcService.queryOmTemplateList(Constants.MessageChannelEnum.EMAIL.getFlag(), "");
            return omEventList.stream().filter(x -> remark.equals(x.getDescription())).map(OmEventResp::getId).limit(1L).collect(Collectors.toList());
        }
        List<String> eventIdList = templateList.stream().map(MessageChannelTemplate::getEventId).distinct().collect(Collectors.toList());
        if (eventIdList.size() > 1) {
            ArrayList respEventIdList = Lists.newArrayList();
            String locale = this.iamService.queryUserLangMetadata();
            log.info("MessageChannelTemplateServiceImpl | query event id list locale:{}. tenantId:{}, remark:{}", new Object[]{locale, tenantId, remark});
            locale = locale.replaceAll("_", "-");
            List omEventList = this.emcService.queryOmTemplateList(Constants.MessageChannelEnum.EMAIL.getFlag(), "");
            List filterList = omEventList.stream().filter(x -> eventIdList.contains(x.getId()) && CollectionUtils.isNotEmpty((Collection)x.getTemplates())).collect(Collectors.toList());
            log.info("MessageChannelTemplateServiceImpl | filter event template list result:{}. tenantId:{}, remark:{}", new Object[]{filterList, tenantId, remark});
            for (OmEventResp resp : filterList) {
                List languageList = resp.getTemplates().stream().map(OmEventTemplateDTO::getLanguage).collect(Collectors.toList());
                if (!languageList.contains(locale)) continue;
                respEventIdList.add(resp.getId());
                break;
            }
            return respEventIdList;
        }
        return eventIdList;
    }

    public Long queryChildTemplateCount(Long parentId) {
        QueryWrapper emailWrapper = new QueryWrapper();
        emailWrapper.eq((Object)"parent_id", (Object)parentId);
        Long count = this.messageChannelTemplateMapper.selectCount((Wrapper)emailWrapper);
        return count;
    }

    @Transactional
    public void copyTemplate(CopyTemplateReq copyTemplateReq) {
        String userName = AppAuthContextHolder.getContext().getAuthoredUser().getUserName();
        if (copyTemplateReq.getId() != null) {
            MessageChannelTemplate template = new MessageChannelTemplate();
            template.setEventId(copyTemplateReq.getEventId());
            template.setValidStatus(copyTemplateReq.getStatus());
            template.setChannelFlag(Constants.MessageChannelEnum.EMAIL.getFlag());
            template.setParentId(copyTemplateReq.getId());
            template.setModifyUserName(userName);
            this.messageChannelTemplateMapper.insert((Object)template);
            TemplateRelReq templateRelReq = new TemplateRelReq();
            templateRelReq.setTemplateId(copyTemplateReq.getId());
            this.updateTemplateTime(templateRelReq);
        } else {
            MessageChannelTemplate template = new MessageChannelTemplate();
            template.setEventId(copyTemplateReq.getEventId());
            template.setRemark(copyTemplateReq.getRemark());
            template.setValidStatus(copyTemplateReq.getStatus());
            template.setChannelFlag(Constants.MessageChannelEnum.EMAIL.getFlag());
            template.setModifyUserName(userName);
            this.messageChannelTemplateMapper.insert((Object)template);
            MessageChannelTemplate childTemplate = new MessageChannelTemplate();
            childTemplate.setEventId(copyTemplateReq.getEventId());
            childTemplate.setValidStatus(copyTemplateReq.getStatus());
            childTemplate.setChannelFlag(Constants.MessageChannelEnum.EMAIL.getFlag());
            childTemplate.setParentId(template.getId());
            childTemplate.setModifyUserName(userName);
            this.messageChannelTemplateMapper.insert((Object)childTemplate);
            TemplateRelReq templateRelReq = new TemplateRelReq();
            templateRelReq.setTemplateId(template.getId());
            this.updateTemplateTime(templateRelReq);
        }
    }
}

